<?php
namespace WebsiteControl\Base;
use WebsiteControl\Base\AbstractTheme;
class DefaultTheme extends AbstractTheme
{
   
	public function getThemePath()
	{
		return realpath(__DIR__)."/../";
	}
	
	public function getThemeUrl($file="")
	{
		if($file != "")
			return ADMIN_THEME_URL.$file;
		else
			return ADMIN_THEME_URL;
	}
	public function getMeta()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/meta.php"))
			include(ADMIN_THEME_PATH."inc/meta.php");
	}
	public function getHeaderCss()
	{
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/bootstrap/dist/css/bootstrap.min.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/font-awesome/css/font-awesome.min.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/nprogress/nprogress.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/animate.css/animate.min.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/google-code-prettify/bin/prettify.min.css");
		//SkCssInclude(ADMIN_THEME_URL."assest/build/css/custom.min.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/bootstrap-daterangepicker/daterangepicker.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.buttons.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.nonblock.css");
		SkCssInclude(ADMIN_THEME_URL."assest/vendors/chosen/chosen.css");
		SkCssInclude("https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css",true);
		SkCssInclude(ADMIN_THEME_URL."assest/build/css/custom.css");
		SkCssInclude(ADMIN_THEME_URL."assest/build/css/theme_red.css");
		SkCssInclude(ADMIN_THEME_URL."assest/build/css/extras.css");
		SkCssInclude(DIR_WS_SITE."includes/custom.css.php");
		//SkCssInclude(DIR_WS_SITE."templates/tools/css/bootstrap-dialog.css");

		SkCssDisplay();
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/jquery/dist/jquery.min.js");
		SkJsInclude(DIR_WS_SITE."templates/tools/jquery/validation/jquery.validate.min.js");
		SkJsDisplay();
		
		
	}
	
	public function getFooterJs()
	{
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/bootstrap/dist/js/bootstrap.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/fastclick/lib/fastclick.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/nprogress/nprogress.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/bootstrap-progressbar/bootstrap-progressbar.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/google-code-prettify/src/prettify.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/moment/min/moment.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/bootstrap-daterangepicker/daterangepicker.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/chosen/chosen.jquery.js");
		SkJsInclude("https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/devbridge-autocomplete/dist/jquery.autocomplete.min.js");
		
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.buttons.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/pnotify/dist/pnotify.nonblock.js");
   
		SkJsInclude(ADMIN_THEME_URL."assest/build/js/custom.js");
		
		SkJsInclude(DIR_WS_SITE."templates/tools/bootstrap/js/bootstrap-dialog.min.js");
		SkJsInclude(DIR_WS_SITE."templates/tools/custom.js");
		
		SkJsInclude(ADMIN_THEME_URL."assest/build/js/extras.js?".uniqid());
		SkJsInclude(DIR_WS_SITE."includes/footer.js.php");
		SkJsDisplay();
		
	}
	
	
	public function getHeader()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/header.php"))
			include(ADMIN_THEME_PATH."inc/header.php");
	}
	public function getFooter()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/footer.php"))
			include(ADMIN_THEME_PATH."inc/footer.php");
	}
	
	public function getMenuSidebar()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/menu_sidebar.php"))
			include(ADMIN_THEME_PATH."inc/menu_sidebar.php");
	}
	
	public function getMenuTopNav()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/menu_top_nav.php"))
			include(ADMIN_THEME_PATH."inc/menu_top_nav.php");
	}
	
	public function getMenuFooter()
	{
		if(file_exists(ADMIN_THEME_PATH."inc/menu_footer.php"))
			include(ADMIN_THEME_PATH."inc/menu_footer.php");
	}
	
	public function getEditorHeader()
	{
		global $SKEditorObj;
		echo $SKEditorObj->HeadScript();
	}
	
	
}
