﻿function GetToken()
{
    var customerId = $.urlParam('cid');;
    
    //customerId = $.md5(customerId);
    
    if (customerId == 0)
    {
        DisplayInvalidUser();
        
        return;
    }

    var url = $.jmsajaxurl({
        url: WebServiceHost,
        method: "GetToken", 
        data: { customerId : customerId }
    });

    $.ajax({
        cache: false,
        type        : "GET", 
        dataType    : "jsonp",
        url         : url + "&format=json",
        success     : function(msg) 
                      {
                          var mmsResponse = msg.d;

                          if (mmsResponse.Success == false)
                          {
                              return DisplayErrorMessages(mmsResponse.ErrorMessages);
                          }
                          
                          Token = mmsResponse.ResultText;
                          
                          $("#dialog").dialog('close');

                          GetMyVideos();
                      },
        error       : function(msg)
                      {
                          //alert(msg.responseText);
                          DisplayFriendlyError();
                      }
    });
}

function GetMyVideos()
{
    $('#ajax_loading').show();

    var url = $.jmsajaxurl({
        url: WebServiceHost,
        method: "GetMyVideos", 
        data: { token : Token }
    });

    $.ajax({
        cache: false,
        type        : "GET", 
        dataType    : "jsonp",
        url         : url + "&format=json",
        success     : function(msg) 
                      {
                          var mmsResponse = msg.d;

                          if (mmsResponse.Success == false)
                          {
                              return DisplayErrorMessages(mmsResponse.ErrorMessages);
                          }                                      
                          
                          var arr2d = [];

                          var videos = mmsResponse.MyVideos;
                          
                          for(i = 0; i < videos.length; i++)
                          {
                                arr2d[i] = 
                                        [
                                            '<a href=# onclick=\'GetVideo(' + videos[i].VideoKey + ')\'>' + videos[i].Title + '</a>',
                                            GetDuration(videos[i].Duration),
                                            GetPurchased(videos[i].Purchased)
                                        ];
                          }
                          
                          MyVideos.fnClearTable();
                          MyVideos.fnAddData(arr2d);
                          
                          $('#ajax_loading').hide();
                      },
        error       : function(msg)
                      {
                          $('#ajax_loading').hide();
                          DisplayFriendlyError();
                      }
    });
}            

function GetHello()
{
    var url = $.jmsajaxurl({
        url: WebServiceHost,
        method: "GetHello", 
        data: { }
    });

    $.ajax({
        cache: false,
        type        : "GET", 
        dataType: "jsonp",
        url: url + "&format=json",
        success     : function(msg) 
                      {
                        var mmsResponse = msg.d;
                        
                        alert(mmsResponse.ResultText);
                      },
        error       : function(msg)
                      {
                        alert(msg.responseText);
                      }
    });
}

function GetVideo(videoKey)
{
    var url = $.jmsajaxurl({
        url: WebServiceHost,
        method: "GetVideo", 
        data: { token : Token, videoKey : videoKey }
    });

    $.ajax({
        cache       : false,
        type        : "GET", 
        dataType    : "jsonp",
        url         : url + "&format=json",
        success     : function(msg) 
                      {
                          var mmsResponse = msg.d;

                          if (mmsResponse.Success == false)
                          {
                              return DisplayErrorMessages(mmsResponse.ErrorMessages);
                          }
                          
                          var video = mmsResponse.MyVideos[0].Url;
                          $('#Title')[0].innerText = mmsResponse.MyVideos[0].Title;

                          var lst = {};

                          var streamer = 'rtmpe://cdn.murphysmagic.com/Videos/';
                          var file     = 'mp4:' + video;
                          var type     = 'rtmp';

                          player.sendEvent('LOAD', {streamer:streamer, file:file, type:type});
                          //player.sendEvent('PLAY', 'true');
                      },
        error       : function(msg)
                      {
                          DisplayFriendlyError();
                      }
    });
    
}
