jQuery(document).ready(function($){
	$(window).scroll(function(){ 
        if ($(this).scrollTop() > 100) { 
            $('#scroll').fadeIn(); 
        } else { 
            $('#scroll').fadeOut(); 
        } 
    }); 
    $('#scroll').click(function(){ 
        $("html, body").animate({ scrollTop: 0 }, 600); 
        return false; 
    }); 
	
	  if(parseInt($(window).width()) > 767){
		  $(".category-mega-nav-link .main-nav-link").mouseover(function() {
			$(".category-mega-content").removeClass("show");
			$($( this ).data("target")).addClass("show");
			$(".category-mega-nav").removeClass("border-end");
		  }).mouseout(function() {
		  });
	  }
	  else{
		  $(".category-mega-nav-link .main-nav-link").each(function(){
			  $($( this ).data("target")).insertAfter($(this));
		  });
	  }
	  
	
	$(".sk_product_precent").each(function(){
		var $element = $(this);
		var percent =  $(this).attr("rel");
		var progressBarWidth = percent * $element.width() / 100;
			if(parseInt(progressBarWidth) > parseInt($element.width()))
				progressBarWidth =$element.width();
				
			$element.find('div').animate({ width: progressBarWidth }, 1500).html("&nbsp;"+percent + "%&nbsp;Stock&nbsp;Left&nbsp;&nbsp;");
	});
	
	$('.sk_cms_read_more').click(function () {
		 var collapse_content_selector = $(this).attr('href');
		  var toggle_switch = $(this);
		  if ($(collapse_content_selector).hasClass('d-none')) {
			  $(collapse_content_selector).removeClass('d-none').addClass("d-block");
			  if(toggle_switch.attr("data-readless"))
					toggle_switch.html(toggle_switch.attr("data-readless"));
				else
					toggle_switch.html('Read Less &raquo;');			  
		  }
		  else if ($(collapse_content_selector).hasClass('d-block')) {
			  $(collapse_content_selector).removeClass('d-block').addClass("d-none");
			  if(toggle_switch.attr("data-readmore"))
					toggle_switch.html(toggle_switch.attr("data-readmore"));
				else
					toggle_switch.html('Read More &raquo;');			  
		  }
	});
	
	
	$('.sk_read_more').click(function () {
        var collapse_content_selector = $(this).attr('href');
        var toggle_switch = $(this);
        
		$(collapse_content_selector).toggle(400,function () {
		  if ($(this).css('display') == 'none') {
				if(toggle_switch.attr("data-readmore") != "")
					toggle_switch.html(toggle_switch.attr("data-readmore"));
				else
					toggle_switch.html('Read More &raquo;');
				
            } else {
			 
			if(toggle_switch.attr("data-readless") != "")
					toggle_switch.html(toggle_switch.attr("data-readless"));
				else
					toggle_switch.html('Read Less &raquo;');
            }
        });
		
		return false;
    });

	
	$(".sk_modal").each(function(index,el){
		$(this).bind("click",function(){
		  	title = ($(el).attr("data-title") == undefined || $(el).attr("data-title") == "")?"": $(el).attr("data-title");
			type = ($(el).attr("data-type") == undefined || $(el).attr("data-type") == "")?"html": $(el).attr("data-type");
			source = ($(el).attr("data-source") == undefined || $(el).attr("data-source") == "")?$(el).attr("href"): $(el).attr("data-source");
			
			switch (type) {
				 case "ajax":
					if(source.indexOf("?") != -1)
						source = source +"&ajax=1"; 
					else
						source = source +"?ajax=1";
				 break;
				 case "iframe":
					if(source.indexOf("?") != -1)
						source = source +"&iframe=1"; 
					else
						source = source +"?iframe=1";
				 break;
			}
			ShowModalView(source, title, type, el);		
			return false;
		})
		
	});
	
	$(".sk_bookmark").each(function(index,el){
		$(this).bind("click",function(){
		  	
			if (window.sidebar && window.sidebar.addPanel) { // Firefox <23
				window.sidebar.addPanel(document.title,window.location.href,'');
			} else if(window.external && ('AddFavorite' in window.external)) { // Internet Explorer
				window.external.AddFavorite(location.href,document.title); 
			} else if(window.opera && window.print || window.sidebar && ! (window.sidebar instanceof Node)) { // Opera <15 and Firefox >23
				/**
				 * For Firefox <23 and Opera <15, no need for JS to add to bookmarks
				 * The only thing needed is a `title` and a `rel="sidebar"`
				 */
				$(this).attr('rel', 'sidebar').attr('title', document.title);
				return true;
			
			} else { // For the other browsers (mainly WebKit) we use a simple alert to inform users that they can add to bookmarks with ctrl+D/cmd+D
				alert('You can add this page to your bookmarks by pressing ' + (navigator.userAgent.toLowerCase().indexOf('mac') != - 1 ? 'Command/Cmd' : 'CTRL') + ' + D on your keyboard.');
			}
			
			return false;
		})
		
	});
	
	
	responsiveTables();	
});

function ShowModalView(source, title, type, el) {
    title = title ? title : "";
    type = type ? type : "html";
    switch (type) {
         case "iframe":
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                message: $('<iframe src="' + source + '" width="100%" height="500" frameborder="0"></iframe>')
            });
            break;
        case "image":
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                message: $('<img src="' + source + '" alt="' + title + '" class="img-responsive" />')
            });
            break;
        case "ajax":
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                //message: $('<div></div>').load(source),
                message: function (dialog) {
                    var $message = $('<div class="loading"></div>');
                    $message.load(source, function (response, status, xhr) {
                        $message.removeClass("loading");
                        try {
                        } 
						catch (ex) { 
							alert(ex); 
						}
                    });
                    return $message;
                },
                onshow: function (dialogRef) {
                    try {
                    } 
					catch (ex) { 
						alert(ex); 
					}
                }
            });
            break;
		case "html":
        default:
			BootstrapDialog.show({
                title: title,
				nl2br:false,
                size: BootstrapDialog.SIZE_WIDE,
                message: $(source).html()
            });
            break;
       
    }
    return false;
}


$(".sk_counter").each(function(index,el){
	
		distance = ($(el).attr("data-distance") == undefined || $(el).attr("data-distance") == "")?"": $(el).attr("data-distance");
		CounterStart(index,el,distance);	
		
	});

function CounterStart(index,el,distance)
{
	 if(distance > 0){
		  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
		  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		  var seconds = Math.floor((distance % (1000 * 60)) / 1000);
		  var innerHTML = "<span class='days clock'>" + days + "<span class='acr'>d</span></span><span class='hours clock'>" + hours + "<span class='acr'>h</span></span><span class='minutes clock'>" + minutes + "<span class='acr'>m</span></span><span class='seconds clock'>" + seconds + "<span class='acr'>s</span></span>";
		  $(el).html(innerHTML);
		  distance = distance-1000;
		  setTimeout(function(){CounterStart(index,el,distance)},1000);
	 }
	 else
	 {
		 end = ($(el).attr("data-end") == undefined || $(el).attr("data-end") == "")?"EXPIRED": $(el).attr("data-end");
		 $(el).html(end); 
	 }
	
}

function responsiveTables(obj) {
    if ($(obj).length == 0) obj = $("body");
    obj.find("table.responsive").each(function () {
        var nmtTable = $(this);
        var nmtHeadRow = nmtTable.find("thead tr");
		if(nmtHeadRow.length > 0){
			nmtTable.find("tbody tr").each(function () {
				var curRow = $(this);
				for (var i = 0; i < curRow.find("td").length; i++) {
					var rowSelector = "td:eq(" + i + ")";
					var headSelector = "th:eq(" + i + ")";
					curRow.find(rowSelector).attr('data-title', nmtHeadRow.find(headSelector).html().replace("&nbsp;", " "));
				}
			});
			nmtTable.find("tfoot tr").each(function () {
				var curRow = $(this);
				for (var i = 0; i < curRow.find("td").length; i++) {
					var rowSelector = "td:eq(" + i + ")";
					var headSelector = "th:eq(0)";
					curRow.find(rowSelector).attr('data-title', curRow.find(headSelector).html());
				}
			});
		}
    });
}