﻿/*! A fix for the iOS orientationchange zoom bug. Script by @scottjehl, rebound by @wilto.MIT / GPLv2 License.*/
(function (a) { function m() { d.setAttribute("content", g), h = !0 } function n() { d.setAttribute("content", f), h = !1 } function o(b) { l = b.accelerationIncludingGravity, i = Math.abs(l.x), j = Math.abs(l.y), k = Math.abs(l.z), (!a.orientation || a.orientation === 180) && (i > 7 || (k > 6 && j < 8 || k < 8 && j > 6) && i > 5) ? h && n() : h || m() } var b = navigator.userAgent; if (!(/iPhone|iPad|iPod/.test(navigator.platform) && /OS [1-5]_[0-9_]* like Mac OS X/i.test(b) && b.indexOf("AppleWebKit") > -1)) return; var c = a.document; if (!c.querySelector) return; var d = c.querySelector("meta[name=viewport]"), e = d && d.getAttribute("content"), f = e + ",maximum-scale=1", g = e + ",maximum-scale=10", h = !0, i, j, k, l; if (!d) return; a.addEventListener("orientationchange", m, !1), a.addEventListener("devicemotion", o, !1) })(this);

/*Date Formats*/
var dateFormat = function () { var e = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g, t = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g, n = /[^-+\dA-Z]/g, r = function (e, t) { e = String(e); t = t || 2; while (e.length < t) e = "0" + e; return e }; return function (i, s, o) { var u = dateFormat; if (arguments.length == 1 && Object.prototype.toString.call(i) == "[object String]" && !/\d/.test(i)) { s = i; i = undefined } i = i ? new Date(i) : new Date; if (isNaN(i)) throw SyntaxError("invalid date"); s = String(u.masks[s] || s || u.masks["default"]); if (s.slice(0, 4) == "UTC:") { s = s.slice(4); o = true } var a = o ? "getUTC" : "get", f = i[a + "Date"](), l = i[a + "Day"](), c = i[a + "Month"](), h = i[a + "FullYear"](), p = i[a + "Hours"](), d = i[a + "Minutes"](), v = i[a + "Seconds"](), m = i[a + "Milliseconds"](), g = o ? 0 : i.getTimezoneOffset(), y = { d: f, dd: r(f), ddd: u.i18n.dayNames[l], dddd: u.i18n.dayNames[l + 7], m: c + 1, mm: r(c + 1), mmm: u.i18n.monthNames[c], mmmm: u.i18n.monthNames[c + 12], yy: String(h).slice(2), yyyy: h, h: p % 12 || 12, hh: r(p % 12 || 12), H: p, HH: r(p), M: d, MM: r(d), s: v, ss: r(v), l: r(m, 3), L: r(m > 99 ? Math.round(m / 10) : m), t: p < 12 ? "a" : "p", tt: p < 12 ? "am" : "pm", T: p < 12 ? "A" : "P", TT: p < 12 ? "AM" : "PM", Z: o ? "UTC" : (String(i).match(t) || [""]).pop().replace(n, ""), o: (g > 0 ? "-" : "+") + r(Math.floor(Math.abs(g) / 60) * 100 + Math.abs(g) % 60, 4), S: ["th", "st", "nd", "rd"][f % 10 > 3 ? 0 : (f % 100 - f % 10 != 10) * f % 10] }; return s.replace(e, function (e) { return e in y ? y[e] : e.slice(1, e.length - 1) }) } }(); dateFormat.masks = { "default": "ddd mmm dd yyyy HH:MM:ss", shortDate: "m/d/yy", mediumDate: "mmm d, yyyy", longDate: "mmmm d, yyyy", fullDate: "dddd, mmmm d, yyyy", shortTime: "h:MM TT", mediumTime: "h:MM:ss TT", longTime: "h:MM:ss TT Z", isoDate: "yyyy-mm-dd", isoTime: "HH:MM:ss", isoDateTime: "yyyy-mm-dd'T'HH:MM:ss", isoUtcDateTime: "UTC:yyyy-mm-dd'T'HH:MM:ss'Z'" }; dateFormat.i18n = { dayNames: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], monthNames: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"] }; Date.prototype.format = function (e, t) { return dateFormat(this, e, t) }

/****  Base64 encode / decode *  http://www.webtoolkit.info/ ***/
var Base64 = { _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", encode: function (r) { var t, e, o, a, h, n, c, d = "", C = 0; for (r = Base64._utf8_encode(r); C < r.length;) t = r.charCodeAt(C++), e = r.charCodeAt(C++), o = r.charCodeAt(C++), a = t >> 2, h = (3 & t) << 4 | e >> 4, n = (15 & e) << 2 | o >> 6, c = 63 & o, isNaN(e) ? n = c = 64 : isNaN(o) && (c = 64), d = d + this._keyStr.charAt(a) + this._keyStr.charAt(h) + this._keyStr.charAt(n) + this._keyStr.charAt(c); return d }, decode: function (r) { var t, e, o, a, h, n, c, d = "", C = 0; for (r = r.replace(/[^A-Za-z0-9\+\/\=]/g, ""); C < r.length;) a = this._keyStr.indexOf(r.charAt(C++)), h = this._keyStr.indexOf(r.charAt(C++)), n = this._keyStr.indexOf(r.charAt(C++)), c = this._keyStr.indexOf(r.charAt(C++)), t = a << 2 | h >> 4, e = (15 & h) << 4 | n >> 2, o = (3 & n) << 6 | c, d += String.fromCharCode(t), 64 != n && (d += String.fromCharCode(e)), 64 != c && (d += String.fromCharCode(o)); return d = Base64._utf8_decode(d) }, _utf8_encode: function (r) { r = r.replace(/\r\n/g, "\n"); for (var t = "", e = 0; e < r.length; e++) { var o = r.charCodeAt(e); 128 > o ? t += String.fromCharCode(o) : o > 127 && 2048 > o ? (t += String.fromCharCode(o >> 6 | 192), t += String.fromCharCode(63 & o | 128)) : (t += String.fromCharCode(o >> 12 | 224), t += String.fromCharCode(o >> 6 & 63 | 128), t += String.fromCharCode(63 & o | 128)) } return t }, _utf8_decode: function (r) { for (var t = "", e = 0, o = c1 = c2 = 0; e < r.length;) o = r.charCodeAt(e), 128 > o ? (t += String.fromCharCode(o), e++) : o > 191 && 224 > o ? (c2 = r.charCodeAt(e + 1), t += String.fromCharCode((31 & o) << 6 | 63 & c2), e += 2) : (c2 = r.charCodeAt(e + 1), c3 = r.charCodeAt(e + 2), t += String.fromCharCode((15 & o) << 12 | (63 & c2) << 6 | 63 & c3), e += 3); return t } };

function responsiveTables(obj) {
    if ($(obj).length == 0) obj = $("body");
    obj.find("table.responsive").each(function () {
        var nmtTable = $(this);
        var nmtHeadRow = nmtTable.find("thead tr");
        nmtTable.find("tbody tr").each(function () {
            var curRow = $(this);
            for (var i = 0; i < curRow.find("td").length; i++) {
                var rowSelector = "td:eq(" + i + ")";
                var headSelector = "th:eq(" + i + ")";
                if (curRow.find(rowSelector).length && nmtHeadRow.find(headSelector).length)
                    curRow.find(rowSelector).attr('data-title', nmtHeadRow.find(headSelector).html().replace("&nbsp;", " "));
            }
        });
        nmtTable.find("tfoot tr").each(function () {
            var curRow = $(this);
            for (var i = 0; i < curRow.find("td").length; i++) {
                var rowSelector = "td:eq(" + i + ")";
                var headSelector = "th:eq(0)";
                curRow.find(rowSelector).attr('data-title', curRow.find(headSelector).html());
            }
        });
    });
}

function showLoader(obj) {
    if ($(".Overlay").length == 1 || ($(".bootstrap-dialog").length == 1 && $(".bootstrap-dialog .btn").length == 0)) return;
    if (obj == undefined || $(obj).length == 0) {
        obj = $("body");
        //$("body,html").css({ "height": "100%", "overflow": "hidden" });
    }
    obj.css("position", "relative");
    obj.append($("<div class='Overlay'></div>"));
    return false;
}

function hideLoader(obj) {
    if ($(".Overlay").length == 0) return;
    if (!obj) {
        obj = $("body");
        $("body,html").removeAttr("style");
    }
    obj.find(".Overlay").remove();
    return false;
}

function LoadImages(obj) {
    if ($(obj).length == 0) obj = $("body");
    obj.find(".image[data-image-url]").each(function () {
        var o = $(this);
        var img = new Image();
        var src = new String(o.attr("data-image-url"));
        o.removeAttr("data-image-url");
        src = src.replace("WIDTH", o.width());
        src = src.replace("HEIGHT", o.height());
        src = src.replace("MODE", "Exact");
        img.onload = function () {
            o.css("backgroundImage", "url('" + src + "')");
            o.css("backgroundPosition", "center center");
            o.css("backgroundSize", "cover");
        }
        img.src = src;
    });
}

function onBegin(xhr, a) {
    var formObj = $(this);
    if (formObj.find(".has-error").length == 0) {
        showLoader();
        return true;
    }
    return false;
}

function onBeginQuiet(xhr, a) {
    var formObj = $(this);
    return formObj.find(".has-error").length == 0;
}

function onFailure(xhr, msg, msgDet) {
    hideLoader();
    //BootstrapDialog.alert({ title: msgDet, message: xhr.responseText });
    BootstrapDialog.alert({ title: msgDet, message: "Unknown error occured. Please try again later." });
}


function onSuccess(data, status) {
    var formObj = $(this);
    hideLoader();
    if (typeof (grecaptcha) != "undefined")
        grecaptcha.reset();

    switch (data.Status) {
        case "Alert":
            if (data.AlertData) {
                if (data.AlertData.callbackText != "") {
                    data.AlertData.callback = function (dialog) {
                        eval(data.AlertData.callbackText);
                    }
                }
                $(data.AlertData.buttons).each(function () {
                    if (this.actionText != "") {
                        var actionText = this.actionText;
                        this.action = function (dialog) {
                            dialog.close();
                            eval(actionText);
                        }
                    }
                });

                if (data.AlertData.buttons) {
                    BootstrapDialog.show(data.AlertData);
                    if (data.AlertData.callbackText != "" && data.AlertData.buttons.length == 0)
                        setTimeout(function () { eval(data.AlertData.callbackText); }, 250);
                } else
                    BootstrapDialog.alert(data.AlertData);
            }
            break;
        case "Redirect":
            RedirectTo(data.RedirectUrl);
            break;
        case "Download":
            Download(data.DownloadUrl);
            break;
        case "Evaluate":
            eval(data.JSCode);
            break;
        case "UpdateHtml":
            if (data.EncodedHtml) $(data.PlaceHolder).html(Base64.decode(data.EncodedHtml));
            else if (data.Html) $(data.PlaceHolder).html(data.Html);
            break;
        default:
            //console.log(data);
            break;
    }
}

function RedirectTo(url, time) {
    time = time == undefined ? 0 : time;
    showLoader();
    setTimeout(function () {
        url = decodeURIComponent(url);
        if (url == "Reload")
            RedirectTo(location.href);
        else
            location.href = url;
    }, time);
}

function Download(url) {
    location.href = url;
}


var passThrough = false;
function MyAlert(msg, callback) {
    BootstrapDialog.alert({
        title: SiteName,
        message: msg,
        callback: function () {
            if (callback && typeof (callback) == "function")
                setTimeout(callback, 100);
        }
    });
}

function ShowError(msg, callback) {
    BootstrapDialog.alert({
        title: SiteName,
        type: BootstrapDialog.TYPE_DANGER,
        message: msg,
        callback: function () {
            if (callback && typeof (callback) == "function")
                setTimeout(callback, 100);
        }
    });
}

function MyConfirm(obj, msg, callback, noCallback) {
    if (passThrough) { passThrough = false; return true; }
    BootstrapDialog.confirm({
        title: SiteName,
        message: msg,
        btnCancelLabel: 'No',
        btnOKLabel: 'Yes',
        callback: function (result) {
            if (result) {
                if (callback && typeof (callback) == "function")
                    setTimeout(callback, 100);
                else if ($(obj).get(0).tagName == "A")
                    RedirectTo($(obj).attr("href"));
                else if (($(obj).get(0).tagName == "BUTTON" || $(obj).get(0).tagName == "INPUT") && $(obj).attr("type").toUpperCase() == "SUBMIT") {
                    passThrough = true;
                    $(obj).click();
                } else
                    alert($(obj).get(0).tagName);
            } else {
                if (noCallback && typeof (noCallback) == "function")
                    setTimeout(noCallback, 100);
            }
        }
    });
    return false;
}

function GeneratePassword(obj) {
    if (obj.length == 1) {
        var pwd = (function () { g = function () { c = '0123456789!@#$&abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; p = ''; for (i = 0; i < 10; i++) { p += c.charAt(Math.floor(Math.random() * 62)); } return p; }; p = g(); while (!/[A-Z]/.test(p) || !/[0-9]/.test(p) || !/[a-z]/.test(p)) { p = g(); } return p; })();
        obj.val(pwd);
    }
    return false;
}

String.prototype.trim = function () {
    return this.replace(/^\s+|\s+$/g, "");
}

String.prototype.ReplaceAll = function (stringToFind, stringToReplace) {
    var temp = this;
    var index = temp.indexOf(stringToFind);
    while (index != -1) {
        temp = temp.replace(stringToFind, stringToReplace);
        index = temp.indexOf(stringToFind);
    }
    return temp;
}

String.prototype.capitalize = function () {
    return this.replace(/(^|\s)([a-z])/g, function (m, p1, p2) { return p1 + p2.toUpperCase(); });
};

$.validator.setDefaults({
    highlight: function (element) {
        $(element).closest('.form-group').addClass('has-error');
        var tab_content = $(element).closest('.tab-content');
        if (tab_content.find(".tab-pane.active:has(div.has-error)").length == 0) {
            var errorTab = tab_content.find(".tab-pane:has(div.has-error):first");
            var id = $(errorTab).attr("id");
            $('a[href="#' + id + '"]').tab('show');
            setTimeout(function () {
                errorTab.find("div.has-error:first .form-control").focus();
            }, 250);
        }
    },
    unhighlight: function (element) {
        $(element).closest('.form-group').removeClass('has-error');
    },
    focusInvalid: true,
    errorElement: 'span',
    errorClass: 'help-block',
    errorPlacement: function (error, element) {
        if (element.parent('.input-group').length) {
            error.insertAfter(element.parent());
        } else {
            error.insertAfter(element);
        }
    },
    ignore: []
});

$.validator.methods.date = function (value, element) {
    return this.optional(element) || moment(value, CultureInfoDateFormat.ShortDatePattern.toUpperCase(), true).isValid();
}

function AjaxCall(Url, data, callback) {
    if (!callback) callback = "onSuccess";
    var obj = $('<form action="' + Url + '" method="post" data-ajax="true" data-ajax-begin="onBegin" data-ajax-failure="onFailure" data-ajax-success="' + callback + '"></form>');
    if (data) {
        for (var key in data)
            obj.append("<input type='hidden' name='" + key + "' value='" + data[key] + "' />");
    }
    $("body").append(obj);
    obj.trigger("submit");
    return false;
}

function ShowRemoteView(url, title, type) {
    title = title ? title : SiteName;
    type = type ? type : "html";
    switch (type) {
        case "iframe":
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                message: $('<iframe src="' + url + '" width="100%" height="500" frameborder="0"></iframe>')
            });
            break;
        case "image":
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                message: $('<img src="' + url + '" alt="' + title + '" class="img-responsive" />')
            });
            break;
        default:
            BootstrapDialog.show({
                title: title,
                size: BootstrapDialog.SIZE_WIDE,
                //message: $('<div></div>').load(url),
                message: function (dialog) {
                    var $message = $('<div class="loading"></div>');
                    $message.load(url, function (response, status, xhr) {
                        $message.removeClass("loading");
                        $.validator.unobtrusive.parse($message);
                        try {
                            widget.Init($message);
                        } catch (ex) { alert(ex); }
                    });
                    return $message;
                },
                onshow: function (dialogRef) {
                    $.validator.unobtrusive.parse(document);
                    try {
                        widget.Init($(document));
                    } catch (ex) { alert(ex); }
                }
            });
            break;
    }
    return false;
}

var widget;
(function (framework, $, window, document, undefined) {
    "use strict";
    $(function () {
        $('.form-control').filter('[data-val-required]').closest(".form-group").find(".control-label").addClass("required");
        $("textarea").each(function () { $(this).val($(this).val().trim()); });
        responsiveTables();
        LoadImages();
        if ($("#CurrentDateTime").length == 1) {
            $("#CurrentDateTime").html(DateTimeNow.format("dddd, mmmm dS, yyyy, h:MM:ss TT"));
            setInterval(function () {
                DateTimeNow.setSeconds(DateTimeNow.getSeconds() + 1);
                $("#CurrentDateTime").html(DateTimeNow.format("dddd, mmmm dS, yyyy, h:MM:ss TT"));
            }, 1000);
        }
        $('a').filter('[data-remote-view]').click(function (e) {
            ShowRemoteView($(this).attr("href"), $(this).attr("title"));
            return false;
        });

        $('.navbar .nav li').removeClass('active');
        $('.navbar .nav li a').filter('[href="' + location.pathname + '"]').parents("li").addClass("active");
        if ($('.navbar .nav li.active').length == 0)
            $('.navbar .nav li a').filter('[href="' + location.href.ReplaceAll(location.protocol, "") + '"]').parents("li").addClass("active");

        widget = new framework.MyWidgets();
        widget.Init();
    });


    framework.MyWidgets = function () {

    }

    framework.MyWidgets.prototype = (function () {
        var self = this;

        function _Init(container) {
            if ($(container).length == 0) container = $("body");
            _InitDatePicker(container);
            _InitDateTimePicker(container);
            _InitSelect2(container);
            _InitFileInput(container);
            _InitTooltips(container);
            _InitGAutoComplete(container);
            _InitGAddressFinder(container);
            _InitGoogleMap(container);
            _InitSlider(container);
        }

        function _InitGAutoComplete(container) {
            if (typeof ($.fn.GAutoComplete) == 'undefined') return;
            container.find("input.GAutoComplete").GAutoComplete();
        }

        function _InitTooltips(container) {
            if (typeof ($.fn.tooltip) == 'undefined') return;
            container.find('[data-toggle="tooltip"]').tooltip();
        }

        function _InitDatePicker(container) {
            if (typeof ($.fn.datepicker) == 'undefined') return;
            container.find(".datepicker").datepicker({
                format: CultureInfoDateFormat.ShortDatePattern.toLowerCase(),
                autoclose: true
            });
            container.find(".dobpicker").datepicker({
                format: CultureInfoDateFormat.ShortDatePattern.toLowerCase(),
                startView: 4,
                autoclose: true
            });
        }

        function _InitDateTimePicker(container) {
            if (typeof ($.fn.datetimepicker) == 'undefined') return;
            container.find(".datetimepicker").datetimepicker({
                format: CultureInfoDateFormat.ShortDatePattern.toLowerCase() + " " + CultureInfoDateFormat.ShortTimePattern
            });
            container.find(".timepicker").datetimepicker({
                format: CultureInfoDateFormat.ShortTimePattern,
                stepping: 30
            });
        }

        function _InitSelect2(container) {
            if (typeof ($.fn.select2) == 'undefined') return;
            container.find(".select2").select2({
                theme: 'bootstrap',
                width: '100%'
            });
            container.find(".select2-tags").select2({
                theme: 'bootstrap',
                width: '100%',
                tags: true,
                tokenSeparators: [',']
            });
        }

        function _InitFileInput(container) {
            if (typeof ($.fn.fileinput) == 'undefined') return;
            if (container.find(".FileInput").length > 0) {
                var requestFiles = 0;
                var completedFiles = 0;
                container.find(".FileInput").each(function () {
                    var obj = $(this);
                    var allowedExtensions = obj.attr("data-extensions").split(',');
                    var refId = obj.attr("data-reference-id");
                    var refField = obj.attr("data-reference-field");
                    var browseLabel = obj.attr("data-browse-label");
                    obj.fileinput({
                        uploadUrl: AdminURL + "/Media/UploadFile",
                        allowedFileExtensions: allowedExtensions,
                        maxFileSize: 4096,
                        maxFileCount: 1,
                        showCancel: false,
                        showUpload: false,
                        showRemove: false,
                        elErrorContainer: "#errorBlock",
                        showPreview: false,
                        showCaption: false,
                        uploadAsync: false,
                        uploadExtraData: function (previewId, index) {
                            return {
                                ReferenceId: refId,
                                ReferenceType: refField
                            };
                        },
                        browseClass: "btn btn-warning",
                        browseLabel: browseLabel,
                        browseIcon: "<i class=\"fa fa-file\"></i> "
                    }).on('filebatchuploadsuccess', function (event, data) {
                        if (data.response.FileName)
                            $(".preview .FileName").val(data.response.FileName);
                        if (data.response.UserFileName)
                            $(".preview .UserFileName").val(data.response.UserFileName);
                        if (data.response.ImageSrc)
                            $(".preview .ImageSrc").attr("src", data.response.ImageSrc);
                        if (data.response.Width)
                            $(".preview .Width").val(data.response.Width);
                        if (data.response.Height)
                            $(".preview .Height").val(data.response.Height);
                        onSuccess(data.response);
                    }).on("filebatchselected", function (event, files) {
                        if (files.length == 1) obj.fileinput("upload");
                    });
                });
            }

            if (container.find(".FileInputMultiple").length > 0) {
                var requestFiles = 0;
                var completedFiles = 0;
                container.find(".FileInputMultiple").each(function () {
                    var obj = $(this);
                    var allowedExtensions = obj.attr("data-extensions").split(',');
                    var refId = obj.attr("data-reference-id");
                    var refField = obj.attr("data-reference-field");
                    var browseLabel = obj.attr("data-browse-label");
                    obj.fileinput({
                        uploadUrl: AdminURL + "/Media/UploadFile",
                        allowedFileExtensions: allowedExtensions,
                        uploadAsync: true,
                        minFileCount: 1,
                        maxFileCount: 10,
                        maxFileSize: 20480,
                        maxPreviewFileSize: 10,
                        maxImageWidth: 2000,
                        maxImageHeight: 2000,
                        resizeImage: true,
                        showPreview: true,
                        uploadExtraData: function (previewId, index) {
                            return {
                                ReferenceId: refId,
                                ReferenceType: refField
                            };
                        }
                    }).on('filepreupload', function () {
                        requestFiles += 1;
                    }).on('fileuploaded', function (event, data) {
                        completedFiles += 1;
                        if (requestFiles == completedFiles)
                            onSuccess(data.response);
                    });
                });
            }

        }

        function _InitGAddressFinder(container) {
            if (typeof ($.fn.GAddressFinder) == 'undefined') return;
            container.find(".GAddressFinder").GAddressFinder();
        }

        function _InitGoogleMap(container) {
            if (typeof ($.fn.GoogleMap) == 'undefined') return;
            container.find(".GoogleMap").GoogleMap();
        }

        function _InitSlider(container) {
            if (typeof ($.fn.slider) == 'undefined') return;
            container.find(".slider").slider();
        }

        return {
            Init: _Init,
            InitDatePicker: _InitDatePicker,
            InitDateTimePicker: _InitDateTimePicker,
            InitSelect2: _InitSelect2,
            InitFileInput: _InitFileInput,
            InitTooltips: _InitTooltips,
            InitGAutoComplete: _InitGAutoComplete,
            InitGoogleMap: _InitGoogleMap,
            InitSlider: _InitSlider,
            InitGAddressFinder: _InitGAddressFinder
        };
    }());
})(window.framework = window.framework || {}, window.jQuery, window, document);