﻿if (typeof (GoogleMapUrl) !== "undefined") {
    var pendingGeoComp = "pending-geo-complete";
    var pendingGMap = "pending-google-map";
    var pendingGAFinder = "pending-google-address-finder";

    $.getScript(GoogleMapUrl + "&callback=initMap");
    function initMap() {
        if (typeof (google) !== 'undefined' && typeof (google.maps) !== 'undefined') {
            $("." + pendingGeoComp).removeClass(pendingGeoComp).GAutoComplete();
            $("." + pendingGMap).removeClass(pendingGMap).GoogleMap();
            $("." + pendingGAFinder).removeClass(pendingGAFinder).GAddressFinder();
        }
    }

    $.fn.GAddressFinder = function (options) {
        return this.each(function () {
            var opts, data, element = $(this);
            data = element.data();
            opts = $.extend({}, $.fn.GAddressFinder.defaults, data, options || {});
            if (typeof (google) !== 'undefined' && typeof (google.maps) !== 'undefined') {
                element.addClass("GAddressFinder").on("click", function () {
                    var zipcode = $("#" + opts.prefix + opts.zipField);
                    if (zipcode.length == 0) return;
                    zipcode = zipcode.val().trim();
                    (new google.maps.Geocoder()).geocode({ 'address': zipcode, 'partialmatch': true }, function (results, status) {
                        if (typeof (opts.callback) == "function")
                            opts.callback(results);
                        else {
                            if (status == google.maps.GeocoderStatus.OK && results.length > 0)
                                updatePlace(results[0], opts.prefix);
                            else
                                console.log("Geocode was not successful for the following reason: " + status + ", searching..." + zipcode);
                        }
                    });
                });
            }
            else
                element.addClass(pendingGAFinder);
        });
    };
    $.fn.GAddressFinder.defaults = {
        zipField: "ZipCode",
        prefix: "",
        callback: null
    };

    $.fn.GoogleMap = function (options) {
        return this.each(function () {
            var opts, data, element = $(this);
            data = element.data();
            opts = $.extend({}, $.fn.GoogleMap.defaults, data, options || {});
            if (typeof (google) !== 'undefined' && typeof (google.maps) !== 'undefined') {
                element.addClass("GoogleMap").bind('UpdateGMap', function () {
                    var gMap = element.data("map");
                    if (gMap == null) {
                        gMap = new google.maps.Map(element.get(0), {
                            zoom: opts.zoom,
                            center: new google.maps.LatLng(opts.lat, opts.lng),
                            mapTypeId: google.maps.MapTypeId.ROADMAP
                        });
                        element.data("map", gMap);
                    }
                    var gMarker = element.data("map-marker");
                    if (gMarker == null) {
                        gMarker = new google.maps.Marker({
                            map: gMap,
                            draggable: opts.draggableMarker,
                            position: new google.maps.LatLng(opts.lat, opts.lng)
                        });
                        google.maps.event.addListener(gMarker, 'dragend', function () {
                            (new google.maps.Geocoder()).geocode({ latLng: gMarker.getPosition() }, function (results, status) {
                                if (status == google.maps.GeocoderStatus.OK && results.length > 0)
                                    updatePlace(results[0], "");
                                else
                                    console.log('Cannot determine address at this location.' + status);
                            });
                        });
                        element.data("map-marker", gMarker);
                    } else {
                        data = element.data();
                        console.log(data.lat)
                        gMarker.setPosition(new google.maps.LatLng(data.lat, data.lng));
                        gMap.setCenter(new google.maps.LatLng(data.lat, data.lng));
                    }

                    if (opts.title.length > 0) {
                        var infoWin = element.data("map-info-window");
                        if (infoWin == null) {
                            infoWin = (new google.maps.InfoWindow({
                                maxWidth: opts.cwWidth
                            }));
                            element.data("map-info-window", infoWin);
                            infoWin.setContent(opts.title);
                        } else {
                            data = element.data();
                            infoWin.setContent(data.title);
                        }
                        infoWin.open(gMap, gMarker);
                    }
                });
                element.trigger('UpdateGMap');
            }
            else
                element.addClass(pendingGMap);
        });
    };
    $.fn.GoogleMap.defaults = {
        zoom: 13,
        draggableMarker: false,
        cwWidth: 150,
        lat: 51.507351,
        lng: -0.127758,
        title: ""
    };

    $.fn.GAutoComplete = function (options) {
        return this.each(function () {
            var opts, data, element = $(this);
            data = element.data();
            opts = $.extend({}, $.fn.GAutoComplete.defaults, data, options || {});
            if (typeof (google) !== 'undefined' && typeof (google.maps) !== 'undefined') {
                if (element.prop("tagName").toUpperCase() !== "INPUT") return;

                element.addClass("GAutoComplete");
                autocomplete = new google.maps.places.Autocomplete(element.get(0), { types: opts.types, componentRestrictions: opts.componentRestrictions });
                google.maps.event.addListener(autocomplete, 'place_changed', function () {
                    var place = autocomplete.getPlace();
                    if (place && place.geometry && place.geometry.location) _updateLocation(element, place);
                    else _updateLocation(element, null);
                });

                element.focus(function () {
                    element.data("init-value", element.val());
                }).blur(function () {
                    setTimeout(function () {
                        if ((element.data("init-value") != "" && element.data("init-value") != element.val()) || $("#Latitude").val() == "" || $("#Longitude").val() == "" || $("#Latitude").val() == "0" || $("#Longitude").val() == "0") {
                            element.val("");
                            element.data("init-value", "");
                        }
                    }, 300);
                });

                var $gmapEl = null;
                if (element.hasClass("GAutoMap")) {
                    $containerEl = $("<div style='margin:5px 0px;'></div>");
                    $styleEl = $("<div style='border:1px solid #ccc;background:#fff;border-radius:10px;overflow:hidden;'></div>");
                    $gmapEl = $("<div style='border:1px solid #fff;height:300px;border-radius:10px;'></div>");
                    $helpEl = $("<div class='help-block'>Drag and drop the marker to set and fine tune your location.</div>");

                    $styleEl.append($gmapEl);
                    $containerEl.append($styleEl);
                    $containerEl.append($helpEl);

                    if (element.parent('.input-group').length) $containerEl.insertAfter(element.parent());
                    else $containerEl.insertAfter(element);

                    $gmapEl.data("lat", $("#" + opts.prefix + "Latitude").val());
                    $gmapEl.data("lng", $("#" + opts.prefix + "Longitude").val());
                    $gmapEl.GoogleMap({ draggableMarker: true });
                }

                function _updateLocation(obj, place) {
                    if (place) {
                        updatePlace(place, opts.prefix);
                        obj.data("init-value", obj.val());
                        if ($gmapEl != null) {
                            $gmapEl.data("lat", $("#" + opts.prefix + "Latitude").val());
                            $gmapEl.data("lng", $("#" + opts.prefix + "Longitude").val());
                            $gmapEl.trigger('UpdateGMap');
                        }
                    }
                }
            }
            else
                element.addClass(pendingGeoComp);
        });
    };
    $.fn.GAutoComplete.defaults = {
        types: ['(regions)'],
        prefix: "",
        componentRestrictions: { country: [] }
    };

    function parseAddressComponent(address, column) {
        if (address == null || column == null) return "";
        var component = "";
        $.each(address, function (i, address_component) {
            if (address_component.types[0] == "street_number" && column == "Address1")
                component = address_component.long_name;
            else if (address_component.types[0] == "route" && column == "Address2")
                component = address_component.long_name;
            else if ((address_component.types[0] == "locality" || address_component.types[0] == "postal_town") && column == "City")
                component = address_component.long_name;
            else if ((address_component.types[0] == "administrative_area_level_1" || address_component.types[0] == "administrative_area_level_2") && column == "State")
                component = address_component.long_name;
            else if (address_component.types[0] == "country" && column == "Country")
                component = address_component.long_name;
            else if (address_component.types[0] == "postal_code" && column == "ZipCode")
                component = address_component.long_name;
        });
        return component;
    }

    function updatePlace(place, prefix) {
        if (place) {
            $(".GAutoComplete").val(place.formatted_address);
            $("#" + prefix + "PlaceId").val(place.place_id);
            $("#" + prefix + "Latitude").val(place.geometry.location.lat());
            $("#" + prefix + "Longitude").val(place.geometry.location.lng());
            var city = parseAddressComponent(place.address_components, "City");
            if (city == null || city.length == 0)
                city = parseAddressComponent(place.address_components, "State");
            $("#" + prefix + "City").val(city);
            $("#" + prefix + "State").val(parseAddressComponent(place.address_components, "State"));
            $("#" + prefix + "ZipCode").val(parseAddressComponent(place.address_components, "ZipCode"));
            $("#" + prefix + "PostCode").val(parseAddressComponent(place.address_components, "ZipCode"));
            $("#" + prefix + "Country").val(parseAddressComponent(place.address_components, "Country"));
            if ($("#" + prefix + "CountryId").length == 1)
                $("#" + prefix + "CountryId").val($("#" + prefix + "CountryId option").filter(function (index) { return $(this).text().trim() === parseAddressComponent(place.address_components, "Country").trim(); }).attr("value"));
        }
    }
}