<?php 
namespace Sale\Report\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function EmailOrdersAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Order Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Report created at ".date("Y-m-d h:i");
			
			$rows = $this->getAllReportList(false);
			$data = $this->PrepareAllReportList($rows,true);
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."order_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $OrderID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	public function PrintOrdersAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $OrderID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	public function DownloadOrdersAction()
	{
		$rows = $this->getAllReportList(false);
		$data = $this->PrepareAllReportList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."order_reports-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $OrderID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	public function PrepareAllReportList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['OrderID']=array("title"=>"Order ID","display"=>true);
		$ReturnData['header']['OrderNo']=array("title"=>"OrderNo","display"=>true);
		$ReturnData['header']['CreatedDate']=array("title"=>"CreatedDate","display"=>true);
		$ReturnData['header']['Name']=array("title"=>"Name","display"=>true);
		$ReturnData['header']['Email']=array("title"=>"Email","display"=>true);
		$ReturnData['header']['BillingAddress']=array("title"=>"Billing Address","display"=>true);
		$ReturnData['header']['ShippingAddress']=array("title"=>"Shipping Address","display"=>true);
		$ReturnData['header']['PaymentStatus']=array("title"=>"Payment Status","display"=>true);
		$ReturnData['header']['OrderStatus']=array("title"=>"Order Status","display"=>true);
		if($csv===false){
			$ReturnData['header']['Detail']=array("title"=>"Detail","display"=>false);
			$ReturnData['header']['Invoice']=array("title"=>"Invoice","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$ReturnData['data'][$CurrentRecord->OrderID]['OrderID'] = isset($CurrentRecord->OrderID)?$CurrentRecord->OrderID:"";
				$ReturnData['data'][$CurrentRecord->OrderID]['OrderNo'] = isset($CurrentRecord->OrderNo)?$CurrentRecord->OrderNo:"";
				$ReturnData['data'][$CurrentRecord->OrderID]['CreatedDate'] = isset($CurrentRecord->CreatedDate)?ConvertDateFromDb($CurrentRecord->CreatedDate):"";
				$ReturnData['data'][$CurrentRecord->OrderID]['Name'] = (isset($CurrentRecord->BillingFirstName)?$CurrentRecord->BillingFirstName:"")." ".(isset($CurrentRecord->BillingLastName)?$CurrentRecord->BillingLastName:"");
				$ReturnData['data'][$CurrentRecord->OrderID]['Email'] = (isset($CurrentRecord->Email)?$CurrentRecord->Email:"");
				$ReturnData['data'][$CurrentRecord->OrderID]['BillingAddress'] = $CurrentRecord->BillingAddress1." ".$CurrentRecord->BillingAddress2." ".$CurrentRecord->BillingCity." ".$CurrentRecord->BillingState." ".SKGetCountryByCodeFull($CurrentRecord->BillingCountry)." ".$CurrentRecord->BillingZipCode." ";
				$ReturnData['data'][$CurrentRecord->OrderID]['ShippingAddress'] = $CurrentRecord->ShippingAddress1." ".$CurrentRecord->ShippingAddress2." ".$CurrentRecord->ShippingCity." ".$CurrentRecord->ShippingState." ".SKGetCountryByCodeFull($CurrentRecord->ShippingCountry)." ".$CurrentRecord->ShippingZipCode." ";
				$ReturnData['data'][$CurrentRecord->OrderID]['PaymentStatus'] = isset($CurrentRecord->PaymentStatus)?$CurrentRecord->PaymentStatus:"";
				$ReturnData['data'][$CurrentRecord->OrderID]['OrderStatus'] = isset($CurrentRecord->OrderStatus)?$CurrentRecord->OrderStatus:"";
				if($csv===false){
					$ReturnData['data'][$CurrentRecord->OrderID]['Detail'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Sale\Order\Index&OrderID='.$CurrentRecord->OrderID.'&view=ViewOrder" class="btn btn-xs btn-primary">Detail</a>';
					$ReturnData['data'][$CurrentRecord->OrderID]['Invoice'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Sale\Order\Index&OrderID='.$CurrentRecord->OrderID.'&action=PrintInvoice&view=ViewOrder" class="btn btn-xs btn-primary">Invoice</a>';
				}
			}
		}
		return $ReturnData;
	}
	public function getAllReportList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$OrderObj = new DataTable(TABLE_ORDERS);
		//$where->notEqualTo('u.UserName','');
		
		if($PaymentStatus !="")
			$where->equalTo('PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('CreatedDate', $EndDate);
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('OrderNo','%'.$Value.'%')->OR
							->like('BillingFirstName','%'.$Value.'%')->OR
							->like('BillingLastName','%'.$Value.'%')->OR
							->like('BillingAddress1','%'.$Value.'%')->OR
							->like('BillingAddress2','%'.$Value.'%')->OR
							->like('BillingCity','%'.$Value.'%')->OR
							->like('BillingState','%'.$Value.'%')->OR
							->like('BillingCountry','%'.$Value.'%')->OR
							->like('BillingZipCode','%'.$Value.'%')->OR
							->like('BillingPhone','%'.$Value.'%')->OR
							->like('BillingFax','%'.$Value.'%')->OR
							->like('ShippingFirstName','%'.$Value.'%')->OR
							->like('ShippingLastName','%'.$Value.'%')->OR
							->like('ShippingAddress1','%'.$Value.'%')->OR
							->like('ShippingAddress2','%'.$Value.'%')->OR
							->like('ShippingCity','%'.$Value.'%')->OR
							->like('ShippingState','%'.$Value.'%')->OR
							->like('ShippingCountry','%'.$Value.'%')->OR
							->like('ShippingZipCode','%'.$Value.'%')->OR
							->like('ShippingPhone','%'.$Value.'%')->OR
							->like('ShippingFax','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('ShippingText','%'.$Value.'%')->OR
							->like('ShippingCode','%'.$Value.'%')->OR
							->like('VoucherText','%'.$Value.'%')->OR
							->like('VoucherCode','%'.$Value.'%')->OR
							->like('TransactionID','%'.$Value.'%')->OR
							->like('TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$OrderObj->where = $where;
		
		//$OrderObj->displayQuery = true;
		$OrderObj->AllowPaging =$paging;
		$OrderObj->PageSize=$PageSize;
		$OrderObj->PageTotalDisplay = 15; 
		$OrderObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $OrderObj;
		//$OrderObj->columnExpression=true;
		return $OrderObj->tableSelectAll(array("*"),array($OrderBy));
	
	}
	
	public function getSortByArray()
	{
		return  array(
					"11"=>array("display"=>"Name (A - Z)","column"=>"BillingFirstName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"BillingFirstName DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"GrandTotal ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"GrandTotal DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"CreatedDate ASC"),
					);
	}
	
	
	public function EmailPurchasedReportAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Product Purchased Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Product Purchased Reports created at ".date("Y-m-d h:i");
			
			$rows = $this->getPurchasedReportList(false);
			$data = $this->PreparePurchasedReportList($rows,true);
		
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."purchased_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $ID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	
	public function PrintPurchasedReportAction()
	{
		$rows = $this->getPurchasedReportList(false);
		$data = $this->PreparePurchasedReportList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $ID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	
	public function DownloadPurchasedReportAction()
	{
		$rows = $this->getPurchasedReportList(false);
		$data = $this->PreparePurchasedReportList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."purchased_reports-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $ID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	
	public function PreparePurchasedReportList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['OrderID']=array("title"=>"Order ID","display"=>true);
		$ReturnData['header']['OrderNo']=array("title"=>"OrderNo","display"=>true);
		$ReturnData['header']['CreatedDate']=array("title"=>"CreatedDate","display"=>true);
		$ReturnData['header']['Name']=array("title"=>"Name","display"=>true);
		$ReturnData['header']['Email']=array("title"=>"Email","display"=>true);
		$ReturnData['header']['ProductName']=array("title"=>"Product Name","display"=>true);
		$ReturnData['header']['PaymentStatus']=array("title"=>"Payment Status","display"=>true);
		$ReturnData['header']['OrderStatus']=array("title"=>"Order Status","display"=>true);
		$ReturnData['header']['Price']=array("title"=>"Price","display"=>true);
		$ReturnData['header']['Qty']=array("title"=>"Quantity","display"=>true);
		$ReturnData['header']['Stock']=array("title"=>"Stock","display"=>true);
		if($csv===false){
			$ReturnData['header']['Buttons']=array("title"=>"","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['OrderID'] = isset($CurrentRecord->OrderID)?$CurrentRecord->OrderID:"";
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['OrderNo'] = isset($CurrentRecord->OrderNo)?$CurrentRecord->OrderNo:"";
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['CreatedDate'] = isset($CurrentRecord->CreatedDate)?ConvertDateFromDb($CurrentRecord->CreatedDate):"";
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['Name'] = (isset($CurrentRecord->BillingFirstName)?$CurrentRecord->BillingFirstName:"")." ".(isset($CurrentRecord->BillingLastName)?$CurrentRecord->BillingLastName:"");
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['Email'] = (isset($CurrentRecord->Email)?$CurrentRecord->Email:"");
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['ProductName'] = $CurrentRecord->ProductName;
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['PaymentStatus'] = isset($CurrentRecord->PaymentStatus)?$CurrentRecord->PaymentStatus:"";
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['OrderStatus'] = isset($CurrentRecord->OrderStatus)?$CurrentRecord->OrderStatus:"";
				
				if($csv===false)
					$ReturnData['data'][$CurrentRecord->OrderDetailID]['Price'] = isset($CurrentRecord->Price)?$this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($CurrentRecord->Price):"";
				else
					$ReturnData['data'][$CurrentRecord->OrderDetailID]['Price'] = number_format($CurrentRecord->Price,2);
				
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['Qty'] = isset($CurrentRecord->Qty)?$CurrentRecord->Qty:"";
				$ReturnData['data'][$CurrentRecord->OrderDetailID]['Stock'] = isset($CurrentRecord->Stock)?$CurrentRecord->Stock:"";
				if($csv===false){
					$ReturnData['data'][$CurrentRecord->OrderDetailID]['Buttons'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Sale\Order\Index&OrderID='.$CurrentRecord->OrderID.'&view=ViewOrder" class="btn btn-xs btn-primary">Order</a> 
																					<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Sale\Order\Index&OrderID='.$CurrentRecord->OrderID.'&action=PrintInvoice&view=ViewOrder" class="btn btn-xs btn-primary">Invoice</a>
																					<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Catalog\Product\Index&ParentID=0&ProductID='.$CurrentRecord->ProductID.'&view=AddEditProduct" class="btn btn-xs btn-primary">Product</a>
																			        ';
				}
			}
		}
		return $ReturnData;
	}
	public function getPurchasedReportList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"o.CreatedDate DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$UserID = (isset($_REQUEST['UserID']) && is_array($_REQUEST['UserID']))?implode(",",$_REQUEST['UserID']):@$_REQUEST['UserID'];
		$ProductIDs = (isset($_REQUEST['ProductIDs']) && is_array($_REQUEST['ProductIDs']))?implode(",",$_REQUEST['ProductIDs']):@$_REQUEST['ProductIDs'];
		
		if(isset($ProductIDs) && is_array($ProductIDs))
		  $ProductIDs = implode(",",$ProductIDs);
		
		if(isset($UserID) && is_array($UserID))
		  $UserID = implode(",",$UserID);
		
			
			
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ReportObj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
		
		$ReportObj->joinExpression = true;
		$ReportObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
									  'on'=>"(od.OrderID=o.OrderID)",
									  'columns'=>array("OrderNo","BillingFirstName","BillingLastName","Email","PaymentStatus","OrderStatus","CreatedDate"),
									  'type'=>''
									  );
										  
		$ReportObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(od.ReferenceID=p.ProductID and od.ItemType='Product')",
									  'columns'=>array("ProductID","ProductName","Stock"),
									  'type'=>''
									  );
		
		
		if($PaymentStatus !="")
			$where->equalTo('o.PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('o.OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('o.PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('o.CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('o.DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
		
		if($ProductIDs !=""){
			$where->in('p.ProductID',explode(",",$ProductIDs));
		}
		if($UserID !=""){
			$where->in('o.UserID',explode(",",$UserID));
		}
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('o.OrderNo','%'.$Value.'%')->OR
							->like('o.BillingFirstName','%'.$Value.'%')->OR
							->like('o.BillingLastName','%'.$Value.'%')->OR
							->like('o.BillingAddress1','%'.$Value.'%')->OR
							->like('o.BillingAddress2','%'.$Value.'%')->OR
							->like('o.BillingCity','%'.$Value.'%')->OR
							->like('o.BillingState','%'.$Value.'%')->OR
							->like('o.BillingCountry','%'.$Value.'%')->OR
							->like('o.BillingZipCode','%'.$Value.'%')->OR
							->like('o.BillingPhone','%'.$Value.'%')->OR
							->like('o.BillingFax','%'.$Value.'%')->OR
							->like('o.ShippingFirstName','%'.$Value.'%')->OR
							->like('o.ShippingLastName','%'.$Value.'%')->OR
							->like('o.ShippingAddress1','%'.$Value.'%')->OR
							->like('o.ShippingAddress2','%'.$Value.'%')->OR
							->like('o.ShippingCity','%'.$Value.'%')->OR
							->like('o.ShippingState','%'.$Value.'%')->OR
							->like('o.ShippingCountry','%'.$Value.'%')->OR
							->like('o.ShippingZipCode','%'.$Value.'%')->OR
							->like('o.ShippingPhone','%'.$Value.'%')->OR
							->like('o.ShippingFax','%'.$Value.'%')->OR
							->like('o.Email','%'.$Value.'%')->OR
							->like('o.ShippingText','%'.$Value.'%')->OR
							->like('o.ShippingCode','%'.$Value.'%')->OR
							->like('o.VoucherText','%'.$Value.'%')->OR
							->like('o.VoucherCode','%'.$Value.'%')->OR
							->like('o.TransactionID','%'.$Value.'%')->OR
							->like('o.TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$ReportObj->where = $where;
		
		//$ReportObj->displayQuery = true;
		$ReportObj->AllowPaging =$paging;
		$ReportObj->PageSize=$PageSize;
		$ReportObj->PageTotalDisplay = 15; 
		$ReportObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ReportObj;
		//$ReportObj->columnExpression=true;
		return $ReportObj->tableSelectAll(array("OrderDetailID","OrderID","Price","Total","Qty"),array($OrderBy));
	
	}
	
	public function getPurchasedReportSortByArray()
	{
		return  array(
					"11"=>array("display"=>"Customer Name (A - Z)","column"=>"o.BillingFirstName ASC"),
					"12"=>array("display"=>"Customer Name (Z - A)","column"=>"o.BillingFirstName DESC"),
					"41"=>array("display"=>"Product Name (A - Z)","column"=>"p.ProductName ASC"),
					"42"=>array("display"=>"Product Name (Z - A)","column"=>"p.ProductName DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"od.Price ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"od.Price DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"o.CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"o.CreatedDate ASC"),
					);
	}
	
	/* TotalPurchaseByUser start */
	public function EmailTotalPurchaseByUserAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Product Purchased Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Product Purchased Reports created at ".date("Y-m-d h:i");
			
			$rows = $this->getTotalPurchaseByUserList(false);
			$data = $this->PrepareTotalPurchaseByUserList($rows,true);
		
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."purchased_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $ID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	
	public function PrintTotalPurchaseByUserAction()
	{
		$rows = $this->getTotalPurchaseByUserList(false);
		$data = $this->PrepareTotalPurchaseByUserList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $ID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	
	public function DownloadTotalPurchaseByUserAction()
	{
		$rows = $this->getTotalPurchaseByUserList(false);
		$data = $this->PrepareTotalPurchaseByUserList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."purchased_reports_by_user-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $ID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	
	public function PrepareTotalPurchaseByUserList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['UserName']=array("title"=>"UserName","display"=>true);
		$ReturnData['header']['Name']=array("title"=>"Name","display"=>true);
		$ReturnData['header']['Email']=array("title"=>"Email","display"=>true);
		$ReturnData['header']['NosOfOrders']=array("title"=>"Nos. of Orders","display"=>true);
		$ReturnData['header']['Price']=array("title"=>"Grand Total","display"=>true);
		if($csv===false){
			$ReturnData['header']['Buttons']=array("title"=>"","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$uniqid= uniqid();
				$ReturnData['data'][$uniqid]['UserName'] = isset($CurrentRecord->UserName)?$CurrentRecord->UserName:"";
				$ReturnData['data'][$uniqid]['Name'] = (isset($CurrentRecord->FirstName)?$CurrentRecord->FirstName:"")." ".(isset($CurrentRecord->LastName)?$CurrentRecord->LastName:"");
				$ReturnData['data'][$uniqid]['Email'] = (isset($CurrentRecord->Email)?$CurrentRecord->Email:"");
				$ReturnData['data'][$uniqid]['NosOfOrders'] = number_format($CurrentRecord->CountOrders,0);
				
				
				if($csv===false)
					$ReturnData['data'][$uniqid]['Price'] = isset($CurrentRecord->SumGrandTotal)?$this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($CurrentRecord->SumGrandTotal):"";
				else
					$ReturnData['data'][$uniqid]['Price'] = number_format($CurrentRecord->SumGrandTotal,2);
				
				$ReturnData['data'][$uniqid]['Qty'] = isset($CurrentRecord->SumQty)?$CurrentRecord->SumQty:"";
				$ReturnData['data'][$uniqid]['Stock'] = isset($CurrentRecord->Stock)?$CurrentRecord->Stock:"";
				if($csv===false){
					$ReturnData['data'][$uniqid]['Buttons'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Customer\MyAccount\Index&UserID='.$CurrentRecord->UserID.'&view=AddEditUser" class="btn btn-xs btn-primary">User</a>
															   <a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Customer\MyAccount\Index&UserID='.$CurrentRecord->UserID.'&view=AddEditUser&tab=orders" class="btn btn-xs btn-primary">Orders</a>
															  ';
				}
			}
		}
		return $ReturnData;
	}
	public function getTotalPurchaseByUserList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"SUM(o.GrandTotal) DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$UserID = (isset($_REQUEST['UserID']) && is_array($_REQUEST['UserID']))?implode(",",$_REQUEST['UserID']):@$_REQUEST['UserID'];
		
		if(isset($UserID) && is_array($UserID))
		  $UserID = implode(",",$UserID);
		
			
			
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ReportObj = new DataTable(array('o'=>TABLE_ORDERS));
		
		$ReportObj->joinExpression = true;
		$ReportObj->joinArray[] = array('name'=>array('u'=>TABLE_USERS),
									  'on'=>"(u.UserID=o.UserID)",
									  'columns'=>array("*"),
									  'type'=>''
									  );
										  
		
		$where->notEqualTo('o.UserID','');
		
		if($PaymentStatus !="")
			$where->equalTo('o.PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('o.OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('o.PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('o.CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('o.DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
		
		if($UserID !=""){
			$where->in('o.UserID',explode(",",$UserID));
		}
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('u.FirstName','%'.$Value.'%')->OR
							->like('u.LastName','%'.$Value.'%')->OR
							->like('u.Address1','%'.$Value.'%')->OR
							->like('u.Address2','%'.$Value.'%')->OR
							->like('u.City','%'.$Value.'%')->OR
							->like('u.State','%'.$Value.'%')->OR
							->like('u.Country','%'.$Value.'%')->OR
							->like('u.ZipCode','%'.$Value.'%')->OR
							->like('u.Phone','%'.$Value.'%')->OR
							->like('o.OrderNo','%'.$Value.'%')->OR
							->like('o.BillingFirstName','%'.$Value.'%')->OR
							->like('o.BillingLastName','%'.$Value.'%')->OR
							->like('o.BillingAddress1','%'.$Value.'%')->OR
							->like('o.BillingAddress2','%'.$Value.'%')->OR
							->like('o.BillingCity','%'.$Value.'%')->OR
							->like('o.BillingState','%'.$Value.'%')->OR
							->like('o.BillingCountry','%'.$Value.'%')->OR
							->like('o.BillingZipCode','%'.$Value.'%')->OR
							->like('o.BillingPhone','%'.$Value.'%')->OR
							->like('o.BillingFax','%'.$Value.'%')->OR
							->like('o.ShippingFirstName','%'.$Value.'%')->OR
							->like('o.ShippingLastName','%'.$Value.'%')->OR
							->like('o.ShippingAddress1','%'.$Value.'%')->OR
							->like('o.ShippingAddress2','%'.$Value.'%')->OR
							->like('o.ShippingCity','%'.$Value.'%')->OR
							->like('o.ShippingState','%'.$Value.'%')->OR
							->like('o.ShippingCountry','%'.$Value.'%')->OR
							->like('o.ShippingZipCode','%'.$Value.'%')->OR
							->like('o.ShippingPhone','%'.$Value.'%')->OR
							->like('o.ShippingFax','%'.$Value.'%')->OR
							->like('o.Email','%'.$Value.'%')->OR
							->like('o.ShippingText','%'.$Value.'%')->OR
							->like('o.ShippingCode','%'.$Value.'%')->OR
							->like('o.VoucherText','%'.$Value.'%')->OR
							->like('o.VoucherCode','%'.$Value.'%')->OR
							->like('o.TransactionID','%'.$Value.'%')->OR
							->like('o.TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$ReportObj->where = $where;
		
		//$ReportObj->displayQuery = true;
		$ReportObj->AllowPaging =$paging;
		$ReportObj->PageSize=$PageSize;
		$ReportObj->PageTotalDisplay = 15; 
		$ReportObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ReportObj;
		$ReportObj->columnExpression=true;
		$ReportObj->orderExpression=true;
		$ReportObj->groupBy = array("o.UserID");
		//$ReportObj->resetPagingGroup = false;
		return $ReportObj->tableSelectAll(array("SumTotal"=>"SUM(o.Total)",
												"CountOrders"=>"Count(o.OrderID)",
												"SumGrandTotal"=>"SUM(o.GrandTotal)",
												"SumSubTotal"=>"SUM(o.SubTotal)
												"),$OrderBy);
	
	}
	
	public function getTotalPurchaseByUserSortByArray()
	{
		return  array(
					"11"=>array("display"=>"Customer Name (A - Z)","column"=>"u.FirstName ASC"),
					"12"=>array("display"=>"Customer Name (Z - A)","column"=>"u.FirstName DESC"),
					"21"=>array("display"=>"Total (Low &gt; High)","column"=>"SUM(o.GrandTotal) ASC"),
					"22"=>array("display"=>"Total (High &gt; Low)","column"=>"SUM(o.GrandTotal) DESC"),
					"31"=>array("display"=>"Nos. of Orders (Low &gt; High)","column"=>"Count(o.OrderID) ASC"),
					"32"=>array("display"=>"Nos. of Orders (High &gt; Low)","column"=>"Count(o.OrderID) DESC"),
					);
	}
	/* PTotalPurchaseByUser end */
	
	/* Purchase by User report start */
	public function EmailPurchasedReportByUserAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Product Purchased Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Product Purchased Reports created at ".date("Y-m-d h:i");
			
			$rows = $this->getPurchasedReportByUserList(false);
			$data = $this->PreparePurchasedReportByUserList($rows,true);
		
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."purchased_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $ID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	
	public function PrintPurchasedReportByUserAction()
	{
		$rows = $this->getPurchasedReportByUserList(false);
		$data = $this->PreparePurchasedReportByUserList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $ID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	
	public function DownloadPurchasedReportByUserAction()
	{
		$rows = $this->getPurchasedReportByUserList(false);
		$data = $this->PreparePurchasedReportByUserList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."purchased_reports_by_user-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $ID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	
	public function PreparePurchasedReportByUserList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		if($csv===false){
			$ReturnData['header']['Checkbox']=array("title"=>'<input type="checkbox" class="ChkItemAll" name="AllCheck" value="1" onclick="return CheckAllItem()">',"display"=>false);
		}
		//$ReturnData['header']['Name']=array("title"=>"Name","display"=>true);
		$ReturnData['header']['Email']=array("title"=>"Email","display"=>true);
		$ReturnData['header']['ProductName']=array("title"=>"Product Name","display"=>true);
		$ReturnData['header']['Price']=array("title"=>"Total Price","display"=>true);
		$ReturnData['header']['Qty']=array("title"=>"Quantity","display"=>true);
		$ReturnData['header']['Stock']=array("title"=>"Stock","display"=>true);
		if($csv===false){
			$ReturnData['header']['Buttons']=array("title"=>"","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$uniqid= uniqid();
				if($csv===false){
					if($CurrentRecord->UserID != "")
						$ReturnData['data'][$uniqid]['Checkbox'] = '<input type="checkbox" class="ChkItem" name="UserID[]" value="'.$CurrentRecord->UserID.'">';
					else
						$ReturnData['data'][$uniqid]['Checkbox'] = '';
				}
					
				$ReturnData['data'][$uniqid]['OrderID'] = isset($CurrentRecord->OrderID)?$CurrentRecord->OrderID:"";
				$ReturnData['data'][$uniqid]['OrderNo'] = isset($CurrentRecord->OrderNo)?$CurrentRecord->OrderNo:"";
				$ReturnData['data'][$uniqid]['CreatedDate'] = isset($CurrentRecord->CreatedDate)?ConvertDateFromDb($CurrentRecord->CreatedDate):"";
				$ReturnData['data'][$uniqid]['Name'] = (isset($CurrentRecord->BillingFirstName)?$CurrentRecord->BillingFirstName:"")." ".(isset($CurrentRecord->BillingLastName)?$CurrentRecord->BillingLastName:"");
				$ReturnData['data'][$uniqid]['Email'] = (isset($CurrentRecord->Email)?$CurrentRecord->Email:"");
				$ReturnData['data'][$uniqid]['ProductName'] = $CurrentRecord->ProductName;
				$ReturnData['data'][$uniqid]['PaymentStatus'] = isset($CurrentRecord->PaymentStatus)?$CurrentRecord->PaymentStatus:"";
				$ReturnData['data'][$uniqid]['OrderStatus'] = isset($CurrentRecord->OrderStatus)?$CurrentRecord->OrderStatus:"";
				
				if($csv===false)
					$ReturnData['data'][$uniqid]['Price'] = isset($CurrentRecord->SumTotal)?$this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($CurrentRecord->SumTotal):"";
				else
					$ReturnData['data'][$uniqid]['Price'] = number_format($CurrentRecord->SumTotal,2);
				
				$ReturnData['data'][$uniqid]['Qty'] = isset($CurrentRecord->SumQty)?$CurrentRecord->SumQty:"";
				$ReturnData['data'][$uniqid]['Stock'] = isset($CurrentRecord->Stock)?$CurrentRecord->Stock:"";
				if($csv===false){
					$ReturnData['data'][$uniqid]['Buttons'] = '<a target="_blank" href="mailto:'.$CurrentRecord->Email.'" class="btn btn-xs btn-info">Email</a>
															   <a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Catalog\Product\Index&ParentID=0&ProductID='.$CurrentRecord->ProductID.'&view=AddEditProduct" class="btn btn-xs btn-primary">Product</a>
															  ';
				}
			}
		}
		return $ReturnData;
	}
	public function getPurchasedReportByUserList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"SUM(od.Qty) DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$UserID = (isset($_REQUEST['UserID']) && is_array($_REQUEST['UserID']))?implode(",",$_REQUEST['UserID']):@$_REQUEST['UserID'];
		$ProductIDs = (isset($_REQUEST['ProductIDs']) && is_array($_REQUEST['ProductIDs']))?implode(",",$_REQUEST['ProductIDs']):@$_REQUEST['ProductIDs'];
		
		if(isset($ProductIDs) && is_array($ProductIDs))
		  $ProductIDs = implode(",",$ProductIDs);
		
		if(isset($UserID) && is_array($UserID))
		  $UserID = implode(",",$UserID);
		
			
			
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"500";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ReportObj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
		
		$ReportObj->joinExpression = true;
		$ReportObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
									  'on'=>"(od.OrderID=o.OrderID)",
									  //'columns'=>array("Email","UserID","BillingFirstName","BillingLastName"),
									  'columns'=>array("Email","UserID"),
									  'type'=>''
									  );
										  
		$ReportObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(od.ReferenceID=p.ProductID and od.ItemType='Product')",
									  'columns'=>array("ProductID","ProductName","Stock"),
									  'type'=>''
									  );
		
		
		if($PaymentStatus !="")
			$where->equalTo('o.PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('o.OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('o.PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('o.CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('o.DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
		
		if($ProductIDs !=""){
			$where->in('p.ProductID',explode(",",$ProductIDs));
		}
		if($UserID !=""){
			$where->in('o.UserID',explode(",",$UserID));
		}
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('o.OrderNo','%'.$Value.'%')->OR
							->like('o.BillingFirstName','%'.$Value.'%')->OR
							->like('o.BillingLastName','%'.$Value.'%')->OR
							->like('o.BillingAddress1','%'.$Value.'%')->OR
							->like('o.BillingAddress2','%'.$Value.'%')->OR
							->like('o.BillingCity','%'.$Value.'%')->OR
							->like('o.BillingState','%'.$Value.'%')->OR
							->like('o.BillingCountry','%'.$Value.'%')->OR
							->like('o.BillingZipCode','%'.$Value.'%')->OR
							->like('o.BillingPhone','%'.$Value.'%')->OR
							->like('o.BillingFax','%'.$Value.'%')->OR
							->like('o.ShippingFirstName','%'.$Value.'%')->OR
							->like('o.ShippingLastName','%'.$Value.'%')->OR
							->like('o.ShippingAddress1','%'.$Value.'%')->OR
							->like('o.ShippingAddress2','%'.$Value.'%')->OR
							->like('o.ShippingCity','%'.$Value.'%')->OR
							->like('o.ShippingState','%'.$Value.'%')->OR
							->like('o.ShippingCountry','%'.$Value.'%')->OR
							->like('o.ShippingZipCode','%'.$Value.'%')->OR
							->like('o.ShippingPhone','%'.$Value.'%')->OR
							->like('o.ShippingFax','%'.$Value.'%')->OR
							->like('o.Email','%'.$Value.'%')->OR
							->like('o.ShippingText','%'.$Value.'%')->OR
							->like('o.ShippingCode','%'.$Value.'%')->OR
							->like('o.VoucherText','%'.$Value.'%')->OR
							->like('o.VoucherCode','%'.$Value.'%')->OR
							->like('o.TransactionID','%'.$Value.'%')->OR
							->like('o.TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$ReportObj->where = $where;
		
		$ReportObj->displayQuery = true;
		$ReportObj->AllowPaging =$paging;
		$ReportObj->PageSize=$PageSize;
		$ReportObj->PageTotalDisplay = 15; 
		$ReportObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $ReportObj;
		$ReportObj->columnExpression=true;
		$ReportObj->orderExpression=true;
		$ReportObj->groupBy = array("p.ProductID","o.Email","o.UserID");
		return $ReportObj->tableSelectAll(array("SumTotal"=>"SUM(od.Total)","SumQty"=>"SUM(od.Qty)"),$OrderBy);
	
	}
	
	public function getPurchasedReportByUserSortByArray()
	{
		return  array(
					"11"=>array("display"=>"Customer Name (A - Z)","column"=>"o.BillingFirstName ASC"),
					"12"=>array("display"=>"Customer Name (Z - A)","column"=>"o.BillingFirstName DESC"),
					"41"=>array("display"=>"Product Name (A - Z)","column"=>"p.ProductName ASC"),
					"42"=>array("display"=>"Product Name (Z - A)","column"=>"p.ProductName DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"SUM(od.Total) ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"SUM(od.Total) DESC"),
					"31"=>array("display"=>"Qty (Low &gt; High)","column"=>"SUM(od.Qty) ASC"),
					"32"=>array("display"=>"Qty (High &gt; Low)","column"=>"SUM(od.Qty) DESC"),
					);
	}
	/* Purchase by User report end */
	
	/* BestSellers report start */
	public function EmailBestSellersReportAction()
	{
		if(count($_POST)){
			$Email = isset($_POST['Email'])?$_POST['Email']:"";
			
			$this->getSession()->setArrVar("alert",array("success","Email sent successfully."));
			$Mail_Subject = "Product Purchased Reports from ".d('SITE_NAME')."";
			$Mail_ToEmail = isset($_POST['Email'])?$_POST['Email']:"";
			
			$Mail_FromEmail = d('ADMIN_EMAIL');
			$Mail_FromName = d('SITE_NAME');
			$MessageBody ="Product Purchased Reports created at ".date("Y-m-d h:i");
			
			$rows = $this->getBestSellersReportList(false);
			$data = $this->PrepareBestSellersReportList($rows,true);
		
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
			$filename=$dir."bestsellers_reports-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
			}
			fputcsv($csv_resource, $pushArray);
				
			foreach($data['data'] as $ID=>$DArr){
				$pushArray = array();
				foreach($data['header'] as $index=>$HArr){
					$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
				}
				fputcsv($csv_resource, $pushArray);
			}
			fclose($csv_resource);
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody,"",d("EMAIL_FORMAT"),true,$filename);
					
		}
	}
	
	public function PrintBestSellersReportAction()
	{
		$rows = $this->getBestSellersReportList(false);
		$data = $this->PrepareBestSellersReportList($rows,true);
		?>
		<table  class="table table-striped jambo_table">
			<thead>
			<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($HArr['title'])?$HArr['title']:""?></td>
				<?php endforeach;?>
			</tr>
			</thead>
			<tbody>
			<?php foreach($data['data'] as $ID=>$DArr):?>
				<tr>
				<?php foreach($data['header'] as $index=>$HArr):?>
				<td><?php echo isset($DArr[$index])?$DArr[$index]:""?></td>
				<?php endforeach;?>
				</tr>
			<?php endforeach;?>
			</tbody>
		</table>
		<script type="text/javascript">
		window.print();
		</script>	
		<?php 
		exit;
	}
	
	public function DownloadBestSellersReportAction()
	{
		$rows = $this->getBestSellersReportList(false);
		$data = $this->PrepareBestSellersReportList($rows,true);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/reports");
		$filename=$dir."bestsellers_reports-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		
		$pushArray = array();
		foreach($data['header'] as $index=>$HArr){
			$pushArray[] = (isset($HArr['title'])?$HArr['title']:"");
		}
		fputcsv($csv_resource, $pushArray);
			
		foreach($data['data'] as $ID=>$DArr){
			$pushArray = array();
			foreach($data['header'] as $index=>$HArr){
				$pushArray[] = (isset($DArr[$index])?$DArr[$index]:"");
			}
			fputcsv($csv_resource, $pushArray);
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
	}
	
	public function PrepareBestSellersReportList($rows,$csv=false)
	{
		$ReturnData = array("header"=>array(),"data"=>array());
		
		$ReturnData['header']['ProductID']=array("title"=>"Product ID","display"=>true);
		$ReturnData['header']['ProductName']=array("title"=>"Product Name","display"=>true);
		$ReturnData['header']['SaleQty']=array("title"=>"Sale Qty","display"=>true);
		$ReturnData['header']['SaleTotal']=array("title"=>"Sale Total","display"=>true);
		$ReturnData['header']['Stock']=array("title"=>"Stock","display"=>true);
		if($csv===false){
			$ReturnData['header']['Buttons']=array("title"=>"","display"=>false);
		}
		if(count($rows) > 0){
			foreach( $rows as $CurrentRecord){
				$ReturnData['data'][$CurrentRecord->ProductID]['ProductID'] = (isset($CurrentRecord->ProductID)?$CurrentRecord->ProductID:"");
				$ReturnData['data'][$CurrentRecord->ProductID]['ProductName'] = $CurrentRecord->ProductName;
				$ReturnData['data'][$CurrentRecord->ProductID]['SaleQty'] = isset($CurrentRecord->SaleQty)?$CurrentRecord->SaleQty:"";
				
				if($csv===false)
					$ReturnData['data'][$CurrentRecord->ProductID]['SaleTotal'] = isset($CurrentRecord->SaleTotal)?$this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($CurrentRecord->SaleTotal):"";
				else
					$ReturnData['data'][$CurrentRecord->ProductID]['SaleTotal'] = number_format($CurrentRecord->SaleTotal,2);
				
				$ReturnData['data'][$CurrentRecord->ProductID]['Stock'] = isset($CurrentRecord->Stock)?$CurrentRecord->Stock:"";
				if($csv===false){
					$ReturnData['data'][$CurrentRecord->ProductID]['Buttons'] = '<a target="_blank" href="'.DIR_WS_SITE_CONTROL.'index.php?m=Catalog\Product\Index&ParentID=0&ProductID='.$CurrentRecord->ProductID.'&view=AddEditProduct" class="btn btn-xs btn-primary">Product</a>
																			        ';
				}
			}
		}
		return $ReturnData;
	}
	public function getBestSellersReportList($paging=true)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"SUM(od.Total) DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$UserID = (isset($_REQUEST['UserID']) && is_array($_REQUEST['UserID']))?implode(",",$_REQUEST['UserID']):@$_REQUEST['UserID'];
		$ProductIDs = (isset($_REQUEST['ProductIDs']) && is_array($_REQUEST['ProductIDs']))?implode(",",$_REQUEST['ProductIDs']):@$_REQUEST['ProductIDs'];
		
		if(isset($ProductIDs) && is_array($ProductIDs))
		  $ProductIDs = implode(",",$ProductIDs);
		
		if(isset($UserID) && is_array($UserID))
		  $UserID = implode(",",$UserID);
		
			
			
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$StartDate = (isset($_REQUEST['stdt']) && $_REQUEST['stdt'] != "")?$_REQUEST['stdt']:"";
		$EndDate = (isset($_REQUEST['eddt']) && $_REQUEST['eddt'] != "")?$_REQUEST['eddt']." 23:59:59":"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ReportObj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
		
		$ReportObj->joinExpression = true;
		$ReportObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
									  'on'=>"(od.OrderID=o.OrderID)",
									  //'columns'=>array("OrderNo","BillingFirstName","BillingLastName","Email","PaymentStatus","OrderStatus","CreatedDate"),
									  'type'=>''
									  );
										  
		$ReportObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(od.ReferenceID=p.ProductID and od.ItemType='Product')",
									  'columns'=>array("ProductID","ProductName","Stock"),
									  'type'=>''
									  );
		
		
		if($PaymentStatus !="")
			$where->equalTo('o.PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('o.OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('o.PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('o.CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('o.DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
		
		if($ProductIDs !=""){
			$where->in('p.ProductID',explode(",",$ProductIDs));
		}
		if($UserID !=""){
			$where->in('o.UserID',explode(",",$UserID));
		}
		
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('o.OrderNo','%'.$Value.'%')->OR
							->like('o.BillingFirstName','%'.$Value.'%')->OR
							->like('o.BillingLastName','%'.$Value.'%')->OR
							->like('o.BillingAddress1','%'.$Value.'%')->OR
							->like('o.BillingAddress2','%'.$Value.'%')->OR
							->like('o.BillingCity','%'.$Value.'%')->OR
							->like('o.BillingState','%'.$Value.'%')->OR
							->like('o.BillingCountry','%'.$Value.'%')->OR
							->like('o.BillingZipCode','%'.$Value.'%')->OR
							->like('o.BillingPhone','%'.$Value.'%')->OR
							->like('o.BillingFax','%'.$Value.'%')->OR
							->like('o.ShippingFirstName','%'.$Value.'%')->OR
							->like('o.ShippingLastName','%'.$Value.'%')->OR
							->like('o.ShippingAddress1','%'.$Value.'%')->OR
							->like('o.ShippingAddress2','%'.$Value.'%')->OR
							->like('o.ShippingCity','%'.$Value.'%')->OR
							->like('o.ShippingState','%'.$Value.'%')->OR
							->like('o.ShippingCountry','%'.$Value.'%')->OR
							->like('o.ShippingZipCode','%'.$Value.'%')->OR
							->like('o.ShippingPhone','%'.$Value.'%')->OR
							->like('o.ShippingFax','%'.$Value.'%')->OR
							->like('o.Email','%'.$Value.'%')->OR
							->like('o.ShippingText','%'.$Value.'%')->OR
							->like('o.ShippingCode','%'.$Value.'%')->OR
							->like('o.VoucherText','%'.$Value.'%')->OR
							->like('o.VoucherCode','%'.$Value.'%')->OR
							->like('o.TransactionID','%'.$Value.'%')->OR
							->like('o.TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$ReportObj->where = $where;
		
		$ReportObj->groupBy = array("p.ProductID");
		//$ReportObj->displayQuery = true;
		$ReportObj->columnExpression=true;
		$ReportObj->orderExpression=true;
		return $ReportObj->tableSelectAll(array("SUM(od.Qty) as SaleQty,SUM(od.Total) as SaleTotal"),$OrderBy);
	
	}
	
	public function getBestSellersReportSortByArray()
	{
		return  array(
					"41"=>array("display"=>"Product Name (A - Z)","column"=>"p.ProductName ASC"),
					"42"=>array("display"=>"Product Name (Z - A)","column"=>"p.ProductName DESC"),
					"21"=>array("display"=>"SaleTotal (Low &gt; High)","column"=>"SUM(od.Total) ASC"),
					"22"=>array("display"=>"SaleTotal (High &gt; Low)","column"=>"SUM(od.Total) DESC"),
					"31"=>array("display"=>"SaleQty (Low &gt; High)","column"=>"SUM(od.Qty) ASC"),
					"32"=>array("display"=>"SaleQty (High &gt; Low)","column"=>"SUM(od.Qty) DESC"),
					);
	}
	/* BestSellers report end */
	public function pageTitle()
	{
		return "Reports";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
				</div>		
			   ';
	}
	
	
}	