<?php 
namespace Sale\Order\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class MessageController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditMessageAction()
	{
		if(count($_POST)>0)
		{
			$MessageObj = new DataTable(TABLE_ORDER_MESSAGE);
			$OrderMsgID = isset($_GET['OrderMsgID'])?$_GET['OrderMsgID']:0;

			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['OrderMsgTitle'] = isset($_POST['OrderMsgTitle'])?$_POST['OrderMsgTitle']:"";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:0;
			
			if($OrderMsgID > 0)
			{
				
				$MessageObj->where[] = array('=',array('OrderMsgID' => $OrderMsgID));
				$MessageObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Message updated successfully."));
				
			}
			else 
			{
							
				$OrderMsgID = $MessageObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Message added successfully."));
				
			}
			
			
			
			
					
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=OrderMessages&OrderMsgID=$OrderMsgID");
			
			exit;
		}
		
	}
	
	public function UpdateMessageAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$MessageObj = new DataTable(TABLE_ORDER_MESSAGE);
				$OrderMsgID =$_POST['OrderMsgID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$MessageObj->where[] = array('=',array('OrderMsgID' => $OrderMsgID));
				$MessageObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Message updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=OrderMessages");
			 exit;
		}
	}
	
	public function DeleteMessageAction()
	{
		$OrderMsgID = isset($_GET['OrderMsgID'])?$_GET['OrderMsgID']:0;
		$obj = $this->getDetail($OrderMsgID);
		
		if($OrderMsgID > 0 && $obj->DefaultValue != "1")
		{
			$MessageObj = new DataTable(TABLE_ORDER_MESSAGE);
			$MessageObj->where[] = array('=',array('OrderMsgID' => $OrderMsgID));
			$MessageObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Message deleted successfully."));
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=OrderMessages");
		 exit;
	}
	public function getList()
	{
		$MessageObj = new DataTable(TABLE_ORDER_MESSAGE);
		$MessageObj->where = "1";
		
		$MessageObj->orderExpression = true;
		$MessageObj->AllowPaging =true;
		$MessageObj->PageSize=50;
		$MessageObj->PageTotalDisplay = 15; 
		$MessageObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $MessageObj;
		return $MessageObj->tableSelectAll(array("*"),"Position ASC,OrderMsgID DESC");
	
	}
	
	
	public function getDetail($OrderMsgID)
	{
		if($OrderMsgID > 0)
		{
			$MessageObj = new DataTable(array('m'=>TABLE_ORDER_MESSAGE));
			$MessageObj->where[] = array('=',array('m.OrderMsgID' => $OrderMsgID));
			return (object)$MessageObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Order Message";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditMessage">Add Order Message</a>
					</div>
              </div>		
			   ';
	}
	
	
}	