<?php 
namespace Sale\Order\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Sale\Order\Common as MyAccountCommon;
use Laminas\Db\Sql\Where;
use Base\File\FileHandle as FileHandle;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	public function AddProductCartAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$GLOBALS['UserIDByAdmin'] = $UserID;
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($UserID);
		if(count($_POST)){
			foreach($_POST['ProductID'] as $k=>$ProductID){
				$Qty = (isset($_POST['Qty']) && $_POST['Qty'] >0)?ceil($_POST['Qty']):"1";
				$return = $this->getClass("Sale\Cart\Common")->AddProductInTmpCart($ProductID,$Qty);
				
			}
			echo "1";
			exit;
		}
	}
	
	
	public function DeleteCartAction()
	{
		$ItemID = isset($_REQUEST['ItemID'])?$_REQUEST['ItemID']:"";
		if($ItemID != ""){
			$SessionID = $this->getSession()->getCurrentSID();
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$where = new Where();
			$where->equalTo('SessionID',$SessionID);
			$where->NEST//start braket
			->equalTo('ItemID',$ItemID)
			->OR
			->equalTo('ParentItemID',$ItemID)
			->UNNEST;
			$TmpCartObj->where = $where;
			$TmpCartObj->tableDelete();
		}
		echo "1";
		exit;
		
	}
	
	public function UpdateProductCartAction()
	{
		
		if(count($_POST) > 0){
			$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
			$GLOBALS['UserIDByAdmin'] = $UserID;
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($UserID);
		
			for($i=1;$i<$_POST['Count'];$i++){
				$SessionID = $this->getSession()->getCurrentSID();
				$ItemID = isset($_POST['ItemID'.$i])?$_POST['ItemID'.$i]:"";
				$Qty = isset($_POST['Qty'][$ItemID])?$_POST['Qty'][$ItemID]:"1";
				if(trim($Qty) <= "0" OR trim($Qty)=="" OR !is_numeric($Qty))
				{
					$this->getSession()->setArrVar("alert",array("danger",d("DEFINE_INVALID_QUANTITY")));
					MyRedirect(SKSEOURL('checkout','Cart')); 	
					exit;
				}
				
				$cartRows = $this->getClass("Sale\Cart\Common")->getShoppingCart();
				foreach($cartRows as $CurrentTmpItem){
					if($CurrentTmpItem->ItemID==$ItemID && isset($CurrentTmpItem->ItemID) && $CurrentTmpItem->ItemID !="" && in_array($CurrentTmpItem->ItemType,array("Bundle","Product","GiftVoucher"))){
						$ProductID = $CurrentTmpItem->ReferenceID;
						$Qty = isset($_POST['Qty'][$ItemID])?$_POST['Qty'][$ItemID]:"1";
						$ModifyPrice = isset($_POST['ModifyPrice'][$ItemID])?$_POST['ModifyPrice'][$ItemID]:"0";
						
						$POSTDUMP = unserialize(base64_decode($CurrentTmpItem->SessionInfo));		
						$TmpCartObj = new DataTable(TABLE_TMPCART);
						$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$TmpCartObj->where[] = array('=',array('ItemID' => $ItemID));
						$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
							
							
						if($ModifyPrice=="1"){
							if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
								$DataArray = array();
								$DataArray['ModifyPrice'] = $ModifyPrice;
								$DataArray['UnitPrice'] = (isset($_POST['UnitPrice'][$ItemID]) && $_POST['UnitPrice'][$ItemID] > 0)?$_POST['UnitPrice'][$ItemID]:"0";
								$DataArray['TaxPercent'] = (isset($_POST['TaxPercent'][$ItemID]) && $_POST['TaxPercent'][$ItemID] > 0)?$_POST['TaxPercent'][$ItemID]:"0";
								$TaxPrice = ($DataArray['TaxPercent']/100) * $DataArray['UnitPrice'];
								
								$DataArray['TaxPrice'] = $TaxPrice;
								$DataArray['Price'] = $DataArray['UnitPrice'];
								
								$DataArray['PriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
								$DataArray['Qty'] = $Qty;
								$DataArray['Total'] = $DataArray['Price'] * $DataArray['Qty'];
								$DataArray['TotalWithTax'] = $DataArray['PriceWithTax'] * $DataArray['Qty'];
								$TmpCartObj->tableUpdate($DataArray);
							}
							
						}
						else{
							
							if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
								$DataArray = array();
								$DataArray['ModifyPrice'] = $ModifyPrice;
								$TmpCartObj->tableUpdate($DataArray);
							}
							
							$this->getClass("Sale\Cart\Common")->AddProductInTmpCart($ProductID,$Qty,@implode(",",(isset($POSTDUMP['ProductAdditionName'])?$POSTDUMP['ProductAdditionName']:array())),$POSTDUMP);
						}
						
						
					}
				}
				
			}
		}
		
		echo "1";
		exit;
		
	}
	
	function applyCouponAction()
	{
		if(isset($_POST['VoucherCode']) && $_POST['VoucherCode'] != ""){
				$this->getSession()->setVar("OrderCoupon",$_POST['VoucherCode']);
				$ReturnArray = $this->getClass('Sale\Cart\ShoppingCalculation')->CheckCouponValues($_POST['VoucherCode'],'-1');
		}
		echo "1";
		exit;
		 
	}
	function getShippingMethodAction()
	{
		$type= isset($_GET['type'])?$_GET['type']:"html";
		$ShippingArray  = $this->getClass("ShippingModule\Shipping\Common")->getAllShipping($_POST);
		if($type=="html"){
			if(isset($ShippingArray['count']) && $ShippingArray['count'] > 0 && is_array($ShippingArray['method']) && count($ShippingArray['method']) > 0){
				
				if($ShippingArray['count']==1){
					foreach($ShippingArray['method'] as $m=>$arr){
						echo '<h4 class="font-weight-light">Shipping</h4>';
						foreach($arr['rates'] as $rateArr){
							echo '<input type="hidden" rel="'.$rateArr['price'].'" data-price="'.$rateArr['price'].'"  name="ship_method" id="'.$m.'__'.$rateArr['code'].'" value="'.$m.'__'.$rateArr['code'].'" />';
							echo '<div class="col-12"><label>'.$arr['title']."-".$rateArr['title'].' ('.$rateArr['display_price'].')</label></div>';
						}
					}		
					exit;
				}
			
				echo '<h4 class="font-weight-light">Shipping</h4>';
				foreach($ShippingArray['method'] as $m=>$arr){
					foreach($arr['rates'] as $rateArr){
						$ship_code = $m.'__'.$rateArr['code'];
						echo '<div class="col-12"><label><input type="radio" rel="'.$rateArr['price'].'" data-price="'.$rateArr['price'].'"  name="ship_method" id="'.$ship_code.'" value="'.$ship_code.'" '.((isset($Obj->ShippingCode) && $Obj->ShippingCode==$ship_code)?"checked":"").' /> '.$arr['title']."-".$rateArr['title'].' ('.$rateArr['display_price'].')</label></div>';
					}
				}
			}
			exit;
		}		
		
	}
	
	public function SaveOrderAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		
		$SessionID = $SessionID = $this->getSession()->getCurrentSID();
		if($OrderID != ""){
			$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
			if(isset($CurrentOrder->SessionID) && $CurrentOrder->SessionID != "")
				$SessionID = $CurrentOrder->SessionID;
		}
		
		if($SessionID != ""){
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
			$TmpCartObj->tableDelete();
		}
		$this->getClass('Sale\Cart\Common')->RemoveCartCookie("SKCartData");
		$this->getSession()->deleteVar("OrderID");
		$this->getSession()->deleteVar("OrderCoupon");
		unset($_SESSION['OrderID']);
		$this->getClass('Customer\Login\Common')->LogoutUser();
		$this->getSession()->setArrVar("alert",array("success","Order added successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&pyst=Pending");
		exit;
	}
	public function ProcessOrderAction()
	{
		$UserID = isset($_GET['UserID'])?$_GET['UserID']:"";
		$GLOBALS['UserIDByAdmin'] = $UserID;
		if(count($_POST)){
			$OrderID = $this->getClass("Sale\Checkout\Common")->processOrder($_POST,$UserID);
			//$this->getSession()->setArrVar("alert",array("success","Order status changed successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=SaveOrder&OrderID=$OrderID");
			exit;
			
		}
	}
	public function SendInvoiceEmailAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$CurrentOrder = $this->getDetail($OrderID);
		if(isset($CurrentOrder->OrderID)){
			$this->getClass("Sale\Checkout\Common")->processInvoice($OrderID);
		}
		$this->getSession()->setArrVar("alert",array("success","Order email sent successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewOrder&OrderID=$OrderID");
		exit;
			
		
	}
	public function PrintInvoiceAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$CurrentOrder = $this->getDetail($OrderID);
		if(isset($CurrentOrder->OrderID)){
			//$this->getClass('Sale\Checkout\Common')->processInvoice($OrderID);
			$MessageBody = $this->getClass('Sale\Cart\ShoppingCalculation')->getInvoice($OrderID);
			echo $MessageBody;
			echo '<script>window.print();</script>';
			
			
		}
		exit;
	}
	
	
	public function BulkOrderAction()
	{
		if(count($_POST) > 0){
			if(isset($_POST['PrintInvoice']) && $_POST['PrintInvoice']=="1"){
				foreach($_POST['OrderIDArr'] as $OrderID){
					$MessageBody = $this->getClass('Sale\Cart\ShoppingCalculation')->getInvoice($OrderID);
					echo $MessageBody;
				}
				echo '<script>window.print();</script>';
				exit;
			}
			
			if(isset($_POST['BulkSubmit']) && $_POST['BulkSubmit']=="1"){
				foreach($_POST['OrderIDArr'] as $OrderID){
					$CurrentOrder = $this->getDetail($OrderID);
					$OrderChangeStatusObj = new DataTable(TABLE_ORDER_CHANGE_STATUS);
					$DataArray = array();
					$DataArray['OrderID'] = $OrderID;
					$DataArray['PaymentStatus'] = isset($_POST['PaymentStatus'])?$_POST['PaymentStatus']:"";
					$DataArray['OrderStatus'] = isset($_POST['OrderStatus'])?$_POST['OrderStatus']:"";
					$DataArray['Comments'] = isset($_POST['Comments'])?$_POST['Comments']:"";
					$DataArray['Notify'] =isset($_POST['Notify'])?$_POST['Notify']:"0";
					$DataArray['CreatedDate'] = date("Y-m-d H:i:s");
					$this->getClass('Sale\Order\Common')->UpdatePaidOrderFromAdmin($OrderID,$DataArray['PaymentStatus'],$DataArray['OrderStatus']);
					$OrderChangeStatusObj->tableInsert($DataArray);
					
					$OrderObj = new DataTable(TABLE_ORDERS);
					$OrderArray = array();
					$OrderArray['PaymentStatus'] = $DataArray['PaymentStatus'];
					$OrderArray['OrderStatus'] = $DataArray['OrderStatus'];
					$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
					$OrderObj->tableUpdate($OrderArray);

					if($DataArray['Notify'] =="1"){
						$Mail_Subject = "Your order Details at ".d("SITE_NAME")." (Ref: ".$CurrentOrder->OrderNo.")";
						$Mail_ToEmail = isset($CurrentOrder->Email)?$CurrentOrder->Email:d("ADMIN_EMAIL");
						$Mail_FromEmail = d("ADMIN_EMAIL");
						$Mail_FromName = d("SITE_NAME");
						$MessageBody = "Dear ".MyStripSlashes($CurrentOrder->BillingFirstName)." ".MyStripSlashes($CurrentOrder->BillingLastName)."<br><br>";
						
						$MessageBody .="Your order is being processed.									 
										<br><br><b>OrderDetails:</b><br>Order Number: ".$CurrentOrder->OrderNo." <br>Status: ".$DataArray['OrderStatus']."";
						$MessageBody .= $DataArray['Comments']!=""?"<br><br>Additional Comment: ".$DataArray['Comments']:"";
						$MessageBody .= "<br><br>Thank you, if you have any queries you can contact us at: <a href='".d("SALES_EMAIL")."'>".d("SALES_EMAIL")."</a>.<br><br>".d("SITE_NAME");
						$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
					
					}	
							
				}
				
				$this->getSession()->setArrVar("alert",array("success","Order status changed successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&pyst=".$this->pyst."&orst=".$this->orst."&pymd=". $this->pymd."&dw=".$this->dw."&crby=".$this->crby."&psz=".$this->psz."&k=".$this->k);
				exit;
			}
			
		}
	}
	public function PushMurphyAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$CurrentOrder = $this->getDetail($OrderID);
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->PaymentStatus == "Paid"){
			$this->getClass('Plugin\MurphysMagic\MMSWebService')->processPayment($OrderID);
			$this->getSession()->setArrVar("alert",array("success","Murphy order status changed successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewOrder&OrderID=$OrderID&tab=orderstatus");
			exit;
		}
	}
	public function DownloadFileAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$filename = isset($_GET['File'])?base64_decode($_GET['File']):"";
		$Name = (isset($_GET['Name']) && $_GET['Name'] != "")?$_GET['Name']:basename($filename);
		$CurrentOrder = $this->getDetail($OrderID);
		if(isset($CurrentOrder->OrderID) && $filename != "" && file_exists($filename)){
			FileHandle::DownloadFile($filename,$Name);
			exit;
			
		}
		die("Invalid");
	}
	public function AddTrackingCodeAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$CurrentOrder = $this->getDetail($OrderID);
		if(count($_POST) && isset($CurrentOrder->OrderID)){
		
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderArray = array();
			$OrderArray['TrackingCode'] = isset($_POST['TrackingCode'])?$_POST['TrackingCode']:"";
			$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
			$OrderObj->tableUpdate($OrderArray);
			
			$this->getSession()->setArrVar("alert",array("success","Tracking code updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewOrder&OrderID=$OrderID");
			exit;	
		}
	}
	public function AddOrderStatusAction()
	{
		$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:0;
		$CurrentOrder = $this->getDetail($OrderID);
		if(count($_POST) && isset($CurrentOrder->OrderID)){
			$OrderChangeStatusObj = new DataTable(TABLE_ORDER_CHANGE_STATUS);
			$DataArray = array();
			$DataArray['OrderID'] = $OrderID;
			$DataArray['PaymentStatus'] = isset($_POST['PaymentStatus'])?$_POST['PaymentStatus']:"";
			$DataArray['OrderStatus'] = isset($_POST['OrderStatus'])?$_POST['OrderStatus']:"";
			$DataArray['Comments'] = isset($_POST['Comments'])?$_POST['Comments']:"";
			$DataArray['Notify'] =isset($_POST['Notify'])?$_POST['Notify']:"0";
			$DataArray['CreatedDate'] = date("Y-m-d H:i:s");
			$this->getClass('Sale\Order\Common')->UpdatePaidOrderFromAdmin($OrderID,$DataArray['PaymentStatus'],$DataArray['OrderStatus']);
			$OrderChangeStatusObj->tableInsert($DataArray);
			
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderArray = array();
			$OrderArray['PaymentStatus'] = $DataArray['PaymentStatus'];
			$OrderArray['OrderStatus'] = $DataArray['OrderStatus'];
			$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
			$OrderObj->tableUpdate($OrderArray);

			if($DataArray['Notify'] =="1"){
				$Mail_Subject = "Your order Details at ".d("SITE_NAME")." (Ref: ".$CurrentOrder->OrderNo.")";
				$Mail_ToEmail = isset($CurrentOrder->Email)?$CurrentOrder->Email:d("ADMIN_EMAIL");
				$Mail_FromEmail = d("ADMIN_EMAIL");
				$Mail_FromName = d("SITE_NAME");
				$MessageBody = "Dear ".MyStripSlashes($CurrentOrder->BillingFirstName)." ".MyStripSlashes($CurrentOrder->BillingLastName)."<br><br>";
				
				$MessageBody .="Your order is being processed.									 
								<br><br><b>OrderDetails:</b><br>Order Number: ".$CurrentOrder->OrderNo." <br>Status: ".$DataArray['OrderStatus']."";
				$MessageBody .= $DataArray['Comments']!=""?"<br><br>Additional Comment: ".$DataArray['Comments']:"";
				$MessageBody .= "<br><br>Thank you, if you have any queries you can contact us at: <a href='".d("SALES_EMAIL")."'>".d("SALES_EMAIL")."</a>.<br><br>".d("SITE_NAME");
				$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
			
			}	
			$this->getSession()->setArrVar("alert",array("success","Order status changed successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=ViewOrder&OrderID=$OrderID&tab=orderstatus");
			exit;
		}
		
	}
	
	
	function getCheckoutObj($UserID)
	{
		$CurrentObj = $this->getClass('Customer\Login\Common')->getUserByUserID($UserID);
		if(isset($CurrentObj->UserID) && $CurrentObj->UserID != ""){
			$CurrentObj->ShippingFirstName = $CurrentObj->BillingFirstName = $CurrentObj->FirstName;
			$CurrentObj->ShippingLastName = $CurrentObj->BillingLastName = $CurrentObj->LastName;
			$CurrentObj->ShippingAddress1 = $CurrentObj->BillingAddress1 = $CurrentObj->Address1;
			$CurrentObj->ShippingAddress2 = $CurrentObj->BillingAddress2 = $CurrentObj->Address2;
			$CurrentObj->ShippingCity = $CurrentObj->BillingCity = $CurrentObj->City;
			$CurrentObj->ShippingState = $CurrentObj->BillingState = $CurrentObj->State;
			$CurrentObj->ShippingCountry = $CurrentObj->BillingCountry = $CurrentObj->Country;
			$CurrentObj->ShippingZipCode = $CurrentObj->BillingZipCode = $CurrentObj->ZipCode;
			$CurrentObj->ShippingPhone = $CurrentObj->BillingPhone = $CurrentObj->Phone;
			//$CurrentObj->ShippingFax = $CurrentObj->BillingFax = $CurrentObj->Fax;
		}
		
		if($this->getSession()->getVar("OrderID") != ""){
			$CurrentObj =  $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($this->getSession()->getVar("OrderID"));
		}
		return $CurrentObj;
	}
	
	public function getDetail($OrderID)
	{
		$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
		return $CurrentOrder;
	}
	public function getOrderStatusList($OrderID)
	{
		$OrderChangeObj = new DataTable(TABLE_ORDER_CHANGE_STATUS);
		$OrderChangeObj->where[] = array('=',array('OrderID' => $OrderID));
		return $OrderChangeObj->tableSelectAll(array("*"),array("OrderChangeID ASC"));
		
	}
	public function getOrderMessagesList()
	{
		$OrderMsgObj = new DataTable(TABLE_ORDER_MESSAGE);
		return $OrderMsgObj->tableSelectAll(array("*"),array("Position ASC","OrderMsgTitle ASC"));
		
	}
	
	public function getAllMurphyOrderList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"m.CreatedDate DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderMurphyObj = new DataTable(array('m'=>TABLE_ORDER_MURPHY));
		$OrderMurphyObj->joinExpression = true;
		$OrderMurphyObj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(m.OrderDetailID = od.OrderDetailID)",
										  'columns'=>array("OrderDetailID","ItemName"),
										  'type'=>"left",
										  );
		
		$OrderMurphyObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
										  'on'=>"(m.OrderID = o.OrderID AND od.OrderID = o.OrderID)",
										  'columns'=>array("OrderNo","BillingFirstName","BillingLastName","BillingPhone","PaymentStatus","GrandTotal"),
										  'type'=>"left",
										  );
			
		
		$where = new Where();
		$where->equalTo('m.Status','Done');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('m.MurphyOrderNumber','%'.$Value.'%')->OR
							->like('o.OrderNo','%'.$Value.'%')->OR
							->like('o.BillingFirstName','%'.$Value.'%')->OR
							->like('o.BillingLastName','%'.$Value.'%')->OR
							->like('o.BillingAddress1','%'.$Value.'%')->OR
							->like('o.BillingAddress2','%'.$Value.'%')->OR
							->like('o.BillingCity','%'.$Value.'%')->OR
							->like('o.BillingState','%'.$Value.'%')->OR
							->like('o.BillingCountry','%'.$Value.'%')->OR
							->like('o.BillingZipCode','%'.$Value.'%')->OR
							->like('o.BillingPhone','%'.$Value.'%')->OR
							->like('o.BillingFax','%'.$Value.'%')->OR
							->like('o.ShippingFirstName','%'.$Value.'%')->OR
							->like('o.ShippingLastName','%'.$Value.'%')->OR
							->like('o.ShippingAddress1','%'.$Value.'%')->OR
							->like('o.ShippingAddress2','%'.$Value.'%')->OR
							->like('o.ShippingCity','%'.$Value.'%')->OR
							->like('o.ShippingState','%'.$Value.'%')->OR
							->like('o.ShippingCountry','%'.$Value.'%')->OR
							->like('o.ShippingZipCode','%'.$Value.'%')->OR
							->like('o.ShippingPhone','%'.$Value.'%')->OR
							->like('o.ShippingFax','%'.$Value.'%')->OR
							->like('o.Email','%'.$Value.'%')->OR
							->like('o.ShippingText','%'.$Value.'%')->OR
							->like('o.ShippingCode','%'.$Value.'%')->OR
							->like('o.VoucherText','%'.$Value.'%')->OR
							->like('o.VoucherCode','%'.$Value.'%')->OR
							->like('o.TransactionID','%'.$Value.'%')->OR
							->like('o.TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$OrderMurphyObj->where = $where;
		
		//$OrderMurphyObj->displayQuery = true;
		$OrderMurphyObj->AllowPaging =true;
		$OrderMurphyObj->PageSize=25;
		$OrderMurphyObj->PageTotalDisplay = 15; 
		$OrderMurphyObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $OrderMurphyObj;
		return  $OrderMurphyObj->tableSelectAll(array('*'),array($orderBy));
	}
	
	public function getAllList()
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"50";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$OrderObj = new DataTable(TABLE_ORDERS);
		//$where->notEqualTo('u.UserName','');
		
		if($PaymentStatus !="")
			$where->equalTo('PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('DownloadID','');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('OrderNo','%'.$Value.'%')->OR
							->like('BillingFirstName','%'.$Value.'%')->OR
							->like('BillingLastName','%'.$Value.'%')->OR
							->like('BillingAddress1','%'.$Value.'%')->OR
							->like('BillingAddress2','%'.$Value.'%')->OR
							->like('BillingCity','%'.$Value.'%')->OR
							->like('BillingState','%'.$Value.'%')->OR
							->like('BillingCountry','%'.$Value.'%')->OR
							->like('BillingZipCode','%'.$Value.'%')->OR
							->like('BillingPhone','%'.$Value.'%')->OR
							->like('BillingFax','%'.$Value.'%')->OR
							->like('ShippingFirstName','%'.$Value.'%')->OR
							->like('ShippingLastName','%'.$Value.'%')->OR
							->like('ShippingAddress1','%'.$Value.'%')->OR
							->like('ShippingAddress2','%'.$Value.'%')->OR
							->like('ShippingCity','%'.$Value.'%')->OR
							->like('ShippingState','%'.$Value.'%')->OR
							->like('ShippingCountry','%'.$Value.'%')->OR
							->like('ShippingZipCode','%'.$Value.'%')->OR
							->like('ShippingPhone','%'.$Value.'%')->OR
							->like('ShippingFax','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('ShippingText','%'.$Value.'%')->OR
							->like('ShippingCode','%'.$Value.'%')->OR
							->like('VoucherText','%'.$Value.'%')->OR
							->like('VoucherCode','%'.$Value.'%')->OR
							->like('TransactionID','%'.$Value.'%')->OR
							->like('TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$OrderObj->where = $where;
		
		//$OrderObj->displayQuery = true;
		$OrderObj->AllowPaging =true;
		$OrderObj->PageSize=$PageSize;
		$OrderObj->PageTotalDisplay = 15; 
		$OrderObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $OrderObj;
		//$OrderObj->columnExpression=true;
		return $OrderObj->tableSelectAll(array("*"),array($OrderBy));
	
	}
	public function getAllListDateStat($Date)
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"CreatedDate DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"50";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$OrderObj = new DataTable(TABLE_ORDERS);
		//$where->notEqualTo('u.UserName','');
		
		if($PaymentStatus !="")
			$where->equalTo('PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('DownloadID','');
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('OrderNo','%'.$Value.'%')->OR
							->like('BillingFirstName','%'.$Value.'%')->OR
							->like('BillingLastName','%'.$Value.'%')->OR
							->like('BillingAddress1','%'.$Value.'%')->OR
							->like('BillingAddress2','%'.$Value.'%')->OR
							->like('BillingCity','%'.$Value.'%')->OR
							->like('BillingState','%'.$Value.'%')->OR
							->like('BillingCountry','%'.$Value.'%')->OR
							->like('BillingZipCode','%'.$Value.'%')->OR
							->like('BillingPhone','%'.$Value.'%')->OR
							->like('BillingFax','%'.$Value.'%')->OR
							->like('ShippingFirstName','%'.$Value.'%')->OR
							->like('ShippingLastName','%'.$Value.'%')->OR
							->like('ShippingAddress1','%'.$Value.'%')->OR
							->like('ShippingAddress2','%'.$Value.'%')->OR
							->like('ShippingCity','%'.$Value.'%')->OR
							->like('ShippingState','%'.$Value.'%')->OR
							->like('ShippingCountry','%'.$Value.'%')->OR
							->like('ShippingZipCode','%'.$Value.'%')->OR
							->like('ShippingPhone','%'.$Value.'%')->OR
							->like('ShippingFax','%'.$Value.'%')->OR
							->like('Email','%'.$Value.'%')->OR
							->like('ShippingText','%'.$Value.'%')->OR
							->like('ShippingCode','%'.$Value.'%')->OR
							->like('VoucherText','%'.$Value.'%')->OR
							->like('VoucherCode','%'.$Value.'%')->OR
							->like('TransactionID','%'.$Value.'%')->OR
							->like('TrackingCode','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$where->expression('(DATE_FORMAT(CreatedDate,"%d %M, %Y") = DATE_FORMAT(?,"%d %M, %Y"))',$Date);
		$OrderObj->where = $where;
		
		//$OrderObj->displayQuery = true;
		$OrderObj->columnExpression=true;
		return (object)$OrderObj->tableSelectOne(array("MonthTotal"=>"SUM(GrandTotal)","TotalOrder"=>"Count(*)"),array($OrderBy));
	
	}
	
	
	public function pageTitle()
	{
		return "Orders";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
				</div>		
			   ';
	}
	
	
}	