<?php 
namespace Sale\Currency\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditCurrencyAction()
	{
		if(count($_POST)>0)
		{
			$CurrencyObj = new DataTable(TABLE_CURRENCIES);
			$CurrencyID = isset($_GET['CurrencyID'])?$_GET['CurrencyID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['CurrencyName'] = isset($_POST['CurrencyName'])?$_POST['CurrencyName']:"";
			$DataArray['Code'] = isset($_POST['Code'])?$_POST['Code']:"";
			$DataArray['Value'] = isset($_POST['Value'])?$_POST['Value']:"";
			$DataArray['Symbol'] = isset($_POST['Symbol'])?$_POST['Symbol']:"";
			$DataArray['Prefix'] = isset($_POST['Prefix'])?$_POST['Prefix']:"0";
			
			if($CurrencyID > 0)
			{
				
				$CurrencyObj->where[] = array('=',array('CurrencyID' => $CurrencyID));
				$CurrencyObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Currency updated successfully."));
				
			}
			else 
			{
							
				$CurrencyID = $CurrencyObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Currency added successfully."));
				
			}
			
			
			
			
					

			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&CurrencyID=$CurrencyID");
		    exit;
		}
		
	}
	
	function UpdateAllAction()
	{
		$CurrencyObj = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj2 = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj->where[] = array('=',array('DefaultValue' => 1));
		$DefaultCurrency=(object)$CurrencyObj->tableSelectOne();
		$base = isset($DefaultCurrency->Code)?$DefaultCurrency->Code:"";

		if($base != "")
		{
			$CurrencyObj = new DataTable(TABLE_CURRENCIES);
			$CurrencyObj->where[] = array('=',array('DefaultValue' => 1));
			$where = new Where();
			$where->equalTo('Active',"1");
			$where->notEqualTo('DefaultValue',"1");
			$CurrencyObj->where = $where;
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$CurrencyObj->offset = $Params['Offset'];
			
			$rows = $CurrencyObj->tableSelectAll("",array("CurrencyID ASC"));
			$SNo =0;
			foreach ($rows as $CurrentCurrency)
			{
				$Value = $this->getClass('Base\Currency\CurrencyHandler')->sk_get_currency($CurrentCurrency->Code,$DefaultCurrency->Code);
				if($Value >0)
				{
					$DataArray = array();
					$DataArray['Value'] = $Value;
					$CurrencyObj2 = new DataTable(TABLE_CURRENCIES);
					$CurrencyObj2->where[] = array('=',array('CurrencyID' => $CurrentCurrency->CurrencyID));
					$CurrencyObj2->tableUpdate($DataArray);
					
				}
			}
	
		}
		
		$this->getSession()->setArrVar("alert",array("success","Currencies updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		exit;
	}

	
	public function UpdateCurrencyAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CurrencyObj = new DataTable(TABLE_CURRENCIES);
				$CurrencyID =$_POST['CurrencyID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$CurrencyObj->where[] = array('=',array('CurrencyID' => $CurrencyID));
				$CurrencyObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Currency updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
			 exit;
		}
	}
	
	public function DeleteCurrencyAction()
	{
		$CurrencyID = isset($_GET['CurrencyID'])?$_GET['CurrencyID']:0;
		$obj = $this->getDetail($CurrencyID);
		
		if($CurrencyID > 0 && $obj->DefaultValue != "1")
		{
			$CurrencyObj = new DataTable(TABLE_CURRENCIES);
			$CurrencyObj->where[] = array('=',array('CurrencyID' => $CurrencyID));
			$CurrencyObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Currency deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	public function getList()
	{
		$CurrencyObj = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj->where="1";
		
		$CurrencyObj->orderExpression = true;
		$CurrencyObj->AllowPaging =false;
		$CurrencyObj->PageSize=50;
		$CurrencyObj->PageTotalDisplay = 15; 
		$CurrencyObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $CurrencyObj;
		return $CurrencyObj->tableSelectAll(array("*"),"DefaultValue=1 DESC,Active=1 DESC,CurrencyID ASC");
	
	}
	
	public function getDetail($CurrencyID)
	{
		if($CurrencyID > 0)
		{
			$CurrencyObj = new DataTable(array('m'=>TABLE_CURRENCIES));
			$CurrencyObj->where[] = array('=',array('m.CurrencyID' => $CurrencyID));
			return (object)$CurrencyObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Currency";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditCurrency">Add Currency</a>
					</div>
              </div>		
			   ';
	}
	
	
}	