<?php 
namespace Sale\Coupon\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditCouponAction()
	{
		if(count($_POST)>0)
		{
			$CouponObj = new DataTable(TABLE_COUPONS);
			$CouponID = isset($_GET['CouponID'])?$_GET['CouponID']:0;
			$PID = isset($_GET['PID'])?$_GET['PID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['CouponName'] = isset($_POST['CouponName'])?$_POST['CouponName']:"";
			$DataArray['CouponCode'] = isset($_POST['CouponCode'])?$_POST['CouponCode']:"";
			$DataArray['CouponType'] = isset($_POST['CouponType'])?$_POST['CouponType']:"";
			
			$DataArray['CouponValue'] = (isset($_POST['CouponValue']) &&  $_POST['CouponValue'] !="")?$_POST['CouponValue']:"0";
			$DataArray['StartDate'] = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			$DataArray['EndDate'] = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']:NULL;
			$DataArray['Message'] = isset($_POST['Message'])?$_POST['Message']:"";
			$DataArray['CouponLimit'] = isset($_POST['CouponLimit'])?(int)$_POST['CouponLimit']:"0";
			$DataArray['MinTotal'] = isset($_POST['MinTotal'])?(int)$_POST['MinTotal']:"0";
			$DataArray['ProductSpecific'] = isset($_POST['ProductSpecific'])?$_POST['ProductSpecific']:"0";
			$DataArray['MultipleEnabled'] = isset($_POST['MultipleEnabled'])?$_POST['MultipleEnabled']:"0";
			$DataArray['ProductIDs'] = isset($_POST['ProductIDs'])?implode(",",$_POST['ProductIDs']):"0";
			
			if($CouponID > 0)
			{
				
				$CouponObj->where[] = array('=',array('CouponID' => $CouponID));
				$CouponObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Coupon updated successfully."));
				
			}
			else 
			{
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');			
				$CouponID = $CouponObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Coupon added successfully."));
				
			}
			
			
			
			
					
			if($PID > 0)
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=Catalog\Product\Index&view=AddEditProduct&ParentID=0&ProductID=".$PID."&tab=coupons");
			else
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&CouponID=$CouponID");
			
			exit;
		}
		
	}
	
	public function UpdateCouponAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CouponObj = new DataTable(TABLE_COUPONS);
				$CouponID =$_POST['CouponID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$CouponObj->where[] = array('=',array('CouponID' => $CouponID));
				$CouponObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Coupon updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
			 exit;
		}
	}
	
	public function DeleteCouponAction()
	{
		$CouponID = isset($_GET['CouponID'])?$_GET['CouponID']:0;
		$PID = isset($_GET['PID'])?$_GET['PID']:0;
		$obj = $this->getDetail($CouponID);
		
		if($CouponID > 0 && $obj->DefaultValue != "1")
		{
			$CouponObj = new DataTable(TABLE_COUPONS);
			$CouponObj->where[] = array('=',array('CouponID' => $CouponID));
			$CouponObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Coupon deleted successfully."));
		
		if($PID > 0)
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=Catalog\Product\Index&view=AddEditProduct&ParentID=0&ProductID=".$PID."&tab=coupons");
		else
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	
	public function VoucherDisabledAction()
	{
		$VCode = isset($_GET['VCode'])?$_GET['VCode']:"";
			
		if($VCode != "")
		{
			$CouponObj = new DataTable(TABLE_COUPONS);
			$DataArray = array();
			$DataArray['Active'] = "0";
			$DataArray['GvRedeem'] = "1";
			$DataArray['RedeemDate'] = date('Y-m-d H:i:s');
			$DataArray['OrderID'] = "-1";
			$CouponObj->where[] = array('=',array('CouponCode' => $VCode));
			$CouponObj->tableUpdate($DataArray);
			
			$this->getSession()->setArrVar("alert",array("success","You have successfully disabled the gift voucher."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&PageNo=".$this->origin->PageNo);
			exit;
			
		}
	}
	public function VouchertoPointAction()
	{
		$VCode = isset($_GET['VCode'])?$_GET['VCode']:"";
			
		if($VCode != "")
		{
			$this->getClass('Customer\Login\Common')->ConvertVouchertoPoint($VCode);
			$this->getSession()->setArrVar("alert",array("success","Congratulation Voucher Code has successfully converted into loyality points."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&PageNo=".$this->origin->PageNo);
			exit;
			
		}
	}
	
	public function getList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"Active=1 DESC,CouponID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		
		$CouponObj = new DataTable(TABLE_COUPONS);
		$where = new Where();
				$where->NEST//start braket
						->equalTo('GvEnabled','')->OR
						->equalTo('GvEnabled','0')->OR
						->isNULL('GvEnabled')->OR
						->UNNEST;
	
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('CouponCode','%'.$Value.'%')->OR
							->like('CouponName','%'.$Value.'%')->OR
							->like('Message','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		
		$CouponObj->where = $where;
		
		$CouponObj->orderExpression = true;
		$CouponObj->AllowPaging =true;
		$CouponObj->PageSize=50;
		$CouponObj->PageTotalDisplay = 15; 
		$CouponObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $CouponObj;
		return $CouponObj->tableSelectAll(array("*"),$orderBy);
	
	}
	
	public function getGiftVouchersList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"gt.CreatedDate DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		
		$CouponObj = new DataTable(array('c'=>TABLE_COUPONS));
		$CouponObj->joinExpression = true;
		$CouponObj->joinArray[] = array('name'=>array('gt'=>TABLE_GV_TRACK),
									  'on'=>"(gt.CouponID = c.CouponID)",
									  'columns'=>array("*"),
									  'type'=>''
									  );
		$where = new Where();
		$where->equalTo('c.GvEnabled','1');
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('c.CouponCode','%'.$Value.'%')->OR
							->like('c.PurchasedOrderID','%'.$Value.'%')->OR
							->like('c.OrderID','%'.$Value.'%')->OR
							->like('gt.FromName','%'.$Value.'%')->OR
							->like('gt.FromEmail','%'.$Value.'%')->OR
							->like('gt.ToName','%'.$Value.'%')->OR
							->like('gt.ToEmail','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		
		$CouponObj->where = $where;
		
		$CouponObj->orderExpression = true;
		$CouponObj->AllowPaging =true;
		$CouponObj->PageSize=50;
		$CouponObj->PageTotalDisplay = 15; 
		$CouponObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		//$CouponObj->displayQuery = true;
		$this->paging = $CouponObj;
		return $CouponObj->tableSelectAll(array("*"),"gt.CreatedDate DESC");
	
	}
	
	public function getDetail($CouponID)
	{
		if($CouponID > 0)
		{
			$CouponObj = new DataTable(array('m'=>TABLE_COUPONS));
			$CouponObj->where[] = array('=',array('m.CouponID' => $CouponID));
			return (object)$CouponObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Coupons/Gift Vouchers";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditCoupon">Add Coupon</a>
					</div>
              </div>		
			   ';
	}
	
	
}	