<?php 
namespace Sale\Checkout;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function processPayment($OrderID,$Param="",$GetArray ="",$PostArray ="")
	{
		$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ""){
			
			if($CurrentOrder->PaymentStatus=="Pending"){
			
				$PaymentStatusArray = $this->getClass('Sale\Order\Common')->getPaymentStatuses();
				$PointStatusArray = $this->getClass('Sale\Order\Common')->getPointStatuses();
				$OrderStatusArray = $this->getClass('Sale\Order\Common')->getOrderStatuses();
				
				$OrderObj = new DataTable(TABLE_ORDERS);
				$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
				$DataArray = array();
				$DataArray['PaymentStatus'] = 'Paid';
				$DataArray['PaymentDate'] = date("Y-m-d H:i:s");
				$DataArray['OrderStatus'] = 'Paid';
				$DataArray['TransactionID'] = isset($Param['TransactionID'])?$Param['TransactionID']:"";;
				$OrderObj->tableUpdate($DataArray);
				
				/* ORDER change status insert start*/
				$OrderChangeStatusObj = new DataTable(TABLE_ORDER_CHANGE_STATUS);
				$DataArray = array();
				$DataArray['OrderID'] = $OrderID;
				$DataArray['PaymentStatus'] = 'Paid';
				$DataArray['OrderStatus'] = 'Paid';
				$DataArray['Comments'] = isset($Param['Comments'])?$Param['Comments']:"";
				$DataArray['Notify'] ="0";
				$DataArray['CreatedDate'] = date("Y-m-d H:i:s");
				$OrderChangeStatusObj->tableInsert($DataArray);
				/* ORDER change status insert end*/	
				
				/* User Points Table Start*/
				$UserPointObj = new DataTable(TABLE_USERS_POINT);
				$UserPointObj->where[] = array('=',array('OrderID' => $OrderID));
				$DataArray = array();
				$DataArray['OrderStatus'] = $PaymentStatusArray['Paid'];
				$UserPointObj->tableUpdate($DataArray);	
				/* User Points Table End*/
				$this->processPaymentStock($OrderID);
				$this->processGiftVoucherQueue($OrderID);
				/* murphy magic start  */
				//$this->getClass('Plugin\MurphysMagic\MurphysMagic')->processPayment($OrderID);
				//$this->getClass('Plugin\MurphysMagic\MMSWebService')->processPayment($OrderID);
				/* murphy magic end  */
				
				/* IDevaffiliate start  */
				//$this->getClass('Plugin\IDevaffiliate\IDevaffiliate')->processPayment($OrderID);
				/* IDevaffiliate start  */
				
			
			}
			
			
		}
	}
	
	function processGiftVoucherQueue($OrderID)
	{
		$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ""){
			$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
			$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
			$cartRows = $OrderDetailObj->tableSelectAll("","OrderDetailID ASC");
			$Amount = 0;
			foreach($cartRows as $CurrentCartItem){
				if(isset($CurrentCartItem->ItemType) && $CurrentCartItem->ItemType =="GiftVoucher"){
					$Amount = $CurrentCartItem->TotalWithTax;
					$GvQueueObj = new DataTable(TABLE_GV_QUEUE);
					$GvQueueObj->where[] = array('=',array('OrderID' => $OrderID));
					$GvQueueObj->where[] = array('=',array('OrderDetailID' => $CurrentCartItem->OrderDetailID));
					$CurrentQueue = (object)$GvQueueObj->tableSelectOne();
					if(!isset($CurrentQueue->OrderDetailID) && $Amount >0 && isset($CurrentOrder->OrderID)){
						
						$GvQueueObj = new DataTable(TABLE_GV_QUEUE);
						$DataArray = array();
						$DataArray['Amount'] = $Amount;
						$DataArray['UserID'] = $CurrentOrder->UserID;
						$DataArray['OrderID'] = $CurrentOrder->OrderID;
						$DataArray['OrderDetailID'] = $CurrentCartItem->OrderDetailID;
						$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
						$GvQueueObj->tableInsert($DataArray);
			
					    /* crete vocher code start */
						$CouponObj = new DataTable(TABLE_COUPONS);
						$CouponCode = uniqid("Gift_");
						$DataArray = array();
						$DataArray['PurchasedOrderID'] = $CurrentOrder->OrderID;
						$DataArray['CouponName'] = "Voucher Code";
						$DataArray['Message'] = "Voucher Code";
						$DataArray['CouponType'] = "FlatPrice";
						$DataArray['CouponCode'] = $CouponCode;
						$DataArray['Active'] = "1";
						$DataArray['CouponValue'] = $Amount;
						$DataArray['GvEnabled'] = "1";
						$DataArray['CouponLimit'] = "1";
						$DataArray['MultipleEnabled'] = "1";
						$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
						$CouponID = $CouponObj->tableInsert($DataArray);
					
						
						$GvTrackObj = new DataTable(TABLE_GV_TRACK);
						$DataArray = array();
						$DataArray['CouponID'] = $CouponID;
						$DataArray['UserID'] = $CurrentOrder->UserID;
						$DataArray['FromEmail'] = d("ADMIN_EMAIL");
						$DataArray['FromName'] = d("SITE_NAME");
						$DataArray['Message'] = "";
						$DataArray['ToName'] = $CurrentOrder->BillingFirstName." ".$CurrentOrder->BillingLastName;
						$DataArray['ToEmail'] = $CurrentOrder->Email;
						
						if(isset($CurrentCartItem->Attribute1) && $CurrentCartItem->Attribute1 != ""){
							$DataArray['ToName'] = $CurrentCartItem->Attribute1;
							$DataArray['ToEmail'] = $CurrentCartItem->Attribute2;
						}
						
						$DataArray['Amount'] = $Amount;
						$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
						$GvTrackObj->tableInsert($DataArray);
						
						
						
						if(file_exists(DIR_FS_SITE."templates/emails/gift_certificate.php")){
							$arr = array("Amount"=>$Amount,
									   "From"=>d('SITE_NAME'),
									   "ToName"=>$DataArray['ToName'],
									   "Message"=>"",
									   "CouponCode"=>$CouponCode,
									   );
							@ob_start();	
							include(DIR_FS_SITE."templates/emails/gift_certificate.php");
							$MessageBody = ob_get_clean();
							//$MessageBody = ob_get_contents();
							$Mail_Subject = "Congratulations! You have received a gift voucher from ".d("SITE_NAME");
							$Mail_ToEmail = $DataArray['ToEmail'];
							$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody);
						}
						/* crete vocher code end*/
						
					}
						
				}
				
			}
		
			/* start acces gift certificate*/	
			if($CurrentOrder->VoucherCode !="")
			{
				 $CouponCodeArray = explode(",",$CurrentOrder->VoucherCode);
				 foreach($CouponCodeArray as $k=>$CouponCode){
					$CouponObj = new DataTable(TABLE_COUPONS);
					$CouponObj->where[] = array('=',array('CouponCode' => $CouponCode));
					$CouponObj->where[] = array('=',array('GvEnabled' => "1"));
					$CurrentCoupon = (object)$CouponObj->tableSelectOne();
					if(isset($CurrentCoupon->CouponID) && $CurrentCoupon->CouponID !="")
					{
						$DataArray = array();
						$DataArray['Active'] = "0";
						$DataArray['GvRedeem'] = "1";
						$DataArray['RedeemDate'] = date('Y-m-d H:i:s');
						$DataArray['OrderID'] = $OrderID;
						
						$CouponObj = new DataTable(TABLE_COUPONS);
						$CouponObj->where[] = array('=',array('CouponID' => $CurrentCoupon->CouponID));
						$CouponObj->tableUpdate($DataArray);
					}
				 }
			}
			/* end acces gift certificate */
			
		}
	}
	
	function processPaymentStock($OrderID)
	{
		/* Stock updation Start*/
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
		$cartRows = $OrderDetailObj->tableSelectAll("","OrderDetailID ASC");
		foreach($cartRows as $CurrentCartItem){
			$ProductID ="";
			if(in_array($CurrentCartItem->ItemType,array("Bundle","Product","GiftVoucher")))
			{
			  $ProductID = $CurrentCartItem->ReferenceID;
			  $ProductObj = new DataTable(TABLE_PRODUCT);
			  $ProductObj->where[] = array('=',array('ProductID' => $CurrentCartItem->ReferenceID));
			  $CurrentProduct = (object)$ProductObj->tableSelectOne(array("Stock","ProductID"));
			  if(isset($CurrentProduct->ProductID)){
				  $DataArray = array();
				  $DataArray['Stock'] = $CurrentProduct->Stock - $CurrentCartItem->Qty;
				  $ProductObj = new DataTable(TABLE_PRODUCT);
				  $ProductObj->where[] = array('=',array('ProductID' => $CurrentCartItem->ReferenceID));
				  $ProductObj->tableUpdate($DataArray);
				  
					for($i=1;$i<=$CurrentCartItem->Qty;$i++){
						$PDataArray = array();
						$ProducReportObj = new DataTable(TABLE_PRODUCT_REPORTS);
						$PDataArray['ProductID'] = $ProductID;
						$PDataArray['ViewType'] = 'P';
						$PDataArray['CreatedDate'] = date("Y-m-d H:i:s");
						$ProducReportObj->tableInsert($PDataArray);			
					}
				
			  }
			}
			
		}
		/* Stock updation End */
	}
	function processInvoice($OrderID,$Param="",$GetArray ="",$PostArray ="")
	{
		$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ""){
			$MessageBody = $this->getClass('Sale\Cart\ShoppingCalculation')->getInvoice($OrderID);
			$Mail_Subject = "Your Order No. ".$CurrentOrder->OrderNo;
			$Mail_ToEmail = $CurrentOrder->Email;
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody,d('BCC_ORDER_EMAIL'));
		}
		
	}
	
	function clearCart($OrderID = "")
	{
		$SessionID = $this->getSession()->getCurrentSID();
		if($OrderID != ""){
			$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
			if(isset($CurrentOrder->SessionID) && $CurrentOrder->SessionID != "")
				$SessionID = $CurrentOrder->SessionID;
		}
		
		if($SessionID != ""){
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
			$TmpCartObj->tableDelete();
		}
		$this->getClass('Sale\Cart\Common')->RemoveCartCookie("SKCartData");
		$this->getSession()->deleteVar("OrderID");
		$this->getSession()->deleteVar("OrderCoupon");
		unset($_SESSION['OrderID']);
		session_unset();
		//session_destroy();
		@session_regenerate_id(true);
		
	}
	function processCoupon($PostArray)
	{
		 $this->getSession()->setVar("OrderCoupon",$PostArray['VoucherCode']);
		 $ReturnArray = $this->getClass('Sale\Cart\ShoppingCalculation')->CheckCouponValues($PostArray['VoucherCode'],'-1');
		 return $ReturnArray;
	}
	function processOrder($PostArray,$UserID="",$CreatedBy="")
	{
		if($UserID != "")
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($UserID);
		else
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		
		$SessionID = $this->getSession()->getCurrentSID();
		$UserID = isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
		$DownloadID = "";
		$TotalUserPoint =0;
		
		if(isset($PostArray['ShippingCountry']) && $PostArray['ShippingCountry'] != ""){
			$this->getSession()->setVar("TaxCountry",$PostArray['ShippingCountry']);
			$this->getSession()->setVar("ShippingZipCode",$PostArray['ShippingZipCode']);
			$this->getSession()->setVar("OrderAddress",array(
					'BillingFirstName' => isset($PostArray['BillingFirstName'])?$PostArray['BillingFirstName']:"",
					'BillingLastName' => isset($PostArray['BillingLastName'])?$PostArray['BillingLastName']:"",
					'BillingAddress1' => isset($PostArray['BillingAddress1'])?$PostArray['BillingAddress1']:"",
					'BillingAddress2' => isset($PostArray['BillingAddress2'])?$PostArray['BillingAddress2']:"",
					'BillingCity' => isset($PostArray['BillingCity'])?$PostArray['BillingCity']:"",
					'BillingState' => isset($PostArray['BillingState'])?$PostArray['BillingState']:"",
					'BillingArea' => isset($PostArray['BillingArea'])?$PostArray['BillingArea']:"",
					'BillingCountry' => isset($PostArray['BillingCountry'])?$PostArray['BillingCountry']:"",
					'BillingZipCode' => isset($PostArray['BillingZipCode'])?$PostArray['BillingZipCode']:"",
					'BillingPhone' => isset($PostArray['BillingPhone'])?$PostArray['BillingPhone']:"",
					'BillingFax' => isset($PostArray['BillingFax'])?$PostArray['BillingFax']:"",
					'ShippingFirstName' => isset($PostArray['ShippingFirstName'])?$PostArray['ShippingFirstName']:"",
					'ShippingLastName' => isset($PostArray['ShippingLastName'])?$PostArray['ShippingLastName']:"",
					'ShippingAddress1' => isset($PostArray['ShippingAddress1'])?$PostArray['ShippingAddress1']:"",
					'ShippingAddress2' => isset($PostArray['ShippingAddress2'])?$PostArray['ShippingAddress2']:"",
					'ShippingCity' => isset($PostArray['ShippingCity'])?$PostArray['ShippingCity']:"",
					'ShippingState' => isset($PostArray['ShippingState'])?$PostArray['ShippingState']:"",
					'ShippingArea' => isset($PostArray['ShippingArea'])?$PostArray['ShippingArea']:"",
					'ShippingCountry' => isset($PostArray['ShippingCountry'])?$PostArray['ShippingCountry']:"",
					'ShippingZipCode' => isset($PostArray['ShippingZipCode'])?$PostArray['ShippingZipCode']:"",
					'ShippingPhone' => isset($PostArray['ShippingPhone'])?$PostArray['ShippingPhone']:"",
					'ShippingFax' => isset($PostArray['ShippingFax'])?$PostArray['ShippingFax']:"",
					)
			);
		}
		
		$OrderObj = new DataTable(TABLE_ORDERS);
		if($this->getSession()->getVar("OrderID") != "" && $this->getSession()->getVar("OrderID") > 0){
			$OrderID = $this->getSession()->getVar("OrderID");
		}
		else{
			$BlankArray = array();
			$BlankArray['CreatedDate']	=date("Y-m-d H:i:s");
			$OrderID = $OrderObj->tableInsert($BlankArray);
			$this->getSession()->setVar("OrderID",$OrderID);
		}
		
		$this->getClass('Sale\Cart\ShoppingCalculation')->ResetCart();
		
		if($this->getSession()->getVar("OrderCoupon") != "")
		  $this->getClass('Sale\Cart\ShoppingCalculation')->CheckCouponValues($this->getSession()->getVar("OrderCoupon"),'-1');
			
		$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart",$PostArray);
		
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
		$cartRows = $TmpCartObj->tableSelectAll("","TmpCartID ASC");
		
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
		$OrderDetailObj->tableDelete();
		
		$UserPointObj = new DataTable(TABLE_USERS_POINT);
		$UserPointObj->where[] = array('=',array('OrderID' => $OrderID));
		$UserPointObj->tableDelete();
		foreach($cartRows as $CurrentCartItem){
			
			$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
			$DataArray = array();
			$DataArray['OrderID'] = $OrderID;
			$DataArray['ItemID'] = "OD_".$CurrentCartItem->ItemID;
			//$DataArray['WishListID'] = $CurrentCartItem->WishListID;
			if($CurrentCartItem->ParentItemID != "")
				$DataArray['ParentItemID'] = "OD_".$CurrentCartItem->ParentItemID;
			else
				$DataArray['ParentItemID'] = $CurrentCartItem->ParentItemID;
			
			$DataArray['ItemType'] = $CurrentCartItem->ItemType;
			$DataArray['ItemStatus'] = $CurrentCartItem->ItemStatus;
			$DataArray['ReferenceID'] = $CurrentCartItem->ReferenceID;
			$DataArray['ItemName'] = $CurrentCartItem->ItemName;
			$DataArray['ItemNo'] = $CurrentCartItem->ItemNo;
			$DataArray['Attribute1'] = $CurrentCartItem->Attribute1;
			$DataArray['Attribute2'] = $CurrentCartItem->Attribute2;
			$DataArray['Width'] = $CurrentCartItem->Width > 0?$CurrentCartItem->Width:"0";
			$DataArray['Height'] = $CurrentCartItem->Height > 0?$CurrentCartItem->Height:"0";
			$DataArray['Length'] = $CurrentCartItem->Length > 0?$CurrentCartItem->Length:"0";
			$DataArray['Weight'] = $CurrentCartItem->Weight > 0?$CurrentCartItem->Weight:"0";
			$DataArray['ModifyPrice'] = $CurrentCartItem->ModifyPrice > 0?$CurrentCartItem->ModifyPrice:"0";
			$DataArray['UnitPrice'] = $CurrentCartItem->UnitPrice;
			$DataArray['TaxPrice'] = $CurrentCartItem->TaxPrice;
			$DataArray['TaxPercent'] = $CurrentCartItem->TaxPercent;
			$DataArray['VoucherAmount'] = $CurrentCartItem->VoucherAmount > 0?$CurrentCartItem->VoucherAmount:"0";
			$DataArray['VoucherText'] = $CurrentCartItem->VoucherText;
			$DataArray['VoucherCode'] = $CurrentCartItem->VoucherCode;
			$DataArray['Price'] = $CurrentCartItem->Price;
			$DataArray['PriceWithTax'] = $CurrentCartItem->PriceWithTax;
			$DataArray['ActualPrice'] = $CurrentCartItem->ActualPrice;
			$DataArray['ActualPriceWithTax'] = $CurrentCartItem->ActualPriceWithTax;
			$DataArray['Qty'] = $CurrentCartItem->Qty;
			$DataArray['Total'] = $CurrentCartItem->Total;
			$DataArray['TotalWithTax'] = $CurrentCartItem->TotalWithTax;
			$DataArray['Comments'] = $CurrentCartItem->Comments;
			$DataArray['SessionID'] = $CurrentCartItem->SessionID;
			$DataArray['SessionInfo'] = $CurrentCartItem->SessionInfo;
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			//$DataArray['ProVoucherAmount'] = $CurrentCartItem->ProVoucherAmount;
			//$DataArray['ProVoucherText'] = $CurrentCartItem->ProVoucherText;
			//$DataArray['ProVoucherCode'] = $CurrentCartItem->ProVoucherCode;
			$OrderDetailObj->tableInsert($DataArray);
			
			/*check download files start*/
			if($DownloadID =="" && $CurrentCartItem->ItemType=="Product"){
				$ProductDownloadObj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
				$ProductDownloadObj->where[] = array('=',array('ProductID' => (int)$CurrentCartItem->ReferenceID));
				$CurrentDownload = (object)$ProductDownloadObj->tableSelectOne(array("ProductID"));
				if(isset($CurrentDownload->ProductID) && $CurrentDownload->ProductID !="" && $DownloadID =="")
					$DownloadID = uniqid("DW_");
				
			}
			/*check download files start*/
		
			if($DownloadID =="" && $CurrentCartItem->ItemStatus=="Download")
				$DownloadID = uniqid("DW_");
			
			
			/* ProductPoint Calculation*/
			if(in_array($CurrentCartItem->ItemType,array("Bundle","Product","GiftVoucher")))
			{
				$ProductID = $CurrentCartItem->ReferenceID;
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductObj->where[] = array('=',array('ProductID' => (int)$CurrentCartItem->ReferenceID));
				$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductPoints","UploadType"));
				if(isset($CurrentProduct->ProductPoints) && $CurrentProduct->ProductPoints > 0){
					
					if(isset($CurrentProduct->UploadType) && strpos($CurrentProduct->UploadType,"Murphy") !== false){
						$Ration = d("PRODUCT_POINT_INCURRENCY")/d("PRODUCT_WAREHOUSE_POINT_INCURRENCY");
						$TotalUserPoint = $TotalUserPoint + ($CurrentCartItem->Qty * $CurrentProduct->ProductPoints * $Ration);
						
					}
					else{
						$TotalUserPoint = $TotalUserPoint + ($CurrentCartItem->Qty * $CurrentProduct->ProductPoints);
					}
				}
				
			}
			/* ProductPoint Calculation end*/
		}
		
		if(isset($IsCurrentUser->WholeSaler) && $IsCurrentUser->WholeSaler=="1"){
			$TotalUserPoint =0;
		}
		
		/* Order Currencies start*/
			$CurrentCurrency = $this->getClass('Frontend\Common\Common')->getFrontCurrency();
			$DefaultCurrentCurrency = $this->getClass('Frontend\Common\Common')->getDefaultCurrency();
			if(isset($CurrentCurrency->CurrencyID) && $CurrentCurrency->CurrencyID !="")
			{
				$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
				$OrderCurrencyObj->where[] = array('=',array('OrderID' => $OrderID));
				$OrderCurrencyObj->tableDelete();
		
				$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
				$OrderCurrencyArray = array();
				$OrderCurrencyArray['OrderID'] = $OrderID;
				$OrderCurrencyArray['CurrencyName'] = $CurrentCurrency->CurrencyName;
				$OrderCurrencyArray['Code'] = $CurrentCurrency->Code;
				$OrderCurrencyArray['Symbol'] = $CurrentCurrency->Symbol;
				$OrderCurrencyArray['Value'] = $CurrentCurrency->Value;
				$OrderCurrencyArray['ExchangeRate'] = $CurrentCurrency->Value;
				$OrderCurrencyArray['DefaultCode'] = $DefaultCurrentCurrency->Code;
				$OrderCurrencyArray['Prefix'] = $CurrentCurrency->Prefix;
				$OrderCurrencyObj->tableInsert($OrderCurrencyArray);
				
			}
			/* Order Currencies end*/
			
			$OrderDataArray = array();
			$OrderDataArray['UserID'] = $UserID;
			$OrderDataArray['CreatedBy'] = isset($PostArray['CreatedBy'])?$PostArray['CreatedBy']:"";
			$OrderDataArray['PurchaseNo'] = isset($PostArray['PurchaseNo'])?$PostArray['PurchaseNo']:"";
			$OrderDataArray['IPAddress'] 	= isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
			
			$OrderDataArray['BillingFirstName'] = isset($PostArray['BillingFirstName'])?$PostArray['BillingFirstName']:"";
			$OrderDataArray['BillingLastName'] = isset($PostArray['BillingLastName'])?$PostArray['BillingLastName']:"";
			$OrderDataArray['BillingAddress1'] = isset($PostArray['BillingAddress1'])?$PostArray['BillingAddress1']:"";
			$OrderDataArray['BillingAddress2'] = isset($PostArray['BillingAddress2'])?$PostArray['BillingAddress2']:"";
			$OrderDataArray['BillingCity'] = isset($PostArray['BillingCity'])?$PostArray['BillingCity']:"";
			$OrderDataArray['BillingState'] = isset($PostArray['BillingState'])?$PostArray['BillingState']:"";
			$OrderDataArray['BillingArea'] = isset($PostArray['BillingArea'])?$PostArray['BillingArea']:"";
			$OrderDataArray['BillingCountry'] = isset($PostArray['BillingCountry'])?$PostArray['BillingCountry']:"";
			$OrderDataArray['BillingZipCode'] = isset($PostArray['BillingZipCode'])?$PostArray['BillingZipCode']:"";
			$OrderDataArray['BillingPhone'] = isset($PostArray['BillingPhone'])?$PostArray['BillingPhone']:"";
			$OrderDataArray['BillingFax'] = isset($PostArray['BillingFax'])?$PostArray['BillingFax']:"";
			$OrderDataArray['ShippingFirstName'] = isset($PostArray['ShippingFirstName'])?$PostArray['ShippingFirstName']:"";
			$OrderDataArray['ShippingLastName'] = isset($PostArray['ShippingLastName'])?$PostArray['ShippingLastName']:"";
			$OrderDataArray['ShippingAddress1'] = isset($PostArray['ShippingAddress1'])?$PostArray['ShippingAddress1']:"";
			$OrderDataArray['ShippingAddress2'] = isset($PostArray['ShippingAddress2'])?$PostArray['ShippingAddress2']:"";
			$OrderDataArray['ShippingCity'] = isset($PostArray['ShippingCity'])?$PostArray['ShippingCity']:"";
			$OrderDataArray['ShippingState'] = isset($PostArray['ShippingState'])?$PostArray['ShippingState']:"";
			$OrderDataArray['ShippingArea'] = isset($PostArray['ShippingArea'])?$PostArray['ShippingArea']:"";
			$OrderDataArray['ShippingCountry'] = isset($PostArray['ShippingCountry'])?$PostArray['ShippingCountry']:"";
			$OrderDataArray['ShippingZipCode'] = isset($PostArray['ShippingZipCode'])?$PostArray['ShippingZipCode']:"";
			$OrderDataArray['ShippingPhone'] = isset($PostArray['ShippingPhone'])?$PostArray['ShippingPhone']:"";
			$OrderDataArray['ShippingFax'] = isset($PostArray['ShippingFax'])?$PostArray['ShippingFax']:"";
			$OrderDataArray['Email'] = isset($PostArray['Email'])?$PostArray['Email']:"";
			$OrderDataArray['Comments'] = isset($PostArray['Comments'])?$PostArray['Comments']:"";
			$OrderDataArray['DownloadID'] = $DownloadID;
			
			$PaymentStatusArray = $this->getClass('Sale\Order\Common')->getPaymentStatuses();
			$PointStatusArray = $this->getClass('Sale\Order\Common')->getPointStatuses();
			$OrderStatusArray = $this->getClass('Sale\Order\Common')->getOrderStatuses();
			//$ShippingStatusArray = $this->getClass('Sale\Order\Common')->getOrderStatuses();
		
			$OrderDataArray['OrderStatus'] = 'Pending';
			$OrderDataArray['ShippingStatus'] = 'Pending';
			$OrderDataArray['PaymentStatus'] = 'Pending';
			
			$OrderDataArray['PaymentMethod'] = isset($PostArray['payment_method'])?$PostArray['payment_method']:"";
			$OrderDataArray['Attempted'] = "0";
			
			if( isset($CalArray['grandtotal']['price']) && number_format($CalArray['grandtotal']['price'],2) == 0)
				$OrderDataArray['PaymentMethod'] = "ZeroPayment";
			
			
			$OrderDataArray['PointText'] = isset($CalArray['userpoint']['title'])?$CalArray['userpoint']['title']:"";
			$OrderDataArray['PointAmount'] = (isset($CalArray['userpoint']['price']) && $CalArray['userpoint']['price'] > 0)?$CalArray['userpoint']['price']:"0";
			
			$OrderDataArray['VoucherText'] = isset($CalArray['discount']['title'])?$CalArray['discount']['title']:"";
			$OrderDataArray['VoucherCode'] = isset($CalArray['discount']['code'])?$CalArray['discount']['code']:"";
			$OrderDataArray['VoucherAmount'] = (isset($CalArray['discount']['price']) && $CalArray['discount']['price'] > 0)?$CalArray['discount']['price']:"0";
			
			$OrderDataArray['ShippingText'] = isset($CalArray['shipping']['title'])?$CalArray['shipping']['title']:"";
			$OrderDataArray['ShippingCode'] = isset($CalArray['shipping']['code'])?$CalArray['shipping']['code']:"";
			$OrderDataArray['ShippingAmount'] = (isset($CalArray['shipping']['price']) && $CalArray['shipping']['price'] > 0)?$CalArray['shipping']['price']:"0";
			
			$OrderDataArray['SubTotal'] = (isset($CalArray['subtotal']['price']) && $CalArray['subtotal']['price'] > 0)?$CalArray['subtotal']['price']:"0";
			$OrderDataArray['TaxText'] = isset($CalArray['tax']['title'])?$CalArray['tax']['title']:"VAT";
			$OrderDataArray['TaxAmount'] = (isset($CalArray['tax']['price']) && $CalArray['tax']['price'] > 0)?$CalArray['tax']['price']:"0";
			
			$OrderDataArray['Total'] = (isset($CalArray['total']['price']) && $CalArray['total']['price'] > 0)?$CalArray['total']['price']:"0";
			$OrderDataArray['ProductDiscount'] = (isset($CalArray['productdiscount']['price']) && $CalArray['productdiscount']['price'] > 0)?$CalArray['productdiscount']['price']:"0";
			
			$OrderDataArray['GrandTotal'] = (isset($CalArray['grandtotal']['price']) && $CalArray['grandtotal']['price'] > 0)?$CalArray['grandtotal']['price']:"0";
			//$OrderDataArray['TaxPercentage'] = $ShoppingCalculationObj->TaxPercentage;
			
			
			/*User Point Table Insert GETPoint start*/
			if($TotalUserPoint >0 && $OrderDataArray['UserID'] !="")
			{
				$UserPointObj = new DataTable(TABLE_USERS_POINT);
				$UPointDataArray = array();
				$UPointDataArray['UserID'] = $OrderDataArray['UserID'];
				$UPointDataArray['OrderID'] = $OrderID;
				$UPointDataArray['Points'] = $TotalUserPoint;
				$UPointDataArray['OrderStatus'] = $OrderDataArray['PaymentStatus'];
				$UPointDataArray['PointStatus'] = $PointStatusArray['Get'];
				$UPointDataArray['CreatedDate'] = date("Y-m-d H:i:s");
				$UserPointObj->tableInsert($UPointDataArray);
			}
			/*User Point Table Insert GETPoint end*/
			
			/*User Point Table Insert AccessPoint start*/
			if( isset($CalArray['userpoint']['points']) && $CalArray['userpoint']['points'] > 0){
				
				$OrderDataArray['AccessPoint'] = $CalArray['userpoint']['points'];
				$UserPointObj = new DataTable(TABLE_USERS_POINT);
				$UPointDataArray = array();
				$UPointDataArray['UserID'] = $OrderDataArray['UserID'];
				$UPointDataArray['OrderID'] = $OrderID;
				$UPointDataArray['Points'] = $CalArray['userpoint']['points'];
				$UPointDataArray['OrderStatus'] = $OrderDataArray['PaymentStatus'];
				$UPointDataArray['PointStatus'] = $PointStatusArray['Access'];
				$UPointDataArray['CreatedDate'] = date("Y-m-d H:i:s");
				$UserPointObj->tableInsert($UPointDataArray);
			}
			/*User Point Table Insert AccessPoint start*/
			
			$OrderDataArray['OrderNo'] ="A".date('y').($OrderID);
			$OrderDataArray['SessionID'] =$SessionID;
			
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
			$CurrentOrder = (object)$OrderObj->tableSelectOne();
			
			if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID !="")
			{
				$OrderObj->tableUpdate($OrderDataArray);
			}
			else 
			{
				$OrderDataArray['OrderID'] =$OrderID;
					
				$OrderDataArray['CreatedDate']	=date("Y-m-d H:i:s");
				$OrderObj->tableInsert($OrderDataArray);
			}
			return $OrderID;
			
    }		
	
	
}	