<?php 
namespace Sale\Cart;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;
class ShoppingCalculation extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function Calculate($type,$Params = "")
	{
		if($type=="order")
			$arr = $this->CalculateFromOrder($Params);
		else
			$arr  = $this->CalculateFromTmp($Params);
	
		return $arr; 	
	}
	
	function CalculateFromOrder($OrderID)
	{
		$CalArray = array();
		$CurrentOrder = $this->getOrder($OrderID);
		
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ''){
			$CalArray['subtotal'] = array("display"=>"1",
									  "title"=>"Sub Total(excl. VAT)",
									  "price"=>$CurrentOrder->SubTotal,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->SubTotal),
									 );
									 
			
		 
		  $CalArray['shipping'] = array("display"=>"1",
								  "title"=>$CurrentOrder->ShippingText,
								  "price"=>$CurrentOrder->ShippingAmount,
								  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->ShippingAmount),
								 );	

		 $CalArray['tax'] = array("display"=>"1",
									  "title"=>$CurrentOrder->TaxText,
									  "price"=>$CurrentOrder->TaxAmount,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->TaxAmount),
									 );		

		if($CurrentOrder->ProductDiscount > 0){		
				$CalArray['productdiscount'] = array("display"=>"0",
												  "title"=>"Product Discount",
												  "price"=>$CurrentOrder->ProductDiscount,
												  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->ProductDiscount),
												 );				
					$Total = $CurrentOrder->SubTotal + $CurrentOrder->TaxAmount + $CurrentOrder->ShippingAmount;	
					//echo "--".$CurrentOrder->Total;	
					if(number_format($Total,2) != number_format($CurrentOrder->Total,2)){
						$CalArray['productdiscount']['display'] = "1";
					}
						
				}					 
		   $CalArray['total'] = array("display"=>"1",
								  "title"=>"Total",
								  "price"=>$CurrentOrder->Total,
								  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->Total),
								 );								
		
		 if($CurrentOrder->PointAmount > 0){		
		  $CalArray['userpoint'] = array("display"=>"1",
								  "title"=>$CurrentOrder->PointText,
								  "price"=>$CurrentOrder->PointAmount,
								  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->PointAmount),
								 );				
		 }								 
									 
		  if($CurrentOrder->VoucherAmount > 0){							 
			  $CalArray['discount'] = array("display"=>"1",
									  "title"=>$CurrentOrder->VoucherText,
									  "price"=>$CurrentOrder->VoucherAmount,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->VoucherAmount),
									 );	
		  }
		  
		 if($CurrentOrder->GrandTotal != $CurrentOrder->Total){	
			   $CalArray['grandtotal'] = array("display"=>"1",
									  "title"=>"Grand Total",
									  "price"=>$CurrentOrder->GrandTotal,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2OrderCurrency($OrderID,$CurrentOrder->GrandTotal),
									 );	
				 }								 
									 							 
		}
		  return $CalArray;
		
	}
	
	function CalculateFromTmp($PostArray = array())
	{
		$CalArray = array();
		
		//$DataArray[0]= "SUM(UnitPrice*Qty) as SubTotal";
		//$Obj = $TmpCartObj->tableSelectOne($DataArray);
		//$this->SubTotal = $Obj->SubTotal;
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();		
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','ProductDiscount'=>'SUM(VoucherAmount)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
		
		if(isset($Obj->Price)){
			$CalArray['subtotal'] = array("display"=>"1",
									  "title"=>"Sub Total(excl. VAT)",
									  "price"=>$Obj->Price,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->Price),
									 );
		}
		
		if(isset($Obj->TaxPrice) && $Obj->TaxPrice > 0){		
			$Obj->Total =  $Obj->Price + $Obj->TaxPrice;
			$CalArray['tax'] = array("display"=>"1",
									  "title"=>"VAT",
									  "price"=>$Obj->TaxPrice,
									   "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->TaxPrice),
									 );							 
		}
		
		if(isset($IsCurrentUser->VATExempt) && $IsCurrentUser->VATExempt == "1"){
		
			$CalArray['tax'] = array("display"=>"1",
									  "title"=>"VAT",
									  "price"=>$Obj->TaxPrice,
									   "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->TaxPrice),
									 );	
		}
		
		if(isset($IsCurrentUser->VATNumber) && $IsCurrentUser->VATNumber  != ""){
			$CalArray['tax']['title'] = $CalArray['tax']['title'] ." - ".$IsCurrentUser->VATNumber;
			$CalArray['tax']['display'] = "1";
		}

		/* shipping method start*/	
		$CalArray['shipping'] = array("display"=>"0",
									  "title"=>"Shipping",
									  "price"=>"0",
									  
									 );	
		
		
		if(isset($PostArray['ship_method']) && $PostArray['ship_method'] != ""){
			$ShippingArray  = $this->getClass("ShippingModule\Shipping\Common")->getAllShipping($PostArray);
			if(isset($ShippingArray['count']) && $ShippingArray['count'] > 0 && is_array($ShippingArray['method']) && count($ShippingArray['method']) > 0){
				foreach($ShippingArray['method'] as $m=>$arr){
					foreach($arr['rates'] as $rateArr){
						$code = $m.'__'.$rateArr['code'];
						if($code==$PostArray['ship_method']){
							$Obj->Total =  $Obj->Total + $rateArr['price'];
							$CalArray['shipping'] = array("display"=>"1",
														  //"title"=>"Shipping (".$arr['title']."-".$rateArr['title'].")",
														  "title"=>"Shipping (".$rateArr['title'].")",
														  "code"=>$code,
														  "price"=>$rateArr['price'],
														  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($rateArr['price']),
														 );	
						}
					}
				}
			}
		}
		
		if(d("VAT_ON_SHIPPING")=="1" && d("VAT_ON_SHIPPING_TAXCLASSID") > 0 && $CalArray['shipping']['price'] > 0){
			
			$TaxArray = $this->getClass('Catalog\Product\Common')->GetTaxPercentByTaxClassID(d("VAT_ON_SHIPPING_TAXCLASSID"));
			$TaxPercent = isset($TaxArray['TaxPercent'])?$TaxArray['TaxPercent']:"0";
			if($TaxPercent > 0){
				$TaxShippingPrice =($TaxPercent/100)*$CalArray['shipping']['price'];
				$TaxPriceIncShippingTax = $CalArray['tax']['price'] + $TaxShippingPrice;
				$Obj->Total =  $Obj->Total + $TaxShippingPrice;
				$CalArray['tax']['price'] = $TaxPriceIncShippingTax;
				$CalArray['tax']['displayprice'] = $this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($TaxPriceIncShippingTax);
				
				
			}
			 
		}
		
		//var_dump($CalArray);exit;
		/* shipping method end*/	
		
		if(isset($Obj->ProductDiscount) && $Obj->ProductDiscount > 0){		
			//$Obj->Total = $Obj->Total - $Obj->ProductDiscount;
			$CalArray['productdiscount'] = array("display"=>"0",
									  "title"=>"Product Discount",
									  "price"=>$Obj->ProductDiscount,
									   "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->ProductDiscount),
									 );							 
		}

		$CalArray['total'] = array("display"=>"0",
									  "title"=>"Total",
									  "price"=>$Obj->Total,
									   "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->Total),
									 );	
									 
		if(isset($Obj->Total) && $Obj->Total != $Obj->Price){		
			$CalArray['total'] = array("display"=>"1",
									  "title"=>"Total",
									  "price"=>$Obj->Total,
									   "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->Total),
									 );							 
		}
		
		$Obj->GrandTotal = $Obj->Total;
		/* userpoint method start*/	
		$CalArray['userpoint'] = array("display"=>"0",
									  "title"=>"",
									  "price"=>"",
									  "displayprice"=>"",
									 );	
		
		if(isset($PostArray['AccessPoint']) && $PostArray['AccessPoint'] != ""){
			if(isset($IsCurrentUser->UserID) && $IsCurrentUser->UserID != ""){
				$LoyalityPointArr = $this->getClass('Customer\Login\Common')->GetLoyalityPoint($IsCurrentUser->UserID);
				if($LoyalityPointArr['LeftPoint'] >= $_POST['AccessPoint']){
					$PointAmount = ($PostArray['AccessPoint']/d("PRODUCT_POINT_INCURRENCY"));
					
					/* Round up discount start*/
					if(floor($PointAmount) != $PointAmount && false){
						$PointAmount = floor($PointAmount);
						$PostArray['AccessPoint'] = d("PRODUCT_POINT_INCURRENCY") * $PointAmount;
					}
					/* Round up discount end*/
					
					$SubTotal = $Obj->UnitPrice + $Obj->TaxPrice;
					if($PointAmount > 0 && $SubTotal >= $PointAmount){
						$Obj->GrandTotal = $Obj->GrandTotal - $PointAmount;
						$CalArray['userpoint'] = array("display"=>"1",
													  "title"=>"Discount on points - ".$PostArray['AccessPoint'],
													  "points"=>$PostArray['AccessPoint'],
													  "price"=>$PointAmount,
													  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($PointAmount),
													 );	
					}
					else{
						
						if(isset($_POST['AccessPoint']) && $_POST['AccessPoint'] > 0)
							$this->getSession()->setArrVar("alert",array("danger","Your Loyalty Points discount should be less than sub total"));
						
					}
				}
			}
		}							 
		/* userpoint method start*/								 
	
		$CalArray['discount'] = array("display"=>"0",
									  "title"=>"Discount",
									  "price"=>"0",
									 );	
									 
		
		if($this->getSession()->getVar("OrderCoupon") != "" && $Obj->GrandTotal > 0){
			$vArr = $this->CheckCouponValues($this->getSession()->getVar("OrderCoupon"),$Obj->GrandTotal);
			
			if(isset($vArr['VOUCHERS']) && isset($vArr['VOUCHERS']['Success']) && isset($vArr['VOUCHERS']['Amount']) && $vArr['VOUCHERS']['Amount'] > 0){
				$Obj->GrandTotal = $Obj->GrandTotal - $vArr['VOUCHERS']['Amount'];
				$CalArray['discount'] = array("display"=>"1",
										      "code"=>$vArr['VOUCHERS']['Code'],
										      "title"=>"Discount (".$vArr['VOUCHERS']['Message'].")",
										      "price"=>$vArr['VOUCHERS']['Amount'],
									          "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($vArr['VOUCHERS']['Amount']),
									
									 );
			}
		}
		
	    $CalArray['grandtotal'] = array("display"=>"0",
									  "title"=>"Grand Total",
									  "price"=>$Obj->GrandTotal,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->GrandTotal),
									 );	
									 
		if(isset($Obj->GrandTotal) && $Obj->GrandTotal != $Obj->Total){
			$CalArray['grandtotal'] = array("display"=>"1",
									  "title"=>"Grand Total",
									  "price"=>$Obj->GrandTotal,
									  "displayprice"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Obj->GrandTotal),
									 );	
		}			
	   
	   return $CalArray;
	   //var_dump($CalArray);exit;
		
	}
	
	function getOrder($OrderID)
	{
		if($OrderID > 0){
			$OrderObj = new DataTable(array('o'=>TABLE_ORDERS));
			$OrderObj->where[] = array('=',array('o.OrderID' => $OrderID));
			return (object)$OrderObj->tableSelectOne(array("*"));
		}
		return false;
	}
	
	function getInvoice($OrderID)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/invoice.php")){
			$CurrentOrder = $this->getOrder($OrderID);
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/invoice.php");
			$MessageBody = ob_get_clean();
			//$MessageBody = ob_get_contents();
			return $MessageBody;
		}
		return false;
		
	}
	
	function CheckCouponValues($VoucherCode,$PushGrandTotal)
	{
		 $cartRows = $this->getClass("Sale\Cart\Common")->getShoppingCart();
		 if(d("COUPON_MULTIPLE_ADDINCART")=="1")
			$CouponCodeArray = explode(",",$VoucherCode);
		 else
			$CouponCodeArray = array($VoucherCode);
	
		 
		 $ReturnArray = array();  
		 $SubTotalCouponArray = array();
		 
		 /* CouponCodeArray Start */
		 foreach($CouponCodeArray as $k=>$CouponCode){
			$CouponObj = new DataTable(TABLE_COUPONS);
			$where = new Where();
			$where->equalTo('CouponCode',trim($CouponCode));
			$where->equalTo('Active',"1");
			$where->NEST//start braket
					->expression('(? BETWEEN StartDate AND EndDate)',date('Y-m-d'))
					//->OR
					//->expression("(StartDate =? OR EndDate =?)",array('0000-00-00','0000-00-00'))
					->OR
						->NEST//start braket
						->ISNULL('StartDate')
						->AND
						->ISNULL('EndDate')
						->UNNEST
					->UNNEST;
	
			
					
			//$CouponObj->displayQuery = true;
			$CouponObj->where = $where;
			$CurrentCoupon = (object)$CouponObj->tableSelectOne(array("*"));
			if(isset($CurrentCoupon->CouponID) && $CurrentCoupon->CouponID != ""){
				if($CurrentCoupon->CouponLimit > $CurrentCoupon->CouponUsed OR ($CurrentCoupon->CouponLimit == 0)){
					/* product specific coupon start*/
					if($CurrentCoupon->ProductSpecific=="1"){
						
						foreach($cartRows as $CurrentCartItem){
							if(in_array($CurrentCartItem->ItemType,array("Product","GiftVoucher"))){
								$ProductID = $CurrentCartItem->ReferenceID;
								$CouponProductArray = explode(",",$CurrentCoupon->ProductIDs);
								if(count($CouponProductArray) > 0 && in_array($ProductID,$CouponProductArray)){
									//echo $ProductID."<hr>";
									$CouponAmount = 0;
									if($CurrentCoupon->CouponType=="FlatPrice"){
										if($CurrentCartItem->Price > $CouponAmount)
											$CouponAmount = $CurrentCoupon->CouponValue;
									}
									else if($CurrentCoupon->CouponType=="Percentage"){
										$CouponAmount = ($CurrentCartItem->Price*($CurrentCoupon->CouponValue/100));
									}
									if($CouponAmount > 0 && $CouponAmount > $CurrentCartItem->VoucherAmount && $CurrentCartItem->Price > $CouponAmount){
										
										$TmpCartObj = new DataTable(TABLE_TMPCART);
										$DataArray = array();
										$DataArray['VoucherAmount'] = $CouponAmount;
										$DataArray['VoucherText'] = isset($CurrentCoupon->Message)?$CurrentCoupon->Message:"";
										$DataArray['VoucherCode'] = isset($CurrentCoupon->CouponCode)?$CurrentCoupon->CouponCode:"";
										
										$DataArray['Price'] = $CurrentCartItem->Price - $CouponAmount;
										$DataArray['TaxPrice'] = (($DataArray['Price']  * $CurrentCartItem->TaxPercent)/100);
										$DataArray['PriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
										$DataArray['Qty'] = $CurrentCartItem->Qty;
										$DataArray['Total'] = $DataArray['Price'] * $DataArray['Qty'];
										$DataArray['TotalWithTax'] = $DataArray['PriceWithTax'] * $DataArray['Qty'];
										
										
										$where = new Where();
										$where->equalTo('ItemID',$CurrentCartItem->ItemID);
										$TmpCartObj->where = $where;
										$TmpCartObj->tableUpdate($DataArray);
										
										$ReturnArray["PRODUCT@@@".$CurrentCoupon->CouponCode."@@@".$ProductID] = array("ID"=>$CurrentCoupon->CouponID,
																										  "Code"=>$CurrentCoupon->CouponCode,
																										  "ProductID"=>$ProductID,
																										  "Type"=>"Product",
																										  "Object"=>$CurrentCoupon,
																										  "Amount"=>$CouponAmount,
																										  "Success"=> "Congratulation Voucher Code - <b>".$CurrentCoupon->CouponCode."</b>  has successfully applied in your order.",
																	                                      );
										
									}								
								}
							}
						}
					}
					/* product specific coupon start*/
					/* subtotal coupon start*/
					else{
						 $SubTotalCouponArray[$CurrentCoupon->CouponID] = $CurrentCoupon;
					}
					/* subtotal specific coupon start*/
				
				}
				else{
					$ReturnArray[$CurrentCoupon->CouponCode] = array("ID"=>$CurrentCoupon->CouponID,
																	 "Code"=>$CurrentCoupon->CouponCode,
																     "Object"=>$CurrentCoupon,
																     "Error"=>"Your Voucher Code - <b>".$CurrentCoupon->CouponCode."</b> has been expired.",
																   );
				}
				
			}
			else{
				$ReturnArray[$CouponCode] = array("ID"=>'',
												  "Code"=>$CouponCode,
												  "Object"=>$CurrentCoupon,
												  "Error"=>"Your Voucher Code - <b>".$CouponCode."</b> is invalid.",
												 );
			}
			
			
		 }
		 /* CouponCodeArray End */
		 
		 /* SubTotalCouponArray Start */
		 if(count($SubTotalCouponArray) > 0){
			 $VoucherTextArray = array();	
			 $VoucherCodeArray  = array();	
			 $VoucherAmount = 0;
			  if($PushGrandTotal=="-1"){	
				$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart");
				$GrandTotal = isset($CalArray['grandtotal']['price'])?$CalArray['grandtotal']['price']:"0";
			  }
			 else{
				$GrandTotal = $PushGrandTotal;
			 }				 
			if(count($SubTotalCouponArray) > 1){
				 foreach($SubTotalCouponArray as $CouponID=>$CurrentCoupon){
					 $VoucherCodeArray[] = $CurrentCoupon->CouponCode;
					 if($CurrentCoupon->Message != "")
						$VoucherTextArray[] = $CurrentCoupon->Message;
					
					if($CurrentCoupon->MultipleEnabled=="1"){
						if($CurrentCoupon->CouponType=="FlatPrice"){
							if($GrandTotal > $VoucherAmount)
								$VoucherAmount = $VoucherAmount + $CurrentCoupon->CouponValue;
						}
						else if($CurrentCoupon->CouponType=="Percentage"){
							$VoucherAmount = $VoucherAmount + ($GrandTotal*($CurrentCoupon->CouponValue/100));
						}
					}						
			   }
			}
			else{
				
				foreach($SubTotalCouponArray as $CouponID=>$CurrentCoupon){
				 $VoucherCodeArray[] = $CurrentCoupon->CouponCode;
				 $VoucherTextArray[] = $CurrentCoupon->Message;
					if($CurrentCoupon->CouponType=="FlatPrice"){
						if($GrandTotal > $VoucherAmount)
							$VoucherAmount = $VoucherAmount + $CurrentCoupon->CouponValue;
					}
					else if($CurrentCoupon->CouponType=="Percentage"){
						$VoucherAmount = $VoucherAmount + ($GrandTotal*($CurrentCoupon->CouponValue/100));
					}
				}
				
			}
			
			if($GrandTotal > 0 && $VoucherAmount > 0 && $GrandTotal >= $VoucherAmount){
				
				$ReturnArray["VOUCHERS"] = array("ID"=>'',
													  "Code"=>implode(",",$VoucherCodeArray),
													  "Type"=>"SubTotal",
													  "Amount"=>$VoucherAmount,
													  "Message"=>(implode(",",array_unique($VoucherTextArray))),
													  "Success"=> "Congratulation Voucher Code - <b>".(implode(",",$VoucherCodeArray))."</b>  has successfully applied in your order.",
													  );
				
			}
            else{
				$ReturnArray["VOUCHERS"] = array("ID"=>'0',
												  "Code"=>implode(",",$VoucherCodeArray),
												  "Error"=>"<b>".(implode(",",$VoucherCodeArray))."</b>: Discount amount should not be greater than order value.",
												 );
			}				
		}
		 /* SubTotalCouponArray End */
		 
		 return $ReturnArray;
	}
	function ResetCart()
	{
		
			
		$cartRows = $this->getClass('Sale\Cart\Common')->getShoppingCart();
		foreach($cartRows as $CurrentTmpItem){
			if(isset($CurrentTmpItem->ItemID) && $CurrentTmpItem->ItemID !="" && in_array($CurrentTmpItem->ItemType,array("Bundle","Product","GiftVoucher"))){
				$ProductID = $CurrentTmpItem->ReferenceID;
				$Qty = $CurrentTmpItem->Qty;
				$POSTDUMP = unserialize(base64_decode($CurrentTmpItem->SessionInfo));		
				$this->getClass('Sale\Cart\Common')->AddProductInTmpCart($ProductID,$Qty,@implode(",",(isset($POSTDUMP['ProductAdditionName'])?$POSTDUMP['ProductAdditionName']:array())),$POSTDUMP);
				$this->getClass('Sale\Cart\Common')->AddCartInCookie();
			}
		}
		
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		if(isset($IsCurrentUser->WholeSaler) && $IsCurrentUser->WholeSaler=="1"){
			$SessionID = $this->getSession()->getCurrentSID();
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$where = new Where();
			$where->equalTo('SessionID',$SessionID);
			$where->equalTo('Attribute2','DiscountedProduct');
			$TmpCartObj->where = $where;
			$discountedRows = $TmpCartObj->tableSelectAll("",array("TmpCartID ASC"));
			if(count($discountedRows) > 0){
				foreach($discountedRows as $CurrentDisItem){
					$TmpCartObj = new DataTable(TABLE_TMPCART);
						$TmpCartObj = new DataTable(TABLE_TMPCART);
						$where = new Where();
						$where->equalTo('SessionID',$SessionID);
						$where->NEST//start braket
						->equalTo('ItemID',$CurrentDisItem->ParentItemID)
						->OR
						->equalTo('ParentItemID',$CurrentDisItem->ParentItemID)
						->UNNEST;
						$TmpCartObj->where = $where;
						$TmpCartObj->tableDelete();
				}
				$this->getClass('Sale\Cart\Common')->AddCartInCookie();
			}
			
		}
		
	}
	
}

	

