<?php 
namespace Sale\Cart\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Sale\Cart\Common as CartCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	function __construct()
	{
		
	}
	
	public function getCartCommon()
	{
		$obj = new CartCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$obj = $this->getClass('Cms\Pages\Common')->getPageByPageID($arr['ID']);
			if(isset($obj->PageID))
			{
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
		}
		
	}
	
	function DownloadLogoAction()
	{
		$file = isset($_REQUEST['file'])?$_REQUEST['file']:"";
		
		if($file != "" ){
			$dir = FileHandle::CheckPrivateLogDirectory("logo_upload");
			$OriginalImage=$dir.$file;	
			if(file_exists($OriginalImage)){
				FileHandle::DownloadFile($OriginalImage);	
				exit;	
			}
		}
		
		die("Invalid request");
	}
	function AddCartDirectAction()
	{
		//die('Coming Soon');
		$ProductID = isset($_REQUEST['PID'])?$_REQUEST['PID']:"";
		$Qty = (isset($_GET['Qty']) && $_GET['Qty'] >0)?ceil($_GET['Qty']):"1";
		$return = $this->getCartCommon()->AddProductInTmpCart($ProductID,$Qty);
		if($return=="1")
		{
			if(isset($_REQUEST['SKAjax']) && $_REQUEST['SKAjax']=="1"){
				//@ob_clean();
				echo "1";
				exit;
			}
			else{
				if(isset($_REQUEST['rview']) && strtolower($_REQUEST['rview'])=="checkout")				
					MyRedirect(SKSEOURL('checkout','Checkout')); 	
				else
					MyRedirect(SKSEOURL('checkout','Cart')); 	
				exit;
			}
		}
		else{
			if(isset($_REQUEST['SKAjax']) && $_REQUEST['SKAjax']=="1"){
				//@ob_clean();
				json_encode($return);
				exit;
			}
			
			if(isset($return) && is_array($return) && count($return) > 0){
				foreach($return as $k=>$arr)
				{
					$this->getSession()->setArrVar("alert",$arr);
				}
			}
			MyRedirect(SKSEOURL('catalog_product','Detail',$ProductID)); 	
			exit;
		}
		
	}
	function AddFastOrderCartAction()
	{	
		if(count($_POST) > 0){
			foreach($_POST["PID"] as $k=>$Val){
				
				if($Val != ""){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ModelNo' => $Val));
					$ProductObj->where[] = array('=',array('Active' => "1"));
					$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","ModelNo"));																	
					if(isset($CurrentProduct->ProductID)){
						$ProductID = $CurrentProduct->ProductID;
						$Qty = (isset($_POST['Qty'][$k]) && $_POST['Qty'][$k] >0)?ceil($_POST['Qty'][$k]):"1";
						$this->getCartCommon()->AddProductInTmpCart($ProductID,$Qty);
					}
				}
			}
			
			foreach($_POST["PrdQty"] as $ProductID=>$Qty){
				if($Qty > 0){
					$this->getCartCommon()->AddProductInTmpCart($ProductID,$Qty);
				}
			}
			if(isset($_POST["ProductID"]) && $_POST["ProductID"] > 0){
				$Qty = (isset($_POST['Qty']) && $_POST['Qty'] >0)?ceil($_POST['Qty']):"1";
				$this->getCartCommon()->AddProductInTmpCart($_POST["ProductID"],$Qty);		
			}
			
			MyRedirect(SKSEOURL('checkout','Cart')); 	
			exit;
		}
			
	}
	
	function AddCartAction()
	{
		//var_dump($_REQUEST);
		//die('Coming Soon');
		$ProductID = isset($_REQUEST['ProductID'])?$_REQUEST['ProductID']:"";
		$Qty = (isset($_POST['Qty']) && $_POST['Qty'] >0)?ceil($_POST['Qty']):"1";
		$return = $this->getCartCommon()->AddProductInTmpCart($ProductID,$Qty,@implode(",",(isset($_POST['ProductAdditionName'])?$_POST['ProductAdditionName']:array())),$_POST);
		
		if($return=="1")
		{
			if(isset($_REQUEST['SKAjax']) && $_REQUEST['SKAjax']=="1"){
				@ob_clean();
				echo "1";
				exit;
			}
			else{
				MyRedirect(SKSEOURL('checkout','Cart')); 	
				exit;
			}
		}
		else{
			if(isset($return) && is_array($return) && count($return) > 0){
				foreach($return as $k=>$arr)
				{
					$this->getSession()->setArrVar("alert",$arr);
				}
			}
			MyRedirect(SKSEOURL('catalog_product','Detail',$ProductID)); 	
			exit;
		}
		
	}
	
	function UpdateCartAction()
	{
		if(count($_POST) > 0){
			for($i=1;$i<$_POST['Count'];$i++){
				$SessionID = $this->getSession()->getCurrentSID();
				$ItemID = isset($_POST['ItemID'.$i])?$_POST['ItemID'.$i]:"";
				$Qty = isset($_POST['Qty'][$ItemID])?$_POST['Qty'][$ItemID]:"1";
				if(trim($Qty) <= "0" OR trim($Qty)=="" OR !is_numeric($Qty))
				{
					$this->getSession()->setArrVar("alert",array("danger",d("DEFINE_INVALID_QUANTITY")));
					MyRedirect(SKSEOURL('checkout','Cart')); 	
					exit;
				}
				
				/*$TmpCartObj = new DataTable(TABLE_TMPCART);
				$where = new Where();
				$where->equalTo('SessionID',$SessionID);
				$where->equalTo('ItemID',$ItemID);
				$TmpCartObj->where = $where;
				$TmpCartObj->displayQuery = true;
				$CurrentTmpItem = (object)$TmpCartObj->tableSelectOne();
				*/
				$cartRows = $this->getCartCommon()->getShoppingCart();
				foreach($cartRows as $CurrentTmpItem){
					if($CurrentTmpItem->ItemID==$ItemID && isset($CurrentTmpItem->ItemID) && $CurrentTmpItem->ItemID !="" && in_array($CurrentTmpItem->ItemType,array("Bundle","ProductChild","Product","GiftVoucher"))){
						$ProductID = $CurrentTmpItem->ReferenceID;
						$Qty = isset($_POST['Qty'][$ItemID])?$_POST['Qty'][$ItemID]:"1";
						$POSTDUMP = unserialize(base64_decode($CurrentTmpItem->SessionInfo));		
						if($CurrentTmpItem->ItemType == "ProductChild"){
							$POSTDUMP["ChQty"] = array();
							$POSTDUMP["ChQty"][$CurrentTmpItem->Attribute1] = $Qty;
						}
						$this->getCartCommon()->AddProductInTmpCart($ProductID,$Qty,@implode(",",(isset($POSTDUMP['ProductAdditionName'])?$POSTDUMP['ProductAdditionName']:array())),$POSTDUMP);
						$this->getCartCommon()->AddCartInCookie();
						//exit;
					}
				}
				
			}
			$this->getSession()->setArrVar("alert",array("success",d("UPDATE_ITEM_IN_CART")));
			MyRedirect(SKSEOURL('checkout','Cart')); 	
			exit;
			//if(isset($_SESSION['CouponCode']) && $_SESSION['CouponCode'] !="")
			//	$ShoppingCalculationObj->CheckCartDiscount($_SESSION['CouponCode']);
		}
			
	}
	function DeleteCartAction()
	{
		
		$ItemID = isset($_REQUEST['ItemID'])?$_REQUEST['ItemID']:"";
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
		->equalTo('ItemID',$ItemID)
		->OR
		->equalTo('ParentItemID',$ItemID)
		->UNNEST;
		$TmpCartObj->where = $where;
		$TmpCartObj->tableDelete();
		
		$this->getCartCommon()->AddCartInCookie();
		
		$this->getSession()->setArrVar("alert",array("success",d("DELETE_ITEM_IN_CART")));
		MyRedirect(SKSEOURL('checkout','Cart')); 	
		exit;
		
	}
	
	function CartCheckoutAction()
	{
		$OrderID = $this->getSession()->getVar("OrderID");
		if($OrderID=="")
		{
			if(d("CHECKOUT_LOGIN")=="1" && d("CHECKOUT_WITHOUT_LOGIN")=="1")
			{
				if($this->getClass('Customer\Login\Common')->CheckUserLogin(SKSEOURL('checkout','Checkout')))
				{
					MyRedirect(SKSEOURL('checkout','Checkout')); 		
					exit;				
				}	
				else 
				{
					MyRedirect(SKSEOURL('customer','Login')); 
					exit;
				}
			}
		}
		MyRedirect(SKSEOURL('checkout','Checkout')); 	
		exit;
	}
	
	
	
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"";
	}
	
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	function directFile()
	{
		if($this->origin->ajax=="1")
			return true;
		else
			return false;
		
	}
	
}	