<?php
namespace Frontend\Base;
use Frontend\Base\AbstractTheme;
use Frontend\Common\Header as header;
class DefaultTheme extends AbstractTheme
{
   
	public function getThemePath()
	{
		return realpath(__DIR__)."/../";
	}
	
	public function getThemeUrl($file="")
	{
		if($file != "")
			return FRONT_THEME_URL.$file;
		else
			return FRONT_THEME_URL;
	}
	public function getMeta()
	{
		if(file_exists(FRONT_THEME_PATH."inc/meta.php"))
			include(FRONT_THEME_PATH."inc/meta.php");
	}
	public function getHeaderCss()
	{
		
		SkCssInclude("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css",true);
		SkCssInclude("https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/css/bootstrap.min.css",true);
		//SkCssInclude(FRONT_THEME_URL."assest/css/bootstrap.min.css");
		SkCssInclude(FRONT_THEME_URL."assest/css/global.css");
		SkCssInclude(FRONT_THEME_URL."assest/css/navbar.css");
		SkCssInclude(DIR_WS_SITE."templates/tools/jquery/slick/slick.css");
		SkCssInclude(DIR_WS_SITE."templates/tools/jquery/slick/slick-theme.css");
			
		if(d("DEFINE_DETECT_IS_MOBILE") == true && d("DEFINE_IS_HOMEPAGE_CHECK") == "1"){
				//SkCssInclude(FRONT_THEME_URL."assest/css/navbar-mobile.css");
				SkCssInclude(FRONT_THEME_URL."assest/css/style.css");
				SkCssInclude(FRONT_THEME_URL."assest/css/animate.css");
				//SkCssInclude(FRONT_THEME_URL."assest/css/style_mobile.css");
				SkCssInclude(FRONT_THEME_URL."assest/custom.css");
				
		}
		else if(d("DEFINE_IS_HOMEPAGE_CHECK") == "1"){
			
			//SkCssInclude(FRONT_THEME_URL."assest/css/navbar-mobile.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/style.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/animate.css");
			//SkCssInclude(FRONT_THEME_URL."assest/css/style_desktop.css");
			SkCssInclude(FRONT_THEME_URL."assest/custom.css");
		
		}
		else if(d("DEFINE_DETECT_IS_MOBILE") == true){
			//SkCssInclude(FRONT_THEME_URL."assest/css/navbar-mobile.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/style.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/animate.css");
			//SkCssInclude(FRONT_THEME_URL."assest/css/style_mobile.css");
			SkCssInclude(FRONT_THEME_URL."assest/custom.css");
			
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/themes/blitzer/jquery-ui.min.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/simple-scrollbar/scrollBar.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/dialog/bootstrap-dialog.min.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/myzoom/jquery.myzoom.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/lightbox2/css/lightbox.min.css");
			
			
		}
		else{
			
			//SkCssInclude(FRONT_THEME_URL."assest/css/navbar-mobile.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/style.css");
			SkCssInclude(FRONT_THEME_URL."assest/css/animate.css");
			//SkCssInclude(FRONT_THEME_URL."assest/css/style_desktop.css");
			SkCssInclude(FRONT_THEME_URL."assest/custom.css?1");
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/themes/blitzer/jquery-ui.min.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/simple-scrollbar/scrollBar.css");
			
			SkCssInclude(DIR_WS_SITE."templates/tools/dialog/bootstrap-dialog.min.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/myzoom/jquery.myzoom.css");
			SkCssInclude(DIR_WS_SITE."templates/tools/jquery/lightbox2/css/lightbox.min.css");
		
		}
		
		SkCssDisplay();
		
		
		
	}
	
	public function getFooterCss()
	{
		
		
	}
	
	public function getFooterJs()
	{
		
		SkJsInclude("https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js",true);
		SkJsInclude("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/js/all.min.js",true);
		SkJsInclude("https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/js/bootstrap.bundle.min.js",true);
		
		SkJsInclude(DIR_WS_SITE."templates/tools/lazysizes/lazysizes.min.js");
		SkJsInclude(FRONT_THEME_URL."assest/js/wow.js");
		SkJsInclude(DIR_WS_SITE."templates/tools/jquery/slick/slick.min.js");
		
		if(d("DEFINE_DETECT_IS_MOBILE") == true && d("DEFINE_IS_HOMEPAGE_CHECK") == "1"){
			SkJsInclude(DIR_WS_SITE."templates/tools/nav-mobile.js");
		}
		else if(d("DEFINE_IS_HOMEPAGE_CHECK") == "1"){
			SkJsInclude(DIR_WS_SITE."templates/tools/nav-mobile.js");
		}
		else if(d("DEFINE_DETECT_IS_MOBILE") == true){
			
			SkJsInclude("https://www.google.com/recaptcha/api.js?render=".d("GOOGLE_CAPTCHA_VERFICATION_KEY"),true);
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/validation/jquery.validate.min.js");
			//SkJsInclude(FRONT_THEME_URL."assest/js/jquery.cycle2.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/themes/blitzer/jquery-ui.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/header.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/NumberFormat.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/dialog/bootstrap-dialog.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/simple-scrollbar/scrollBar.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/myzoom/jquery.myzoom.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/lightbox2/js/lightbox.min.js");
			//SkJsInclude(FRONT_THEME_URL."assest/js/slider.js");
			//SkJsInclude(DIR_WS_SITE."templates/tools/nav-mobile.js");
		}
		else{			
			SkJsInclude("https://www.google.com/recaptcha/api.js?render=".d("GOOGLE_CAPTCHA_VERFICATION_KEY"),true);
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/validation/jquery.validate.min.js");
			//SkJsInclude(FRONT_THEME_URL."assest/js/jquery.cycle2.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/themes/blitzer/jquery-ui.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/header.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/NumberFormat.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/dialog/bootstrap-dialog.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/simple-scrollbar/scrollBar.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/myzoom/jquery.myzoom.min.js");
			SkJsInclude(DIR_WS_SITE."templates/tools/jquery/lightbox2/js/lightbox.min.js");
			//SkJsInclude(FRONT_THEME_URL."assest/js/slider.js");
			//SkJsInclude(DIR_WS_SITE."templates/tools/nav-mobile.js");
			
		}
		SkJsInclude(FRONT_THEME_URL."assest/js/script.js");
		SkJsInclude(DIR_WS_SITE."includes/footer.js.php",true);
		SkJsInclude(DIR_WS_SITE."templates/tools/custom.js");
	
		
		SkJsDisplay();
		SkJsIncludeInner();
	}
	
	
	public function getHeader()
	{
		if(file_exists(FRONT_THEME_PATH."inc/header.php"))
			include(FRONT_THEME_PATH."inc/header.php");
	}
	public function getLeftSide($FileName,$LeftSideArr = array())
	{
		if(file_exists(FRONT_THEME_PATH."inc/".$FileName.".php"))
			include(FRONT_THEME_PATH."inc/".$FileName.".php");
	}
	public function getFooter()
	{
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
		$CacheKey = $this->getClass("Frontend\Common\Common")->getUniqueCacheKey();
		$filename=$dir.md5("cache.footer".$CacheKey).".txt";
		
		if(false && file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			include($filename);
		}
		else
		{
			@ob_start();
			if(file_exists(FRONT_THEME_PATH."inc/footer.php"))
				include(FRONT_THEME_PATH."inc/footer.php");
		
			$Content = ob_get_contents();
			$fp2 = fopen($filename, "w");
			fputs($fp2,$Content);	
			fclose($fp2);
			
		}

		
	}
	
	public function getTemplateFile($file)
	{
		if(file_exists(FRONT_THEME_PATH."inc/".basename($file)))
			include(FRONT_THEME_PATH."inc/".basename($file));
	}
	
	
	public function getMenuFooter()
	{
		if(file_exists(FRONT_THEME_PATH."inc/menu_footer.php"))
			include(FRONT_THEME_PATH."inc/menu_footer.php");
	}
	
	
}
