<?php 
namespace WebsiteControl\Login\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class IndexController extends AbstractModule
{
	protected $themeFile = "login";
	function __construct()
	{
		
	}
	
	public function checkLoginAction()
	{
		global $sessionObj;
		if(count($_POST) > 0)
		{
			$userName =$_POST['UserName'];
			$password = $_POST['Password'];
			$adminArr = $this->authenticateController($userName,$password);
			if(isset($adminArr['ControllerID']) && $adminArr['ControllerID'] !="")
			{
				$sessionObj->setVar("admin",$adminArr);
				$sessionObj->setArrVar("alert",array("success","Welcome ".$adminArr['UserName']));
				if($sessionObj->getVar("redirect_url") != "")
				{
					$redirect_url = $sessionObj->getVar("redirect_url");
					$sessionObj->deleteVar("redirect_url");
					MyRedirect($redirect_url);
					exit;
				}
				MyRedirect(DIR_WS_SITE_CONTROL."index.php");
				exit;
			}
			else 
			{
				$sessionObj->setArrVar("alert",array("danger",d("USER_LOGIN_INVALID_MSG")));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php");
				exit;
				
			}
						
		}
		
	}
	function UpdatePasswordAction()
	{
		if(count($_POST)>0)
		{
			$admin = $this->getSession()->getVar('admin');
			$ControllerFirstObj = new DataTable(TABLE_CONTROLLERS);
			$ControllerObj = new DataTable(TABLE_CONTROLLERS);
			
			$ControllerFirstObj->where[] = array('=',array('UserName' => $admin['UserName']));
			$ControllerFirstObj->where[] = array('=',array('Active' => "1"));
			$FirstObj =  (object)$ControllerFirstObj->tableSelectOne(array("Password"));
			if(isset($FirstObj->Password) && $FirstObj->Password !="")
			{
				$TmpPwd = explode(":",$FirstObj->Password);
				$EncyptPassword = NeoCryptedPassword($_POST['OldPassword'],$TmpPwd[1]).":".$TmpPwd[1];
				
				if($EncyptPassword == $FirstObj->Password)
				{
					$ControllerObj->where = array(array('=',array('UserName' => $admin['UserName'])),
									  array('=',array('Password' => $EncyptPassword)),
									  array('=',array('Active' => "1"))											  
									  );
						
			
					$ControllerObj->tableSelectOne(array("ControllerID"));
					$NumRows = $ControllerObj->getNumRows();
				}
				
				if(isset($NumRows) && $NumRows == 1)
				{
					if(!empty($_POST['Password']))
					{
						if($_POST['Password'] == $_POST['RPassword'])
						{
							$DataArray = array();
							$DataArray['Password'] = $_POST['Password'];
							$PassSalt = md5(uniqid(rand(),true));
							$DataArray['Password'] = NeoCryptedPassword($DataArray['Password'],$PassSalt).":".$PassSalt;
							$ControllerObj->tableUpdate($DataArray);
							$this->getSession()->setArrVar("alert",array("success","You have successfully changed your password."));
							MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view);
							exit;
						}
						else 
						{
							$_SESSION['ErrorMessage'] = "Password does not match.";
							$this->getSession()->setArrVar("alert",array("danger","Password does not match."));
						}
					}
					else 
					{
						$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
					}
				}
				else 
				{
						$this->getSession()->setArrVar("alert",array("danger","Please enter correct old password."));
				}
				
			}
		
		}
		
	}
	
	function logoutAction()
	{
		global $sessionObj;
		$sessionObj->deleteVar("admin");
		$sessionObj->setArrVar("alert",array("success",d("LOGOUT_MSG")));
		$this->getClass("Cms\Pages\Common")->ClearCacheFiles();
		MyRedirect(DIR_WS_SITE_CONTROL."index.php");
		exit;
	}
	
	function authenticateController($UserName, $Password,$Encrypted=false)
	{
		
		$ControllerFirstObj = new DataTable(TABLE_CONTROLLERS);
		$ControllerObj = new DataTable(TABLE_CONTROLLERS);
		
		$ControllerFirstObj->where[] = array('=',array('UserName' => $UserName));
		$ControllerFirstObj->where[] = array('=',array('Active' => "1"));
		$FirstObj =  (object)$ControllerFirstObj->tableSelectOne(array("Password"));
		if(isset($FirstObj->Password) && $FirstObj->Password !="")
		{
			$TmpPwd = explode(":",$FirstObj->Password);
			$EncyptPassword = NeoCryptedPassword($Password,$TmpPwd[1]).":".$TmpPwd[1];
			if($EncyptPassword == $FirstObj->Password)
			{
				$ControllerObj->where = array(array('=',array('UserName' => $UserName)),
											  array('=',array('Password' => $EncyptPassword)),
											  array('=',array('Active' => "1"))											  
											  );
											  
				$CurrentControllerObj = $ControllerObj->tableSelectOne();
				$NumRows = $ControllerObj->getNumRows();
			}
		}
		if($Encrypted===true)
		{
			$ControllerObj->where = array(array('=',array('UserName' => $UserName)),
									  array('=',array('Password' => $Password)),
									  array('=',array('Active' => "1"))											  
									  );

			$CurrentControllerObj = $ControllerObj->tableSelectOne();
			$NumRows = $ControllerObj->getNumRows();
		}
		if(isset($NumRows) && $NumRows == 1)
		{
			$ControllerObj->tableUpdate(
										array("LastLogin"=>date("YmdHis"),
										      "PrevLastLogin"=>(isset($CurrentControllerObj['LastLogin'])?$CurrentControllerObj['LastLogin']:date("YmdHis"))
										      )
										);
			return $CurrentControllerObj;
			
		}
		return false;
	}	
	
	
	public function getThemeFile()
	{
		if(strtolower($this->origin->view)=="default")
			$this->setThemeFile("login");
		else
		$this->setThemeFile("default");
	
		return $this->themeFile;
	}
	
	public function setThemeFile($themeFile)
	{
		$this->themeFile =$themeFile;
	}
	
	public function pageTitle()
	{
		return d('SITE_NAME')." Admin";
	}
	
	
	
	
	
	
	
}	