<?php 
	$PaymentStatusArray = $this->getClass('Sale\Order\Common')->getPaymentStatuses();
	$OrderStatusArray = $this->getClass('Sale\Order\Common')->getOrderStatuses();
	$OrderColorArray = $this->getClass('Sale\Order\Common')->getOrderStatusColors();
	$PaymentMethodArray = $this->getClass('Sale\Order\Common')->getPaymentMethodList();
	$OrderGData = array();
	foreach($OrderStatusArray as $k=>$v){
		$Obj = $this->getOrderStatTop($k);
		$OrderGData[$k] = array("Title"=>$v,
								"Count"=>number_format($Obj->Total,0),
								"Total"=>$Obj->GrandTotal,
							   );
	}
	
?>
<!-- page content -->
<div>
<div class="row panel">
	  <div class="col-sm-12 text-right">
		<form method="GET" class="form-horizontal form-label-left" action="<?php echo DIR_WS_SITE_CONTROL?>index.php">
		<input type="hidden" name="m" value="WebsiteControl\Dashboard\Index">
		<input type="hidden" name="view" value="<?php echo $this->view?>">
		<input type="hidden" name="stdt" id="stdt" value="<?php echo $this->stdt?>">
		<input type="hidden" name="eddt" id="eddt" value="<?php echo $this->eddt?>">
		<div class="input-group">
			 <div id="dashboardDates" data-startel="#stdt" data-endel="#eddt" data-startdate="<?php echo date('m/d/Y',strtotime($this->stdt))?>" data-enddate="<?php echo date('m/d/Y',strtotime($this->eddt))?>" class="myDateRangeCal pull-right" style="background: #fff; cursor: pointer; padding: 7px 10px; border: 1px solid #ccc">
			  <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
			  <span><?php echo ConvertDateFromDb($this->stdt)." - ".ConvertDateFromDb($this->eddt)?></span> <b class="caret"></b>
			</div>
			<span class="input-group-btn">
			  <button class="btn btn-info" type="submit">Go!</button>
			</span>
	   </div>
	   </form>
	  </div>
	  <div class="clearfix"></div>
	</div>
 </div>

  <!-- top tiles -->
  <div class="row tile_count">
	<?php $Obj = $this->getOrderStatTop();?>
	<div class="col-sm-2 tile_stats_count">
	  <span class="count_top"><i class="fa fa-money"></i> All Orders</span>
	  <div class="green"><h3><?php echo $this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($Obj->GrandTotal)?></h3></div>
	  <span class="count_bottom"><i class="red"><?php echo number_format($Obj->Total,0)?> </i> No. of Orders</span>
	</div>
	<?php foreach($OrderGData as $k=>$arr):?>
	<div class="col-sm-2 tile_stats_count">
	  <span class="count_top"><i class="fa fa-money"></i> Orders - <?php echo $arr['Title']?></span>
	  <div style="color:<?php echo $OrderColorArray[$k]?>"><h3><?php echo $this->getClass('Base\Currency\CurrencyHandler')->Change2DefaultCurrency($arr['Total'])?></h3></div>
	   <span class="count_bottom"><i class="red"><?php echo $arr['Count']?> </i> No. of Orders</span>
	</div>
	<?php endforeach;?>
  </div>
  <!-- /top tiles -->
  <hr />
  <?php /* Order Start Chart here start*/?>
  <div class="row">
	<div class="col-lg-8 col-sm-12">
		<h4>Orders - Line</h4>
		<div id="order_echart_line" style="height:500px;"></div>
	</div>
	<div class="col-lg-4 col-sm-12">
		<h4>Orders - Pie</h4>
		<div id="order_echart_pie" style="height:500px;"></div>
	</div>
  </div>
  <?php /* Order Start Chart here end*/?>
   <?php /* Product Chart here start*/?>
   <div class="clearfix"></div>
   <hr>
  <div class="row">
	<div class="col-sm-12">
		<h4>Best Sellers Products</h4>
		<div id="product_echart_bar_horizontal" style="height:500px;"></div>
	</div>	
  </div>
  <?php /* Product Chart here end*/?>
<!-- /page content -->
<?php 
$DateArray = $this->getDateArray();


/*ProductBarData start*/
$ProductBarData = array();
$prdBarData = $this->getBestSellersProductsGraph();
foreach($prdBarData as $k=>$arr){
	$ProductBarData[] = array("SaleQty"=>number_format($arr['SaleQty'],0,".",""),
							  "SaleTotal"=>number_format($arr['SaleTotal'],0,".",""),
							  "ProductName"=>$arr['ProductName'],
							);
}
usort($ProductBarData, function ($a, $b) { return strnatcmp($a['SaleTotal'], $b['SaleTotal']);});
//var_dump($ProductBarData);
/*ProductBarData end*/

/*GraphLineData start*/
$GraphLineData = array();
foreach($OrderStatusArray as $k=>$v){
		$lineData = $this->getOrderStatLineGraph($k);
		$GraphLineData[] = array('name'=>$v,
								 'type'=>'line', 
								 'smooth'=>true,
								 'data'=>array_values($lineData),		
								 "itemStyle"=>array("normal"=>array("color"=>$OrderColorArray[$k],"areaStyle"=>array("type"=>"default"))),
								);
}
/*GraphLineData end*/

$GraphPieData = array();
foreach($OrderGData as $k=>$arr){
	$GraphPieData[] = array("value"=>number_format($arr['Total']??0,2,".",""),
							"name"=>$arr['Title'],
							"itemStyle"=>array("normal"=>array("color"=>$OrderColorArray[$k])),
							);
}


?>
<script>
jQuery(document).ready(function($) {
	
			// product_echart_bar_horizontal start
			  
			if ($('#product_echart_bar_horizontal').length ){ 
			  var echartBar = echarts.init(document.getElementById('product_echart_bar_horizontal'));

			  echartBar.setOption({
				title: {
				  text: 'Best Sellers',
				  subtext: 'Graph'
				},
				grid: [{
				  left: '25%'
				}],
				tooltip: {
				  trigger: 'axis'
				},
				legend: {
				  x: 320,
				  data: ['Qty', 'Sale']
				},
				toolbox: {
				  show: true,
				  feature: {
				  restore: {
					  show: true,
					  title: "Restore"
					},
					saveAsImage: {
					  show: false,
					  title: "Save Image"
					}
				  }
				},
				calculable: true,
				xAxis: [{
				  type: 'value',
				  boundaryGap: [0, 0.01]
				}],
				yAxis:[{ 
				  type: 'category',
				  data: <?php echo json_encode(array_column($ProductBarData, 'ProductName'))?>
				}],
				series: [{
				  name: 'Sale',
				  type: 'bar',
				  data: <?php echo json_encode(array_column($ProductBarData, 'SaleTotal'))?>
				}, {
				  name: 'Qty',
				  type: 'bar',
				  data: <?php echo json_encode(array_column($ProductBarData, 'SaleQty'))?>
				}]
			  });

			} 
			// product_echart_bar_horizontal end
			
			// order_echart_line start
			if ($('#order_echart_line').length ){ 
			  var order_echart_line = echarts.init(document.getElementById('order_echart_line'));
			  order_echart_line.setOption({
				title: {
				  text: 'Graph',
				  subtext: 'order graph'
				},
				tooltip: {
				  trigger: 'axis'
				},
				legend: {
				  x: 80,
				  y: 40,
				  data: <?php echo json_encode(array_column($GraphPieData, 'name'))?>
				},
				toolbox: {
				  show: true,
				  feature: {
					magicType: {
					  show: true,
					  title: {
						line: 'Line',
						bar: 'Bar',
						stack: 'Stack',
						tiled: 'Tiled'
					  },
					  type: ['line', 'bar', 'stack', 'tiled']
					},
					restore: {
					  show: true,
					  title: "Restore"
					},
					saveAsImage: {
					  show: false,
					  title: "Save Image"
					}
				  }
				},
				calculable: true,
				xAxis: [{
				  type: 'category',
				  boundaryGap: false,
				  data: <?php echo json_encode(array_values($DateArray))?>
				}],
				yAxis: [{
				  type: 'value'
				}],
				series: <?php echo json_encode($GraphLineData)?>
			  });

			} 
			  
			// order_echart_line end
			
			// order_echart_pie start
			if ($('#order_echart_pie').length ){  
			  var order_echart_pie = echarts.init(document.getElementById('order_echart_pie'));
			  order_echart_pie.setOption({
				tooltip: {
				  trigger: 'item',
				  formatter: "{a} <br/>{b} : {c} ({d}%)"
				},
				legend: {
				  x: 'center',
				  y: 'bottom',
				  data: <?php echo json_encode(array_column($GraphPieData, 'name'))?>
				},
				toolbox: {
				  show: true,
				  feature: {
					magicType: {
					  show: true,
					  type: ['pie', 'funnel'],
					  option: {
						funnel: {
						  x: '25%',
						  width: '50%',
						  funnelAlign: 'left',
						  max: 1548
						}
					  }
					},
					restore: {
					  show: true,
					  title: "Restore"
					},
					saveAsImage: {
					  show: false,
					  title: "Save Image"
					}
				  }
				},
				calculable: true,
				series: [{
				  name: 'Orders',
				  type: 'pie',
				  radius: '55%',
				  center: ['50%', '48%'],
				  data: <?php echo json_encode($GraphPieData)?>
				}]
			  });

			  var dataStyle = {
				normal: {
				  label: {
					show: false
				  },
				  labelLine: {
					show: false
				  }
				}
			  };

			  var placeHolderStyle = {
				normal: {
				  color: 'rgba(0,0,0,0)',
				  label: {
					show: false
				  },
				  labelLine: {
					show: false
				  }
				},
				emphasis: {
				  color: 'rgba(0,0,0,0)'
				}
			  };

			} 
			// order_echart_pie end
	
});
</script>
