<?php 
namespace WebsiteControl\Dashboard\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;


class IndexController extends AbstractModule
{
	var $stdt,$eddt;
	function __construct()
	{
		$this->stdt=isset($_GET['stdt'])?MyStripSlashes($_GET['stdt']):date('Y-m-d',strtotime("-7 days"));
		$this->eddt=isset($_GET['eddt'])?MyStripSlashes($_GET['eddt']):date('Y-m-d');
	}
	
	public function getHeaderCss()
	{
		
	}
	public function getFooterJs()
	{
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Chart.js/dist/Chart.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/gauge.js/dist/gauge.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/iCheck/icheck.min.js");
		
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Flot/jquery.flot.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Flot/jquery.flot.pie.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Flot/jquery.flot.time.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Flot/jquery.flot.stack.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Flot/jquery.flot.resize.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/flot.orderbars/js/jquery.flot.orderBars.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/flot-spline/js/jquery.flot.spline.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/flot.curvedlines/curvedLines.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/DateJS/build/date.js");
		
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/echarts/dist/echarts.min.js");
		
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/jquery.vmap.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/maps/jquery.vmap.world.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/examples/js/jquery.vmap.sampledata.js");
	
	}
	
	function getDateArray()
	{
		$StartDate = $this->stdt;
		$EndDate = $this->eddt;
		$DataArray = array();
		
		$date1 = new \DateTime($StartDate);
		$date2 = new \DateTime($EndDate);
		$interval = $date1->diff($date2);
		if($interval->days > 0){
			for($i=0;$i<=$interval->days;$i++)
				$DataArray[date('Y-m-d',strtotime($StartDate)+($i*24*60*60))] = ConvertDateFromDb(date('Y-m-d',strtotime($StartDate)+($i*24*60*60)));
		}
		return $DataArray;
	}
	
	public function getBestSellersProductsGraph()
	{
		$OrderBy = (isset($_REQUEST['orby']) && $_REQUEST['orby'] != "")?$_REQUEST['orby']:"SUM(od.Total) DESC";
		$PaymentStatus = (isset($_REQUEST['pyst']) && $_REQUEST['pyst'] != "")?$_REQUEST['pyst']:"Paid";
		$OrderStatus = (isset($_REQUEST['orst']) && $_REQUEST['orst'] != "")?$_REQUEST['orst']:"";
		$PaymentMethod = (isset($_REQUEST['pymd']) && $_REQUEST['pymd'] != "")?$_REQUEST['pymd']:"";
		$Download=isset($_REQUEST['dw'])?$_REQUEST['dw']:"";
		$CreatedBy = (isset($_REQUEST['crby']) && $_REQUEST['crby'] != "")?$_REQUEST['crby']:"";
		$UserID = (isset($_REQUEST['UserID']) && is_array($_REQUEST['UserID']))?implode(",",$_REQUEST['UserID']):@$_REQUEST['UserID'];
		$ProductIDs = (isset($_REQUEST['ProductIDs']) && is_array($_REQUEST['ProductIDs']))?implode(",",$_REQUEST['ProductIDs']):@$_REQUEST['ProductIDs'];
		
		$StartDate = $this->stdt;
		$EndDate = $this->eddt." 23:59:59";
		
		if(isset($ProductIDs) && is_array($ProductIDs))
		  $ProductIDs = implode(",",$ProductIDs);
		
		if(isset($UserID) && is_array($UserID))
		  $UserID = implode(",",$UserID);
		
			
			
		$PageSize = (isset($_REQUEST['psz']) && $_REQUEST['psz'] > 0)?$_REQUEST['psz']:"100";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		
		$where = new Where();
		$ReportObj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
		
		$ReportObj->joinExpression = true;
		$ReportObj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
									  'on'=>"(od.OrderID=o.OrderID)",
									  //'columns'=>array("OrderNo","Email","PaymentStatus","OrderStatus","CreatedDate"),
									  'type'=>''
									  );
										  
		$ReportObj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(od.ReferenceID=p.ProductID and od.ItemType='Product')",
									  'columns'=>array("ProductID","ProductName","Stock"),
									  'type'=>''
									  );
		
		
		if($PaymentStatus !="")
			$where->equalTo('o.PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('o.OrderStatus',$OrderStatus);
		if($PaymentMethod !="")
			$where->equalTo('o.PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('o.CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('o.DownloadID','');
		if($StartDate != "")
			$where->greaterThanOrEqualTo('o.CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('o.CreatedDate', $EndDate);
		
		if($ProductIDs !=""){
			$where->in('p.ProductID',explode(",",$ProductIDs));
		}
		if($UserID !=""){
			$where->in('o.UserID',explode(",",$UserID));
		}
		
		
		$ReportObj->where = $where;
		$ReportObj->groupBy = array("p.ProductID");
		//$ReportObj->displayQuery = true;
		$ReportObj->columnExpression=true;
		$ReportObj->orderExpression=true;
		$ReportObj->rowType="array";
		return $ReportObj->tableSelectAll(array("SUM(od.Qty) as SaleQty,SUM(od.Total) as SaleTotal"),$OrderBy,10);
		
	
	}
	
	function getOrderStatLineGraph($OrderStatus="",$PaymentStatus="",$PaymentMethod="",$CreatedBy="",$Download="")
	{
		$StartDate = $this->stdt;
		$EndDate = $this->eddt." 23:59:59";
		$where = new Where();
		$OrderObj = new DataTable(TABLE_ORDERS);
		
		if($PaymentStatus !="")
			$where->equalTo('PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('OrderStatus',$OrderStatus);
		
		if($PaymentMethod !="")
			$where->equalTo('PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('DownloadID','');
		
		if($StartDate != "")
			$where->greaterThanOrEqualTo('CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('CreatedDate', $EndDate);
		
		 //$OrderObj->displayQuery = true;
		 $OrderObj->where = $where;
		 $OrderObj->columnExpression = true;
		 $OrderObj->groupBy = array("MyCurDate");
		 $rows  = $OrderObj->tableSelectAll(array("DATE_FORMAT(CreatedDate,'%Y-%m-%d') as MyCurDate","SUM(GrandTotal) as GrandTotal","COUNT(*) as Total"));
		
		$DateDataArray = $this->getDateArray();
		$DateDataArray = array_fill_keys(array_keys($DateDataArray), 0);
		foreach( $rows as $CurrentRecord){
			$DateDataArray[$CurrentRecord->MyCurDate] = (float)number_format($CurrentRecord->GrandTotal,2,".",""); 	
		}
		return $DateDataArray;
		//SELECT DATE_FORMAT(CreatedDate,"%Y-%m-%d") as MyCurDate,SUM(GrandTotal) as GrandTotal, COUNT(*) as Total FROM `zsk_orders`	WHERE `OrderStatus` = 'Paid' AND `CreatedDate` >= '2018-04-19' AND `CreatedDate` <= '2018-08-17 23:59:59' group by MyCurDate
	}
	function getOrderStatTop($OrderStatus="",$PaymentStatus="",$PaymentMethod="",$CreatedBy="",$Download="")
	{
		$StartDate = $this->stdt;
		$EndDate = $this->eddt." 23:59:59";
		
		
		$where = new Where();
		$OrderObj = new DataTable(TABLE_ORDERS);
		
		if($PaymentStatus !="")
			$where->equalTo('PaymentStatus',$PaymentStatus);
		if($OrderStatus !="")
			$where->equalTo('OrderStatus',$OrderStatus);
		
		if($PaymentMethod !="")
			$where->equalTo('PaymentMethod',$PaymentMethod);
		if($CreatedBy !="")
			$where->equalTo('CreatedBy',$CreatedBy);
		if($Download =="1")
			$where->notEqualTo('DownloadID','');
		
		if($StartDate != "")
			$where->greaterThanOrEqualTo('CreatedDate', $StartDate);
		if($EndDate != "")
			$where->lessThanOrEqualTo('CreatedDate', $EndDate);
		
		 //$OrderObj->displayQuery = true;
		 $OrderObj->where = $where;
		 $OrderObj->columnExpression = true;
		 return  (object)$OrderObj->tableSelectOne(array("SUM(GrandTotal) as GrandTotal","COUNT(*) as Total"));
		 
	}
	
	public function getWhosOnlineList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"LastClick DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$WObj = new DataTable(array('u'=>TABLE_WHOS_ONLINE));
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('UserID','%'.$Value.'%')->OR
							->like('UserName','%'.$Value.'%')->OR
							->like('EmailAddress','%'.$Value.'%')->OR
							->like('FullName','%'.$Value.'%')->OR
							->like('LastURL','%'.$Value.'%')->OR
							->like('IPAddress','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		$WObj->where = $where;
		$WObj->groupBy = array("IPAddress");
		$WObj->resetPagingGroup = false;
		//$WObj->displayQuery = true;
		$WObj->AllowPaging =true;
		$WObj->PageSize=500;
		$WObj->PageTotalDisplay = 15; 
		$WObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $WObj;
		return $WObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function pageTitle()
	{
		return d('SITE_NAME')." Admin";
	}
	
	
	
	
	
	
	
}	