<?php
namespace WebsiteControl\Base;


#[AllowDynamicProperties]
abstract class AbstractModule extends \stdClass implements AbstractModuleInterface
{
    protected $module; 
    protected $moduleObj; 
    protected $moduleArr; 
    protected $view; 
    protected $theme; 
    protected $session; 
    
	function __construct()
	{
		$this->view = "Default";
		if(isset($_GET['view']) && $_GET['view'] != "")
		$this->view = $_GET['view'];
		
		if(count($_GET) > 0)
		{
			foreach($_GET as $k=>$v)
			  $this->{$k} = $v;
		}
		
		if(count($_POST) > 0)
		{
			if(count($_POST,COUNT_RECURSIVE) > (ini_get("max_input_vars")-100)){
				die('Request exceeded limit');
			}
		}
		
			
	}
	public function setModule($module)
    {
		$this->module = $module;
		$this->initModule();
		return $this;
    }
	
	public function getModule()
    {
		return $this->module;
    }
	 
	 public function getSession()
	 {
		global $sessionObj;
		return $sessionObj;
	 }
	public function __get($name)
	{
		if(isset($this->moduleObj->{$name}))
			return $this->moduleObj->{$name};
		
	}
	
	public function __call($method,$arguments) {
		if(method_exists($this, $method)) {
            return call_user_func_array(array($this,$method),$arguments);
	   }
       else if(isset($this->moduleObj) && method_exists($this->moduleObj, $method)) {
		    return call_user_func_array(array($this->moduleObj,$method),$arguments);
	   }
       else{
		   /* method not found */
	   }
    }
	
	public function getClass($class)
	 {
		 if(class_exists($class))
			 return new $class;
		 
	 }
	 
	 public function initModule()
	 {
		 $this->module = str_replace("/","\\",$this->module);
		 $moduleString ="";
		 if($this->module != "")
		 {
			 $arr = explode("\\",$this->module);
			 $this->moduleArr = $arr;
			 $class = "\\".(isset($arr[0])?$arr[0]:"")."\\".(isset($arr[1])?$arr[1]:"")."\\Admin\\Controller\\".(isset($arr[2])?$arr[2]:"Index")."Controller";
			 //$this->moduleObj = new \Catalog\Category\Admin\Controller\IndexController;
			 
			 if(class_exists($class))
			 {
				 $this->moduleObj = new $class;
				 $this->moduleObj->origin = $this;
				 $this->moduleObj->module = $this->module;
				 $this->moduleObj->moduleArr = $this->moduleArr;
				 $this->moduleObj->theme = $this->theme;
				 $this->moduleObj->view = $this->view;
				 
				 if(method_exists($this->moduleObj, "settings"))
					$this->moduleObj->settings();
					 
				 
				 
			 }
			 
		 }
	 }
	 
    public function getController($arguments =array())
	{
		if(isset($_GET['action']) && $_GET['action'] != "")
			call_user_func_array(array($this->moduleObj,$_GET['action']."Action"),$arguments);
		
	}
	
	public function showMeta()
	{
		if(isset($this->moduleObj) && method_exists($this->moduleObj, "showMeta")) {
		    return call_user_func_array(array($this->moduleObj,"showMeta"),array());
	   }
	   else
		   return true;
	}
	
	public function getView()
	{
		return $this->view;	
	}
	public function setView($view)
	{
		$this->view = $view;
	}
	
	public function getTheme()
	{
		return $this->theme;	
	}
	public function setTheme($theme)
	{
		$this->theme = $theme;
	}
	
	public function displayView()
	{
		if(file_exists(DIR_FS_SITE_CONTROL."includes/alert.php"))
			include(DIR_FS_SITE_CONTROL."includes/alert.php");
		
		if(isset($this->moduleArr[0]) && isset($this->moduleArr[1]))
			$displayFile = ($this->moduleArr[0])."/".($this->moduleArr[1])."/Admin/View/".$this->view.".php";
		
		$moduleObj = $this;
		$themeObj = $this->getTheme();
		if(file_exists(ADMIN_THEME_PATH."modules/".$displayFile))
			include(ADMIN_THEME_PATH."modules/".$displayFile);
		else if(file_exists(DIR_FS_SITE."modules/".$displayFile))
			include(DIR_FS_SITE."modules/".$displayFile);
		else
			echo "Coming Soon";
		
	}	
};
