<?php 
namespace ShippingModule\UKShopShipping;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function getRates($PostArray="")
	{
			
		$ResponseArray = array();
		$Country = $this->getSession()->getVar("TaxCountry");
		$ZipCode = $this->getSession()->getVar("ShippingZipCode");
		if($Country == ""){
			$Country = d("DEFINE_DEFAULT_COUNTRY");
			$this->getSession()->setVar("TaxCountry",$Country);
		}
		/* shipping calculation start*/
		$ShippingGroupArray = array();
		if($ZipCode != ""){
			
			$rows = $this->getClass("Sale\Cart\Common")->getShoppingCart();
			foreach($rows as $CurrentCartItem){
				$ProductID= $GroupID =0;
				if(isset($CurrentCartItem->ItemStatus) && isset($CurrentCartItem->ItemType) && $CurrentCartItem->ItemStatus=="Normal" && $CurrentCartItem->ItemType=="Product"){
					$ProductID = $CurrentCartItem->ReferenceID;
				}
				else if(isset($CurrentCartItem->ItemStatus) && isset($CurrentCartItem->ItemType) && $CurrentCartItem->ItemStatus=="Normal" && $CurrentCartItem->ItemType=="ProductChild"){
					$ProductID = $CurrentCartItem->Attribute1;
				}
				if($ProductID > 0){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
					$ProductObj->where[] = array('=',array('Active' => "1"));
					$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","ShippingProductID"));																	
					if(isset($CurrentProduct->ShippingProductID) && $CurrentProduct->ShippingProductID > 0)
						$ShippingGroupArray[$CurrentProduct->ShippingProductID] = $ShippingGroupArray[$CurrentProduct->ShippingProductID] + $CurrentCartItem->Qty;
					else 
						$ShippingGroupArray[$CurrentProduct->ShippingProductID] = $CurrentCartItem->Qty;
					
					
				}
			}
			
			$ShippingAmountArray = array();	
			$ShippingAmount = 0;
			$Country = SKGetCountryCodeByCountry($Country,2);
			foreach ($ShippingGroupArray as $ShippingProductID=>$Qty){
				$ReturnAmount = $this->CalculateShippingAmountFromPostCodeAndGroup($Country,$ZipCode,$ShippingProductID,$Qty);
				if($ReturnAmount=="REDIRECT"){
					return $ResponseArray;
				 }
				$ShippingAmountArray[$ShippingProductID] = $ReturnAmount;
				if($ShippingAmountArray[$ShippingProductID] > $ShippingAmount)
				{
					$ShippingAmount = $ShippingAmountArray[$ShippingProductID];
				}
				
			}
		}
		/* shipping calculation end*/
	
		$ResponseArray['normal'] = array("code"=>"1",
									  "title"=>"Shipping",
									  "price"=>$ShippingAmount,
									  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($ShippingAmount),
									  );
		return $ResponseArray; 
  
    }
	
	/* CalculateShippingAmountFromPostCodeAndGroup Start*/
	function CalculateShippingAmountFromPostCodeAndGroup($CountryISOCode1, $ShippingZip,$ShippingProductID,$Qty)
	{
		
		$ShippingZip = str_replace(array(' '),
								   array(''), $ShippingZip);
		
		$len= strlen($ShippingZip);
		
		$ReceiveFlag = 0;
		if($len >0){
			for ($i=0;$i<=$len;$i++){
				$ShipObj = new DataTable(array('spb'=>TABLE_SHIPPING_PRODUCT_BAND));
				$ShipObj->joinExpression = true;
				$ShipObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
											  'on'=>"(spb.CountryID=c.CountryID)",
											  'columns'=>array("CountryID"),
											  'type'=>'left'
											  );
				
				$ShipObj->joinArray[] = array('name'=>array('spbpr'=>TABLE_SHIPPING_PRODUCT_BAND_PRICES),
											  'on'=>"(spbpr.ShippingBandID=spb.ShippingBandID)",
											  'columns'=>array("Price"),
											  'type'=>'left'
											  );
				$ShipObj->joinArray[] = array('name'=>array('spbpo'=>TABLE_SHIPPING_PRODUCT_BAND_POSTCODES),
											  'on'=>"(spbpo.ShippingBandID=spb.ShippingBandID)",
											  'columns'=>array("PostCodeID"),
											  'type'=>'left'
											  );
				$ShipObj->joinArray[] = array('name'=>array('cp'=>TABLE_COUNTRY_POSTCODES),
											  'on'=>"(spbpo.PostCodeID=cp.PostCodeID AND cp.CountryID=c.CountryID)",
											  'columns'=>array("PostCode"),
											  'type'=>'left'
											  );
				
				$where = new Where();
				$where->equalTo('spb.ShippingProductID',$ShippingProductID);
				$where->equalTo('c.CountryISOCode1',$CountryISOCode1);
				$where->equalTo('cp.PostCode',substr($ShippingZip,0,$len-$i));
				$where->greaterThanOrEqualTo('RangeMax',$Qty);
				$where->lessThanOrEqualTo('RangeMin',$Qty);
				
				
				$ShipObj->where = $where;
				//$ShipObj->displayQuery =true;
				$CurrentRange = (object)$ShipObj->tableSelectOne(array("*"),array("spbpr.Price DESC"));
				if(isset($CurrentRange->ShippingBandID) && $CurrentRange->ShippingBandID  > 0){
					$ReceiveFlag = 1;
					return $CurrentRange->Price;
					break;
				}
				
				
			}
		}
		if($ReceiveFlag ==0){
			return "REDIRECT";	
		}
	}
/* CalculateShippingAmountFromPostCodeAndGroup End*/

	
	
	
}	