<?php 
namespace ShippingModule\UKShopShipping\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditShippingGroupAction()
	{
		if(count($_POST)>0)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;


			$DataArray = array();
			$DataArray['ShippingGroup'] = isset($_POST['ShippingGroup'])?$_POST['ShippingGroup']:"";
			//$DataArray['NormalPrice'] = (isset($_POST['NormalPrice']) && $_POST['NormalPrice'] > 0)?$_POST['NormalPrice']:"0";
			//$DataArray['FirstClassPrice'] = (isset($_POST['FirstClassPrice']) && $_POST['FirstClassPrice'] > 0)?$_POST['FirstClassPrice']:"0";
			//$DataArray['NormalFreePrice'] = (isset($_POST['NormalFreePrice']) && $_POST['NormalFreePrice'] > 0)?$_POST['NormalFreePrice']:"0";
			//$DataArray['FirstClassFreePrice'] = (isset($_POST['FirstClassFreePrice']) && $_POST['FirstClassFreePrice'] > 0)?$_POST['FirstClassFreePrice']:"0";
			//$DataArray['ExtraShipping'] = (isset($_POST['ExtraShipping']) && $_POST['ExtraShipping'] > 0)?$_POST['ExtraShipping']:"0";
			//$DataArray['FirstClassActive'] = isset($_POST['FirstClassActive'])?$_POST['FirstClassActive']:0;
			
			if($ShippingID > 0)
			{
				
				$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
				$ShippingZoneObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Shipping updated successfully."));
				
			}
			else 
			{
							
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$ShippingID = $ShippingZoneObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Shipping added successfully."));
				
			}
			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
				$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
				$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
			}
			
			foreach ($_POST['CountryIDs'] as $k=>$v){
					$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
					$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
					$ShippingCountryObj->tableUpdate(array("ShippingID"=>$ShippingID));
			}
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=$ShippingID");
		    exit;
		}
	}
	
	public function DeleteShippingAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		if($ShippingID > 1)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
			$ShippingZoneObj->tableDelete();	

			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
				$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
				$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
			}	
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Shipping deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	
	public function AddShippingProductGroupAction()
	{
		if(count($_POST)>0){
			
			$DataArray = array();
			$DataArray['GroupName'] = isset($_POST['GroupName'])?$_POST['GroupName']:"";
			$DataArray['IsMultiple'] = "0";
			$DataArray['Active'] = "1";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			$TypeObj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
			$TypeObj->tableInsert($DataArray);		
			$this->getSession()->setArrVar("alert",array("success","Product group added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
		    exit;
			
		}
	}
	public function EditShippingProductGroupAction()
	{
		if(count($_POST)>0){
			
			$ShippingProductID = isset($_POST['ShippingProductID'])?$_POST['ShippingProductID']:0;
			$DataArray = array();
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['GroupName'] = isset($_POST['GroupName'])?$_POST['GroupName']:"";
			
			$TypeObj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
			$TypeObj->where[] = array('=',array('ShippingProductID' => $ShippingProductID));
			$TypeObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Product group updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
			exit;
			
		}
	}
	
	public function DeleteShippingProductGroupAction()
	{
		$ShippingProductID = isset($_GET['DeleteProductGroup'])?$_GET['DeleteProductGroup']:0;
		if($ShippingProductID > 1){
		
			$TypeObj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
			$TypeObj->where[] = array('=',array('ShippingProductID' => $ShippingProductID));
			$TypeObj->tableDelete();
			$this->getSession()->setArrVar("alert",array("success","Shipping group delted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
			exit;
			
		}
	}
	public function DeleteShippingBandAction()
	{
		$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
		$ShippingBandID = isset($_GET['DeleteBandID'])?$_GET['DeleteBandID']:0;
		if($ShippingBandID > 1){
		
			$BandObj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND);
			$BandObj->where[] = array('=',array('ShippingBandID' => $ShippingBandID));
			$BandObj->tableDelete();
			$this->getSession()->setArrVar("alert",array("success","Shipping band delted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view."&CountryID=$CountryID");
			exit;
			
		}
	}
	
	public function EditShippingPriceAction()
	{
		$ShippingBandID = isset($_GET['ShippingBandID'])?$_GET['ShippingBandID']:0;
		$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
		$ShippingProductID = isset($_GET['ShippingProductID'])?$_GET['ShippingProductID']:0;
		
		if(count($_POST)>0){
		
			$BandObj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND);	
			if($ShippingBandID > 0){
				
				$DataArray = array();
				$DataArray['BandName'] = isset($_POST['BandName'])?$_POST['BandName']:"";
				$BandObj->where[] = array('=',array('ShippingBandID' => $ShippingBandID));
				$BandObj->tableUpdate($DataArray);
				
			}
			else{
				$DataArray = array();
				$DataArray['BandName'] = isset($_POST['BandName'])?$_POST['BandName']:"";
				$DataArray['ShippingProductID'] = $ShippingProductID;
				$DataArray['CountryID'] = $CountryID;
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$ShippingBandID = $BandObj->tableInsert($DataArray);
			
			}
			
			if($ShippingBandID > 0){
				$PostCodes = isset($_POST['PostCodes'])?$_POST['PostCodes']:array();
				
				$PostCodeObj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND_POSTCODES);
				$PostCodeObj->where = "ShippingBandID = '".(int)$ShippingBandID."'";
				$PostCodeObj->tableDelete();
				foreach($PostCodes as $k=>$PostCodeID){
					$SubDataArray = array();
					$SubDataArray['PostCodeID'] = $PostCodeID;
					$SubDataArray['ShippingBandID'] = $ShippingBandID;
					$PostCodeObj->tableInsert($SubDataArray);
				}
				
				$PriceObj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND_PRICES);
				$PriceObj->where = "ShippingBandID = '".(int)$ShippingBandID."'";
				$PriceObj->tableDelete();
				foreach($_POST['Price'] as $k=>$Price){
					$SubDataArray = array();
					$SubDataArray['ShippingBandID'] = $ShippingBandID;
					$SubDataArray['RangeMin'] = (isset($_POST['RangeMin'][$k]) && $_POST['RangeMin'][$k] !="")?$_POST['RangeMin'][$k]:"0";
					$SubDataArray['RangeMax'] = (isset($_POST['RangeMax'][$k]) && $_POST['RangeMax'][$k] !="")?$_POST['RangeMax'][$k]:d("DEFINE_PRODUCT_QTY_MAX");
					$SubDataArray['Price'] = (isset($_POST['Price'][$k]) && $_POST['Price'][$k] !="")?$_POST['Price'][$k]:"0";
					$SubDataArray['ExtraShipping'] = (isset($_POST['ExtraShipping'][$k]) && $_POST['ExtraShipping'][$k] !="")?$_POST['ExtraShipping'][$k]:"0";
					$SubDataArray['Active'] = (isset($_POST['Active'][$k]) && $_POST['Active'][$k] !="")?$_POST['Active'][$k]:"1";
					$PriceObj->tableInsert($SubDataArray);
				}
				
			}
			
			$this->getSession()->setArrVar("alert",array("success","Prices updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view."&CountryID=$CountryID&ShippingProductID=$ShippingProductID&ShippingBandID=$ShippingBandID");
			exit;
		}
		exit;
		
		
	}
	public function pageTitle()
	{
		return "Shipping";
	}
	
	public function getPriceByShippingType($ShippingID,$TypeID)
	{
		if($ShippingID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
			$Obj->rowType="array";
			$Obj->where[] = array('=',array('ShippingID' => $ShippingID));
			$Obj->where[] = array('=',array('TypeID' => $TypeID));
			return $Obj->tableSelectAll(array("*"),array("RangeMin ASC","ID ASC"));
	
		}
		return ;
	
	}
	
	public function getPriceByShippingBand($ShippingBandID)
	{
		if($ShippingBandID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND_PRICES);
			$Obj->rowType="array";
			$Obj->where[] = array('=',array('ShippingBandID' => $ShippingBandID));
			return $Obj->tableSelectAll(array("*"),array("RangeMin ASC","ID ASC"));
	
		}
		return ;
	
	}
	
	public function getPostCodesByShippingBand($ShippingBandID)
	{
		if($ShippingBandID > 0)
		{
			$ShippingCountryObj = new DataTable(array('m'=>TABLE_SHIPPING_PRODUCT_BAND_POSTCODES));
			$ShippingCountryObj->where[] = array('=',array('m.ShippingBandID' => $ShippingBandID));
			$ShippingCountryObj->columnExpression = true;
			$Obj  = (object)$ShippingCountryObj->tableSelectOne(array("GROUP_CONCAT(PostCodeID) as PostCodeIDs"));
			return explode(",",$Obj->PostCodeIDs);
		
		}
		return array();
	
	}
	public function getPostCodesNames($ShippingBandID)
	{
		if($ShippingBandID > 0)
		{
			$Obj = new DataTable(array('bp'=>TABLE_SHIPPING_PRODUCT_BAND_POSTCODES));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('cp'=>TABLE_COUNTRY_POSTCODES),
										  'on'=>"(cp.PostCodeID=bp.PostCodeID)",
										  'columns'=>array(),
										  'type'=>''
										  );
			
			$where = new Where();
			$where->equalTo('bp.ShippingBandID',$ShippingBandID);
			$Obj->where = $where;
			//$Obj->displayQuery = true;
			$Obj->columnExpression = true;
			$ReturnObj  = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT PostCode ORDER BY PostCode ASC SEPARATOR ', ') as PostCodes"));
			return $ReturnObj->PostCodes;
			
		
		}
		return "";
	
	}
	public function getShippingBandByGroupAndCountry($ShippingProductID,$CountryID)
	{
		if($ShippingProductID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND);
			$Obj->where[] = array('=',array('ShippingProductID' => $ShippingProductID));
			$Obj->where[] = array('=',array('CountryID' => $CountryID));
			return $Obj->tableSelectAll(array("*"),array("ShippingBandID ASC"));
	
		}
		return ;
	
	}
	
	public function getProductGroupById($ShippingProductID)
	{
		if($ShippingProductID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
			$Obj->where[] = array('=',array('ShippingProductID' => $ShippingProductID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function getShippingBandById($ShippingBandID)
	{
		if($ShippingBandID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_BAND);
			$Obj->where[] = array('=',array('ShippingBandID' => $ShippingBandID));
			return (object)$Obj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function getGroup()
	{
		$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
		$ShippingZoneObj->where="1";
		return $ShippingZoneObj->tableSelectAll(array("*"),array("CreatedDate ASC"));
	
	}
	
	
	public function getGroupDetail($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			return (object)$ShippingZoneObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function AddPostCodesAction()
	{
		$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
		if(count($_POST)>0){
			
			$SeparatedBy = isset($_POST['SeparatedBy'])?$_POST['SeparatedBy']:",";
			$PostCodeArray = isset($_POST['PostCodes'])?explode($SeparatedBy,$_POST['PostCodes']):array();
			if(count($PostCodeArray) > 0)
			{
				foreach($PostCodeArray as $k=>$PostCode)
				{
					$SubDataArray = array();
					$SubDataArray['CountryID'] = $CountryID;
					$SubDataArray['PostCode'] = trim($PostCode);
					
					$PostCodeObj = new DataTable(TABLE_COUNTRY_POSTCODES);
					$PostCodeObj->where[] = array('=',array('CountryID' => $CountryID));
					$PostCodeObj->where[] = array('=',array('PostCode' => trim($PostCode)));
					$IsPostCode = (object)$PostCodeObj->tableSelectOne(array("PostCodeID"));
					if(!isset($IsPostCode->PostCodeID) && trim($PostCode) != ""){
						$PostCodeObj = new DataTable(TABLE_COUNTRY_POSTCODES);
						$PostCodeObj->tableInsert($SubDataArray);
					}
				}
	
			}
			
			$this->getSession()->setArrVar("alert",array("success","Post Codes added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view."&CountryID=$CountryID");
			exit;
		}
		
	}
	
	public function DeletePostCodesAction()
	{
		$CountryID = isset($_GET['CountryID'])?$_GET['CountryID']:0;
		if(count($_POST)>0){
			
			$PostCodeArray = isset($_POST['PostCodes'])?$_POST['PostCodes']:array();
			if(count($PostCodeArray) > 0)
			{
				foreach($PostCodeArray as $k=>$PostCodeID)
				{
					
					$PostCodeObj = new DataTable(TABLE_COUNTRY_POSTCODES);
					$PostCodeObj->where[] = array('=',array('CountryID' => $CountryID));
					$PostCodeObj->where[] = array('=',array('PostCodeID' => trim($PostCodeID)));
					$PostCodeObj->tableDelete();
				}
	
			}
			
			$this->getSession()->setArrVar("alert",array("success","Post Codes deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view."&CountryID=$CountryID");
			exit;
		}
		
	}
	
	public function getPostCodesByCountryID($CountryID)
	{
		$PostCodeObj = new DataTable(TABLE_COUNTRY_POSTCODES);
		$PostCodeObj->where[] = array('=',array('CountryID' => $CountryID));
		return $PostCodeObj->tableSelectAll(array("*"),array("PostCode ASC"));
	
	}
	public function getCountryById($CountryID)
	{
		if($CountryID > 0)
		{
			$CountryObj = new DataTable(TABLE_COUNTRIES);
			$CountryObj->where[] = array('=',array('CountryID' => $CountryID));
			return (object)$CountryObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function getShippingCountries($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingCountryObj = new DataTable(array('m'=>TABLE_SHIPPING_COUNTRIES));
			$ShippingCountryObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$ShippingCountryObj->columnExpression = true;
			$Obj  = (object)$ShippingCountryObj->tableSelectOne(array("GROUP_CONCAT(CountryID) as CountrIDs"));
			return explode(",",$Obj->CountrIDs);
		
		}
		return array();
	
	}
	
	public function getCountries()
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="1";
		$CountryObj->orderExpression = true;
		return $CountryObj->tableSelectAll(array("CountryID","CountryName"),"CountryISOCode1='GB' DESC,CountryName ASC");
	
	}
	
	public function getProductGroups()
	{
		$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
		$Obj->where="1";
		return $Obj->tableSelectAll(array("*"),array("Position ASC","ShippingProductID ASC"));
	
	}
	
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-info" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'">Shipping Countries/Postcodes</a>
						  <a class="btn btn-info" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=ProductGroup">Product Group</a>
					</div>
              </div>		
			   ';
	}
	
	
}	