<?php 
namespace ShippingModule\Shipping;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function getAllShipping($PostArray="")
	{
		if(isset($PostArray['ShippingCountry']) && $PostArray['ShippingCountry'] != ""){
			$this->getSession()->setVar("TaxCountry",$PostArray['ShippingCountry']);
			$this->getSession()->setVar("ShippingZipCode",$PostArray['ShippingZipCode']);
			$this->getSession()->setVar("OrderAddress",array(
					'BillingFirstName' => isset($PostArray['BillingFirstName'])?$PostArray['BillingFirstName']:"",
					'BillingLastName' => isset($PostArray['BillingLastName'])?$PostArray['BillingLastName']:"",
					'BillingAddress1' => isset($PostArray['BillingAddress1'])?$PostArray['BillingAddress1']:"",
					'BillingAddress2' => isset($PostArray['BillingAddress2'])?$PostArray['BillingAddress2']:"",
					'BillingCity' => isset($PostArray['BillingCity'])?$PostArray['BillingCity']:"",
					'BillingState' => isset($PostArray['BillingState'])?$PostArray['BillingState']:"",
					'BillingArea' => isset($PostArray['BillingArea'])?$PostArray['BillingArea']:"",
					'BillingCountry' => isset($PostArray['BillingCountry'])?$PostArray['BillingCountry']:"",
					'BillingZipCode' => isset($PostArray['BillingZipCode'])?$PostArray['BillingZipCode']:"",
					'BillingPhone' => isset($PostArray['BillingPhone'])?$PostArray['BillingPhone']:"",
					'BillingFax' => isset($PostArray['BillingFax'])?$PostArray['BillingFax']:"",
					'ShippingFirstName' => isset($PostArray['ShippingFirstName'])?$PostArray['ShippingFirstName']:"",
					'ShippingLastName' => isset($PostArray['ShippingLastName'])?$PostArray['ShippingLastName']:"",
					'ShippingAddress1' => isset($PostArray['ShippingAddress1'])?$PostArray['ShippingAddress1']:"",
					'ShippingAddress2' => isset($PostArray['ShippingAddress2'])?$PostArray['ShippingAddress2']:"",
					'ShippingCity' => isset($PostArray['ShippingCity'])?$PostArray['ShippingCity']:"",
					'ShippingState' => isset($PostArray['ShippingState'])?$PostArray['ShippingState']:"",
					'ShippingArea' => isset($PostArray['ShippingArea'])?$PostArray['ShippingArea']:"",
					'ShippingCountry' => isset($PostArray['ShippingCountry'])?$PostArray['ShippingCountry']:"",
					'ShippingZipCode' => isset($PostArray['ShippingZipCode'])?$PostArray['ShippingZipCode']:"",
					'ShippingPhone' => isset($PostArray['ShippingPhone'])?$PostArray['ShippingPhone']:"",
					'ShippingFax' => isset($PostArray['ShippingFax'])?$PostArray['ShippingFax']:"",
					)
			);
		}
		
		if(d("FRONT_SIDE_INCLUDE")==true){
			$ModuleObj = new DataTable(TABLE_MODULES);
			$ModuleObj->where[] = array('=',array('ModuleType' => 'Shipping'));
			$ModuleObj->where[] = array('=',array('Active' => '1'));
		}
		else{
			$ModuleObj = new DataTable(TABLE_MODULES);
			$ModuleObj->where[] = array('=',array('ModuleType' => 'Shipping'));
			$ModuleObj->where[] = array('=',array('Active' => '1'));
			
			$where = new Where();
			$where->equalTo('ModuleType','Shipping');
			$where->NEST//start braket
				->equalTo('Active','1')
				->OR
				->equalTo('ModuleCode','FreeShipping')
				->UNNEST;
			$ModuleObj->where = $where;
			
		}
		
		$rows = $ModuleObj->tableSelectAll("",array("ModuleID ASC"));
		$ShippingArray = array("count"=>0,
							   "method"=>array(),
							   );
		if(count($rows) > 0){
			foreach($rows as $CurrentRecord){
				
				if(class_exists("ShippingModule\\".$CurrentRecord->ModuleCode."\Common")){
					$arr = $this->getClass("ShippingModule\\".$CurrentRecord->ModuleCode."\Common")->getRates($PostArray);
					if(isset($arr) && is_array($arr) && count($arr) > 0){
						$ShippingArray['method'][$CurrentRecord->ModuleCode]['title'] = "";//$CurrentRecord->Description;	
						$ShippingArray['method'][$CurrentRecord->ModuleCode]['rates'] = $arr;	
						$ShippingArray['count'] += count($arr);
						
					}
				}
			}
			
		}
		return $ShippingArray;
	}		
	
}	