<?php 
namespace ShippingModule\RangeTypeZoneShipping;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	var $s_t="";
	var $rangetype="price";
	function __construct()
	{
		
	}
	
	
	function getRates($PostArray="")
	{
		//if(strtolower($this->rangetype) == "weight")
		//	return 	$this->getRatesByWeight($PostArray);
		//else 
			return 	$this->getRatesByPrice($PostArray);
			
	}
	
	function getRatesByPrice($PostArray="")
	{
			
		$ResponseArray = array();
		$ShippingID = "1";
		$RegionID = 0;
		$CheckPrice = 0;
		
		$Country = $this->getSession()->getVar("TaxCountry");
		$OrderAddress = $this->getSession()->getVar("OrderAddress");
		if($Country == ""){
			$Country = d("DEFINE_DEFAULT_COUNTRY");
			$this->getSession()->setVar("TaxCountry",$Country);
		}
		
		$CountryObj = new DataTable(array('s'=>TABLE_SHIPPING_COUNTRIES));
		
		$CountryObj->joinExpression = true;
		$CountryObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
									  'on'=>"(c.CountryID=s.CountryID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$where = new Where();
			//$where->equalTo('c.CountryISOCode1',substr($Country,0,3));
			$where->NEST//start braket
				->equalTo('c.CountryISOCode1',substr($Country,0,3))
				->OR
				->equalTo('c.CountryISOCode2',substr($Country,0,3))
				//->OR
				//->equalTo('c.CountryID',substr($Country,0,3))
				->UNNEST;
			
		$CountryObj->where = $where;			
		$obj =  (object)$CountryObj->tableSelectOne(array("*"));
		if(isset($obj->ShippingID) && $obj->ShippingID > 0)
		  $ShippingID = $obj->ShippingID;
	  
		$CountryName = isset($obj->CountryName)?$obj->CountryName:"";	
		
		if(isset($obj->CountryID) && isset($OrderAddress['ShippingState'])){
			$RegionID = $this->getRegionByCountryIDAndState($obj->CountryID,$OrderAddress['ShippingState']);
		}
		
		$ZoneID = $this->getZoneByShippingIDAndRegionID($ShippingID,$RegionID);
		$TypeArr = $this->getShippingTypes();
		
		
		if($ShippingID > 0){
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$CurrentRecord = (object)$ShippingZoneObj->tableSelectOne();
		}
		if(isset($CurrentRecord->ShippingID) && $ZoneID > 0){
			
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$SessionID = $this->getSession()->getCurrentSID();
			$where = new Where();
			$where->equalTo('SessionID',$SessionID);
			$where->equalTo('ItemStatus','Normal');
			$TmpCartObj->where = $where;
			$TmpCartObj->columnExpression=true;
			$Obj = (object)$TmpCartObj->tableSelectOne(array('Weight'=>'SUM(Weight*Qty)','Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
			$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
			//$CartTotal = $Obj->UnitPrice;
			$CartWeight = $Obj->Weight;
			
				
			$QtyArr = $this->getQtyArr();
			$Price = 0;
			foreach($QtyArr as $TypeID=>$Qty){
				
				 $PriceObj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
				 $where = new Where();
				 $where->greaterThanOrEqualTo('RangeMax',$CartTotal);
				 $where->lessThanOrEqualTo('RangeMin',$CartTotal);
				 $where->equalTo('ShippingID',$CurrentRecord->ShippingID);
				 $where->equalTo('TypeID',$TypeID);
				 $where->equalTo('ZoneID',$ZoneID);
				 $where->equalTo('Active',"1");
				 //$PriceObj->displayQuery = true;
				 $PriceObj->where = $where;
				 $CurrentPrice = (object)$PriceObj->tableSelectOne(array("*"),array("Price DESC","ID ASC"));
				 if(isset($CurrentPrice->Price)){
					//$Price =  max($Price,$CurrentPrice->Price);	 	
					$Price =  $CurrentPrice->Price;	 	
					$CheckPrice = 1;
					
					//if($Price > 0){
						$code = "code_".$ShippingID."_".$TypeID."_".$ZoneID;
						$ResponseArray[$code] = array("code"=>$code,
												  "title"=>$TypeArr[$TypeID]." (".$CountryName.")",
												  "price"=>$Price,
												  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($Price),
												  );
						//return $ResponseArray; 	
					//}
					
				 }
				
			}
			
		}
		return $ResponseArray; 
  
    }

	function getQtyArr()
	{
		$QtyArr = array();
		$SessionID = $this->getSession()->getCurrentSID();
		$TypeArr = $this->getShippingTypes();
		foreach($TypeArr as $TypeID=>$TypeName)
			$QtyArr[$TypeID] =0;
			
		$Obj = new DataTable(array('tm'=>TABLE_TMPCART));
		$Obj->joinExpression = true;
		$Obj->joinArray[] = array('name'=>array('p'=>TABLE_PRODUCT),
									  'on'=>"(tm.ReferenceID=p.ProductID AND tm.ItemType='Product')",
									  'columns'=>array("ProductID","ShippingType"),
									  'type'=>'left'
									  );
									  
		$where = new Where();
		$where->equalTo('tm.SessionID',$SessionID);
		$where->equalTo('tm.ItemType','Product');
		$Obj->where = $where;
		//$Obj->displayQuery =true;
		$rows = $Obj->tableSelectAll(array('Qty'));
		foreach($rows as $Record){
			if(isset($Record->ShippingType) && isset($TypeArr[$Record->ShippingType]) && $Record->ShippingType > 0){
				$QtyArr[$Record->ShippingType] = $QtyArr[$Record->ShippingType] + $Record->Qty;	
			}
			else {
				$QtyArr[1] = $QtyArr[1] + $Record->Qty;	
			}
		}
		return $QtyArr;
	}
	function getZoneByShippingIDAndRegionID($ShippingID,$RegionID)
	{
		$Obj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
		
		$where = new Where();
		$where->equalTo('ShippingID',$ShippingID);	
		if($RegionID > 0)
			$where->expression('FIND_IN_SET(?,RegionIDs)', $RegionID);	
			
		$Obj->where = $where;	
		$ZoneObj =  (object)$Obj->tableSelectOne(array("ZoneID"));
		return isset($ZoneObj->ZoneID)?$ZoneObj->ZoneID:0;
		
	}
	
	function getRegionByCountryIDAndState($country_id,$code)
	{
		$Obj = new DataTable(TABLE_COUNTRY_REGION);
		
		$where = new Where();
		$where->equalTo('country_id',$country_id);	
		$where->NEST//start code
				->equalTo('code',substr($code,0,2))
				->OR
				->equalTo('region_name',$code)
				->UNNEST;
			
		$Obj->where = $where;	
		$RegionObj =  (object)$Obj->tableSelectOne(array("region_id"));
		return isset($RegionObj->region_id)?$RegionObj->region_id:0;
		
	}
	
	function getShippingTypeByID($TypeID)
	{
		$Obj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
		$Obj->where[] = array('=',array('TypeID' => (int)$TypeID));
		$RecObj = (object)$Obj->tableSelectOne(array("TypeName"));
		
		if(isset($RecObj->TypeName) && $RecObj->TypeName != "")
			return $RecObj->TypeName." Shipping charges";
		else 
			return "Shipping";
		
	}
	
	function getShippingTypes()
	{
		$Arr = array();
		$Obj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
		$rows = $Obj->tableSelectAll(array("*"),"DefaultType DESC");
		foreach($rows as $type){
			$Arr[$type->TypeID] =$type->TypeName;
		}
		return $Arr;
		
		
	}

	public function getRegionByShippingID($ShippingID)
	{
		$ReturnArray = array();
		if($ShippingID > 0)
		{
			$ShipObj = new DataTable(array('sc'=>TABLE_SHIPPING_COUNTRIES));
			$ShipObj->joinExpression = true;
			$ShipObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
										  'on'=>"(sc.CountryID=c.CountryID)",
										  'columns'=>array("CountryID","CountryName"),
										  'type'=>'left'
										  );
			
			$where = new Where();
			$where->equalTo('sc.ShippingID',$ShippingID);
			$ShipObj->where = $where;
			//$ShipObj->displayQuery =true;
			$countryRows = $ShipObj->tableSelectAll(array("*"),array("CountryName ASC"));
			foreach($countryRows as $CurrentObj){
				
				$ReturnArray[$CurrentObj->CountryID] = array("name"=>$CurrentObj->CountryName);
					$RegionObj = new DataTable(TABLE_COUNTRY_REGION);	
					$RegionObj->where = "country_id = '".(int)$CurrentObj->CountryID."'";
					$regionRows = $RegionObj->tableSelectAll(array("*"),array("region_name ASC"));
					foreach ($regionRows as $CurrentRegion) 
					{
						$ReturnArray[$CurrentObj->CountryID]['states'][$CurrentRegion->region_id] = array("id"=>$CurrentRegion->region_id,
																										  "name"=>$CurrentRegion->region_name,
																										  "OBJECT"=>$CurrentRegion
																										  );
					}
				
			}
	
		}
		return $ReturnArray;
	
	}
	
	
}	