<?php 
namespace ShippingModule\RangeTypeZoneShipping\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditShippingGroupAction()
	{
		if(count($_POST)>0)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;


			$DataArray = array();
			$DataArray['ShippingGroup'] = isset($_POST['ShippingGroup'])?$_POST['ShippingGroup']:"";
			//$DataArray['NormalPrice'] = (isset($_POST['NormalPrice']) && $_POST['NormalPrice'] > 0)?$_POST['NormalPrice']:"0";
			//$DataArray['FirstClassPrice'] = (isset($_POST['FirstClassPrice']) && $_POST['FirstClassPrice'] > 0)?$_POST['FirstClassPrice']:"0";
			//$DataArray['NormalFreePrice'] = (isset($_POST['NormalFreePrice']) && $_POST['NormalFreePrice'] > 0)?$_POST['NormalFreePrice']:"0";
			//$DataArray['FirstClassFreePrice'] = (isset($_POST['FirstClassFreePrice']) && $_POST['FirstClassFreePrice'] > 0)?$_POST['FirstClassFreePrice']:"0";
			//$DataArray['ExtraShipping'] = (isset($_POST['ExtraShipping']) && $_POST['ExtraShipping'] > 0)?$_POST['ExtraShipping']:"0";
			//$DataArray['FirstClassActive'] = isset($_POST['FirstClassActive'])?$_POST['FirstClassActive']:0;
			
			if($ShippingID > 0)
			{
				
				$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
				$ShippingZoneObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Shipping updated successfully."));
				
			}
			else 
			{
							
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$ShippingID = $ShippingZoneObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Shipping added successfully."));
				
			}
			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				if($v != ""){
					$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
					$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
					$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
				}
			}
			
			foreach ($_POST['CountryIDs'] as $k=>$v){
					if($v != ""){
						$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
						$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
						$ShippingCountryObj->tableUpdate(array("ShippingID"=>$ShippingID));
					}
			}
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=$ShippingID");
		    exit;
		}
	}
	
	public function DeleteShippingAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		if($ShippingID > 1)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
			$ShippingZoneObj->tableDelete();	

			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				if($v != ""){
					$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
					$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
					$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
				}
			}	
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Shipping deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	
	public function AddShippingTypeAction()
	{
		if(count($_POST)>0){
			
			$DataArray = array();
			$DataArray['TypeName'] = isset($_POST['TypeName'])?$_POST['TypeName']:"";
			$DataArray['DefaultType'] = "0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			$TypeObj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
			$TypeObj->tableInsert($DataArray);		
			$this->getSession()->setArrVar("alert",array("success","Shipping type added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
		    exit;
			
		}
	}
	public function EditShippingTypeAction()
	{
		if(count($_POST)>0){
			
			$TypeID = isset($_POST['TypeID'])?$_POST['TypeID']:0;
			$DataArray = array();
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['TypeName'] = isset($_POST['TypeName'])?$_POST['TypeName']:"";
			
			$TypeObj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
			$TypeObj->where[] = array('=',array('TypeID' => $TypeID));
			$TypeObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Shipping type updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
			exit;
			
		}
	}
	
	public function DeleteShippingTypeAction()
	{
		$TypeID = isset($_GET['DeleteType'])?$_GET['DeleteType']:0;
		if($TypeID > 1){
		
			$TypeObj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
			$TypeObj->where[] = array('=',array('TypeID' => $TypeID));
			$TypeObj->tableDelete();
			$this->getSession()->setArrVar("alert",array("success","Shipping type delted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view);
			exit;
			
		}
	}
	
	
	public function AddShippingZoneAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		if(count($_POST)>0){
			
			$rows = $this->getShippingZones($ShippingID);
			$DataArray = array();
			$DataArray['ZoneName'] = isset($_POST['ZoneName'])?$_POST['ZoneName']:"";
			$DataArray['DefaultZone'] = "1";
			if(count($rows)> 0)
				$DataArray['DefaultZone'] = "0";
			
			$DataArray['ShippingID'] = $ShippingID;
			$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
			
			$DBObj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
			$DBObj->tableInsert($DataArray);		
			$this->getSession()->setArrVar("alert",array("success","Shipping zone added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=".$ShippingID."&view=".$this->origin->view);
		    exit;
			
		}
	}
	public function EditShippingZoneAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		if(count($_POST)>0){
			
			$ZoneID = isset($_POST['ZoneID'])?$_POST['ZoneID']:0;
			$DataArray = array();
			$DataArray['ZoneName'] = isset($_POST['ZoneName'])?$_POST['ZoneName']:"";
			
			$DBObj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
			$DBObj->where[] = array('=',array('ZoneID' => $ZoneID));
			$DBObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Shipping zone updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=".$ShippingID."&view=".$this->origin->view);
			exit;
			
		}
	}
	
	public function DeleteShippingZoneAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		$ZoneID = isset($_GET['DeleteZone'])?$_GET['DeleteZone']:0;
		if($ZoneID > 1){
		
			$TypeObj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
			$TypeObj->where[] = array('=',array('ZoneID' => $ZoneID));
			$TypeObj->tableDelete();
			$this->getSession()->setArrVar("alert",array("success","Shipping zone delted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=".$ShippingID."&view=".$this->origin->view);
			exit;
			
		}
	}
	
	public function EditZoneRegionAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		$ZoneID = isset($_GET['ZoneID'])?$_GET['ZoneID']:0;
		
		$DataArray = array();
		$DataArray['RegionIDs'] = isset($_POST['RegionIDs'])?implode(',',$_POST['RegionIDs']):"";
		$DBObj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
		$DBObj->where[] = array('=',array('ZoneID' => $ZoneID));
		$DBObj->tableUpdate($DataArray);
		$this->getSession()->setArrVar("alert",array("success","Shipping zone updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=".$ShippingID."&ZoneID=".$ZoneID."&view=".$this->origin->view);
		exit;
		
	}
	public function EditShippingPriceAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		$TypeID = isset($_GET['TypeID'])?$_GET['TypeID']:0;
		$ZoneID = isset($_GET['ZoneID'])?$_GET['ZoneID']:0;
		$PriceObj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
		if(count($_POST)>0){
			
			$PriceObj->where = "ShippingID = ".$ShippingID." AND ZoneID = ".$ZoneID." AND TypeID ='".(int)$TypeID."'";
			$PriceObj->tableDelete();
			if(isset($_POST['Price'][$TypeID]) && count($_POST['Price'][$TypeID]) > 0)
			{
				foreach($_POST['Price'][$TypeID] as $k=>$val)
				{
					$SubDataArray = array();
					$SubDataArray['ShippingID'] = $ShippingID;
					$SubDataArray['TypeID'] = $TypeID;
					$SubDataArray['ZoneID'] = $ZoneID;
					$SubDataArray['RangeMin'] = (isset($_POST['RangeMin'][$TypeID][$k]) && $_POST['RangeMin'][$TypeID][$k] !="")?$_POST['RangeMin'][$TypeID][$k]:"0";
					$SubDataArray['RangeMax'] = (isset($_POST['RangeMax'][$TypeID][$k]) && $_POST['RangeMax'][$TypeID][$k] !="")?$_POST['RangeMax'][$TypeID][$k]:d("DEFINE_PRODUCT_QTY_MAX");
					$SubDataArray['Price'] = (isset($_POST['Price'][$TypeID][$k]) && $_POST['Price'][$TypeID][$k] !="")?$_POST['Price'][$TypeID][$k]:"0";
					$SubDataArray['ExtraShipping'] = (isset($_POST['ExtraShipping'][$TypeID][$k]) && $_POST['ExtraShipping'][$TypeID][$k] !="")?$_POST['ExtraShipping'][$TypeID][$k]:"0";
					$SubDataArray['Active'] = (isset($_POST['Active'][$TypeID][$k]) && $_POST['Active'][$TypeID][$k] !="")?$_POST['Active'][$TypeID][$k]:"0";
					$PriceObj->tableInsert($SubDataArray);
				}
	
			}
			
			$this->getSession()->setArrVar("alert",array("success","Prices updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->origin->view."&TypeID=$TypeID&ShippingID=$ShippingID&ZoneID=$ZoneID&tab=$TypeID");
			exit;
		}
		
	}
	public function pageTitle()
	{
		return "Shipping";
	}
	
	public function getPriceByShippingType($ShippingID,$TypeID)
	{
		if($ShippingID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
			$Obj->rowType="array";
			$Obj->where[] = array('=',array('ShippingID' => $ShippingID));
			$Obj->where[] = array('=',array('TypeID' => $TypeID));
			return $Obj->tableSelectAll(array("*"),array("RangeMin ASC","ID ASC"));
	
		}
		return ;
	
	}
	
	public function getPriceByShippingZoneType($ShippingID,$ZoneID,$TypeID)
	{
		if($ShippingID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
			$Obj->rowType="array";
			$Obj->where[] = array('=',array('ShippingID' => $ShippingID));
			$Obj->where[] = array('=',array('ZoneID' => $ZoneID));
			$Obj->where[] = array('=',array('TypeID' => $TypeID));
			return $Obj->tableSelectAll(array("*"),array("RangeMin ASC","ID ASC"));
	
		}
		return ;
	
	}
	
	public function getShippingZones($ShippingID)
	{
		if($ShippingID > 0)
		{
			$Obj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
			$Obj->where[] = array('=',array('ShippingID' => $ShippingID));
			return $Obj->tableSelectAll(array("*"),array("ZoneID ASC"));
	
		}
		return ;
	
	}
	
	public function getGroup()
	{
		$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
		$ShippingZoneObj->where="1";
		return $ShippingZoneObj->tableSelectAll(array("*"),array("CreatedDate ASC"));
	
	}
	
	public function getGroupDetail($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			return (object)$ShippingZoneObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function getZoneDetail($ZoneID)
	{
		if($ZoneID > 0)
		{
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_ZONES));
			$ShippingZoneObj->where[] = array('=',array('m.ZoneID' => $ZoneID));
			return (object)$ShippingZoneObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function zoneCount($ShippingID)
	{
		$DBObj = new DataTable(TABLE_SHIPPING_RZS_ZONES);
		$DBObj->where="ShippingID ='".(int)$ShippingID."'";
		$DBObj->columnExpression=true;
		$Obj = $DBObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getShippingCountries($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingCountryObj = new DataTable(array('m'=>TABLE_SHIPPING_COUNTRIES));
			$ShippingCountryObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$ShippingCountryObj->columnExpression = true;
			$Obj  = (object)$ShippingCountryObj->tableSelectOne(array("GROUP_CONCAT(CountryID) as CountrIDs"));
			return explode(",",$Obj->CountrIDs);
		
		}
		return array();
	
	}
	
	public function getCountries()
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="1";
		return $CountryObj->tableSelectAll(array("CountryID","CountryName"),array("CountryName ASC"));
	
	}
	
	public function getShippingTypes()
	{
		$Obj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
		$Obj->where="1";
		return $Obj->tableSelectAll(array("*"),array("DefaultType DESC","Position ASC","TypeID ASC"));
	
	}
	
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-info" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'">Shipping Groups</a>
						  <a class="btn btn-info" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=ShippingType">Shipping Types</a>
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditShippingGroup">Add Shipping Group</a>
					</div>
              </div>		
			   ';
	}
	
	
}	