<?php 
namespace ShippingModule\RangeTypeShipping;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function getRates($PostArray="")
	{
			
		$ResponseArray = array();
		$ShippingID = "1";
		$Country = $this->getSession()->getVar("TaxCountry");
		if($Country == ""){
			$Country = d("DEFINE_DEFAULT_COUNTRY");
			$this->getSession()->setVar("TaxCountry",$Country);
		}
	
		$CountryObj = new DataTable(array('s'=>TABLE_SHIPPING_COUNTRIES));
		
		$CountryObj->joinExpression = true;
		$CountryObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
									  'on'=>"(c.CountryID=s.CountryID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$where = new Where();
			//$where->equalTo('c.CountryISOCode1',substr($Country,0,3));
			$where->NEST//start braket
				->equalTo('c.CountryISOCode1',substr($Country,0,3))
				->OR
				->equalTo('c.CountryISOCode2',substr($Country,0,3))
				//->OR
				//->equalTo('c.CountryID',substr($Country,0,3))
				->UNNEST;
			
		$CountryObj->where = $where;			
		$obj =  (object)$CountryObj->tableSelectOne(array("*"));
		if(isset($obj->ShippingID) && $obj->ShippingID > 0)
		  $ShippingID = $obj->ShippingID;
			
		if($ShippingID > 0){
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$CurrentRecord = (object)$ShippingZoneObj->tableSelectOne();
		}
		if(isset($CurrentRecord->ShippingID) && $CurrentRecord->ShippingID > 0){
			
			 /* check free shipping products start*/
			 
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$SessionID = $this->getSession()->getCurrentSID();
				$where = new Where();
				$where->equalTo('SessionID',$SessionID);
				$where->equalTo('ItemStatus','Normal');
				$TmpCartObj->where = $where;
				$TmpCartObj->columnExpression=true;
				$Obj = (object)$TmpCartObj->tableSelectOne(array('Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
				$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
				
				if($CartTotal==0){
					$price = 0;
					$ResponseArray['normal'] = array("code"=>"free",
										  "title"=>"Free Shipping",
										  "price"=>$price,
										  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($price),
										  );
				return $ResponseArray; 						  
				}
				/* check free shipping products end*/
			 
			  /* check full cart value start*/
			 if($CartTotal > 0){
				 
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$SessionID = $this->getSession()->getCurrentSID();
				$where = new Where();
				$where->equalTo('SessionID',$SessionID);
				//$where->equalTo('ItemStatus','Normal');
				$TmpCartObj->where = $where;
				$TmpCartObj->columnExpression=true;
				$Obj = (object)$TmpCartObj->tableSelectOne(array('Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
				$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
				
				
				$TaxPercent = 0;
				$TmpCartObj2 = new DataTable(TABLE_TMPCART);
				$SessionID = $this->getSession()->getCurrentSID();
				$where = new Where();
				$where->equalTo('SessionID',$SessionID);
				//$where->equalTo('ItemStatus','Normal');
				$TmpCartObj2->where = $where;
				$Obj = (object)$TmpCartObj2->tableSelectOne(array('TaxPercent'),array('TaxPercent DESC'));
				$TaxPercent = isset($Obj->TaxPercent)?$Obj->TaxPercent:"0";
				 
			 }
			 /* check full cart value end*/
			 
			 $PriceObj = new DataTable(TABLE_SHIPPING_RZS_PRICES);
			 $where = new Where();
			 $where->greaterThanOrEqualTo('RangeMax',$CartTotal);
			 $where->lessThanOrEqualTo('RangeMin',$CartTotal);
			 $where->equalTo('ShippingID',$CurrentRecord->ShippingID);
			 $where->equalTo('Active',"1");
			 //$PriceObj->displayQuery = true;
			 $PriceObj->where = $where;
			 $priceRows = $PriceObj->tableSelectAll(array("*"),array("Price ASC","ID ASC"));
	
			if(count($priceRows) > 0){
				foreach($priceRows as $CurrentPrice){
					
					$price = isset($CurrentPrice->Price)?$CurrentPrice->Price:"0";
					$code = "code_".(isset($CurrentPrice->ShippingID)?$CurrentPrice->ShippingID:"0")."_".(isset($CurrentPrice->TypeID)?$CurrentPrice->TypeID:"0");
					
					if($CurrentPrice->ExtraShipping && $CurrentPrice->ExtraShipping >0){
						$price = $price + ($CurrentPrice->ExtraShipping/100)*$CartTotal;
					}
					if($TaxPercent >0  && $price >0){
						$price = $price + ($price/100)*$price;
					}
					
					$ResponseArray[$code] = array("code"=>$code,
										  "title"=>$this->getShippingTypeByID((isset($CurrentPrice->TypeID)?$CurrentPrice->TypeID:"0")),
										  "price"=>$price,
										  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($price),
										  );
				}
			}	
				
		}
		
		return $ResponseArray; 
  
    }

	function getShippingTypeByID($TypeID)
	{
		$Obj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
		$Obj->where[] = array('=',array('TypeID' => (int)$TypeID));
		$RecObj = (object)$Obj->tableSelectOne(array("TypeName"));
		
		if(isset($RecObj->TypeName) && $RecObj->TypeName != "")
			return $RecObj->TypeName." Shipping charges";
		else 
			return "Shipping";
		
	}	
	
	
}	