<?php 
namespace ShippingModule\FixedPriceShipping;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function getRates($PostArray="")
	{
			
		$ResponseArray = array();
		$ShippingID = "1";
		$Country = $this->getSession()->getVar("TaxCountry");
		
		$CountryObj = new DataTable(array('s'=>TABLE_SHIPPING_COUNTRIES));
		
		$CountryObj->joinExpression = true;
		$CountryObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
									  'on'=>"(c.CountryID=s.CountryID)",
									  'columns'=>array("*"),
									  'type'=>'left'
									  );
		
		$where = new Where();
			//$where->equalTo('c.CountryISOCode1',substr($Country,0,3));
			$where->NEST//start braket
				->equalTo('c.CountryISOCode1',substr($Country,0,3))
				->OR
				->equalTo('c.CountryISOCode2',substr($Country,0,3))
				//->OR
				//->equalTo('c.CountryID',substr($Country,0,3))
				->UNNEST;
			
		$CountryObj->where = $where;			
		$obj =  (object)$CountryObj->tableSelectOne(array("*"));
		if(isset($obj->ShippingID) && $obj->ShippingID > 0)
		  $ShippingID = $obj->ShippingID;
			
		if($ShippingID > 0){
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$CurrentRecord = (object)$ShippingZoneObj->tableSelectOne();
		}
		if(isset($CurrentRecord->ShippingID) && $CurrentRecord->ShippingID > 0){
			
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$SessionID = $this->getSession()->getCurrentSID();
			$where = new Where();
			$where->equalTo('SessionID',$SessionID);
			$where->equalTo('ItemStatus','Normal');
			$TmpCartObj->where = $where;
			$TmpCartObj->columnExpression=true;
			$Obj = (object)$TmpCartObj->tableSelectOne(array('Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
			$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
				
			$price = $CurrentRecord->NormalPrice;
			if($CurrentRecord->ExtraShipping && $CurrentRecord->ExtraShipping >0){
				$price = $price + ($CurrentRecord->ExtraShipping/100)*$CartTotal;
			 }
			 
			 /* check free shipping products start*/
			 
				
				
				if($CartTotal==0){
					$price = 0;
					$ResponseArray['normal'] = array("code"=>"free",
										  "title"=>"Free Shipping",
										  "price"=>$price,
										  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($price),
										  );
				return $ResponseArray; 						  
				}
				/* check free shipping products end*/
			 
			 if($CartTotal >= $CurrentRecord->NormalFreePrice && $CurrentRecord->NormalFreePrice >0){
				 $price = 0;
			 }
			 
			$ResponseArray['normal'] = array("code"=>"normal",
										  "title"=>"Normal Shipping",
										  "price"=>$price,
										  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($price),
										  );
										  
			if($CurrentRecord->FirstClassActive=="1"){
				
				$price = $CurrentRecord->FirstClassPrice;
				if($CartTotal >= $CurrentRecord->FirstClassFreePrice && $CurrentRecord->FirstClassFreePrice >0){
						$price = 0;
				}
		
				$ResponseArray['track'] = array("code"=>"track",
										  "title"=>"Track Shipping",
										  "price"=>$price,
										  "display_price"=>$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency($price),
										  );
				
			}				
		}
		
		return $ResponseArray; 
  
    }		
	
	
}	