<?php 
namespace ShippingModule\FixedPriceShipping\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditShippingAction()
	{
		if(count($_POST)>0)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;


			$DataArray = array();
			$DataArray['ShippingGroup'] = isset($_POST['ShippingGroup'])?$_POST['ShippingGroup']:"";
			$DataArray['NormalPrice'] = (isset($_POST['NormalPrice']) && $_POST['NormalPrice'] > 0)?$_POST['NormalPrice']:"0";
			$DataArray['FirstClassPrice'] = (isset($_POST['FirstClassPrice']) && $_POST['FirstClassPrice'] > 0)?$_POST['FirstClassPrice']:"0";
			$DataArray['NormalFreePrice'] = (isset($_POST['NormalFreePrice']) && $_POST['NormalFreePrice'] > 0)?$_POST['NormalFreePrice']:"0";
			$DataArray['FirstClassFreePrice'] = (isset($_POST['FirstClassFreePrice']) && $_POST['FirstClassFreePrice'] > 0)?$_POST['FirstClassFreePrice']:"0";
			$DataArray['ExtraShipping'] = (isset($_POST['ExtraShipping']) && $_POST['ExtraShipping'] > 0)?$_POST['ExtraShipping']:"0";
			$DataArray['FirstClassActive'] = isset($_POST['FirstClassActive'])?$_POST['FirstClassActive']:0;
			
			if($ShippingID > 0)
			{
				
				$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
				$ShippingZoneObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Shipping updated successfully."));
				
			}
			else 
			{
							
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$ShippingID = $ShippingZoneObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Shipping added successfully."));
				
			}
			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
				$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
				$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
			}
			
			foreach ($_POST['CountryIDs'] as $k=>$v){
					$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
					$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
					$ShippingCountryObj->tableUpdate(array("ShippingID"=>$ShippingID));
			}
			
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ShippingID=$ShippingID");
		    exit;
		}
	}
	
	public function DeleteShippingAction()
	{
		$ShippingID = isset($_GET['ShippingID'])?$_GET['ShippingID']:0;
		if($ShippingID > 1)
		{
			$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
			$ShippingZoneObj->where[] = array('=',array('ShippingID' => $ShippingID));
			$ShippingZoneObj->tableDelete();	

			$arr = $this->getShippingCountries($ShippingID);
			foreach ($arr as $k=>$v){
				$ShippingCountryObj = new DataTable(TABLE_SHIPPING_COUNTRIES);
				$ShippingCountryObj->where[] = array('=',array('CountryID' => $v));
				$ShippingCountryObj->tableUpdate(array("ShippingID"=>"1"));
			}	
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Shipping deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	
	public function pageTitle()
	{
		return "Shipping";
	}
	
	public function getGroup()
	{
		$ShippingZoneObj = new DataTable(TABLE_SHIPPING_RZS_GROUPS);
		$ShippingZoneObj->where="1";
		return $ShippingZoneObj->tableSelectAll(array("*"),array("CreatedDate ASC"));
	
	}
	
	public function getGroupDetail($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingZoneObj = new DataTable(array('m'=>TABLE_SHIPPING_RZS_GROUPS));
			$ShippingZoneObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			return (object)$ShippingZoneObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function getShippingCountries($ShippingID)
	{
		if($ShippingID > 0)
		{
			$ShippingCountryObj = new DataTable(array('m'=>TABLE_SHIPPING_COUNTRIES));
			$ShippingCountryObj->where[] = array('=',array('m.ShippingID' => $ShippingID));
			$ShippingCountryObj->columnExpression = true;
			$Obj  = (object)$ShippingCountryObj->tableSelectOne(array("GROUP_CONCAT(CountryID) as CountrIDs"));
			return explode(",",$Obj->CountrIDs);
		
		}
		return array();
	
	}
	
	public function getCountries()
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="1";
		return $CountryObj->tableSelectAll(array("CountryID","CountryName"),array("CountryName ASC"));
	
	}
	
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditShipping">Add shipping Group</a>
					</div>
              </div>		
			   ';
	}
	
	
}	