<?php 
namespace Sale\Tax\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditTaxAction()
	{
		if(count($_POST)>0)
		{
			$TaxObj = new DataTable(TABLE_TAX_CLASS);
			$TaxClassID = isset($_GET['TaxClassID'])?$_GET['TaxClassID']:0;
			$DataArray = array();
			$DataArray['TaxClassTitle'] = isset($_POST['TaxClassTitle'])?$_POST['TaxClassTitle']:"";
			if($TaxClassID > 0)
			{
				
				$TaxObj->where[] = array('=',array('TaxClassID' => $TaxClassID));
				$TaxObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Tax updated successfully."));
				
			}
			else 
			{
							
				$TaxClassID = $TaxObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Tax class added successfully."));
				
			}
			
			
			
			
					

			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&TaxClassID=$TaxClassID");
		    exit;
		}
		
	}
	
	function UpdateTaxByCountryAction()
	{
		if(count($_POST)>0){
			$TaxClassID = isset($_GET['TaxClassID'])?$_GET['TaxClassID']:0;
			
			foreach($_POST['TaxPercent'] as $CountryID=>$TaxPercent){
				
				$Obj = $this->getTaxByTaxID($TaxClassID,$CountryID);
				if(isset($Obj->ID)){
					
					$DataArray = array();
					$DataArray['TaxPercent'] = ($TaxPercent > 0)?$TaxPercent:"0";
					$TaxObj = new DataTable(TABLE_TAX_CLASS_CALC);
					$TaxObj->where[] = array('=',array('ID' => $Obj->ID));
					$TaxObj->tableUpdate($DataArray);
				}
				else{
					
					$DataArray = array();
					$DataArray['TaxPercent'] = ($TaxPercent > 0)?$TaxPercent:"0";
					$DataArray['TaxClassID'] = $TaxClassID;
					$DataArray['CountryID'] = $CountryID;
					$DataArray['RegionID'] = "0";
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
					$TaxObj = new DataTable(TABLE_TAX_CLASS_CALC);
					$TaxObj->tableInsert($DataArray);
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Tax updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=SetTax&TaxClassID=".$TaxClassID);
			exit;
		}
	}

	
	
	public function DeleteTaxAction()
	{
		$TaxClassID = isset($_GET['TaxClassID'])?$_GET['TaxClassID']:0;
		$obj = $this->getDetail($TaxClassID);
		
		if($TaxClassID > 0 && $obj->DefaultValue != "1")
		{
			$TaxObj = new DataTable(TABLE_TAX_CLASS);
			$TaxObj->where[] = array('=',array('TaxClassID' => $TaxClassID));
			$TaxObj->tableDelete();		

			$TaxClassCalcObj = new DataTable(TABLE_TAX_CLASS_CALC);
			$TaxClassCalcObj->where[] = array('=',array('TaxClassID' => $TaxClassID));
			$TaxClassCalcObj->tableDelete();			
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Tax deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	public function getList()
	{
		$TaxObj = new DataTable(TABLE_TAX_CLASS);
		$TaxObj->where="1";
		return $TaxObj->tableSelectAll("",array("TaxClassID ASC"));
	
	}
	
	public function getCountries()
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$CountryObj->where="1";
		return $CountryObj->tableSelectAll(array("CountryID","CountryName"),array("CountryName ASC"));
	
	}
	
	public function getTaxByTaxID($TaxClassID,$CountryID)
	{
		
		$TaxClassCalcObj = new DataTable(TABLE_TAX_CLASS_CALC);
		
		$where = new Where();
		$where->equalTo('TaxClassID',$TaxClassID);
		$where->equalTo('CountryID',$CountryID);
				$where->NEST//start braket
						->equalTo('RegionID','')->OR
						->equalTo('RegionID','0')->OR
						->isNULL('RegionID')->OR
						->UNNEST;
	
		$TaxClassCalcObj->where = $where;
		return (object)$CurrentTaxCal = $TaxClassCalcObj->tableSelectOne();
	
	}
	
	public function getDetail($TaxClassID)
	{
		if($TaxClassID > 0)
		{
			$TaxObj = new DataTable(array('m'=>TABLE_TAX_CLASS));
			$TaxObj->where[] = array('=',array('m.TaxClassID' => $TaxClassID));
			return (object)$TaxObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Tax";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditTax">Add Tax</a>
					</div>
              </div>		
			   ';
	}
	
	
}	