<?php 
namespace Sale\Package\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditPackageAction()
	{
		if(count($_POST)>0)
		{
			$DBObj = new DataTable(TABLE_SALE_PACKAGES);
			$PackageID = isset($_GET['PackageID'])?$_GET['PackageID']:0;
			

			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['PackageName'] = isset($_POST['PackageName'])?$_POST['PackageName']:"";
			$DataArray['DisplayName'] = isset($_POST['DisplayName'])?$_POST['DisplayName']:"";
			$DataArray['PackageType'] = isset($_POST['PackageType'])?$_POST['PackageType']:"Monthly";
			
			$DataArray['PackageFee'] = (isset($_POST['PackageFee']) &&  $_POST['PackageFee'] > 0)?$_POST['PackageFee']:"0";
			$DataArray['NosOfListings'] = (isset($_POST['NosOfListings']) &&  $_POST['NosOfListings'] > 0)?$_POST['NosOfListings']:"0";
			$DataArray['SmallDescription'] = isset($_POST['SmallDescription'])?$_POST['SmallDescription']:"";
			$DataArray['LargeDescription'] = isset($_POST['LargeDescription'])?$_POST['LargeDescription']:"";
			
			if($PackageID > 0)
			{
				
				$DBObj->where[] = array('=',array('PackageID' => $PackageID));
				$DBObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Package updated successfully."));
				
			}
			else 
			{
				$DBObj->where ="1";
				$Position = $DBObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$PackageID = $DBObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Package added successfully."));
				
			}
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&PackageID=$PackageID");
			exit;
		}
		
	}
	
	public function UpdatePackageAction()
	{
		if(count($_POST)>0)
		{
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$DBObj = new DataTable(TABLE_SALE_PACKAGES);
				$PackageID =$_POST['PackageID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$DBObj->where[] = array('=',array('PackageID' => $PackageID));
				$DBObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Package updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
			 exit;
		}
	}
	
	public function DeletePackageAction()
	{
		$PackageID = isset($_GET['PackageID'])?$_GET['PackageID']:0;
		$PID = isset($_GET['PID'])?$_GET['PID']:0;
		$obj = $this->getDetail($PackageID);
		
		if($PackageID > 0 && $PackageID != "1")
		{
			$DBObj = new DataTable(TABLE_SALE_PACKAGES);
			$DBObj->where[] = array('=',array('PackageID' => $PackageID));
			$DBObj->tableDelete();								
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Package deleted successfully."));
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		exit;
	}
	
	
	
	public function getList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"Position ASC,PackageID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		
		$DBObj = new DataTable(TABLE_SALE_PACKAGES);
		$where = new Where();
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('DisplayName','%'.$Value.'%')->OR
							->like('PackageName','%'.$Value.'%')->OR
							->like('PackageType','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
			
		}
		
		$DBObj->where = $where;
		
		$DBObj->orderExpression = true;
		$DBObj->AllowPaging =true;
		$DBObj->PageSize=50;
		$DBObj->PageTotalDisplay = 15; 
		$DBObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $DBObj;
		return $DBObj->tableSelectAll(array("*"),$orderBy);
	
	}
	
	public function getDetail($PackageID)
	{
		if($PackageID > 0)
		{
			$DBObj = new DataTable(array('m'=>TABLE_SALE_PACKAGES));
			$DBObj->where[] = array('=',array('m.PackageID' => $PackageID));
			return (object)$DBObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Packages";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditPackage">Add Package</a>
					</div>
              </div>		
			   ';
	}
	
	
}	