<?php 
namespace Sale\Order;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class CronController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	
	public function CronOrderRefillAction($ScriptTimeLimit,$Obj)
	{
		//var_dump("dfsfds");exit;
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/order");
		$filename=$dir."refill_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Refill_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Refill Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Action']="Processing";
				$Params['Offset']="0";				
			}
			
			$OrderObj = new DataTable(array('o'=>TABLE_ORDERS));
			$OrderObj->joinExpression = true;
			$OrderObj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(od.OrderID=o.OrderID)",
										  'columns'=>array("OrderDetailID","ReferenceID"),
										  'type'=>''
										  );
			
			$where = new Where();
			$where->equalTo('o.PaymentStatus','Paid');
			$where->expression('(DATEDIFF(NOW(),o.CreatedDate) = ?)','1');
			$where->notEqualTo('o.OrderStatus','Cancelled');
			$where->equalTo('od.ItemType','Product');
			$where->NEST//start braket
				->equalTo('od.ParentItemID','')
				->OR
				->isNull('od.ParentItemID')
				->UNNEST;
			
			$OrderObj->where = $where;
			
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$OrderObj->offset = (int)$Params['Offset'];
			
			//$OrderObj->displayQuery = true;
			$rows = $OrderObj->tableSelectAll(array("OrderID","OrderNo","Email","BillingFirstName","BillingLastName"),array("o.CreatedDate DESC"));
			$SNo =$Params['Offset'];
			/* for loope start here */
			foreach ($rows as $CurrentOrder){
				$discountedRows = $this->getClass("Catalog\Product\Common")->getProductWithDiscounted($CurrentOrder->ReferenceID);
				if(count($discountedRows) > 0){
					foreach($discountedRows as $CurrentRecord){
						
						if($this->CheckProductInOrderDetail($CurrentOrder->OrderID,$CurrentRecord->ProductID)===false){
							
							if(isset($CurrentRecord->Custom) && $CurrentRecord->Custom > 0){	
								
								$Arr = array();
								$Arr['Name'] = $CurrentOrder->BillingFirstName." ".$CurrentOrder->BillingLastName;
								$Arr['ProductName'] = $CurrentRecord->ProductName;
								$Arr['ProductID'] = $CurrentRecord->ProductID;
								$Arr['Discount'] = number_format($CurrentRecord->Custom);
								
								/* Coupon create start*/
								$DataArray = array();
								$DataArray['Active'] = "1";
								$DataArray['CouponName'] = "Discount ".number_format($CurrentRecord->Custom,2)."% off";
								$DataArray['CouponCode'] = uniqid("D_");
								$DataArray['CouponType'] = "Percentage";
								
								$DataArray['CouponValue'] = number_format($CurrentRecord->Custom,2);
								$DataArray['StartDate'] = date('Y-m-d');
								$DataArray['EndDate'] = date('Y-m-d',strtotime("+2 day"));;
								$DataArray['Message'] = "Discount ".number_format($CurrentRecord->Custom,2)."% off";
								$DataArray['CouponLimit'] = "1";
								$DataArray['MinTotal'] = "0";
								$DataArray['ProductSpecific'] = "1";
								$DataArray['MultipleEnabled'] = "1";
								$DataArray['ProductIDs'] = $CurrentRecord->ProductID;
								$DataArray['CreatedDate'] = date('Y-m-d H:i:s');			
								
								$CouponObj = new DataTable(TABLE_COUPONS);
								$CouponID = $CouponObj->tableInsert($DataArray);		
							
								$Arr['CouponCode'] = $DataArray['CouponCode'];
								$Arr['ExpiryDate'] = ConvertDateFromDb($DataArray['EndDate']);
								/* Coupon create end*/
							
								fputs($fp2,"Refill Arr ".$UniqueID."=".print_r($Arr,true).chr(13));	
								
								$MessageBody = $this->getRefillProductDiscount($Arr);
								$Mail_Subject = "Congratulations! You are entitled to a ".number_format($CurrentRecord->Custom)."% discount at ".d('SITE_NAME');
								$Mail_ToEmail = $CurrentOrder->Email;
								$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody);
								
							}
							
						}
					}
				}
				
				
				$SNo++;
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$Params['Offset'] = $SNo;
				$DataArray = array();
				$DataArray['CronStatus'] = "Processing";
				$DataArray['Params'] = base64_encode(serialize($Params));
				$CronObj->tableUpdate($DataArray);
				
				$sk_timeend = explode(' ', microtime() );
				$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
				if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
					return ;
			}
			/* for loope end here */
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
		}

		fputs($fp2,"Refill End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
		//http://192.168.0.77/sunil/custom_cms/ecommerce/newsite/index.php?m=Sale\Order\Cron&v=Default&action=CronOrderRefill	
		
	}
	
	public function CheckProductInOrderDetail($OrderID,$ProductID)
	{
		$Obj = new DataTable(TABLE_ORDER_DETAILS);
		$Obj->where[] = array('=',array('OrderID' => $OrderID));
		$Obj->where[] = array('=',array('ReferenceID' => $ProductID));
		$Obj->where[] = array('=',array('ItemType' => 'Product'));
		$CurrentObj = (object)$Obj->tableSelectOne(array("ReferenceID"));
		if(isset($CurrentObj->ReferenceID) && $CurrentObj->ReferenceID != "")
			return true;
		
		return false;
	}
	
	function getRefillProductDiscount($Arr)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/order_refill.php")){
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/order_refill.php");
			$MessageBody = ob_get_clean();
			return $MessageBody;
		}
		return false;
		
	}
	
	function getReminderOrderEmail($Arr)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/order_reminder.php")){
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/order_reminder.php");
			$MessageBody = ob_get_clean();
			return $MessageBody;
		}
		return false;
		
	}
	
	public function CronOrderReminderAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/order");
		$filename=$dir."reminder_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Reminder_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Reminder Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Action']="Processing";
				$Params['Offset']="0";				
			}
			
			$OrderObj = new DataTable(array('o'=>TABLE_ORDERS));
			$where = new Where();
			$where->equalTo('o.PaymentStatus','Pending');
			$where->expression('(DATEDIFF(NOW(),o.CreatedDate) = ?)','3');
			$where->notEqualTo('o.PaymentMethod','ZeroPayment');
			$where->notEqualTo('o.OrderStatus','Cancelled');
			$OrderObj->where = $where;
			
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$OrderObj->offset = (int)$Params['Offset'];
			
			//$OrderObj->displayQuery = true;
			$rows = $OrderObj->tableSelectAll(array("OrderID","OrderNo","Email","BillingFirstName","BillingLastName"),array("o.CreatedDate DESC"));
			$SNo =$Params['Offset'];
			/* for loope start here */
			foreach ($rows as $CurrentOrder){
				
				$Arr = array();
				$Arr['Name'] = $CurrentOrder->BillingFirstName." ".$CurrentOrder->BillingLastName;
				$Arr['OrderID'] = $CurrentOrder->OrderID;
				$Arr['OrderNo'] = $CurrentOrder->OrderNo;
				
				fputs($fp2,"Reminder Arr ".$UniqueID."=".print_r($Arr,true).chr(13));	
								
				$MessageBody = $this->getReminderOrderEmail($Arr);
				$Mail_Subject = "Thank you for visiting ".d('SITE_NAME');
				$Mail_ToEmail = $CurrentOrder->Email;
				$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody);
								
				$SNo++;
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$Params['Offset'] = $SNo;
				$DataArray = array();
				$DataArray['CronStatus'] = "Processing";
				$DataArray['Params'] = base64_encode(serialize($Params));
				$CronObj->tableUpdate($DataArray);
				
				$sk_timeend = explode(' ', microtime() );
				$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
				if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
					return ;
			}
			/* for loope end here */
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
			
		}
		/* script end here*/
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
		}

		fputs($fp2,"Reminder End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
		//http://192.168.0.77/sunil/custom_cms/ecommerce/newsite/index.php?m=Sale\Order\Cron&v=Default&action=CronOrderReminder	
		
	}
	
	
}	