<?php 
namespace Sale\Order;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function getPaymentStatuses()
	{
		$rows = array();
		$rows["Pending"] = "Pending";
		$rows["Paid"] = "Paid";
		return $rows;
	}
	
	function getInvoiceStatuses()
	{
		$rows = array();
		$rows["Pending"] = "Pending";
		$rows["Paid"] = "Paid";
		$rows["Cancel"] = "Cancel";
		return $rows;
	}
	
	function getPointStatuses()
	{
		$rows = array("Get"=>"Get",
					  "Access"=>"Access",
					  );
		
		return $rows;
	}
	
	function getPaymentMethodList()
	{
		$rows = array(
					  "BankTransfer"=>"Bank Transfer",
					  //"PaypalStandard"=>"Paypal",
					  //"Worldpay"=>"Credit/Debit Card (Worldpay)",
					  //"Worldpay"=>"Credit/Debit Card (Worldpay)",
					  //"PDQ"=>"PDQ",
					  //"ZeroPayment"=>"ZeroPayment",
					  );
		
		return $rows;
	}
	
	function getOrderStatuses()
	{
		$rows = array("Paid"=>"Paid",
					  "Delivered"=>"Delivered",
					  "Dispatched"=>"Dispatched",
					  "Completed"=>"Completed",
					  //"OnOrder"=>"OnOrder",
					  "Closed"=>"Closed",
					  "Canceled"=>"Canceled",
					  "OnHold"=>"On Hold",
					  "Pending"=>"PendingPayment",
				  );
		
		return $rows;
	}
	
	function getOrderStatusColors()
	{
		//https://www.w3schools.com/colors/colors_trends.asp
		
		$rows = array("Pending"=>"#d3dce3",
					  "Paid"=>"#c1e089",
					  "Delivered"=>"#fed086",
					  "Dispatched"=>"#a5dcea",
					  "Completed"=>"#cda3d8",
					  "OnOrder"=>"#98ddde",
					  "Closed"=>"#66bc29",
					  "Canceled"=>"#f0d6db",
					  "OnHold"=>"#e58a9e",
				  );
		
		return $rows;
	}
	
	function getClientInvoice($InvoiceID)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/client_invoice.php")){
			$CurrentInvoice = $this->getClientInvoiceDetailByInvoiceID($InvoiceID);
			$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($CurrentInvoice->UserID);
			$rowsInvoiceProducts = $this->getClientInvoiceProductByInvoiceID($InvoiceID);
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/client_invoice.php");
			$MessageBody = ob_get_clean();
			return $MessageBody;
		}
		return false;
		
	}
	
	public function getClientInvoiceDetailByInvoiceID($InvoiceID)
	{
		if($InvoiceID != ""){
			$Obj = new DataTable(TABLE_CLIENT_INVOICES);
			$Obj->where[] = array('=',array('InvoiceID' => $InvoiceID));
			return (object)$Obj->tableSelectOne(array("*"),array("InvoiceID DESC"));	
		}
	}
	public function getClientInvoiceProductByInvoiceID($InvoiceID)
	{
		if($InvoiceID != "")
		{
			$Obj = new DataTable(TABLE_CLIENT_INVOICES_PRODUCT);
			$Obj->where[] = array('=',array('InvoiceID' => $InvoiceID));
			return $Obj->tableSelectAll(array("*"),array("ProductInvoiceID ASC"));									
			
		}
		return ;
	}
	
	public function checkMurphyOrder($OrderID)
	{
		$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
		$OrderMurphyObj->where[] = array('=',array('OrderID' => $OrderID));
		$OrderMurphyObj->columnExpression=true;
		$Obj = $OrderMurphyObj->tableSelectOne(array('Total'=>'Count(*)'));
	
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getMurphyOrderByOrderID($OrderID)
	{
		$OrderMurphyObj = new DataTable(array('m'=>TABLE_ORDER_MURPHY));
		$OrderMurphyObj->where[] = array('=',array('m.OrderID' => $OrderID));
		$OrderMurphyObj->where[] = array('=',array('m.Status' => 'Done'));
	
		$OrderMurphyObj->joinExpression = true;
		$OrderMurphyObj->joinArray[] = array('name'=>array('od'=>TABLE_ORDER_DETAILS),
										  'on'=>"(m.OrderDetailID = od.OrderDetailID)",
										  'columns'=>array("OrderDetailID","ItemName"),
										  'type'=>"left",
										  );
										  
		return  $OrderMurphyObj->tableSelectAll(array('*'),"od.OrderDetailID ASC");
	}
	
	function getOrderWithColumn($OrderID,$Column = array())
	{
		if($OrderID > 0){
			if(count($Column) == 0)
				$Column = array("*");
		
			$OrderObj = new DataTable(array('o'=>TABLE_ORDERS));
			$OrderObj->where[] = array('=',array('o.OrderID' => $OrderID));
			return (object)$OrderObj->tableSelectOne($Column);
		}
		return false;
	}
	
	function UpdatePaidOrderFromAdmin($OrderID,$PaymentStatus,$OrderStatus)
	{
		if($PaymentStatus=="Paid")
		{
			$OrderChangeStatusObj = new DataTable(TABLE_ORDER_CHANGE_STATUS);
			$OrderChangeStatusObj->where[] = array('=',array('OrderID' => $OrderID));
			$OrderChangeStatusObj->where[] = array('=',array('PaymentStatus' => $PaymentStatus));
			$OrderChangeStatusObj->tableSelectAll(array("OrderID"));
			if($OrderChangeStatusObj->getNumRows() == 0){
				$this->getClass("Sale\Checkout\Common")->processPayment($OrderID,array("Comments"=>"By Admin"));
			}
		}
	}
}	

