<?php 
namespace Sale\Checkout\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Sale\Cart\Common as CartCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = false; 
	function __construct()
	{
		
	}
	
	public function getCartCommon()
	{
		$obj = new CartCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if(isset($arr['ID']) && $arr['ID'] != "")
		{
			$obj = $this->getClass('Cms\Pages\Common')->getPageByPageID($arr['ID']);
			if(isset($obj->PageID))
			{
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
		}
		
		if(d("CHECKOUT_LOGIN")=="1" && d("CHECKOUT_WITHOUT_LOGIN")=="0")
			$CurrentUserObj = $this->getClass('Customer\Login\Common')->CheckUserLogin(SKSEOURL('checkout','Checkout'));	
		else 
			$CurrentUserObj = $this->getClass('Customer\Login\Common')->IsUserLogin();	
		
		/* check empty cart*/
		$CartCount = $this->getClass('Sale\Cart\Common')->CartCount();
		if($CartCount=="" || $CartCount <=0)
		{
			MyRedirect(SKSEOURL('checkout','Cart'));
			exit;
		}
		/* check product status prices here*/
		
		/* confirm here*/
		if($arr['MView']=="Confirm"){
			if($this->getSession()->getVar("OrderID") == ""){
				MyRedirect(SKSEOURL('checkout','Cart'));
				exit;
			}
			$Obj = $this->getCheckoutObj();
			if($Obj->ShippingCode==""){
				$this->getSession()->setArrVar("alert",array("danger","Please call for delivery charges for this Postcode."));	
				MyRedirect(SKSEOURL('checkout','Checkout'));
				exit;
			}
			$this->getClass("PaymentModule\Payment\Common")->getPaymentPreProcess($Obj->PaymentMethod,$Obj);
			if(count($_POST) > 0){
				$this->getClass("PaymentModule\Payment\Common")->getPaymentPostProcess($Obj->PaymentMethod,$Obj,$_POST);
			}
		}
		/* confirm here*/
		
		if($this->getSession()->getVar("IsChance") == "")
			$this->getSession()->setVar("IsChance","1");
		else if($this->getSession()->getVar("IsChance") == "1")
			$this->getSession()->setVar("IsChance","-1");
		
		
	}
	
	function getCheckoutObj()
	{
		//$CurrentObj = new \stdClass();
		$CurrentObj = $this->getClass('Customer\Login\Common')->IsUserLogin();	
		if(isset($CurrentObj->UserID) && $CurrentObj->UserID != ""){
			$CurrentObj->ShippingFirstName = $CurrentObj->BillingFirstName = $CurrentObj->FirstName;
			$CurrentObj->ShippingLastName = $CurrentObj->BillingLastName = $CurrentObj->LastName;
			$CurrentObj->ShippingAddress1 = $CurrentObj->BillingAddress1 = $CurrentObj->Address1;
			$CurrentObj->ShippingAddress2 = $CurrentObj->BillingAddress2 = $CurrentObj->Address2;
			$CurrentObj->ShippingCity = $CurrentObj->BillingCity = $CurrentObj->City;
			$CurrentObj->ShippingState = $CurrentObj->BillingState = $CurrentObj->State;
			$CurrentObj->ShippingCountry = $CurrentObj->BillingCountry = $CurrentObj->Country;
			$CurrentObj->ShippingZipCode = $CurrentObj->BillingZipCode = $CurrentObj->ZipCode;
			$CurrentObj->ShippingPhone = $CurrentObj->BillingPhone = $CurrentObj->Phone;
			//$CurrentObj->ShippingFax = $CurrentObj->BillingFax = $CurrentObj->Fax;
		}
		
		if($this->getSession()->getVar("OrderID") != ""){
			$CurrentObj =  $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($this->getSession()->getVar("OrderID"));
		}
		if($this->getSession()->getVar("OrderCoupon") != ""){
			//$CurrentObj = new stdClass();
			if(!is_object($CurrentObj))
				$CurrentObj = new \stdClass();
		
			$CurrentObj->VoucherCode = $this->getSession()->getVar("OrderCoupon");
		}
		
		return $CurrentObj;
	}
	
	function OrderProcessAction()
	{
		if(count($_POST) > 0){
			 $OrderID = $this->getClass("Sale\Checkout\Common")->processOrder($_POST);
			 //sleep(1);
			 //MyRedirect(SKSEOURL('checkout','Confirm'),true);
			 MyRedirect(SKSEOURL('checkout','Confirm'));
			 exit;
		}
	}
	
	function CouponProcessAction()
	{
		if(count($_POST) > 0){
			$arr = $this->getClass("Sale\Checkout\Common")->processCoupon($_POST);
			if(count($arr) > 0){
				foreach($arr as $k=>$cArr){
					if(isset($cArr['Success']) && $cArr['Success'] != "")
						$this->getSession()->setArrVar("alert",array("success",$cArr['Success']));
					
					if(isset($cArr['Error']) && $cArr['Error'] != "")
						$this->getSession()->setArrVar("alert",array("danger",$cArr['Error']));
					
				}
			}
			else{
				 $this->getSession()->setArrVar("alert",array("danger","Your Voucher Code is invalid."));
			}
			MyRedirect(SKSEOURL('checkout','Checkout'));
			exit;
		}
	}
	
	function getShippingMethodAction()
	{
		$Obj = $this->getCheckoutObj();
		$type= isset($_GET['type'])?$_GET['type']:"";
		$ShippingArray  = $this->getClass("ShippingModule\Shipping\Common")->getAllShipping($_POST);
		if($type=="html"){
			if(isset($ShippingArray['count']) && $ShippingArray['count'] > 0 && is_array($ShippingArray['method']) && count($ShippingArray['method']) > 0){
				
				if($ShippingArray['count']==1){
					foreach($ShippingArray['method'] as $m=>$arr){
						//echo '<h4 class="font-weight-light">Shipping</h4>';
						foreach($arr['rates'] as $rateArr){
							if(isset($rateArr['alert']) && $rateArr['alert'] != ""){
								echo '<div class="col-12"><label>'.$rateArr['alert'].'</label></div>';
							}
							else{
								echo '<input type="hidden" rel="'.$rateArr['price'].'" data-price="'.$rateArr['price'].'"  name="ship_method" id="'.$m.'__'.$rateArr['code'].'" value="'.$m.'__'.$rateArr['code'].'" />';
								echo '<div class="col-12"><label>'.$arr['title']."-".$rateArr['title'].' ('.$rateArr['display_price'].')</label></div>';
							}
						}
					}		
					exit;
				}
			
				//echo '<h4 class="font-weight-light">Shipping</h4>';
				foreach($ShippingArray['method'] as $m=>$arr){
					foreach($arr['rates'] as $rateArr){
						$ship_code = $m.'__'.$rateArr['code'];
						echo '<div class="col-12"><label><input type="radio" rel="'.$rateArr['price'].'" data-price="'.$rateArr['price'].'"  name="ship_method" id="'.$ship_code.'" value="'.$ship_code.'" '.((isset($Obj->ShippingCode) && $Obj->ShippingCode==$ship_code)?"checked":"").' /> '.$arr['title']."-".$rateArr['title'].' ('.$rateArr['display_price'].')</label></div>';
					}
				}
			}
			exit;
		}
		
		if($type=="json"){
			header('Content-Type: application/json');
			echo json_encode($ShippingArray);
			exit;
		}
	}
	
	function getPaymentMethod()
	{
		$Obj = $this->getCheckoutObj();
		$PaymentArray  = $this->getClass("PaymentModule\Payment\Common")->getAllPayment($_POST);
		if(count($PaymentArray) > 0){
			if(count($PaymentArray) ==1){
				//echo '<h4 class="font-weight-light">Payment Method</h4>';
				foreach($PaymentArray as $m=>$arr){
						echo '<div class="col-12"><label><input type="hidden" name="payment_method" id="'.$m.'" value="'.$m.'" /> '.$arr['title'].'</label></div>';
				}
			}
			else{
				$SNo = 1;
				//echo '<h4 class="font-weight-light">Payment Method</h4>';
				foreach($PaymentArray as $m=>$arr){
						echo '<div class="col-12">
								<h5> <label><input type="radio" name="payment_method" id="'.$m.'" value="'.$m.'" '.((isset($Obj->PaymentMethod) && $Obj->PaymentMethod==$m)?"checked":(($SNo==1)?"checked":"")).' />'.$arr['title'].'</label></h5>
								'.$arr['note'].'
							</div>';
						$SNo++;
				}
			}				
		}
	}
	
	function getPaymentPreForm($PaymentMethod,$Obj,$PostArray="")
	{
		return $this->getClass("PaymentModule\Payment\Common")->getPaymentPreForm($PaymentMethod,$Obj,$PostArray);
	}
	
	function getPaymentPostForm($PaymentMethod)
	{
		return $this->getClass("PaymentModule\Payment\Common")->getPaymentPostForm($PaymentMethod);
	}
	
	function pageTitle()
	{
		return isset($this->currentObj->LeftTitle1)?MyStripSlashes($this->currentObj->LeftTitle1):"";
	}
	
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
}	