<?php 
namespace Sale\Cart;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function AddProductInTmpCart($ID,$Qty=1,$Attribute1 ="",$PostArray = array())
	{
		$AlertArray = array();
		
		$SessionID = $this->getSession()->getCurrentSID();
		/* Check Nos of Items in the cart start */
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('TotalItems'=>'Count(*)'));
		if(isset($Obj->TotalItems) && ($Obj->TotalItems+$Qty) > d("PRODUCTS_ITEMS_IN_CART_MAX"))
		{
			$AlertArray[] = array("danger","You can not add more than ".d("PRODUCTS_ITEMS_IN_CART_MAX")." items in the cart.");
		}
		/* Check Nos of Items in the cart end */
		
		$MasterID =	$ID;
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $MasterID));
		
		if(isset($GLOBALS['UserIDByAdmin']) && $GLOBALS['UserIDByAdmin'] != "")
		{
				//$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		else
		{
			$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																	"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																	"Stock","StockStatus","StockTotal","EndStock",
																	"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	
																	
		if(!isset($CurrentProduct->ProductID))
		{
			$AlertArray[] = array("danger","Something went wrong");
			//$this->getSession()->setArrVar("alert",array("danger","Something went wrong"));
			//MyRedirect(SKSEOURL('cms_pages','Detail',1001));
			//exit;
		}
		
		if(isset($CurrentProduct->NotForSale) && $CurrentProduct->NotForSale == "1")
			$AlertArray[] = array("danger","Currently this product is not available for sale.");
		
		if(isset($CurrentProduct->EndStock) && $CurrentProduct->EndStock == "1" && $Qty > $CurrentProduct->Stock){
				$AlertArray[] = array("danger","Currently this product is out of stock.");
		}
			

		if(isset($CurrentProduct->SignedIn) && $CurrentProduct->SignedIn == "1")
		{
			if(d("FRONT_SIDE_INCLUDE")==true){
				$this->getSession()->setArrVar("alert",array("danger","Currently this product is available for registered customers."));
				$this->getClass('Customer\Login\Common')->CheckUserLogin(SKSEOURL('catalog_product','Detail',$CurrentProduct->ProductID));
			}
		}
		
		if(isset($CurrentProduct->ProductType) && class_exists("Catalog\\Product\\ProductType\\".$CurrentProduct->ProductType)){
			$ClsObj = $this->getClass("Catalog\\Product\\ProductType\\".$CurrentProduct->ProductType);
			if(method_exists($ClsObj, "AddProductInTmpCart"))
				return $ClsObj->AddProductInTmpCart($ID,$Qty,$Attribute1,$PostArray);
		}
		
		/* add bundle product section start */
		if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType == "Bundle"){
			$BundleAddStatus = true;
			$bundleRows = $this->getClass("Catalog\Product\Common")->getProductBundleActive($CurrentProduct->ProductID);
			foreach( $bundleRows as $CurrentBundle){
				//echo "<hr>";
				$BCount = isset($PostArray['BundleProductID'][$CurrentBundle->BundleID])?count($PostArray['BundleProductID'][$CurrentBundle->BundleID]):0;
				//echo $BCount."<br>";
				//echo $CurrentBundle->MaxProduct."<br>";
				if($CurrentBundle->MaxProduct > 0 && $CurrentBundle->MaxProduct != $BCount){
					$BundleAddStatus = false;
				}
			}
			
			if($BundleAddStatus===false){
				$AlertArray[] = array("danger","Please select correct numbers of bundles.");
			}
			
			$arr = $AlertArray;
			if($arr==NULL || count($arr)==0){
					//var_dump("Bundle added here");
				/* Bundle added here start*/
				 $ItemStatus ="Normal";
				 $ItemType ="Bundle";
				 $ItemName = isset($CurrentProduct->ProductName)?$CurrentProduct->ProductName:"";
				 $ItemNo = isset($CurrentProduct->ModelNo)?$CurrentProduct->ModelNo:"";
				 $ReferenceID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
				 
				 if($CurrentProduct->FreeShippingStatus =="1")
					$ItemStatus ="FreeShipping";
				if($CurrentProduct->VirtualProduct =="1")
					$ItemStatus ="Download";
				
				$Attribute1 = base64_encode(serialize($PostArray['BundleProductID']));
				$PriceArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentProduct->ProductID,$Qty,$PostArray);
				
				$ItemID = uniqid("Item_");
				$DataArray = array();
				$DataArray['ItemID'] = $ItemID;
				$DataArray['ItemType'] = $ItemType;
				$DataArray['ItemStatus'] = $ItemStatus;
				$DataArray['ReferenceID'] = $ReferenceID;
				$DataArray['ItemName'] = $ItemName;
				$DataArray['ItemNo'] =$ItemNo;
				$DataArray['Attribute1'] = isset($Attribute1)?$Attribute1:"";
				$DataArray['Attribute2'] = isset($Attribute2)?$Attribute2:"";
				
				$DataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
				$DataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
				$DataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
				$DataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
				
				$DataArray['UnitPrice'] = isset($PriceArray['UnitPrice'])?$PriceArray['UnitPrice']:"";
				$DataArray['TaxPercent'] = isset($PriceArray['TaxPercent'])?$PriceArray['TaxPercent']:"";
				$DataArray['Price'] = isset($PriceArray['Price'])?$PriceArray['Price']:"";
				$DataArray['TaxPrice'] = (($DataArray['Price']  * $DataArray['TaxPercent'])/100);
				$DataArray['VoucherAmount'] = isset($PriceArray['Discount'])?$PriceArray['Discount']:"";
				$DataArray['VoucherText'] = "";
				$DataArray['VoucherCode'] = "";
				
				$DataArray['ActualPrice'] = $DataArray['Price'];
				$DataArray['ActualPriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				
				if($DataArray['VoucherAmount'] > 0){
					$DataArray['Price'] = $DataArray['Price'] - $DataArray['VoucherAmount'];
				}
				
				$DataArray['TaxPrice'] = (($DataArray['Price']  * $DataArray['TaxPercent'])/100);
				$DataArray['PriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				$DataArray['Qty'] = isset($PriceArray['Qty'])?$PriceArray['Qty']:"";
				$DataArray['Total'] = $DataArray['Price'] * $DataArray['Qty'];
				$DataArray['TotalWithTax'] = $DataArray['PriceWithTax'] * $DataArray['Qty'];
				
				
				$DataArray['Comments'] = isset($PostArray['Comments'])?$PostArray['Comments']:"";		
				$DataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
				$DataArray['SessionID'] = $SessionID;

				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
				$TmpCartObj->where[] = array('=',array('ItemName' => $DataArray['ItemName']));
				$TmpCartObj->where[] = array('=',array('Attribute1' => $DataArray['Attribute1']));
				$TmpCartObj->where[] = array('=',array('ItemType' => $DataArray['ItemType']));
				$TmpCartObj->where[] = array('=',array('ReferenceID' => $DataArray['ReferenceID']));
				$CurrentCart = (object)$TmpCartObj->tableSelectOne();
				if(isset($CurrentCart->TmpCartID) && $CurrentCart->TmpCartID !=""){
					$TmpCartObj->tableUpdate($DataArray);
				}
				else{
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
					$TmpCartObj->tableInsert($DataArray);
				}
				
				/* BundleProductID attribute start */
				if(isset($PostArray['BundleProductID']) && is_array($PostArray['BundleProductID']) && count($PostArray['BundleProductID']) > 0){
					foreach ($PostArray['BundleProductID'] as $BundleID=>$ProductArray){
						foreach($ProductArray as $k=>$ChildProductID){
							$ProductObj = new DataTable(TABLE_PRODUCT);
							$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
							$ProductObj->where[] = array('=',array('Active' => "1"));
							$CurrentChild = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																						"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																						"PurchaseOnline","NotForSale","SignedIn"));																	
			
							
							if(isset($CurrentChild->ProductID) && $CurrentChild->ProductID != ""){
								
								 $ItemStatus ="Normal";
								 $ItemType ="Product";
								 $ItemName = isset($CurrentChild->ProductName)?$CurrentChild->ProductName:"";
								 $ItemNo = isset($CurrentChild->ModelNo)?$CurrentChild->ModelNo:"";
								 $ReferenceID = isset($CurrentChild->ProductID)?$CurrentChild->ProductID:"";
								 
								 if($CurrentChild->FreeShippingStatus =="1")
									$ItemStatus ="FreeShipping";
								if($CurrentChild->VirtualProduct =="1")
									$ItemStatus ="Download";
								
								$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentChild->ProductID,$Qty,$PostArray);
								$SubItemID = uniqid("Item_");
								$SubDataArray = array();
								$SubDataArray['ItemID'] = $SubItemID;
								$SubDataArray['ParentItemID'] = $ItemID;
								$SubDataArray['ItemType'] = $ItemType;
								$SubDataArray['ItemStatus'] = $ItemStatus;
								$SubDataArray['ReferenceID'] = $ReferenceID;
								$SubDataArray['ItemName'] ="Product :<i>".$ItemName." (".$this->getClass('Base\Currency\CurrencyHandler')->Change2CurrentCurrency((isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"0")).")</i>";
								$SubDataArray['ItemNo'] = $ItemNo;	
								
								$SubDataArray['Attribute1'] = $CurrentProduct->ProductID;
								$SubDataArray['Attribute2'] = $BundleID;
								
								$SubDataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
								$SubDataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
								$SubDataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
								$SubDataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
								
								$SubDataArray['UnitPrice'] = "0";
								$SubDataArray['TaxPrice'] = "0";
								$SubDataArray['TaxPercent'] = "0";
								$SubDataArray['VoucherAmount'] = "0";
								$SubDataArray['VoucherText'] = "";
								$SubDataArray['VoucherCode'] = "";
							
								$SubDataArray['Price'] = "0";
								$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
								$SubDataArray['ActualPrice'] = "0";
								$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
								$SubDataArray['Qty'] = isset($PriceArray['Qty'])?$PriceArray['Qty']:"";
								$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
								$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
								
								$SubDataArray['Comments'] = "";		
								$SubDataArray['SessionInfo'] = "";		
								$SubDataArray['SessionID'] = $SessionID;
								$TmpCartObj = new DataTable(TABLE_TMPCART);
								$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
								$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
								$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
								$TmpCartObj->where[] = array('=',array('Attribute1' => $SubDataArray['Attribute1']));
								$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
								$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
								$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
								if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
									$TmpCartObj->tableUpdate($SubDataArray);
								}
								else{
									$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
									$TmpCartObj->tableInsert($SubDataArray);
								}
							}
							
						}
					}
				}
			/* BundleProductID attribute end */
			/* Bundle added here end*/				
			}			
		}
		/* add bundle product section end */
		//var_dump($PostArray);
		//var_dump($CurrentProduct);
		//exit;
		/* add attribute product section start */
		if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType == "Attribute"){
			if(isset($PostArray['ChQty']) && count($PostArray['ChQty']) > 0){
				foreach($PostArray['ChQty'] as $ChildProductID=>$ChQty){
					if($ChQty > 0){
						$ChildProductArray[$ChildProductID] = $ChQty;
					}
			}
		}
		
		if(isset($PostArray['ChildProductID']) && $PostArray['ChildProductID'] != ""){
			$ChildProductArray[$PostArray['ChildProductID']] = $Qty;
			
		}
		if(isset($ChildProductArray) && is_array($ChildProductArray) && count($ChildProductArray) > 0){
			foreach($ChildProductArray as $ChildProductID=>$ChQty){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
					$ProductObj->where[] = array('=',array('MasterID' => $CurrentProduct->ProductID));
					$ProductObj->where[] = array('=',array('Active' => "1"));
					$CurrentChild = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																				"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																				"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	

					
					$ChildAlertArray = array();
					if(isset($CurrentChild->NotForSale) && $CurrentChild->NotForSale == "1")
							$ChildAlertArray[] = array("danger","Currently this product is not available for sale.");
						
						if(isset($CurrentChild->EndStock) && $CurrentChild->EndStock == "1" && $Qty > $CurrentChild->Stock){
								$ChildAlertArray[] = array("danger","Currently this product is out of stock.");
						}
							

						if(isset($CurrentChild->SignedIn) && $CurrentChild->SignedIn == "1")
						{
							if(d("FRONT_SIDE_INCLUDE")==true){
								$ChildAlertArray[] = array("danger","Currently this product is available for registered customers.");
							}
						}
						
						if($CurrentChild->ProductType == "Child" && isset($CurrentChild->ShippingProductID) && $CurrentChild->ShippingProductID == "1"){
							$Mod = $ChQty%2;
							if($Mod=="1")
								$ChildAlertArray[] = array("danger","Please add multiple for 2 for ".$CurrentChild->ProductName);
						}
					if(isset($CurrentChild->ProductID) && $CurrentChild->ProductID != "" && count($ChildAlertArray)==0){
						
						
						 $ItemStatus ="Normal";
						 $ItemType ="ProductChild";
						 $ItemName = isset($CurrentChild->ProductName)?$CurrentChild->ProductName:"";
						 $ItemNo = isset($CurrentChild->ModelNo)?$CurrentChild->ModelNo:"";
						 $ReferenceID = isset($CurrentChild->MasterID)?$CurrentChild->MasterID:"";
						 
						 if($CurrentChild->FreeShippingStatus =="1")
							$ItemStatus ="FreeShipping";
						if($CurrentChild->VirtualProduct =="1")
							$ItemStatus ="Download";
						
						$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentChild->ProductID,$ChQty,$PostArray);
						$SubItemID = uniqid("Item_");
						$SubDataArray = array();
						$SubDataArray['ItemID'] = $SubItemID;
						$SubDataArray['ParentItemID'] = "";
						$SubDataArray['ItemType'] = $ItemType;
						$SubDataArray['ItemStatus'] = $ItemStatus;
						$SubDataArray['ReferenceID'] = $ReferenceID;
						$SubDataArray['ItemName'] =$ItemName;
						$SubDataArray['ItemNo'] = $ItemNo;	
						
						$SubDataArray['Attribute1'] = $CurrentChild->ProductID;
						$SubDataArray['Attribute2'] = "";
						
						$SubDataArray['Width'] = (isset($CurrentChild->Width) && $CurrentChild->Width > 0)?$CurrentChild->Width:"0";
						$SubDataArray['Height'] = (isset($CurrentChild->Height) && $CurrentChild->Height > 0)?$CurrentChild->Height:"0";
						$SubDataArray['Length'] = (isset($CurrentChild->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
						$SubDataArray['Weight'] = (isset($CurrentChild->Weight) && $CurrentChild->Weight > 0)?$CurrentChild->Weight:"0";
						
						$SubDataArray['UnitPrice'] = isset($PriceSubArray['UnitPrice'])?$PriceSubArray['UnitPrice']:"";
						$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
						$SubDataArray['Price'] = isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"";
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['VoucherAmount'] = isset($PriceSubArray['Discount'])?$PriceSubArray['Discount']:"";
						$SubDataArray['VoucherText'] = "";
						$SubDataArray['VoucherCode'] = "";
						
						$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
						$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						
						if($SubDataArray['VoucherAmount'] > 0){
							$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
						}
						
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
						$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
						$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
										
				
						$SubDataArray['Comments'] = $Comments;		
						$PostArray["ChQty"] = array();
						$PostArray["ChQty"][$SubDataArray['Attribute1']] = $SubDataArray['Qty'];
						$SubDataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
						$SubDataArray['SessionID'] = $SessionID;
						
					
						$TmpCartObj = new DataTable(TABLE_TMPCART);
						$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
						$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
						$TmpCartObj->where[] = array('=',array('Attribute1' => $SubDataArray['Attribute1']));
						$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
						$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
						$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
						if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
							$TmpCartObj->tableUpdate($SubDataArray);
						}
						else{
							$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
							$TmpCartObj->tableInsert($SubDataArray);
						}
					}
					else{
						return $ChildAlertArray;
					}
					
					
					
				}
			}
		
		}
		/* add attribute product section end */
		
			
		 $arr = $AlertArray;
		 if($arr==NULL || count($arr)==0)	{
			 /* add product start*/
			 
			 $ItemStatus ="Normal";
			 $ItemType ="Product";
			 $ItemName = isset($CurrentProduct->ProductName)?$CurrentProduct->ProductName:"";
			 $ItemNo = isset($CurrentProduct->ModelNo)?$CurrentProduct->ModelNo:"";
			 $ReferenceID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
			 $ProductID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
			 $Comments = isset($PostArray['Comments'])?$PostArray['Comments']:"";
			 if(isset($CurrentProduct->EndStock) && $CurrentProduct->EndStock==0 &&  $CurrentProduct->StockStatus==1 && $CurrentProduct->Stock<=0)
				$Comments .= " - out of stock";
			 
			 if($CurrentProduct->FreeShippingStatus =="1")
				$ItemStatus ="FreeShipping";
			if($CurrentProduct->VirtualProduct =="1")
				$ItemStatus ="Download";
			if($CurrentProduct->GiftVoucherStatus =="1"){
				$ItemStatus ="FreeShipping";
				$ItemType ="GiftVoucher";
				if(isset($PostArray['RName']) && $PostArray['RName'] !=""){
					$Attribute1 = isset($PostArray['RName'])?$PostArray['RName']:"";
					$Attribute2 = isset($PostArray['REmail'])?$PostArray['REmail']:"";
					$ItemName .=  " for ".$Attribute1." (".$Attribute2.")";
				}
			}
			
			if(isset($PostArray['DiscountedProductID']) && is_array($PostArray['DiscountedProductID']) && count($PostArray['DiscountedProductID']) > 0){
				$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				if(isset($IsCurrentUser->WholeSaler) && $IsCurrentUser->WholeSaler=="1"){
					$PostArray['DiscountedProductID'] = null;
				}
			}
				
			if(isset($PostArray['DiscountedProductID']) && is_array($PostArray['DiscountedProductID']) && count($PostArray['DiscountedProductID']) > 0){
				$ItemName .=  " (DISCOUNTED)";
				$Attribute1 = "DIS_".implode("@@@",$PostArray['DiscountedProductID']);
			}
			
			$PriceArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentProduct->ProductID,$Qty,$PostArray);
			
			/* Check simple product start*/
			if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType == "Simple"){
				
				$ItemID = uniqid("Item_");
				$DataArray = array();
				$DataArray['ItemID'] = $ItemID;
				$DataArray['ItemType'] = $ItemType;
				$DataArray['ItemStatus'] = $ItemStatus;
				$DataArray['ReferenceID'] = $ReferenceID;
				$DataArray['ItemName'] = $ItemName;
				$DataArray['ItemNo'] =$ItemNo;
				$DataArray['Attribute1'] = isset($Attribute1)?$Attribute1:"";
				$DataArray['Attribute2'] = isset($Attribute2)?$Attribute2:"";
				
				$DataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
				$DataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
				$DataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
				$DataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
				
				$DataArray['UnitPrice'] = isset($PriceArray['UnitPrice'])?$PriceArray['UnitPrice']:"";
				$DataArray['TaxPercent'] = isset($PriceArray['TaxPercent'])?$PriceArray['TaxPercent']:"";
				$DataArray['Price'] = isset($PriceArray['Price'])?$PriceArray['Price']:"";
				$DataArray['TaxPrice'] = (($DataArray['Price']  * $DataArray['TaxPercent'])/100);
				$DataArray['VoucherAmount'] = isset($PriceArray['Discount'])?$PriceArray['Discount']:"";
				$DataArray['VoucherText'] = "";
				$DataArray['VoucherCode'] = "";
				
				$DataArray['ActualPrice'] = $DataArray['Price'];
				$DataArray['ActualPriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				
				if($DataArray['VoucherAmount'] > 0){
					$DataArray['Price'] = $DataArray['Price'] - $DataArray['VoucherAmount'];
				}
				
				$DataArray['TaxPrice'] = (($DataArray['Price']  * $DataArray['TaxPercent'])/100);
				$DataArray['PriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				$DataArray['Qty'] = isset($PriceArray['Qty'])?$PriceArray['Qty']:"";
				$DataArray['Total'] = $DataArray['Price'] * $DataArray['Qty'];
				$DataArray['TotalWithTax'] = $DataArray['PriceWithTax'] * $DataArray['Qty'];
										
				
				$DataArray['Comments'] = $Comments;		
				$DataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
				$DataArray['SessionID'] = $SessionID;

				//echo "<pre>";var_dump($DataArray);exit;	
				
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
				$TmpCartObj->where[] = array('=',array('ItemName' => $DataArray['ItemName']));
				$TmpCartObj->where[] = array('=',array('Attribute1' => $DataArray['Attribute1']));
				$TmpCartObj->where[] = array('=',array('ItemType' => $DataArray['ItemType']));
				$TmpCartObj->where[] = array('=',array('ReferenceID' => $DataArray['ReferenceID']));
				$CurrentCart = (object)$TmpCartObj->tableSelectOne();
				if(isset($CurrentCart->TmpCartID) && $CurrentCart->TmpCartID !=""){
					if(isset($CurrentCart->ModifyPrice) && $CurrentCart->ModifyPrice =="1"){
						/* nothing update*/
					}
					else{
						
						$DelTmpCartObj = new DataTable(TABLE_TMPCART);
						$DelTmpCartObj->where[] = array('=',array('ParentItemID' => $CurrentCart->ItemID));
						$DelTmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$DelTmpCartObj->tableDelete();
						$TmpCartObj->tableUpdate($DataArray);
					}
				}
				else{
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
					$TmpCartObj->tableInsert($DataArray);
				}
			
			/* additional attribute start */
			if($Attribute1 !="")
			{
				$ProductAdditionName = explode(",",$Attribute1);
				foreach ($ProductAdditionName as $k=>$v)
				{
					if($v !="")
					{
						$ProductAdditionObj = new DataTable(TABLE_PRODUCT_ADDITIONS);
						$ProductAdditionObj->where[] = array('=',array('ProductAdditionID' => $v));
						$CurrentAddition = (object)$ProductAdditionObj->tableSelectOne();
						if(isset($CurrentAddition->ProductID) && $CurrentAddition->ProductID !="")
						{
							
							$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentProduct->ProductID,$Qty,array("ProductAdditionID"=>$v));
							
							$SubItemID = uniqid("Item_");
							$SubDataArray = array();
							$SubDataArray['ItemID'] = $SubItemID;
							$SubDataArray['ParentItemID'] = $ItemID;
							$SubDataArray['ItemType'] = "Option";
							$SubDataArray['ItemStatus'] = $ItemStatus;
							$SubDataArray['ReferenceID'] = $CurrentAddition->ProductAdditionID;
							$SubDataArray['ItemName'] = $CurrentAddition->AttributeName.": ".$CurrentAddition->AttributeValue."";
							$SubDataArray['ItemNo'] = $CurrentAddition->ModelNo;	
							
							
							$SubDataArray['UnitPrice'] = isset($PriceSubArray['UnitPrice'])?$PriceSubArray['UnitPrice']:"";
							$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
							$SubDataArray['Price'] = isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"";
							$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
							$SubDataArray['VoucherAmount'] = isset($PriceSubArray['Discount'])?$PriceSubArray['Discount']:"";
							$SubDataArray['VoucherText'] = "";
							$SubDataArray['VoucherCode'] = "";

							$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
							$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];

							if($SubDataArray['VoucherAmount'] > 0){
								$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
							}

							$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
							$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
							$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
							$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
							$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
							
							
							$SubDataArray['SessionID'] = $SessionID;	
							
							$TmpCartObj = new DataTable(TABLE_TMPCART);
							$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
							$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
							$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
							$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
							$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
							$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
							if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !="" && false){
								$TmpCartObj->tableUpdate($SubDataArray);
							}
							else{
								$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
								$TmpCartObj->tableInsert($SubDataArray);
							}
						}
					}
					
				}
			}
			/* additional attribute end */
			/* printing option start */
			if(isset($PostArray['MoreOption']) && is_array($PostArray['MoreOption']) && count($PostArray['MoreOption']) > 0){
					foreach($PostArray['MoreOption'] as $MoreOptionKey=>$MoreOptionValue){
						if(isset($PostArray[$MoreOptionKey]) && $PostArray[$MoreOptionKey] != "" && $MoreOptionValue !="")
						{
							
							
							$SubItemID = uniqid("Item_");
							$SubDataArray = array();
							$SubDataArray['ItemID'] = $SubItemID;
							$SubDataArray['ParentItemID'] = $ItemID;
							$SubDataArray['ItemType'] = "MoreOption";
							$SubDataArray['ItemStatus'] = $ItemStatus;
							$SubDataArray['ReferenceID'] = "";
							$SubDataArray['ItemName'] = $MoreOptionValue.":<i> ".nl2br($PostArray[$MoreOptionKey])."</i>";
							$SubDataArray['ItemNo'] = $MoreOptionValue;	
							$SubDataArray['SessionID'] = $SessionID;	
							$TmpCartObj = new DataTable(TABLE_TMPCART);
							$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
							$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
							$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
							$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
							$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
							$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
							if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !="" && false){
								$TmpCartObj->tableUpdate($SubDataArray);
							}
							else{
								$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
								$TmpCartObj->tableInsert($SubDataArray);
							}
						}
						
					}
			}
			/* printing option end */
			
			/* DiscountedProductID attribute start */
			if(isset($PostArray['DiscountedProductID']) && is_array($PostArray['DiscountedProductID']) && count($PostArray['DiscountedProductID']) > 0){
				
				foreach($PostArray['DiscountedProductID'] as $k=>$ChildProductID){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
					$ProductObj->where[] = array('=',array('Active' => "1"));
					$CurrentChild = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																				"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																				"WholeSaler","VIPStatus","IsBundle",
																				"PurchaseOnline","NotForSale","SignedIn"));																	
	
					
					
					if(isset($CurrentChild->ProductID) && $CurrentChild->ProductID != ""){
					
						$Obj = new DataTable(TABLE_PRODUCT_RELATION);
						$Obj->where[] = array('=',array('ProductID' => $ProductID));
						$Obj->where[] = array('=',array('RelationID' => $CurrentChild->ProductID));
						
						$DisWhere = new Where();
						$DisWhere->equalTo('ProductID',$ProductID);
						$DisWhere->equalTo('RelationType','product_discounted');
						$DisWhere->equalTo('RelationID',$CurrentChild->ProductID);
						$DisWhere->greaterThan('Custom',0);
						
						$Obj->where = $DisWhere;
		
						$CurrentDiscount = (object)$Obj->tableSelectOne();			
						if(isset($CurrentDiscount->Custom) && $CurrentDiscount->Custom > 0){
							 $ItemStatus ="Normal";
							 $ItemType ="Product";
							 $ItemName = isset($CurrentChild->ProductName)?$CurrentChild->ProductName:"";
							 $ItemNo = isset($CurrentChild->ModelNo)?$CurrentChild->ModelNo:"";
							 $ReferenceID = isset($CurrentChild->ProductID)?$CurrentChild->ProductID:"";
							 
							 if($CurrentChild->FreeShippingStatus =="1")
								$ItemStatus ="FreeShipping";
							if($CurrentChild->VirtualProduct =="1")
								$ItemStatus ="Download";
							
							$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentChild->ProductID,$Qty);
							$SubItemID = uniqid("Item_");
							$SubDataArray = array();
							$SubDataArray['ItemID'] = $SubItemID;
							$SubDataArray['ParentItemID'] = $ItemID;
							$SubDataArray['ItemType'] = $ItemType;
							$SubDataArray['ItemStatus'] = $ItemStatus;
							$SubDataArray['ReferenceID'] = $ReferenceID;
							$SubDataArray['ItemName'] ="Product :<i>".$ItemName." (".number_format($CurrentDiscount->Custom,2)."% OFF)</i>";
							$SubDataArray['ItemNo'] = $ItemNo;	
							
							$SubDataArray['Attribute1'] = $CurrentProduct->ProductID;
							$SubDataArray['Attribute2'] = "DiscountedProduct";
							
							$SubDataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
							$SubDataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
							$SubDataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
							$SubDataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
							
							
							$SubDataArray['UnitPrice'] = $this->getClass('Catalog\Product\Common')->GetDiscountedPrice($PriceSubArray['UnitPrice'],$CurrentDiscount->Custom);
							$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
							$SubDataArray['Price'] = $this->getClass('Catalog\Product\Common')->GetDiscountedPrice($PriceSubArray['Price'],$CurrentDiscount->Custom);
							
							$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
							$SubDataArray['VoucherAmount'] = $this->getClass('Catalog\Product\Common')->GetDiscountedPrice($PriceSubArray['Discount'],$CurrentDiscount->Custom);
							$SubDataArray['VoucherText'] = "";
							$SubDataArray['VoucherCode'] = "";

							$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
							$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];

							if($SubDataArray['VoucherAmount'] > 0){
								$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
							}

							$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
							$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
							$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
							$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
							$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];

							$SubDataArray['Comments'] = "";		
							$SubDataArray['SessionInfo'] = "";		
							$SubDataArray['SessionID'] = $SessionID;
							$TmpCartObj = new DataTable(TABLE_TMPCART);
							$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
							$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
							$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
							$TmpCartObj->where[] = array('=',array('Attribute1' => $SubDataArray['Attribute1']));
							$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
							$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
							$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
							if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !="" && false){
								$TmpCartObj->tableUpdate($SubDataArray);
							}
							else{
								$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
								$TmpCartObj->tableInsert($SubDataArray);
							}
						}
					}
					
				}
				
			}
			/* DiscountedProductID attribute end */
			
			
			
		}
		/* Check simple product end*/
		
		
		$this->AddCartInCookie();
			 return "1";
			 /* add product end*/
		 }
		 else{
			 return $AlertArray;
		 }
			 
		//var_dump($CurrentProduct);exit;
	}
	
	function AddCartInCookie()
	{
		$this->RemoveDummyDatainCart();
		$CartObj = new DataTable(TABLE_TMPCART);
		$SessionID = $this->getSession()->getCurrentSID();
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$CartObj->where = $where;
		//$CartObj->displayQuery = true;	
		$rows = $CartObj->tableSelectAll(array("ItemID"),array("TmpCartID ASC"),4);
		$CookieArray = array();
		foreach($rows as $CurrentCartItem)
		{
			$CookieArray[$CurrentCartItem->ItemID] = $CurrentCartItem->ItemID;
		}
		
		if(count($CookieArray) > 0){
			$value = base64_encode(serialize($CookieArray));
			setcookie("SKCartData", $value, time()+60*60*24*30);  /* 30 day cookie set time (60*60*24 = 1 day)  */
		}
		else{
			$this->RemoveCartCookie("SKCartData");
		}
		
		$this->DiscountAfterCartAdd();
		
	}

	function RemoveCartCookie($cookiename)
	{
		if(isset($_COOKIE[$cookiename]))
		{
			unset($_COOKIE[$cookiename]);
			@setcookie($cookiename, "", -1);
		}
	}
	
	function RestoreCartByCookie()
	{
		$RestoreCart = $this->getSession()->getVar("RestoreCart");
		if($RestoreCart==""){
			$this->getSession()->setVar("RestoreCart","1");
			$data = isset($_COOKIE['SKCartData'])?$_COOKIE['SKCartData']:"";
			$CartArray = unserialize(base64_decode($data));
			$SessionID = $this->getSession()->getCurrentSID();
			if(isset($CartArray) && is_array($CartArray) && count($CartArray) > 0){
				$ItemID = key($CartArray);
				if($ItemID != ""){
					$TmpCartObj = new DataTable(TABLE_TMPCART);
					$TmpCartObj->where[] = array('=',array('ItemID' => $ItemID));
					$FirstTmpItem = (object)$TmpCartObj->tableSelectOne();
					$OldSessionID = isset($FirstTmpItem->SessionID)?$FirstTmpItem->SessionID:"";
					if($OldSessionID != ""){
						
						$CartObj = new DataTable(TABLE_TMPCART);
						$where = new Where();
						$where->equalTo('SessionID',$OldSessionID);
						$where->NEST//start braket
								->equalTo('ParentItemID','')
								->OR
								->isNull('ParentItemID')
								->UNNEST;
						
						$CartObj->where = $where;
						//$CartObj->displayQuery = true;	
						$rows = $CartObj->tableSelectAll(array("*"),array("TmpCartID ASC"));
						foreach($rows as $CurrentTmpItem){
							
							if(isset($CurrentTmpItem->ItemID) && $CurrentTmpItem->ItemID != ""){
								$OrderDetailObj = new DataTable();
								$Obj = new DataTable(array('od'=>TABLE_ORDER_DETAILS));
								$Obj->joinExpression = true;
								$Obj->joinArray[] = array('name'=>array('o'=>TABLE_ORDERS),
															  'on'=>"(o.OrderID=od.OrderID and o.PaymentStatus='Paid')",
															  'columns'=>array("OrderID"),
															  'type'=>''
															  );
															  
								$Obj->where[] = array('=',array('od.ItemID' => $CurrentTmpItem->ItemID));
								//$Obj->displayQuery = true;
								$CurrentOrderItem = (object)$Obj->tableSelectOne(array("ItemID"));
								if(!isset($CurrentOrderItem->ItemID)){
									if($CurrentTmpItem->ItemType=="Product" || $CurrentTmpItem->ItemType=="ProductChild"){
										
										$ProductID = $CurrentTmpItem->ReferenceID;
										$Qty = $CurrentTmpItem->Qty;
										$POSTDUMP = unserialize(base64_decode($CurrentTmpItem->SessionInfo));		
										$this->AddProductInTmpCart($ProductID,$Qty,@implode(",",(isset($POSTDUMP['ProductAdditionName'])?$POSTDUMP['ProductAdditionName']:array())),$POSTDUMP);
									}						
								}
							}
							
							
						}
						
					}
				}
			}
			
		}
	}
	
	function RemoveDummyDatainCart()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->notEqualTo('ParentItemID','');
				
		$TmpCartObj->where = $where;
		//$TmpCartObj->displayQuery=true;
		$data = $TmpCartObj->tableSelectAll(array("TmpCartID","ParentItemID","ItemID"));
		 foreach($data as $CurrentCartItem){
			 if(isset($CurrentCartItem->ParentItemID) && $CurrentCartItem->ParentItemID != ""){
				 $TmpCartObj = new DataTable(TABLE_TMPCART);
				 $TmpCartObj->where[] = array('=',array('ItemID' => $CurrentCartItem->ParentItemID));
				 $Obj = (object)$TmpCartObj->tableSelectOne(array("ParentItemID","ItemID"));
				if(!isset($Obj->ItemID) && isset($CurrentCartItem->TmpCartID)){
					$DelTmpCartObj = new DataTable(TABLE_TMPCART);
					$DelTmpCartObj->where[] = array('=',array('TmpCartID' => $CurrentCartItem->TmpCartID));
					$DelTmpCartObj->tableDelete();
			 
				}
			 }
		 }
			
		
	}
	
	function DiscountAfterCartAdd()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$TmpCartObj->where = $where;
		$rows = $TmpCartObj->tableSelectAll();
		$DiscountProduct = array();
		if(count($rows) > 0){
			foreach($rows as $CurrentCartItem){
				if(in_array($CurrentCartItem->ItemType,array("Product","ProductChild"))){
					if(isset($DiscountProduct[$CurrentCartItem->ReferenceID]))
						$DiscountProduct[$CurrentCartItem->ReferenceID] +=$CurrentCartItem->Qty;
					else 
						$DiscountProduct[$CurrentCartItem->ReferenceID] = $CurrentCartItem->Qty;		
				}
			}
		}
		/* discount product start*/
		foreach($DiscountProduct as $ProductID=>$TotalQty){
			$UserTypeID =1;
			//echo "<br>".$TotalQty;
			$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
			$where = new Where();
			$where->equalTo('pd.UserTypeID',$UserTypeID);
			$where->greaterThanOrEqualTo('QtyMax',$TotalQty);
			$where->lessThanOrEqualTo('QtyMin',$TotalQty);
			$ProductDiscountObj->where = $where;								  
			$CurrentProductPrice = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("QtyMin ASC"));	
			if(isset($CurrentProductPrice->DiscountPercent) && $CurrentProductPrice->DiscountPercent > 0){
				$DiscountPercent = $CurrentProductPrice->DiscountPercent;
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$where = new Where();
				$where->equalTo('SessionID',$SessionID);
				$where->in('ItemType',array("Product","ProductChild"));
				$where->equalTo('ReferenceID',$ProductID);
				$TmpCartObj->where = $where;
				//$TmpCartObj->displayQuery = true;
				$ProRows = $TmpCartObj->tableSelectAll();
				foreach($ProRows as $CurrentCartItem){
					if(isset($CurrentCartItem->TmpCartID) && $CurrentCartItem->TmpCartID !=""){
						
						$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentCartItem->Attribute1,$CurrentCartItem->Qty);
						
						$SubDataArray = array();
						$SubDataArray['UnitPrice'] = isset($PriceSubArray['UnitPrice'])?$PriceSubArray['UnitPrice']:"";
						$SubDataArray['Price'] = isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"";
						$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
						$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
						
						if($SubDataArray['UnitPrice'] > 0 && $DiscountPercent > 0)
							$SubDataArray['UnitPrice'] = $SubDataArray['UnitPrice'] - ($DiscountPercent/100)*$SubDataArray['UnitPrice'];
						
						if($SubDataArray['Price'] > 0 && $DiscountPercent > 0)
							$SubDataArray['Price'] = $SubDataArray['Price'] - ($DiscountPercent/100)*$SubDataArray['Price'];
						
						$SubDataArray['UnitPrice'] = number_format($SubDataArray['UnitPrice'],2,'.','');
						$SubDataArray['Price'] = number_format($SubDataArray['Price'],2,'.','');
						
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
						$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
						$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
						
						if(count($SubDataArray) > 0){
							$TmpCartObj2 = new DataTable(TABLE_TMPCART);						
							$TmpCartObj2->where[] = array('=',array('TmpCartID' => $CurrentCartItem->TmpCartID));
							$TmpCartObj2->tableUpdate($SubDataArray);
						}
					}
				}
		
			}
			
			
		}
		/* discount product start*/
		
	}
	
	function CartCount()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('TotalItems'=>'Count(*)'));
		return $Obj->TotalItems;
	}
	
	function QtyCount()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('TotalItems'=>'SUM(Qty)'));
		return $Obj->TotalItems;
	}
	
	function CartTotal()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('TotalAmount'=>'SUM(TotalWithTax)'));
		return isset($Obj->TotalAmount)?$Obj->TotalAmount:0;
	}
	function getShoppingCart()
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		return  $TmpCartObj->tableSelectAll("",array("TmpCartID ASC"));
	}
	
	function getShoppingCartSubData($ItemID)
	{
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->equalTo('ParentItemID',$ItemID);
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		return  $TmpCartObj->tableSelectAll("",array("TmpCartID ASC"));
	}
	
	function getShoppingCartRowTotal($ItemID)
	{
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$where = new Where();
		$where->NEST//start braket
		->equalTo('ItemID',$ItemID)
		->OR
		->equalTo('ParentItemID',$ItemID)
		->UNNEST;
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('TotalItems'=>'Count(*)',
														 'Price'=>'SUM(Price)',
														 'ActualPrice'=>'SUM(ActualPrice)',
														 'UnitPrice'=>'SUM(UnitPrice)',
														 'TaxPrice'=>'SUM(TaxPrice)',
														 'PriceWithTax'=>'SUM(PriceWithTax)',
														 'ActualPriceWithTax'=>'SUM(ActualPriceWithTax)',
														 'TotalWithTax'=>'SUM(TotalWithTax)',
														 'VoucherAmount'=>'SUM(VoucherAmount)',
														 'Total'=>'SUM(Total)'));
		return $Obj;
	}
	
	function getOrderCart($OrderID)
	{
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$where = new Where();
		$where->equalTo('OrderID',$OrderID);
		$where->NEST//start braket
				->equalTo('ParentItemID','')
				->OR
				->isNull('ParentItemID')
				->UNNEST;
		
		$OrderDetailObj->where = $where;
		//$OrderDetailObj->columnExpression=true;
		//$OrderDetailObj->displayQuery = true;
		//return  $OrderDetailObj->tableSelectAll(array("*"),array("OrderDetailID ASC"));
		return  $OrderDetailObj->tableSelectAll(array("*"),array("ItemName ASC","OrderDetailID ASC"));
	}
	
	function getOrderCartSubData($OrderID,$ItemID)
	{
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$where = new Where();
		$where->equalTo('OrderID',$OrderID);
		$where->equalTo('ParentItemID',$ItemID);
		$OrderDetailObj->where = $where;
		$OrderDetailObj->columnExpression=true;
		return  $OrderDetailObj->tableSelectAll("",array("OrderDetailID ASC"));
	}
	
	function getOrderCartRowTotal($OrderID,$ItemID)
	{
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$where = new Where();
		$where->equalTo('OrderID',$OrderID);
		$where->NEST//start braket
		->equalTo('ItemID',$ItemID)
		->OR
		->equalTo('ParentItemID',$ItemID)
		->UNNEST;
		$OrderDetailObj->where = $where;
		$OrderDetailObj->columnExpression=true;
		$Obj = (object)$OrderDetailObj->tableSelectOne(array('TotalItems'=>'Count(*)',
														 'Price'=>'SUM(Price)',
														 'ActualPrice'=>'SUM(ActualPrice)',
														 'UnitPrice'=>'SUM(UnitPrice)',
														 'TaxPrice'=>'SUM(TaxPrice)',
														 'PriceWithTax'=>'SUM(PriceWithTax)',
														 'ActualPriceWithTax'=>'SUM(ActualPriceWithTax)',
														 'TotalWithTax'=>'SUM(TotalWithTax)',
														 'VoucherAmount'=>'SUM(VoucherAmount)',
														 'Total'=>'SUM(Total)'));
		return $Obj;
	}
	
	function getCartTemplate($data,$file="default",$OrderID="",$ControllerObj = "")
	{
			if(!is_object($ControllerObj))
				$ControllerObj = new \Sale\Cart\Front\Controller\IndexController;
			
			if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php"))
				include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
			else
				include(dirname(__FILE__)."/Front/View/templates/default.php");
					
	}
	
	
	
}	