<?php 
namespace Plugin\Vimeo;
use Base\File\FileHandle as FileHandle;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class VimeoVideo extends AbstractModule
{
	var $apiID; // Api ID for your account.
	var $apiMode; // Api Mode for your account.
	var $apiToken; // Api Token for your account.
	var $apiSecret; // Api Secret for your account.
	
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	  require_once (dirname(__FILE__)."/autoload.php");
	  $this->apiID = DEFINE_VIMEO_CLIENT_ID;
	  $this->apiMode = DEFINE_VIMEO_WEBSERVICES_MODE;
	  $this->apiToken = DEFINE_VIMEO_ACCESS_TOKEN;
	  $this->apiSecret = DEFINE_VIMEO_CLIENT_SECRET;
	
	}
	
	function DownloadFile($VideoID,$Dindex="-1")
	{
	   $lib = new \Vimeo\Vimeo($this->apiID, $this->apiSecret,$this->apiToken);
		$response = $lib->request('/me/videos/'.$VideoID);
		$VimeodownloadLink = ""; 
		if(isset($response['body']['download']['0']['link']) && $response['body']['download']['0']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['0']['link'];
		elseif(isset($response['body']['download']['1']['link']) && $response['body']['download']['1']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['1']['link'];
		elseif(isset($response['body']['download']['2']['link']) && $response['body']['download']['2']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['2']['link'];
		elseif(isset($response['body']['download']['3']['link']) && $response['body']['download']['3']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['3']['link'];
		elseif(isset($response['body']['download']['4']['link']) && $response['body']['download']['4']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['4']['link'];
		elseif(isset($response['body']['download']['5']['link']) && $response['body']['download']['5']['link'] != "")
			$VimeodownloadLink = $response['body']['download']['5']['link'];
	
		if($Dindex >=0)
			$VimeodownloadLink = $response['body']['download'][$Dindex]['link'];
		
		if($VimeodownloadLink != "")
		{
			MyRedirect($VimeodownloadLink);
			exit;	
		}	
		return false;
	}
	
	function GetVideoFormatData($VideoID,$parms="download")
	{
		
	  $dir = FileHandle::CheckPrivateLogDirectory("vimeo");
	  $filename=$dir."vimeo_".$VideoID.".txt";
	  if(file_exists($filename)){
		$response =unserialize(file_get_contents($filename));
	  }
	  else{
		$lib = new \Vimeo\Vimeo($this->apiID, $this->apiSecret,$this->apiToken);
		$response = $lib->request('/me/videos/'.$VideoID);
		 if(isset($response['status']) && $response['status'] == "200"){
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($response));	
				fclose($fp2);
		 }
	  }
	 	
	   $returnArray = array();
	   if($parms=="all" && isset($response['body']) && is_array($response['body'])){
		   $returnArray = $response['body'];
		   return $returnArray;
	   }
		
	   if(isset($response['body'][$parms]) && is_array($response['body'][$parms])){
			$returnArray = $response['body'][$parms];
			return $returnArray;
	   }
		
		return $returnArray;
	}
	
	
	
}

?>