<?php 
namespace Plugin\SocialLogin;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;
use Google\Client as Google_Client;
use Google\Service\Oauth2 as Google_Service_Oauth2;

class Common extends AbstractModule
{
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	}
	
	function Init($Provider)
	{
		if(strtolower($Provider)=="google"){
			$this->GoogleRedirect();
		}
		if(strtolower($Provider)=="facebook"){
			$this->FacebookRedirect();
		}
		
	}
	
	
	function AfterLogin($Provider)
	{
		if(strtolower($Provider)=="google"){
			$this->GoogleAutentication();
		}
		if(strtolower($Provider)=="facebook"){
			$this->FacebookAutentication();
		}
		
		var_dump($Provider);exit;
	}
	
	function GoogleRedirect()
	{
		if(d("DEFINE_GOOGLE_SOCIAL_LOGIN_STATUS")=="1"){
			$clientID = d("DEFINE_GOOGLE_SOCIAL_LOGIN_CLIENTID");
			$clientSecret = d("DEFINE_GOOGLE_SOCIAL_LOGIN_CLIENTSECRET");
			$redirectUri = SKSEOURL('customer','Login','','action=SocialLoginRedirect&Provider=Google');
			   
			// create Client Request to access Google API
			$client = new Google_Client();
			$client->setClientId($clientID);
			$client->setClientSecret($clientSecret);
			$client->setRedirectUri($redirectUri);
			$client->addScope("email");
			$client->addScope("profile");
			$url = $client->createAuthUrl();
			if($url != ""){
				MyRedirect($url);				
				exit;
			}
			//http://php8.development.com/sunil/custom_cms/example/newsite/login?action=SocialLoginRedirect&Provider=Google
		}
	}
	
	function GoogleAutentication()
	{
		if(isset($_GET['code'])){
				$clientID = d("DEFINE_GOOGLE_SOCIAL_LOGIN_CLIENTID");
				$clientSecret = d("DEFINE_GOOGLE_SOCIAL_LOGIN_CLIENTSECRET");
				$redirectUri = SKSEOURL('customer','Login','','action=SocialLoginRedirect&Provider=Google');
				   
				// create Client Request to access Google API
				$client = new Google_Client();
				$client->setClientId($clientID);
				$client->setClientSecret($clientSecret);
				$client->setRedirectUri($redirectUri);
				$client->addScope("email");
				$client->addScope("profile");
			
				$token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
				$client->setAccessToken($token['access_token']);
			     // get profile info
				$google_oauth = new Google_Service_Oauth2($client);
				$google_account_info = $google_oauth->userinfo->get();
				$email =  $google_account_info->email;
				$id =  $google_account_info->id;
				$name =  explode(" ",$google_account_info->name);
				
				$DataArray = array();
				$DataArray['UserName']	= isset($google_account_info->email)?$google_account_info->email:"";
				$DataArray['Email']		= isset($google_account_info->email)?$google_account_info->email:"";
				$DataArray['FirstName']	= isset($name[0])?$name[0]:"";
				$DataArray['LastName'] 	= isset($name[1])?$name[1]:"";
				$DataArray['IPAddress'] 	= isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
				$PassSalt = md5(uniqid(rand(),true));
				$DataArray['Password'] = NeoCryptedPassword(uniqid(),$PassSalt).":".$PassSalt;
				$DataArray['ActivationCode'] 	= md5(uniqid(rand(),true));
				$DataArray['LastLogin'] 	= date("YmdHis");
				$DataArray['PrevLastLogin'] 	= date("YmdHis");
				$DataArray['CreatedDate'] 	= date("YmdHis");
				
				//$DataArray['ProviderID'] = $id;
				//$DataArray['Provider'] = "Google";
				$ExtraParam = array();
				$ExtraParam['ProviderID'] = $id;
				$ExtraParam['Provider'] = "Google";
				if(trim($DataArray['UserName']) != "")
					$this->getClass('Customer\Login\Common')->SocialLoginRegister($DataArray,$ExtraParam);
				
			
		}
	}
	
	function FacebookRedirect()
	{
		if(d("DEFINE_FACEBOOK_SOCIAL_LOGIN_STATUS")=="1"){
			$appID = d("DEFINE_FACEBOOK_SOCIAL_LOGIN_APPID");
			$appSecret = d("DEFINE_FACEBOOK_SOCIAL_LOGIN_APPSECRET");
			$redirectUri = SKSEOURL('customer','Login','','action=SocialLoginRedirect&Provider=Facebook');
			$fb = new \Facebook\Facebook([
				 'app_id' => $appID,
				 'app_secret' => $appSecret,
				 'default_graph_version' => 'v2.5',
				]);
				
				// login helper with redirect_uri
				$helper = $fb->getRedirectLoginHelper();
				$permissions = array('public_profile','email'); // Optional permissions
				$url = $helper->getLoginUrl($redirectUri, $permissions);
				
				//$accessToken = $helper->getAccessToken($redirectUri);
				//$fb->setDefaultAccessToken((string)$accessToken);
				//$this->getSession()->setVar("FACEBOOKAccessToken",$accessToken);
				if($url != ""){
					MyRedirect($url);				
					exit;
			}
			/*
			https://gurbir74.dev.wcukdev.co.uk/example/newsite/login?action=SocialLogin&Provider=Facebook
			https://gurbir74.dev.wcukdev.co.uk/example/newsite/login?action=SocialLoginRedirect&Provider=Facebook
			*/
		}
	}
	
	function FacebookAutentication()
	{
		if(isset($_GET['code'])){
				$appID = d("DEFINE_FACEBOOK_SOCIAL_LOGIN_APPID");
				$appSecret = d("DEFINE_FACEBOOK_SOCIAL_LOGIN_APPSECRET");
				$redirectUri = SKSEOURL('customer','Login','','action=SocialLoginRedirect&Provider=Facebook');
				
				$fb = new \Facebook\Facebook([
					 'app_id' => $appID,
					 'app_secret' => $appSecret,
					 'default_graph_version' => 'v2.5',
					]);
			  
			  $oAuth2Client = $fb->getOAuth2Client();
			  $accessToken = $oAuth2Client->getAccessTokenFromCode($_GET['code'],$redirectUri);
			  $longLivedAccessToken = $oAuth2Client->getLongLivedAccessToken($accessToken);
			  $fb->setDefaultAccessToken($longLivedAccessToken);
			  $graphResponse = $fb->get('/me?fields=name,first_name,last_name,email');
			  $fbUser = $graphResponse->getGraphUser();
			  /*var_dump("<hr>fbUser<hr>",$fbUser);
			  var_dump("<hr>fbUser-first_name<hr>",$fbUser['first_name']);
			  var_dump("<hr>fbUser-last_name<hr>",$fbUser['last_name']);
			  var_dump("<hr>fbUser-email<hr>",$fbUser['email']);
			  */
			  if(isset($fbUser['email']) && $fbUser['email'] != ""){
				 $DataArray = array();
					$DataArray['UserName']	= isset($fbUser['email'])?$fbUser['email']:"";
					$DataArray['Email']		= isset($fbUser['email'])?$fbUser['email']:"";
					$DataArray['FirstName']	=  isset($fbUser['first_name'])?$fbUser['first_name']:"";
					$DataArray['LastName'] 	=  isset($fbUser['last_name'])?$fbUser['last_name']:"";
					$DataArray['IPAddress'] 	= isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
					$PassSalt = md5(uniqid(rand(),true));
					$DataArray['Password'] = NeoCryptedPassword(uniqid(),$PassSalt).":".$PassSalt;
					$DataArray['ActivationCode'] 	= md5(uniqid(rand(),true));
					$DataArray['LastLogin'] 	= date("YmdHis");
					$DataArray['PrevLastLogin'] 	= date("YmdHis");
					$DataArray['CreatedDate'] 	= date("YmdHis");
					
					//$DataArray['ProviderID'] = isset($fbUser['id'])?$fbUser['id']:"";
					//$DataArray['Provider'] = "Facebook";
					$ExtraParam = array();
					$ExtraParam['ProviderID'] = isset($fbUser['id'])?$fbUser['id']:"";
					$ExtraParam['Provider'] = "Facebook";
					if(trim($DataArray['UserName']) != "")
						$this->getClass('Customer\Login\Common')->SocialLoginRegister($DataArray,$ExtraParam); 
			  }
			  
				
		}
		
	}
	
}	