<?php 
namespace Plugin\MurphysMagic;
use Base\File\FileHandle as FileHandle;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class MurphysMagic extends AbstractModule
{
	var $apikey; // Api Key for your account.
	var $ftpUser; // ftp user.
	var $ftpPassword; // ftp password.
	
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	  $this->apikey = DEFINE_MURPHYSMAGIC_DOWNLOAD_APIKEY;
	  $this->ftpUser = DEFINE_MURPHYSMAGIC_DOWNLOAD_FTPUSER;
	  $this->ftpPassword = DEFINE_MURPHYSMAGIC_DOWNLOAD_FTPPASSWORD;
	}
	
	function FetchMurphyRecord($funcs,$parms = "",$return_string="")
	{
	    $json = $this->SubmitMurphyJSON($funcs, $parms,$return_string);
			
	    if($return_string=="1")
	    {
	    	return $json;
	    }
	    // Always check for an error. A list of errors can be found in the documentation
	    if(isset($json["error"]))
	    {
	        // You'd handle the error within your UI, but for this sample, I just write it to the page
	        echo($json["error"]);
	    }
	    else
	    {
	        return $json;
	    }
	}
	
	function SubmitMurphyJSON($functionToCall, $postVars,$return_string)
	{
	    // The URL we call, plus the function name
	    $url = 'http://downloads.murphysmagic.com/api/' . $functionToCall . '/';
	     
	    // Add the APIKey to every post
	     
	    if ($postVars != "")
	        $postVars = $postVars . '&APIKey='.$this->apikey;
	    else
	        $postVars = 'APIKey='.$this->apikey;
	     
	    // Use CURL to post the form data to the API
	    $ch = curl_init( $url );
	    curl_setopt( $ch, CURLOPT_POST, 1);
	    curl_setopt( $ch, CURLOPT_POSTFIELDS, $postVars);
	    curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
	    curl_setopt( $ch, CURLOPT_HEADER, 0);
	    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
	    // Encode what is returned into a PHP array
		$return = curl_exec($ch);
	    if($return_string=="1")
	    {
	    	return $return;
	    }
	    else
	    { 
	    	return json_decode($return, true);
	    }
	}
	
	function FetchFileFromMurphyServer($ServerFile,$LocalFile)
	{
		$curl = curl_init();
		$file = fopen($LocalFile, 'w');
		curl_setopt($curl, CURLOPT_URL, $ServerFile); #input
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_FILE, $file); #output
		curl_setopt($curl, CURLOPT_USERPWD, $this->ftpUser.":".$this->ftpPassword);
		$return = curl_exec($curl);
		curl_close($curl);
		//var_dump($return);exit;
		fclose($file);
	}
	function GetExtension($type)
	{
		$ext = "";
		switch (strtolower($type)){
		case ".mp4":
		case ".m4v":
		case ".mov":
		case ".f4v":
		case ".m4a":
		case ".f4a":
		case ".aac":
			$ext = "mp4";
		break;
		case ".flv":
			$ext = "flv";
		break;
		case ".mp3":
			$ext = "mp3";
		break;
		}
		return $ext;
	}
	function processPayment($OrderID)
	{
		$CurrentOrder = $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);
		if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID != ""){
			$ProductIDArray =array();
			$MurphyIDArray =array();
			
			$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
			$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
			$cartRows = $OrderDetailObj->tableSelectAll("","OrderDetailID ASC");
			foreach($cartRows as $CurrentCartItem){	
				if($CurrentCartItem->ItemType=="Product"){
				  $ProductID = $CurrentCartItem->ReferenceID;
				  $ProductObj = new DataTable(TABLE_PRODUCT);
				  $ProductObj->where[] = array('=',array('ProductID' => $CurrentCartItem->ReferenceID));
				  $CurrentProduct = (object)$ProductObj->tableSelectOne(array("Stock","ProductID"));
				  if(isset($CurrentProduct->ProductID)){
					  $ProductIDArray[] = $CurrentCartItem->ReferenceID;
				  }
				}
			
			}
			if(isset($ProductIDArray) && is_array($ProductIDArray) && count($ProductIDArray) > 0){
				
				foreach ($ProductIDArray as $k=>$ProductID){
				
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
					$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","VirtualProduct","UploadType","FeedID"));
					if(isset($CurrentProduct->ProductID) && $CurrentProduct->VirtualProduct=="1" && $CurrentProduct->UploadType=="MurphyScriptStreaming"){
						$MurphyIDArray[] = $CurrentProduct->FeedID;
					}
					
					if(isset($MurphyIDArray) && is_array($MurphyIDArray) && count($MurphyIDArray) > 0){
						
						$params = array();
						$params["FirstName"] = isset($CurrentOrder->BillingFirstName)?$CurrentOrder->BillingFirstName:"";
						$params["LastName"] = isset($CurrentOrder->BillingLastName)?$CurrentOrder->BillingLastName:"";
						$params["email"] = isset($CurrentOrder->Email)?$CurrentOrder->Email:"";
						$params["ProductIDs"] = implode(",",$MurphyIDArray);
						$return = $this->FetchMurphyRecord("AddOrder",http_build_query($params));
					}
					
				}
				
			}	
			
		}

	}

	
}

?>