<?php
namespace Plugin\MurphysMagic;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class MMSWebService extends AbstractModule
{
	var $username, $password, $wsdl; 
	var $namespace = "http://webservices.murphysmagicsupplies.com/";	
	var $result = ""; 
	var $ErrorMessages = ""; 
	var $Success = ""; 
	
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	  $this->username = DEFINE_MURPHYSMAGIC_WEBSERVICES_USERNAME; 
	  $this->password = DEFINE_MURPHYSMAGIC_WEBSERVICES_PASSWORD; 
	  $this->wsdl = DEFINE_MURPHYSMAGIC_WEBSERVICES_URL; 
	}
	
	function CallRequest($funcs,$parameters = "")
	{
			
	   $client = new \SoapClient($this->wsdl,array('connection_timeout' => 60000)); 
	   $auth = array( 'Username'=>$this->username, 'Password'=>$this->password ); 
	   $header = new \SoapHeader($this->namespace,'SoapAuthenticationHeader',$auth,false); 
	   $client->__setSoapHeaders(array($header)); 
	   try 
	   { 
			//$result = $client->GetDownloadItemByID(array("InternalID"=>56372)); 
			/*
			$parameters = array("itemKeys"=>array(35791),
								);
			$result = $client->GetInventoryItems($parameters ); 
			$result = $client->GetInventoryItemsAvailableQuantities ($parameters ); 
			
			$parameters = array("itemKeys"=>array(35791),
								 "quantities"=>array(1),
								);
			$result = $client->SubmitSalesOrderLineItems($parameters ); 
			
			*/
			$this->result = $result = $client->{$funcs}($parameters);
			
			if(isset($result->{$funcs."Result"}->ErrorMessages->string) && $result->{$funcs."Result"}->ErrorMessages->string != "")
				$this->ErrorMessages = $result->{$funcs."Result"}->ErrorMessages->string;
		
		if(isset($result->{$funcs."Result"}->Success))
				$this->Success = $result->{$funcs."Result"}->Success;
		else
			$this->Success = false;
				
			return $result;
			
	   } 
		catch (Exception $e) 
		{
			//printf("Soap Fault: %s\n", $e); 
		} 
		if(isset($response->ErrorMessages->string) && $response->ErrorMessages->string != "")
		{
				//echo "ERROR: ". $response->ErrorMessages->string;
		
		}
	
	}
	
	function GetResult()
	{
	  return $this;
	}
	
	function processPayment($OrderID)
	{
		$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
		$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
		$cartRows = $OrderDetailObj->tableSelectAll("","OrderDetailID ASC");
		foreach($cartRows as $CurrentCartItem){	
			if($CurrentCartItem->ItemType=="Product"){
			  $ProductID = $CurrentCartItem->ReferenceID;
			  $ProductObj = new DataTable(TABLE_PRODUCT);
			  $ProductObj->where[] = array('=',array('ProductID' => $CurrentCartItem->ReferenceID));
			  $ProductObj->where[] = array('=',array('UploadType' => "MurphyScript"));
			  $CurrentProduct = (object)$ProductObj->tableSelectOne(array("Stock","ProductID","FeedID","UploadType"));
			  if(isset($CurrentProduct->ProductID)){
				  
				$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
				$OrderMurphyObj->where[] = array('=',array('OrderDetailID' => $CurrentCartItem->OrderDetailID));
				$OrderMurphyObj->where[] = array('=',array('OrderID' => $OrderID));
				$MurphyItem = (object)$OrderMurphyObj->tableSelectOne();
				if(!isset($MurphyItem->OrderDetailID)){
					$DataArray= array();
					$DataArray['OrderID'] = $OrderID;
					$DataArray['OrderDetailID'] = $CurrentCartItem->OrderDetailID;
					$DataArray['MurphyProductID'] = $CurrentProduct->FeedID;
					$DataArray['MurphyProductQty'] = $CurrentCartItem->Qty;
					$DataArray['Status'] = "Pending";
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
					$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
					$OrderMurphyObj->tableInsert($DataArray);
				}
				  
			  }
			}
		}
		
		/* MurphyScript Product start*/
		$MurphyData['itemKeys'] = $MurphyData['quantities'] = array();
		$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
		$OrderMurphyObj->where[] = array('=',array('Status' => 'Pending'));
		$OrderMurphyObj->where[] = array('=',array('OrderID' => $OrderID));
		$murphyRows = $OrderMurphyObj->tableSelectAll("","OrderDetailID ASC");
		foreach($murphyRows as $CurrentMurphyItem){
			array_push($MurphyData['itemKeys'],$CurrentMurphyItem->MurphyProductID);
			array_push($MurphyData['quantities'],$CurrentMurphyItem->MurphyProductQty);
		}
		
		if(is_array($MurphyData['itemKeys']) && count($MurphyData['itemKeys']) > 0){
			$parameters = array("itemKeys"=>$MurphyData['itemKeys'],
								 "quantities"=>$MurphyData['quantities'],
								);
			$return  = $this->CallRequest("SubmitSalesOrderLineItems",$parameters);
			if(isset($this->Success) && $this->Success === true && isset($return->salesOrderNumber)){
				$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
				$OrderMurphyObj->where[] = array('=',array('Status' => 'Pending'));
				$OrderMurphyObj->where[] = array('=',array('OrderID' => $OrderID));
				$DataArray= array();
				$DataArray['MurphyOrderNumber'] = $return->salesOrderNumber;
				$DataArray['MurphyOrderTotal'] = $return->salesOrderTotal;
				$DataArray['Status'] = "Done";
				$OrderMurphyObj->tableUpdate($DataArray);
			}
			if(isset($this->ErrorMessages) && $this->ErrorMessages!= ""){
				$OrderMurphyObj = new DataTable(TABLE_ORDER_MURPHY);
				$OrderMurphyObj->where[] = array('=',array('OrderID' => $OrderID));
				$DataArray= array();
				$DataArray['MurphyOrderTotal'] = $obj->ErrorMessages;
				$OrderMurphyObj->tableUpdate($DataArray);
			}
		}
		/* MurphyScript Product end*/
		
	}
	
}

?>
