<?php 
namespace Plugin\ContinentalClothing;
use Base\File\FileHandle as FileHandle;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;
use Box\Spout\Reader\Common\Creator\ReaderEntityFactory;
class ProductImport extends AbstractModule
{
	var $apiBaseURL; // Api Key for your account.
	var $ftpUser; // ftp user.
	var $ftpPassword; // ftp password.
	var $ftpHost; // ftp password.
	var $Obj; // ftp password.
	
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	  $this->apiBaseURL = DEFINE_CONTINENTALCLOTHING_WEBSERVICES_URL;
	  $this->apikey = DEFINE_CONTINENTALCLOTHING_WEBSERVICES_APIKEY;
	  $DBObj = new DataTable(TABLE_SUPPLIERS);
	  $DBObj->where[] = array('=',array('SuppierCode' => 'CC'));
	  $this->Obj  = (object)$DBObj->tableSelectOne(array("*"));
	  
	}
	
	function PriceIncrease($Price)
	{
		if($this->Obj->PriceIncrease > 0 && $Price > 0){
			$FinalPrice = $Price + ($this->Obj->PriceIncrease*$Price/100);
			return $FinalPrice;
		}
		return $Price;
		
	}
	function FetchRecord($funcs,$parms = "",$LocalFile="")
	{
	    $json = $this->SubmitJSON($funcs, $parms);
		if(isset($json["error"])){
	        return $json;
	    }
	    else
	    {
	        $fp = fopen($LocalFile, 'w');
			fwrite($fp, $json);
			fclose($fp);
			return $json;
	    }
	}
	
	function SubmitJSON($functionToCall,$Vars,$method="GET")
	{
	    // The URL we call, plus the function name
	    $url = $this->apiBaseURL.'api/v2/' . $functionToCall . '/';
	     
	    // Add the APIKey to every post
	     
	    if ($Vars != "")
	        $Vars = $Vars . '&api_key='.$this->apikey;
	    else
	        $Vars = 'api_key='.$this->apikey;
	     
		$url = $this->apiBaseURL.'api/v2/' . $functionToCall . '/';
		
		 if(strtoupper($method)=="GET")
			$url = $this->apiBaseURL.'api/v2/' . $functionToCall . '?'.$Vars;
		
		// Use CURL to post the form data to the API
	    $ch = curl_init( $url );
	    if(strtoupper($method)=="POST"){
			curl_setopt( $ch, CURLOPT_POST, 1);
			curl_setopt( $ch, CURLOPT_POSTFIELDS, $Vars);
	   }
		
		curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
	    curl_setopt( $ch, CURLOPT_HEADER, 0);
	    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
	    // Encode what is returned into a PHP array
		$return = curl_exec($ch);
		if(curl_errno($ch)){
			$return = array("error"=>true,
						 "error_no"=>curl_errno($ch),
						 "error_msg"=>curl_error($ch),
						 "return"=>$return
						 );
		}
		return $return;
	    
	}
	
	
	function uploadImage($src,$filename) 
	{
		if(file_exists($filename)){
			//return basename($src);
		}
		else{
			$size = getimagesize($src);
			$extension = "";
			switch(strtolower($size['mime']))
			{
				case "image/jpeg":
					$extension = ".jpg";
					break;
				case "image/gif":
					$extension = ".gif";
					break;
				case "image/png":
					$extension = ".png";
					break;
				case "image/bmp":
					$extension = ".bmp";
					break;
			}
			
			//if($extension != "" && isset($size[0]) && $size[0] > 0)
			if(true)
			{
				$ch = curl_init ($src);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		
				$raw=curl_exec($ch);
				
				curl_close ($ch);
				if(curl_errno($ch)){
					//var_dump(curl_errno($ch),curl_error($ch));
					//exit;
				}
				if(!file_exists($filename)){
					$fp = fopen($filename,'x');
					fwrite($fp, $raw);
					fclose($fp);
					
				}
				//return basename($src);
			}
		}
		
		return "0";

	}
	
	
}
