<?php 
namespace Plugin\ContinentalClothing;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;
use Plugin\ContinentalClothing\ProductImport;

class CronController extends AbstractModule
{
	function __construct()
	{
		$this->ProductImport = new ProductImport();
						
	}
	
	
	public function ImportCCProductAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$ccdir = FileHandle::CheckPrivateLogDirectory("cron/cc");
		$filename=$ccdir."cc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("CC_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"CC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="CCFile";
				$Params['Action']="DownloadFull";
				$Params['StartPoint']="0";				
			}
			$CurrencyValue = $this->getClass('Base\Currency\CurrencyHandler')->GetCurrencyRateFromDB("USD","GBP","1");
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download CCFile file start*/
			$CCFile=$ccdir."all_products.json";
			if($Params['Section']=="CCFile" && $Params['Action']=="DownloadFull"){
				if(file_exists($CCFile)==false)
				{
					fputs($fp2,"CCFile ".$UniqueID."= START Download all_products.json ".chr(13));	
					$d_return = $this->ProductImport->FetchRecord("styles","",$CCFile);
					if(isset($d_return['error'])){
						fputs($fp2,"Download Fail CCFile ".$UniqueID."=".print_r($d_return,true).chr(13));
						if(file_exists($CCFile))
							unlink($CCFile);
						
					}
					fputs($fp2,"CCFile ".$UniqueID."= END Download all_products.json ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportFull ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="CCFile";
					$Params['Action']="ImportFull";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download CCFile file end*/
			
			
			/* ImportFull CCFile file start*/
			if($Params['Section']=="CCFile" && $Params['Action']=="ImportFull"){
				$CCFile=$ccdir."all_products.json";
				if(file_exists($CCFile))
				{
					$jsondata = file_get_contents($CCFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr as $k=>$ProductArr){
						$RowSNo++;
						if($RowSNo >= $StartPoint){
							$ProductID = $this->CCImportProduct($ProductArr);
							//var_dump("<pre>",$ProductArr);exit;
							fputs($fp2,"CC ".$UniqueID."Product  =".print_r($ProductID,true).chr(13));	
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['StartPoint']=$RowSNo;		
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
						}
						
					}
					
					fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
					rename($CCFile,$ccdir."all_products_".date('Y-m-d-His').".json");
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$DataArray = array();
					$DataArray['CronDate'] = date('Y-m-d',strtotime("+5 day"));
					$DataArray['CronStatus'] = "Pending";
					$DataArray['Params'] = "";
					$CronObj->tableUpdate($DataArray);
					exit;
				}
				else
				{
					
				}
			}
			/* ImportFull CCFile file end*/
			

			
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$CCFile=$ccdir."all_products.json";
			if(file_exists($CCFile))
				@unlink($CCFile);	
			
		}

		fputs($fp2,"CC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		
	}
	
	public function ImportCCAttributeAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$ccdir = FileHandle::CheckPrivateLogDirectory("cron/cc");
		$filename=$ccdir."cc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("CC_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"CC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="CCFile";
				$Params['Action']="DownloadAttribute";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download CCFile file start*/
			$CCColorFile=$ccdir."attribute_color.json";
			$CCSizeFile=$ccdir."attribute_size.json";
			$CCFabricFile=$ccdir."attribute_fabric.json";
			if($Params['Section']=="CCFile" && $Params['Action']=="DownloadAttribute"){
				if(file_exists($CCColorFile)==false || file_exists($CCSizeFile)==false || file_exists($CCFabricFile)==false)
				{
					fputs($fp2,"CCFile ".$UniqueID."= START Download attribute_color.json ".chr(13));	
					$this->ProductImport->FetchRecord("attributes","attribute=Colour",$CCColorFile);
					$this->ProductImport->FetchRecord("attributes","attribute=Size",$CCSizeFile);
					$this->ProductImport->FetchRecord("attributes","attribute=Fabric",$CCFabricFile);
					
					fputs($fp2,"CCFile ".$UniqueID."= END Download attribute_color.json ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportAttribute ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="CCFile";
					$Params['Action']="ImportAttribute";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download CCFile file end*/
			
			
			/* ImportAttribute CCFile file start*/
			if($Params['Section']=="CCFile" && $Params['Action']=="ImportAttribute"){
				
				$CCColorFile=$ccdir."attribute_color.json";
				$CCSizeFile=$ccdir."attribute_size.json";
				$CCFabricFile=$ccdir."attribute_fabric.json";
			
				if(file_exists($CCColorFile))
				{
					$jsondata = file_get_contents($CCColorFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr['values'] as $k=>$AttributeArr){
						$this->CCImportAttribute("101",$AttributeArr);
					}
					rename($CCColorFile,$ccdir."attribute_color_".date('Y-m-d-His').".json");
					
				}
				
				if(file_exists($CCSizeFile))
				{
					$jsondata = file_get_contents($CCSizeFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr['values'] as $k=>$AttributeArr){
						$this->CCImportAttribute("102",$AttributeArr);
					}
					rename($CCSizeFile,$ccdir."attribute_size_".date('Y-m-d-His').".json");
				}
				
				if(file_exists($CCFabricFile))
				{
					$jsondata = file_get_contents($CCFabricFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr['values']['source'] as $k=>$FilterArr){
						$this->CCImportFilter("103",$FilterArr);
					}
					rename($CCFabricFile,$ccdir."attribute_fabric_".date('Y-m-d-His').".json");
				}
				
				fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d',strtotime("+4 day"));
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$CronObj->tableUpdate($DataArray);
				
			}
			/* ImportAttribute CCFile file end*/
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$CCColorFile=$ccdir."attribute_color.json";
			$CCSizeFile=$ccdir."attribute_size.json";
			$CCFabricFile=$ccdir."attribute_fabric.json";
			
			if(file_exists($CCColorFile))
				@unlink($CCColorFile);	
			if(file_exists($CCSizeFile))
				@unlink($CCSizeFile);	
			if(file_exists($CCFabricFile))
				@unlink($CCFabricFile);	
			
		}

		fputs($fp2,"CC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		
	}
	
	
	public function CCImportAttribute($AttributeID,$AttributeArr)
	{
		https://www.continentalclothing.com/assets/swatches/WH.jpg
		$AttributeValue = isset($AttributeArr['name']['en-UK'])?$AttributeArr['name']['en-UK']:"";
		if($AttributeValue != ""){
			$DBObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
			$where = new Where();
			$where->equalTo('AttributeID',$AttributeID);
			$where->equalTo('AttributeValue',trim($AttributeValue));
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("AttributeValueID"),"AttributeValueID ASC");
			if(isset($Singleobj->AttributeValueID)){
				$AObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
				$AObj->where = "AttributeValueID = '".$Singleobj->AttributeValueID."'";
				$SubDataArray = array();
				$SubDataArray['FeedID'] =isset($AttributeArr['_id'])?$AttributeArr['_id']:"";
				$SubDataArray['FeedType'] ="FeedCC";
				$SubDataArray['DumpData'] =serialize($AttributeArr);
				$AObj->tableUpdate($SubDataArray);
			}
			else{
				
				$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
				$SubDataArray = array();
				$Image = "cc-".basename($AttributeArr['images'][0]);
				if($Image != ""){
					$imgdir = FileHandle::CheckUploadLogDirectory("attribute");
					$ImagePath=$imgdir.$Image;
						
					if(!file_exists($ImagePath)){
						$IMAGE_URL = "https://www.continentalclothing.com/assets/swatches/".basename($AttributeArr['images'][0]);
						$this->ProductImport->uploadImage($IMAGE_URL,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							$ImageAltText = $AttributeValue;
							$SubDataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_attribute","attribute",$ImageAltText);
						}
						else{
							unlink($ImagePath);
						}
					}
				}
				$SubDataArray['AttributeValue'] =trim($AttributeValue);
				$SubDataArray['AttributeLine'] =isset($AttributeArr['pmsCode'])?$AttributeArr['pmsCode']:"";
				$SubDataArray['ColorCode'] =isset($AttributeArr['hexCode'])?$AttributeArr['hexCode']:"";
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['AttributeID'] =$AttributeID;
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedID'] =isset($AttributeArr['_id'])?$AttributeArr['_id']:"";
				$SubDataArray['FeedType'] ="FeedCC";
				$SubDataArray['DumpData'] =serialize($AttributeArr);
				$AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
			}
			
		}
	}
	public function CCImportFilter($FilterID,$FilterArr)
	{
		https://www.continentalclothing.com/assets/swatches/WH.jpg
		$FilterValue = isset($FilterArr['name']['en-UK'])?$FilterArr['name']['en-UK']:"";
		if($FilterValue != ""){
			$DBObj = new DataTable(TABLE_FILTER_VALUE);
			$where = new Where();
			$where->equalTo('FilterID',$FilterID);
			$where->equalTo('FilterValue',trim($FilterValue));
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("FilterValueID"),"FilterValueID ASC");
			if(!isset($Singleobj->FilterValueID)){
				
				$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
				$SubDataArray = array();
				$Image = "cc-".basename($FilterArr['images'][0]);
				if($Image != ""){
					$imgdir = FileHandle::CheckUploadLogDirectory("attribute");
					$ImagePath=$imgdir.$Image;
						
					if(!file_exists($ImagePath)){
						$IMAGE_URL = "https://www.continentalclothing.com/assets/swatches/".basename($FilterArr['images'][0]);
						$this->ProductImport->uploadImage($IMAGE_URL,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							$ImageAltText = $FilterValue;
							$SubDataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_attribute","attribute",$ImageAltText);
						}
						else{
							unlink($ImagePath);
						}
					}
				}
				$SubDataArray['FilterValue'] =trim($FilterValue);
				$SubDataArray['FilterLine'] =isset($FilterArr['code'])?$FilterArr['code']:"";
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['FilterID'] =$FilterID;
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedID'] =isset($FilterArr['_id'])?$FilterArr['_id']:"";
				$SubDataArray['FeedType'] ="FeedCC";
				$SubDataArray['DumpData'] =serialize($FilterArr);
				$FilterValueID = $FilterValueObj->tableInsert($SubDataArray);
			}
			
		}		
	}
	
	public function ImportCCCategoryAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$ccdir = FileHandle::CheckPrivateLogDirectory("cron/cc");
		$filename=$ccdir."cc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("CC_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"CC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="CCFile";
				$Params['Action']="DownloadCategory";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download CCFile file start*/
			$CCCatFile=$ccdir."category_main.json";
			if($Params['Section']=="CCFile" && $Params['Action']=="DownloadCategory"){
				if(file_exists($CCCatFile)==false)
				{
					fputs($fp2,"CCFile ".$UniqueID."= START Download category_main.json ".chr(13));	
					$this->ProductImport->FetchRecord("categories","",$CCCatFile);
					fputs($fp2,"CCFile ".$UniqueID."= END Download category_main.json ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportCategory ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="CCFile";
					$Params['Action']="ImportCategory";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download CCFile file end*/
			
			
			/* ImportCategory CCFile file start*/
			if($Params['Section']=="CCFile" && $Params['Action']=="ImportCategory"){
				
				$CCCatFile=$ccdir."category_main.json";
				if(file_exists($CCCatFile))
				{
					$jsondata = file_get_contents($CCCatFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr as $k=>$CategoryArr){
						$this->CCImportCategory("1",$CategoryArr);
					}
					rename($CCCatFile,$ccdir."category_main_".date('Y-m-d-His').".json");
				}
				
				
				
				fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d',strtotime("+4 day"));
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$CronObj->tableUpdate($DataArray);
				
			}
			/* ImportCategory CCFile file end*/
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$CCCatFile=$ccdir."category_main.json";
			
			if(file_exists($CCCatFile))
				@unlink($CCCatFile);	
			
		}

		fputs($fp2,"CC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		
	}
	
	public function CCImportCategory($ParentID,$CategoryArr)
	{
		$CategoryValue = isset($CategoryArr['name']['en-UK'])?$CategoryArr['name']['en-UK']:"";
		
		if($CategoryValue != ""){
			
			$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
			$where = new Where();
			$where->equalTo('ParentID',"1");
			$where->equalTo('CategoryName',trim($CategoryValue));
			$Obj->where = $where;
			$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
			if(isset($Cobj->CategoryID) && $Cobj->CategoryID != ""){
				$CategoryID = $Cobj->CategoryID; 	
				
				$CategoryObj = new DataTable(TABLE_CATEGORY);
				$SubDataArray = array();
				$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$SubDataArray['FeedID'] =isset($CategoryArr['_id'])?$CategoryArr['_id']:"";
				$SubDataArray['FeedType'] ="FeedCC";
				$SubDataArray['DumpData'] =serialize($CategoryArr);
				$CategoryObj->tableUpdate($SubDataArray);
				
			}
			else{
				
				$CategoryObj = new DataTable(array('c'=>TABLE_CATEGORY));
				$DataArray = array();
				$DataArray['ParentID'] = "1";
				$DataArray['Active'] = "1";
				$DataArray['TopMenu'] = "1";
				$DataArray['CategoryName'] = trim($CategoryValue);
				$DataArray['CategoryTitle'] = trim($CategoryValue);
				$DataArray['CategoryCode'] = trim($CategoryValue);
				$CategoryObj->where ="ParentID='1'";
				$DataArray['Position'] = $CategoryObj->getMax("Position") + 1;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$DataArray['FeedID'] =isset($CategoryArr['_id'])?$CategoryArr['_id']:"";
				$DataArray['FeedType'] ="FeedCC";
				$DataArray['DumpData'] =serialize($CategoryArr);
				$CategoryID = $CategoryObj->tableInsert($DataArray);
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				$DataArray = array();
				$DataArray['MetaTitle'] =$CategoryValue." - Collections";
				$DataArray['MetaKeyword'] =$CategoryValue;
				$DataArray['MetaDescription'] ="";
			
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
					$URL = 	SkURLCreate($CategoryValue);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
					$DataArray['URLName'] = $URL;
					//$SeoObj->tableUpdate($DataArray);
				}
				else{
					
					$URL = 	SkURLCreate($CategoryValue);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
					$DataArray['URLName'] = $URL;			
					$DataArray['MCode'] = "catalog_category";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $CategoryID;
					$SeoObj->tableInsert($DataArray);
				}
				
			}
		}
	}
	
	public function ImportCCPriceAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$ccdir = FileHandle::CheckPrivateLogDirectory("cron/cc");
		$filename=$ccdir."cc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("CC_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"CC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="CCFile";
				$Params['Action']="DownloadPrice";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download CCFile file start*/
			$CCPriceFile=$ccdir."pricelist.json";
			if($Params['Section']=="CCFile" && $Params['Action']=="DownloadPrice"){
				if(file_exists($CCPriceFile)==false)
				{
					fputs($fp2,"CCFile ".$UniqueID."= START Download pricelist.json ".chr(13));	
					$this->ProductImport->FetchRecord("pricelist","",$CCPriceFile);
					fputs($fp2,"CCFile ".$UniqueID."= END Download pricelist.json ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportPrice ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="CCFile";
					$Params['Action']="ImportPrice";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download CCFile file end*/
			
			
			/* ImportPrice CCFile file start*/
			if($Params['Section']=="CCFile" && $Params['Action']=="ImportPrice"){
				
				$CCPriceFile=$ccdir."pricelist.json";
				if(file_exists($CCPriceFile))
				{
					$jsondata = file_get_contents($CCPriceFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr as $k=>$PriceArr){
						$this->CCImportPrice($PriceArr);
					}
					rename($CCPriceFile,$ccdir."pricelist_".date('Y-m-d-His').".json");
				}
				
				
				
				fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d',strtotime("+2 day"));
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$CronObj->tableUpdate($DataArray);
				
			}
			/* ImportPrice CCFile file end*/
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$CCPriceFile=$ccdir."pricelist.json";
			
			if(file_exists($CCPriceFile))
				@unlink($CCPriceFile);	
			
		}

		fputs($fp2,"CC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		
	}
	
	public function CCImportPrice($PriceArr)
	{
		if(isset($PriceArr['sku']) && $PriceArr['sku'] != ""){
			$checkProduct = $this->checkProductbySKU($PriceArr['sku']);
			$ChildProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"";
			if($ChildProductID > 0){
				/* ProductPrice entry start*/
				$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
				$UserTypeID ='1';
				$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".$UserTypeID."' AND 
										   (QtyMin='0' OR QtyMin='1')";
				$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
				$DataArray = array();
				$DataArray['Price'] = (isset($PriceArr['price1']) && $PriceArr['price1'] !="")?$this->ProductImport->PriceIncrease($PriceArr['price1']):"0";
				$DataArray['SalePrice'] = "0";
				$DataArray['SaleActive'] = "0";
				
				if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
				{
					$ProductPriceObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['QtyMin'] = "0";
					$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$DataArray['PriceType'] = 'Unit';
					$DataArray['UserTypeID'] = $UserTypeID;
					$DataArray['ProductID'] = $ChildProductID;
					$ProductPriceObj->tableInsert($DataArray);
				}
				
				/* ProductPriceObj entry end*/
			}
			
			
		}
	}
	
	public function ImportCCStockAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$ccdir = FileHandle::CheckPrivateLogDirectory("cron/cc");
		$filename=$ccdir."cc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("CC_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"CC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="CCFile";
				$Params['Action']="DownloadStock";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download CCFile file start*/
			$CCStockFile=$ccdir."allstock.json";
			if($Params['Section']=="CCFile" && $Params['Action']=="DownloadStock"){
				if(file_exists($CCStockFile)==false)
				{
					fputs($fp2,"CCFile ".$UniqueID."= START Download allstock.json ".chr(13));	
					$this->ProductImport->FetchRecord("allstock","",$CCStockFile);
					fputs($fp2,"CCFile ".$UniqueID."= END Download allstock.json ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportStock ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="CCFile";
					$Params['Action']="ImportStock";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download CCFile file end*/
			
			
			/* ImportStock CCFile file start*/
			if($Params['Section']=="CCFile" && $Params['Action']=="ImportStock"){
				
				$CCStockFile=$ccdir."allstock.json";
				if(file_exists($CCStockFile))
				{
					$jsondata = file_get_contents($CCStockFile);
					$FullArr = json_decode($jsondata,true);
					$TotalRow = count($FullArr);
					$StartPoint = $Params['StartPoint'];
					$RowSNo =0;
					foreach($FullArr as $k=>$StockArr){
						$this->CCImportStock($StockArr);
					}
					rename($CCStockFile,$ccdir."allstock_".date('Y-m-d-His').".json");
				}
				
				
				
				fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$CronObj->tableUpdate($DataArray);
				
			}
			/* ImportStock CCFile file end*/
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$CCStockFile=$ccdir."allstock.json";
			
			if(file_exists($CCStockFile))
				@unlink($CCStockFile);	
			
		}

		fputs($fp2,"CC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		
	}
	
	public function CCImportStock($StockArr)
	{
		if(isset($StockArr['sku']) && $StockArr['sku'] != ""){
			$checkProduct = $this->checkProductbySKU($StockArr['sku']);
			$ChildProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"";
			$MasterID = isset($checkProduct->MasterID)?$checkProduct->MasterID:"";
			$ProductObj = new DataTable(TABLE_PRODUCT);
			if($ChildProductID > 0){
				
				$DataArray = array();
				$DataArray['Stock'] = ($StockArr['stock'] > 0)?$StockArr['stock']:0;
				$DataArray['StockStatus'] = "1";
				$DataArray['StockTotal'] = ($StockArr['stock'] > 0)?$StockArr['stock']:0;
				$DataArray['Active'] ="0";
				
				if($DataArray['Stock'] > 0){
				  $DataArray['Active'] ="1";
				  if($MasterID > 0){
					
					$MasterArray = array();
					$MasterArray['Active'] ="1";
					$MasterObj = new DataTable(TABLE_PRODUCT);  
					$MasterObj->where[] = array('=',array('ProductID' => $MasterID));
					$MasterObj->tableUpdate($MasterArray);
				
				  }
				  
				}
				
				$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
				$ProductObj->tableUpdate($DataArray);
				
			}
			
		}
	}
	
	public function CCImportProduct($ProductArr)
	{
		/*
		https://www.continentalclothing.com/assets/drawings/COR19.jpg
		*/
		if(isset($ProductArr["_id"]) && $ProductArr["_id"] != ""){
			$checkMaster = $this->CCMasterProductbySKU($ProductArr["_id"],$ProductArr);
			$MasterID = isset($checkMaster->ProductID)?$checkMaster->ProductID:"";
			
		}
		return $MasterID;
		
		
	}
	public function CCMasterProductbySKU($ModelNo,$ProductArr)
	{
		$ImageArray = array();
		$imgk =1;
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$where = new Where();
		$where->equalTo('UploadType','FeedCC');
		$where->equalTo('FeedID',$ModelNo);
		//$ProductObj->displayQuery = true;
		$ProductObj->where = $where;
		$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName"));
		
		
		
		$UpdateRecord = $NewRecord = false;
		if(isset($Obj->ProductID)){
			$ProductID = $Obj->ProductID;
			$UpdateRecord = true;
		}
		else{
			$NewRecord = true;
		}
		
		if($NewRecord===true || $UpdateRecord==true){
			
			$BrandID = $this->CCGetBrandID("Continental",$ProductArr);
			$CategoriesIDs = $this->CCGetCategoryIDs($ProductArr);
			if(isset($ProductArr['images'])){
				/*
				https://www.continentalclothing.com/assets/drawings/COR19.jpg
				https://www.continentalclothing.com/assets/cropped/high_res/BAM01.jpg
				*/
				if(isset($ProductArr['images']['cropped']) && count($ProductArr['images']['cropped']) > 0){
					foreach($ProductArr['images']['cropped'] as $image){
						if(!isset($ImageArray['MainImage']))
							$ImageArray['MainImage'] = array("image"=>$image,"alt"=>$ModelNo."-0".$imgk++);
						else
						 $ImageArray[md5($image)] = array("image"=>$image,"alt"=>$ModelNo."-0".$imgk++);
					}
				}
				
			}
			$DataArray = array();
			$ProductName = "Continental ".(isset($ProductArr['name']['en-UK'])?$ProductArr['name']['en-UK']:"");
			$DataArray['ModelNo'] = $ModelNo;
			$DataArray['ProductName'] = $ProductName;
			$DataArray['BrandID'] = ($BrandID > 0)?$BrandID:"0";
			$DataArray['LargeDescription'] = (isset($ProductArr['description']['en-UK'])?$ProductArr['description']['en-UK']:"");
			$DataArray['DumpData'] = serialize($ProductArr);
			if($UpdateRecord==true){
				$ProductObj->tableUpdate($DataArray);
			}
			else{
				
				
				$DataArray['Active'] = $ProductArr['archived']===false?1:0;
				$DataArray['StockStatus'] = "1";
				$DataArray['EndStock'] = "0";
				$DataArray['StockTotal'] = "0";
				$DataArray['Stock'] = "0";
				
				$DataArray['UploadType'] = "FeedCC";
				$DataArray['FeedID'] = $ModelNo;
				$DataArray['ProductType'] = "Attribute";
				$DataArray['ProductAttribute'] = "101,102";
				$DataArray['MasterID'] = "0";
				$DataArray['SupplierID'] = "2";
				$DataArray['TaxClass'] = "1";
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$ProductID = $ProductObj->tableInsert($DataArray);
				
				/* SEO START*/
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$ProductID." AND MCode ='catalog_product' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$SeoArray = array();
				$URL = 	SkURLCreate($ProductName." ".$ModelNo);
				$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_product','Detail',$ProductID);
				$SeoArray['URLName'] = $URL;
				
				if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
				{
					$SeoArray['MetaTitle'] = $ProductName." ".$ModelNo;
					$SeoArray['MetaKeyword'] = $ProductName.",".$ModelNo;
					$SeoArray['MetaDescription'] = strip_tags($DataArray['LargeDescription']);
				}
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($SeoArray);
				}
				else 
				{
					$SeoArray['MCode'] = "catalog_product";
					$SeoArray['MView'] = "Detail";
					$SeoArray['ReferenceID'] = $ProductID;
					$SeoObj->tableInsert($SeoArray);
				}
				/* SEO END*/
				
				
				
			}
			if($ProductID > 0){
				
				
				/* ProductPrice entry start*/
				$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
				$UserTypeID ='1';
				$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
										   (QtyMin='0' OR QtyMin='1')";
				$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
				$PriceArray = array();
				$PriceArray['Price'] = "0";
				$PriceArray['SalePrice'] = "0";
				$PriceArray['SaleActive'] = "0";
				
				if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
				{
					$ProductPriceObj->tableUpdate($PriceArray);
				}
				else 
				{
					$PriceArray['QtyMin'] = "0";
					$PriceArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$PriceArray['PriceType'] = 'Unit';
					$PriceArray['UserTypeID'] = $UserTypeID;
					$PriceArray['ProductID'] = $ProductID;
					$ProductPriceObj->tableInsert($PriceArray);
				}
				
				/* ProductPriceObj entry end*/
				
				
				$this->AddAddditionalImages($ProductID,$ImageArray);
				$this->AssignCategories($ProductID,$CategoriesIDs);
				$this->AddChildren($ProductID,$ProductArr);
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$where = new Where();
				$where->equalTo('UploadType','FeedCC');
				$where->equalTo('FeedID',$ModelNo);
				//$ProductObj->displayQuery = true;
				$ProductObj->where = $where;
				$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
				return $Obj;
				
			}
			
		}
	}
	
	public function AddChildren($MasterID,$ProductArr)
	{
		
		if(isset($ProductArr['colours']) && count($ProductArr['colours']) > 0){
			foreach($ProductArr['colours'] as $ColorFeedID=>$SizeArray){
				if(is_array($SizeArray) && count($SizeArray) > 0){
					foreach($SizeArray as $k=>$AttArr){
						$ChildModelMo = isset($AttArr['sku'])?$AttArr['sku']:"";
						if($ChildModelMo != ""){
							$ProductObj = new DataTable(TABLE_PRODUCT);
							$where = new Where();
							$where->equalTo('ProductType','Child');
							$where->equalTo('UploadType','FeedCC');
							$where->equalTo('MasterID',$MasterID);
							$where->equalTo('FeedID',$ChildModelMo);
							//$ProductObj->displayQuery = true;
							$ProductObj->where = $where;
							$checkProduct  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
							$ChildProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
							$AttributeArr = $this->CCAttributes($ColorFeedID,$AttArr['size_code_id'],$ChildProductID);
							if(isset($AttributeArr[101]) && isset($AttributeArr[102])){
								
								if($ChildProductID==0){
									$ProductObj = new DataTable(TABLE_PRODUCT);
									$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
									$Position = $ProductObj->getMax("Position") + 1;
									$SubDataArray = array();
									$SubDataArray['StockStatus'] = "1";
									$SubDataArray['EndStock'] = "1";
									$SubDataArray['StockTotal'] = "0";
									$SubDataArray['Stock'] = "0";
									$SubDataArray['ProductType'] = 'Child';
									$SubDataArray['UploadType'] = 'FeedCC';
									$SubDataArray['MasterID'] = $MasterID;
									$SubDataArray['FeedID'] = $ChildModelMo;
									$SubDataArray['Position'] = $Position;
									$SubDataArray['ModelNo'] = $ChildModelMo;
									$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
									$ChildProductID = $ProductObj->tableInsert($SubDataArray);		
									
								}
								if($ChildProductID > 0){
									
									
									$SubDataArray = array();
									$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
									$ProductRelationObj->where = "RelationType='attribute_child' and 
																  ProductID='".(int)$ChildProductID."'";
									$ProductRelationObj->tableDelete();	
									
									$ProductAttribute = "";
									$ProductAttributeString = "Continental ".(isset($ProductArr['name']['en-UK'])?$ProductArr['name']['en-UK']:"")." - Colour: ".$ColorFeedID." - Size: ".$AttArr['size_code_id'];
									$ModelNoString = $ProductArr["_id"];
									foreach($AttributeArr as $AttributeID=>$AttributeValueID){
										$ProductAttribute .= $AttributeID."=".$AttributeValueID.", ";
										$ModelNoString .= "___".$AttributeValueID;

										$AttDataArray = array();
										$AttDataArray['ProductID'] = $ChildProductID;
										$AttDataArray['RelationID'] = $AttributeValueID;
										$AttDataArray['RelationType'] = "attribute_child";
										$AttDataArray['Custom'] = $AttributeID;
										$ProductRelationObj->tableInsert($AttDataArray);
										
									}
									
									$SubDataArray['ProductAttribute'] = substr($ProductAttribute,0,-2); 
									$SubDataArray['ProductName'] = $ProductAttributeString;
									$SubDataArray['SmallDescription'] = $ProductAttributeString;
									$SubDataArray['ProductLine'] = $ModelNoString;
									$SubDataArray['Active'] = ($AttArr['on_sale']==true)?"1":"0";
									$SubDataArray['FeedBarcode'] = "";
									$SubDataArray['FeedGtin'] = "";
									$SubDataArray['DumpData'] = serialize($$AttArr);
								
									$ProductObj = new DataTable(TABLE_PRODUCT);
									$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
									$ProductObj->tableUpdate($SubDataArray);
									
									/* ProductPrice entry start*/
									$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
									$UserTypeID ='1';
									$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".$UserTypeID."' AND 
															   (QtyMin='0' OR QtyMin='1')";
									$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
									$DataArray = array();
									$DataArray['Price'] = "0";
									$DataArray['SalePrice'] = "0";
									$DataArray['SaleActive'] = "0";
									
									if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
									{
										$ProductPriceObj->tableUpdate($DataArray);
									}
									else 
									{
										$DataArray['QtyMin'] = "0";
										$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
										$DataArray['PriceType'] = 'Unit';
										$DataArray['UserTypeID'] = $UserTypeID;
										$DataArray['ProductID'] = $ChildProductID;
										$ProductPriceObj->tableInsert($DataArray);
									}
									
									/* ProductPriceObj entry end*/
								}
								
								
								
							}
						}
						
					}
				} 
				
			}
		}
		
	}
	
	public function AssignCategories($ProductID,$CategoriesIDs)
	{
		if(is_array($CategoriesIDs) && count($CategoriesIDs) > 0){
			
			$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
			foreach($CategoriesIDs as $CategoryID){
				$DBObj = new DataTable(TABLE_PRODUCT_RELATION);
				$where = new Where();
				$where->equalTo('ProductID',$ProductID);
				$where->equalTo('RelationID',$CategoryID);
				$where->equalTo('RelationType','catalog_category');
				$DBObj->where = $where;
				$Singleobj = (object)$DBObj->tableSelectOne(array("RelationID"),"RelationID ASC");
				if(isset($Singleobj->RelationID)){
				
				}
				else{
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['RelationID'] = $CategoryID;
					$DataArray['RelationType'] = "catalog_category";
					$DataArray['SortOrder'] = $this->getClass("Catalog\Product\Common")->SKMaxGetProductSortOrder($CategoryID,"catalog_category") + 1;
					$ProductCategoryObj->tableInsert($DataArray);
				}
			
			
			}
		}
		
	}
	public function AddAddditionalImages($ProductID,$ImageArray)
	{
		if(count($ImageArray) > 0){
			
			foreach($ImageArray as $imgk=>$img_arr){
				$img_url ="https://www.continentalclothing.com".$img_arr['image'];
				
				//https://www.continentalclothing.com/assets/drawings/COR19.jpg
				//https://www.continentalclothing.com/assets/cropped/high_res/BAM01.jpg
				
				$Image = basename($img_url);
				if($Image != ""){
					$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
					$ImagePath=$productdir.$Image;
					if(!file_exists($ImagePath)){
						$this->ProductImport->uploadImage($img_url,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							
							if($imgk=="MainImage"){
								/* product image added*/
								$ImageAltText = isset($img_arr['alt'])?$img_arr['alt']:$Image;
								$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
								$DataArray = array();
								$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_product",'product/p-'.$ProductID,$ImageAltText);
								$ProdObj = new DataTable(TABLE_PRODUCT);
								$ProdObj->where = "ProductID = '".$ProductID."'";
								$CurrentProduct = (object)$ProdObj->tableSelectOne(array("ProductID","Image"));
								if(isset($CurrentProduct->ProductID) && $DataArray['Image'] !="" && $DataArray['Image'] != $CurrentProduct->Image){
									$ProdObj->tableUpdate($DataArray);
								}
								
								/* product image end*/
							}
							else{
								$ProductImageObj = new DataTable(TABLE_PRODUCT_IMAGES);
								$DataArray = array();
								$DataArray['ProductID'] = $ProductID;
								$DataArray['Active'] = "1";
								$DataArray['Position'] = "0";
								
								/* product image added*/
								$ImageAltText = isset($img_arr['alt'])?$img_arr['alt']:$Image;
								$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
								$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_product",'product/p-'.$ProductID,$ImageAltText);
								$where = new Where();
								$where->equalTo('Image',$Image);
								$where->equalTo('ProductID',$ProductID);
								$ProductImageObj->where = $where;
								//$ProductImageObj->displayQuery = true;
								$Obj  = (object)$ProductImageObj->tableSelectOne(array("ImageID"));
								if(!isset($Obj->ImageID)){
									$ProductImageObj->tableInsert($DataArray);
								}
					
							}
						
						}
						else{
							
						}
					}
				}
			}
		}
	}
	
	public function CCAttributes($CC_COLOUR,$CC_SIZE,$ChildProductID="")
	{
		$AttributeArray = array();
		$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
		if($CC_COLOUR != ""){
			
			$DBObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
			$where = new Where();
			$where->equalTo('AttributeID',"101");
			$where->equalTo('FeedID',trim($CC_COLOUR));
			$where->equalTo('FeedType','FeedCC');
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("AttributeValueID"),"AttributeValueID ASC");
			if(isset($Singleobj->AttributeValueID)){
				$AttributeArray[101] = $Singleobj->AttributeValueID;
			}
			else{
				
				$SubDataArray = array();
				$SubDataArray['AttributeValue'] =trim($CC_COLOUR);
				$SubDataArray['AttributeLine'] =trim($CC_COLOUR);
				$SubDataArray['FeedID'] =trim($CC_COLOUR);
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['AttributeID'] ="101";
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedType'] ="FeedCC";
				$AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
				$AttributeArray[101] = $AttributeValueID;
				
			}
		}
		if($CC_SIZE != ""){
			
			$DBObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
			$where = new Where();
			$where->equalTo('AttributeID',"102");
			$where->equalTo('FeedID',trim($CC_SIZE));
			$where->equalTo('FeedType','FeedCC');
			
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("AttributeValueID"),"AttributeValueID ASC");
			if(isset($Singleobj->AttributeValueID)){
				$AttributeArray[102] = $Singleobj->AttributeValueID;
			}
			else{
				
				$SubDataArray = array();
				$SubDataArray['AttributeValue'] =trim($CC_SIZE);
				$SubDataArray['AttributeLine'] =trim($CC_SIZE);
				$SubDataArray['FeedID'] =trim($CC_SIZE);
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['AttributeID'] ="102";
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedType'] ="FeedCC";
				$AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
				$AttributeArray[102] = $AttributeValueID;
				
			}
		}
		
		return $AttributeArray;
	}
	public function CCGetBrandID($CC_BRAND,$ProductArr)
	{
		$BrandID =0;
		if($CC_BRAND != ""){
			$DBObj = new DataTable(array('c'=>TABLE_BRANDS));
			$where = new Where();
			$where->equalTo('BrandName',trim($CC_BRAND));
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("BrandID"),"BrandID ASC");
			if(isset($Singleobj->BrandID) && $Singleobj->BrandID != ""){
				$BrandID = $Singleobj->BrandID; 	
			}
			else{
				
				$BrandObj = new DataTable(array('c'=>TABLE_BRANDS));
				$DataArray = array();
				$DataArray['Active'] = "1";
				$DataArray['BrandName'] = trim($CC_BRAND);
				$DataArray['BrandCode'] = trim($CC_BRAND);
				$DataArray['UploadType'] = "FeedCC";
				$DataArray['FeedID'] = $CC_BRAND;
				
				$BrandObj->where ="1";
				$DataArray['Position'] = $BrandObj->getMax("Position") + 1;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$BrandID = $DBObj->tableInsert($DataArray);
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$BrandID." AND MCode ='catalog_brand' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				$DataArray = array();
				$DataArray['MetaTitle'] =$CC_BRAND." - Collections";
				$DataArray['MetaKeyword'] =$CC_BRAND;
				$DataArray['MetaDescription'] =$CC_BRAND." - Collections";
			
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
					$URL = 	SkURLCreate($CC_BRAND);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;
					//$SeoObj->tableUpdate($DataArray);
				}
				else{
					
					$URL = 	SkURLCreate($CC_BRAND);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;			
					$DataArray['MCode'] = "catalog_brand";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $BrandID;
					$SeoObj->tableInsert($DataArray);
				}
				
				
				
			}
			
		}
		return $BrandID;
		
	}
	public function CCGetCategoryIDs($ProductArr)
	{
		$ReturnArray = array();
		if(isset($ProductArr['clearance']) && $ProductArr['clearance']==true)
			$ReturnArray[] = "2";
		
		if(isset($ProductArr['categoryIds']) && count($ProductArr['categoryIds']) > 0){
			foreach($ProductArr['categoryIds'] as $k=>$CID){
				$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
				$where = new Where();
				$where->equalTo('FeedID',$CID);
				$where->equalTo('FeedType','FeedCC');
				$Obj->where = $where;
				$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
				if(isset($Cobj->CategoryID) && $Cobj->CategoryID != "")
					$ReturnArray[] = $Cobj->CategoryID; 
			}
		}
		return $ReturnArray;
	}
	
	function checkProductbySKU($ModelNo)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$where = new Where();
		$where->equalTo('UploadType','FeedCC');
		$where->equalTo('FeedID',$ModelNo);
		//$ProductObj->displayQuery = true;
		$ProductObj->where = $where;
		return (object)$ProductObj->tableSelectOne(array("ProductID","MasterID","ModelNo","ProductName"));
	}
	
	
}	