<?php 
namespace Plugin\BtcActivewear;
use Base\File\FileHandle as FileHandle;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;
use Box\Spout\Reader\Common\Creator\ReaderEntityFactory;
class ProductImport extends AbstractModule
{
	var $apikey; // Api Key for your account.
	var $ftpUser; // ftp user.
	var $ftpPassword; // ftp password.
	var $ftpHost; // ftp password.
	var $Obj; // ftp password.
	
	function __construct()
	{
	  require_once (dirname(__FILE__)."/config.php");
	  $this->apikey = DEFINE_BTCACTIVEWEAR_WEBSERVICES_APIKEY;
	  $this->ftpUser = DEFINE_BTCACTIVEWEAR_FTP_USER;
	  $this->ftpPassword = DEFINE_BTCACTIVEWEAR_FTP_PWD;
	  $this->ftpHost = DEFINE_BTCACTIVEWEAR_FTP_HOST;
	  $DBObj = new DataTable(TABLE_SUPPLIERS);
	  $DBObj->where[] = array('=',array('SuppierCode' => 'BTC'));
	  $this->Obj  = (object)$DBObj->tableSelectOne(array("*"));
		
	  
	}
	
	function PriceIncrease($Price)
	{
		if($this->Obj->PriceIncrease > 0 && $Price > 0){
			$FinalPrice = $Price + ($this->Obj->PriceIncrease*$Price/100);
			$FinalPrice = number_format($FinalPrice,1,'.','');
			return $FinalPrice;
		}
		return $Price;
		
	}
	function FetchRecord($funcs,$parms = "",$return_string="")
	{
	    $json = $this->SubmitJSON($funcs, $parms,$return_string);
			
	    if($return_string=="1")
	    {
	    	return $json;
	    }
	    // Always check for an error. A list of errors can be found in the documentation
	    if(isset($json["error"]))
	    {
	        // You'd handle the error within your UI, but for this sample, I just write it to the page
	        echo($json["error"]);
	    }
	    else
	    {
	        return $json;
	    }
	}
	
	function SubmitJSON($functionToCall, $postVars,$return_string)
	{
	    // The URL we call, plus the function name
	    $url = 'http://downloads.BtcActivewear.com/api/' . $functionToCall . '/';
	     
	    // Add the APIKey to every post
	     
	    if ($postVars != "")
	        $postVars = $postVars . '&APIKey='.$this->apikey;
	    else
	        $postVars = 'APIKey='.$this->apikey;
	     
	    // Use CURL to post the form data to the API
	    $ch = curl_init( $url );
	    curl_setopt( $ch, CURLOPT_POST, 1);
	    curl_setopt( $ch, CURLOPT_POSTFIELDS, $postVars);
	    curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
	    curl_setopt( $ch, CURLOPT_HEADER, 0);
	    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
	    // Encode what is returned into a PHP array
		$return = curl_exec($ch);
	    if($return_string=="1")
	    {
	    	return $return;
	    }
	    else
	    { 
	    	return json_decode($return, true);
	    }
	}
	
	function downloadFTPFile($FileName,$LocalFile)
	{
		$ServerFile ="ftp://".$this->ftpHost."/".$FileName;
		$ch = curl_init();
		$file = fopen($LocalFile, 'w');
		try {
			curl_setopt($ch, CURLOPT_URL, $ServerFile); #input
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
			//curl_setopt( $ch, CURLOPT_FTPPORT , "-");
			curl_setopt($ch, CURLOPT_FILE, $file); #output
			curl_setopt($ch, CURLOPT_USERPWD, $this->ftpUser.":".$this->ftpPassword);
			$return = curl_exec($ch);
		}finally {
			if ($file !== null && is_resource($file)) {	
				fclose($file);
			}
		}
		if(curl_errno($ch)){
			return array("error"=>true,
						 "error_no"=>curl_errno($ch),
						 "error_msg"=>curl_error($ch)
						 );
		}
		curl_close($ch);
		return $return;
	}
	
	function downloadFTPFile__nnnnnnnnn($FileName, $LocalFile)
	{
		$ServerFile = "ftp://" . $this->ftpHost . "/" . $FileName;
		$ch = curl_init();
		$file = null;
		$success = false;
		
		try {
			// Try to open the local file for writing
			$file = fopen($LocalFile, 'w');
			if ($file === false) {
				return [
					"error" => true,
					"error_no" => 0,
					"error_msg" => "Failed to open local file for writing: " . $LocalFile
				];
			}

			// Set cURL options
			curl_setopt($ch, CURLOPT_URL, $ServerFile);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
			//curl_setopt($ch, CURLOPT_FTPPORT, "-"); // Use passive mode
			curl_setopt($ch, CURLOPT_FILE, $file);
			curl_setopt($ch, CURLOPT_USERPWD, $this->ftpUser . ":" . $this->ftpPassword);
			curl_setopt($ch, CURLOPT_FTPSSLAUTH, CURLFTPAUTH_DEFAULT); // Let cURL negotiate SSL/TLS
			curl_setopt($ch, CURLOPT_FTP_CREATE_MISSING_DIRS, true); // Create missing directories
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30); // Connection timeout
			curl_setopt($ch, CURLOPT_TIMEOUT, 300); // Overall timeout

			$result = curl_exec($ch);
			
			if ($result === false) {
				$error = curl_error($ch);
				$errno = curl_errno($ch);
				return [
					"error" => true,
					"error_no" => $errno,
					"error_msg" => $error
				];
			}
			
			// Check HTTP status code (if available)
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			if ($httpCode >= 400) {
				return [
					"error" => true,
					"error_no" => $httpCode,
					"error_msg" => "HTTP error: " . $httpCode
				];
			}
			
			$success = true;
			
		} finally {
			// Always clean up resources
			if ($file !== null && is_resource($file)) {
				fclose($file);
			}
			curl_close($ch);
		}
		
		return [
			"error" => false,
			"success" => $success,
			"local_file" => $LocalFile,
			"remote_file" => $ServerFile
		];
	}
	
	function uploadImage($src,$filename) 
	{
		if(file_exists($filename)){
			//return basename($src);
		}
		else{
			$size = getimagesize($src);
			$extension = "";
			switch(strtolower($size['mime']))
			{
				case "image/jpeg":
					$extension = ".jpg";
					break;
				case "image/gif":
					$extension = ".gif";
					break;
				case "image/png":
					$extension = ".png";
					break;
				case "image/bmp":
					$extension = ".bmp";
					break;
			}
			
			//if($extension != "" && isset($size[0]) && $size[0] > 0)
			if(true)
			{
				$ch = curl_init ($src);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		
				$raw=curl_exec($ch);
				
				curl_close ($ch);
				if(curl_errno($ch)){
					//var_dump(curl_errno($ch),curl_error($ch));
					//exit;
				}
				if(!file_exists($filename)){
					$fp = fopen($filename,'x');
					try {
						fwrite($fp, $raw);
					} finally {
						if ($fp !== null && is_resource($fp)) {	
							fclose($fp);
						}	
					}
					
				}
				//return basename($src);
			}
		}
		
		return "0";

	}
	
	function unZip($Dir, $LocalFile)
	{
		$zip = new \ZipArchive;
		$res = $zip->open($LocalFile);
		if ($res === TRUE) {
		  $zip->extractTo($Dir);
		  $zip->close();
		} else {
		  
		}
	}
	
function ReadFileXLS($LocalFile)
	{
		# open the file
		$reader = ReaderEntityFactory::createXLSXReader();
		$reader->open($LocalFile);
		# read each cell of each row of each sheet
		return $reader;
		
	}	

	
}

?>