<?php 
namespace Plugin\BtcActivewear;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;
use Plugin\BtcActivewear\ProductImport;

class CronController extends AbstractModule
{
	function __construct()
	{
		$this->ProductImport = new ProductImport();
						
	}
	
	
public function ImportBTCProductStockAction($ScriptTimeLimit,$Obj)
{
	$dir = FileHandle::CheckPrivateLogDirectory("cron");
	$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
	$filename=$btcdir."btc_stock".date('Y-m-d').".txt";
	$UniqueID = uniqid("BTC_");
	
	$fp2 = fopen($filename, "a+");
	try{
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	

		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d H',strtotime($Obj->CronDate))==date('Y-m-d H')){	
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="BTCStockFile";
				$Params['Action']="DownloadStock";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download BTCStockFile file start*/
			$BTCStockFile=$btcdir."stock_levels_stock_id_fully_quoted.csv";
			if($Params['Section']=="BTCStockFile" && $Params['Action']=="DownloadStock"){
				if(file_exists($BTCStockFile)==false)
				{
					fputs($fp2,"BTCStockFile ".$UniqueID."= START Download stock_levels_stock_id_fully_quoted.csv ".chr(13));	
					$d_return = $this->ProductImport->downloadFTPFile("webdata/stock_levels_stock_id_fully_quoted.csv",$BTCStockFile);
					if(isset($d_return['error'])){
						fputs($fp2,"Download Fail BTCStockFile ".$UniqueID."=".print_r($d_return,true).chr(13));
						if(file_exists($BTCStockFile))
							unlink($BTCStockFile);
						
					}
					else{
						$Params['Section']="BTCStockFile";
						$Params['Action']="ImportStock";
					}
					fputs($fp2,"BTCStockFile ".$UniqueID."= END Download stock_levels_stock_id_fully_quoted.csv ".chr(13));
					
					
					
				}
				else
				{
					fputs($fp2,"Ready for ImportStock ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="BTCStockFile";
					$Params['Action']="ImportStock";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download BTCStockFile file end*/
			
			
			/* ImportFull BTCStockFile file start*/
			if($Params['Section']=="BTCStockFile" && $Params['Action']=="ImportStock"){
				$BTCStockFile=$btcdir."stock_levels_stock_id_fully_quoted.csv";
				fputs($fp2,"Stock Start with File ".$UniqueID."=".print_r($BTCStockFile,true).chr(13));	
											
				if(file_exists($BTCStockFile))
				{
					if(filesize($BTCStockFile) > 0){
						$StartPoint = $Params['StartPoint'];
						$RowSNo =0;
						if (($handle = fopen($BTCStockFile, "r")) !== FALSE) {
								if($StartPoint==0){
									$DataArray = array();
									$DataArray['Stock'] = 0;
									$DataArray['StockStatus'] = "1";
									$DataArray['Active'] =0;
									$ProductObj = new DataTable(TABLE_PRODUCT);
									$ProductObj->where[] = array('=',array('UploadType' => 'FeedBTC'));
									$ProductObj->where[] = array('=',array('ProductType' => 'Child'));
									$ProductObj->tableUpdate($DataArray);
									echo "Reset Child products";
								}
								while (($data = fgetcsv($handle)) !== FALSE) {
									$RowSNo++;
									if($RowSNo==1){
										$HeaderArray = array();
										foreach ($data as $k=>$cell) {
											$index = "DATA_CSV_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($cell)));
											//echo $index;
											if(!defined($index))	
												define($index,$k);
										
											$HeaderArray[constant($index)] = $cell;
											
										}
										
									}
									else{
										if($RowSNo >= $StartPoint){
											
											
											foreach($HeaderArray as $key=>$val):
											$index = "DATA_CSV_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($val)));
											//echo "<hr>".$index."--".constant($index);
											if(defined($index)){
													${"BTC_".strtoupper(str_replace(array(" ","-"),array("_","_"),$val))} = isset($data[constant($index)])?trim($data[constant($index)]):"";
												}
											endforeach;
			
											if($BTC_STOCK_ID != ""){
												
													$checkProduct = $this->checkProductbySKU($BTC_STOCK_ID);
													$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
													$MasterID = isset($checkProduct->MasterID)?$checkProduct->MasterID:"0";
													$ProductObj = new DataTable(TABLE_PRODUCT);
													
													if($ProductID > 0){
														
														$DataArray = array();
														$DataArray['Stock'] = ($BTC_FREE_STOCK > 0)?$BTC_FREE_STOCK:0;
														$DataArray['StockStatus'] = "1";
														$DataArray['StockTotal'] = ($BTC_FREE_STOCK > 0)?$BTC_FREE_STOCK:0;
														$DataArray['Active'] ="0";
														 if($DataArray['Stock'] > 0){
														  $DataArray['Active'] ="1";
														  if($MasterID > 0){
															
															$MasterArray = array();
															$MasterArray['Active'] ="1";
															$MasterObj = new DataTable(TABLE_PRODUCT);  
															$MasterObj->where[] = array('=',array('ProductID' => $MasterID));
															$MasterObj->tableUpdate($MasterArray);
														
														  }
														  
														}
														
														
														$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
														$ProductObj->tableUpdate($DataArray);
														echo $ProductID." - Stock: ".$DataArray['Stock']." "." - RowSNo: ".$RowSNo." processed".chr(13);
														//fputs($fp2,"Stock Update ".$UniqueID."=ProductID ".print_r($ProductID,true).chr(13));	
												
													}
												
											}
											//fputs($fp2,"Stock Update ".$UniqueID."=".print_r($data,true).chr(13));	
											$CronObj = new DataTable(TABLE_MODULE_CRONS);
											$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
											$Params['StartPoint']=$RowSNo;		
											$DataArray = array();
											$DataArray['CronStatus'] = "Processing";
											$DataArray['Params'] = base64_encode(serialize($Params));
											$CronObj->tableUpdate($DataArray);										
										}
									}
									
								}
						}
						
						fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
						$BTCStockFile=$btcdir."stock_levels_stock_id_fully_quoted.csv";
						if(file_exists($BTCStockFile))
							rename($BTCStockFile,$btcdir."stock_".date('Y-m-d-His').".csv");
						
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d H:i:s',strtotime("+1 hours"));
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$CronObj->tableUpdate($DataArray);
						
					}
					else{
						unlink($BTCStockFile);
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCStockFile";
						$Params['Action']="ImportStock";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);

					}
					
					
				}
				else
				{
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$DataArray = array();
					$DataArray['CronDate'] = date('Y-m-d H:i:s',strtotime("+1 hours"));
					$DataArray['CronStatus'] = "Pending";
					$DataArray['Params'] = "";
					$DataArray['CronMessage'] = "";
					$CronObj->tableUpdate($DataArray);
				
					
				}
			}
			/* ImportStock BTCStockFile file end*/
			

			
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d H:i:s');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$BTCStockFile=$btcdir."stock_levels_stock_id_fully_quoted.csv";
			if(file_exists($BTCStockFile))
				@unlink($BTCStockFile);	
			
		}

		fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
	} finally {
		if ($handle !== null && is_resource($handle)) {
                fclose($handle);
            }
		if ($fp2 !== null && is_resource($fp2)) {	
			fclose($fp2);
		}		
	}
	
	
}

	public function ImportBTCProductClearanceAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_clearance".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
			fputs($fp2,"======================================================".chr(13));	
			fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	

			
			$sk_timestart = explode(' ', microtime() );
			$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
			
			/* script start here*/	
			if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
				$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				if(count($Params)==0)
				{
					$Params['Section']="BTCClearanceFile";
					$Params['Action']="DownloadClearance";
					$Params['StartPoint']="0";				
				}
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				/* Download BTCClearanceFile file start*/
				$BTCClearanceFile=$btcdir."outlet_products.xlsx";
				if($Params['Section']=="BTCClearanceFile" && $Params['Action']=="DownloadClearance"){
					if(file_exists($BTCClearanceFile)==false)
					{
						fputs($fp2,"BTCClearanceFile ".$UniqueID."= START Download outlet_products.xlsx ".chr(13));	
						$d_return = $this->ProductImport->downloadFTPFile("webdata/outlet_products.xlsx",$BTCClearanceFile);
						if(isset($d_return['error'])){
							fputs($fp2,"Download Fail BTCClearanceFile ".$UniqueID."=".print_r($d_return,true).chr(13));
							if(file_exists($BTCClearanceFile))
								unlink($BTCClearanceFile);
							
						}
						fputs($fp2,"BTCClearanceFile ".$UniqueID."= END Download outlet_products.xlsx ".chr(13));
					}
					else
					{
						fputs($fp2,"Ready for BTCClearanceFile ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCClearanceFile";
						$Params['Action']="ImportClearance";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
					}
				}
				/* Download BTCClearanceFile file end*/
				
				
				/* ImportFull BTCClearanceFile file start*/
				if($Params['Section']=="BTCClearanceFile" && $Params['Action']=="ImportClearance"){
					$BTCClearanceFile=$btcdir."outlet_products.xlsx";
					if(file_exists($BTCClearanceFile))
					{
						if(filesize($BTCClearanceFile) > 0){
							$StartPoint = $Params['StartPoint'];
							if($StartPoint==0){
								$this->getClass('Catalog\Product\Common')->BTCResetClearance();
							}
							$reader = $this->ProductImport->ReadFileXLS($BTCClearanceFile);
							foreach ($reader->getSheetIterator() as $sheet) {
								$RowSNo =0;
								foreach ($sheet->getRowIterator() as $row) {
									$RowSNo++;
									if($RowSNo==1){
										$HeaderArray = array();
										foreach ($row->getCells() as $k=>$cell) {
											$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($cell->getValue())));
											//echo $index;
											if(!defined($index))	
												define($index,$k);
										
											$HeaderArray[constant($index)] = $cell->getValue();
											
										}
										
									}
									else{
										$ExcelData = Array();
										if($RowSNo >= $StartPoint){
											foreach ($row->getCells() as $k=>$cell) {
												$ExcelData[$k] = $cell->getValue();
											}
											$this->BTCImportClearance($HeaderArray,$ExcelData);
											
											$CronObj = new DataTable(TABLE_MODULE_CRONS);
											$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
											$Params['StartPoint']=$RowSNo;		
											$DataArray = array();
											$DataArray['CronStatus'] = "Processing";
											$DataArray['Params'] = base64_encode(serialize($Params));
											$CronObj->tableUpdate($DataArray);										
										}
									}
									
								}
								
							}
							
							
							fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
							$BTCClearanceFile=$btcdir."outlet_products.xlsx";
							if(file_exists($BTCClearanceFile))
								rename($BTCClearanceFile,$btcdir."outlet_products_".date('Y-m-d-His').".xlsx");
							
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d',strtotime("+6 day"));
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);
							
						}
						else{
							unlink($BTCClearanceFile);
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="BTCClearanceFile";
							$Params['Action']="ImportClearance";
							$Params['StartPoint']="0";	
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);

						}
						
						
					}
					else
					{
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d');
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$DataArray['CronMessage'] = "";
						$CronObj->tableUpdate($DataArray);
					
						
					}
				}
				/* ImportFull BTCClearanceFile file end*/
				

				
				
			}
			/* script end here*/	
			
			if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
			
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d');
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$DataArray['CronMessage'] = "";
				$CronObj->tableUpdate($DataArray);
				
				$BTCClearanceFile=$btcdir."outlet_products.xlsx";
				if(file_exists($BTCClearanceFile))
					@unlink($BTCClearanceFile);	
				
			}

			fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
			fputs($fp2,"======================================================".chr(13));

		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
			
		
		
	}

	public function ImportBTCProductAdditionAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_additional".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
			fputs($fp2,"======================================================".chr(13));	
			fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	

			
			$sk_timestart = explode(' ', microtime() );
			$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
			
			/* script start here*/	
			if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
				$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				if(count($Params)==0)
				{
					$Params['Section']="BTCAdditionalFile";
					$Params['Action']="DownloadAdditional";
					$Params['StartPoint']="0";				
				}
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				/* Download BTCAdditionalFile file start*/
				$BTCAdditionalFile=$btcdir."extended_data_".date('Y').".xlsx";
				if($Params['Section']=="BTCAdditionalFile" && $Params['Action']=="DownloadAdditional"){
					if(file_exists($BTCAdditionalFile)==false)
					{
						fputs($fp2,"BTCAdditionalFile ".$UniqueID."= START Download extended_data file ".chr(13));	
						$this->ProductImport->downloadFTPFile("webdata/extended_data_".date('Y').".xlsx",$BTCAdditionalFile);
						if(isset($d_return['error'])){
							fputs($fp2,"Download Fail BTCAdditionalFile ".$UniqueID."=".print_r($d_return,true).chr(13));
							if(file_exists($BTCAdditionalFile))
								unlink($BTCAdditionalFile);
							
						}
						fputs($fp2,"BTCAdditionalFile ".$UniqueID."= END Download extended_data file ".chr(13));
					}
					else
					{
						fputs($fp2,"Ready for ImportAdditional ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCAdditionalFile";
						$Params['Action']="ImportAdditional";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
					}
				}
				/* Download BTCAdditionalFile file end*/
				
				
				/* ImportFull BTCAdditionalFile file start*/
				if($Params['Section']=="BTCAdditionalFile" && $Params['Action']=="ImportAdditional"){
					$BTCAdditionalFile=$btcdir."extended_data_".date('Y').".xlsx";
					if(file_exists($BTCAdditionalFile))
					{
						if(filesize($BTCAdditionalFile) > 0){
							$StartPoint = $Params['StartPoint'];
							$reader = $this->ProductImport->ReadFileXLS($BTCAdditionalFile);
							foreach ($reader->getSheetIterator() as $sheet) {
								$RowSNo =0;
								foreach ($sheet->getRowIterator() as $row) {
									$RowSNo++;
									if($RowSNo==1){
										$HeaderArray = array();
										foreach ($row->getCells() as $k=>$cell) {
											$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($cell->getValue())));
											//echo $index;
											if(!defined($index))	
												define($index,$k);
										
											$HeaderArray[constant($index)] = $cell->getValue();
											
										}
										
									}
									else{
										$ExcelData = Array();
										if($RowSNo >= $StartPoint){
											foreach ($row->getCells() as $k=>$cell) {
												$ExcelData[$k] = $cell->getValue();
											}
											$AdditionalID = $this->BTCImportAdditional($HeaderArray,$ExcelData);
											fputs($fp2,"Additional Update ".$UniqueID."=".print_r($AdditionalID,true).chr(13));	
											//print_r($HeaderArray);
											//echo "<hr>--".$AdditionalID;
											//exit;
											$CronObj = new DataTable(TABLE_MODULE_CRONS);
											$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
											$Params['StartPoint']=$RowSNo;		
											$DataArray = array();
											$DataArray['CronStatus'] = "Processing";
											$DataArray['Params'] = base64_encode(serialize($Params));
											$CronObj->tableUpdate($DataArray);										
										}
									}
									
								}
								
							}
							
							
							fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
							$BTCAdditionalFile=$btcdir."extended_data_".date('Y').".xlsx";;
							if(file_exists($BTCAdditionalFile))
								rename($BTCAdditionalFile,$btcdir."extended_data_".date('Y-m-d-His').".xlsx");
							
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d',strtotime("+6 day"));
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);
							
						}
						else{
							unlink($BTCAdditionalFile);
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="BTCAdditionalFile";
							$Params['Action']="ImportAdditional";
							$Params['StartPoint']="0";	
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);

						}
						
						
					}
					else
					{
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d');
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$DataArray['CronMessage'] = "";
						$CronObj->tableUpdate($DataArray);
					
						
					}
				}
				/* ImportAdditional BTCAdditionalFile file end*/
				

				
				
			}
			/* script end here*/	
			
			if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
			
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d');
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$DataArray['CronMessage'] = "";
				$CronObj->tableUpdate($DataArray);
				
				$BTCAdditionalFile=$btcdir."extended_data_".date('Y').".xlsx";;
				if(file_exists($BTCAdditionalFile))
					@unlink($BTCAdditionalFile);	
				
			}

			fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
			fputs($fp2,"======================================================".chr(13));	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
		
		
	}


	public function BTCImportClearance($HeaderArray,$ExcelData)
	{
		foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)));
			//echo "<hr>".$index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		
		if($BTC_STOCK_ID != ""){
			
			
			$checkProduct = $this->checkProductbySKU($BTC_STOCK_ID);
			$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
			$MasterID = isset($checkProduct->MasterID)?$checkProduct->MasterID:"0";
			$ProductObj = new DataTable(TABLE_PRODUCT);
			if($ProductID > 0){
				
				$DataArray = array();
				$DataArray['Clearance'] ="1";
				  if($MasterID > 0){
					/*
					$MasterArray = array();
					$MasterArray['Clearance'] ="1";
					$MasterObj = new DataTable(TABLE_PRODUCT);  
					$MasterObj->where[] = array('=',array('ProductID' => $MasterID));
					$MasterObj->tableUpdate($MasterArray);
					*/
					$this->getClass('Catalog\Product\Common')->AssignCategories($MasterID,array(2));
				}
				$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
				$ProductObj->tableUpdate($DataArray);
		
			}
			
		}
	}
	
	public function BTCImportAdditional($HeaderArray,$ExcelData)
	{
		foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)));
			//echo $index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		//echo "BTC_SPC__PRODUCT_CODE=".$BTC_SPC__PRODUCT_CODE;
		if($BTC_SPC__PRODUCT_CODE != ""){
			
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$where = new Where();
			$where->equalTo('UploadType','FeedBTC');
			$where->equalTo('ModelNo',$BTC_SPC__PRODUCT_CODE);
			$where->equalTo('FeedID',$BTC_SPC__PRODUCT_CODE);
			//$ProductObj->displayQuery = true;
			$ProductObj->where = $where;
			$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
			//var_dump($Obj,"<hr>");
			if(isset($Obj->ProductID)){
				
				/* Information tab start */
				$ProductID = $Obj->ProductID;	
				$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
				$Information = isset($BTC_PRODUCT_DETAIL)?$BTC_PRODUCT_DETAIL:"";
				if($Information != "" && false){
					$DBObj2 = new DataTable(TABLE_PRODUCT_INFO);
					$where = new Where();
					$where->equalTo('ProductID',$Obj->ProductID);
					$where->equalTo('TabTitle',"Information");
					$DBObj2->where = $where;
					$Obj2  = (object)$DBObj2->tableSelectOne(array("ProductID","InfoID"));
					if(isset($Obj2->InfoID)){
						
						$DataArray = array();
						$DataArray['Description'] = $Information;
						$ProductInfoObj->where[] = array('=',array('InfoID' => $Obj2->InfoID));
						$ProductInfoObj->tableUpdate($DataArray);
					}
					else{
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['Active'] = "1";
						$DataArray['Position'] = "1";
						$DataArray['TabTitle'] = "Information";
						$DataArray['InfoType'] = "HTML";
						$DataArray['Description'] = $Information;
						$ProductInfoObj->tableInsert($DataArray);
					}
					
				}
				/* Information tab end */
				/* Exceptions tab start */
				$ProductID = $Obj->ProductID;	
				$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
				$Exceptions = $BTC_EXTRA_1 != ""?"<p>".$BTC_EXTRA_1."</p>":"";
				$Exceptions .= $BTC_EXTRA_2 != ""?"<p>".$BTC_EXTRA_2."</p>":"";
				if($Exceptions != ""){
					$DBObj2 = new DataTable(TABLE_PRODUCT_INFO);
					$where = new Where();
					$where->equalTo('ProductID',$Obj->ProductID);
					$where->equalTo('TabTitle',"Exceptions");
					$DBObj2->where = $where;
					$Obj2  = (object)$DBObj2->tableSelectOne(array("ProductID","InfoID"));
					if(isset($Obj2->InfoID)){
						
						$DataArray = array();
						$DataArray['Description'] = $Exceptions;
						$ProductInfoObj->where[] = array('=',array('InfoID' => $Obj2->InfoID));
						$ProductInfoObj->tableUpdate($DataArray);
					}
					else{
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['Active'] = "1";
						$DataArray['Position'] = "1";
						$DataArray['TabTitle'] = "Exceptions";
						$DataArray['InfoType'] = "HTML";
						$DataArray['Description'] = $Exceptions;
						$ProductInfoObj->tableInsert($DataArray);
					}
					
				}
				/* Exceptions tab end */
				/* Specification  tab start */
				$ProductID = $Obj->ProductID;	
				$ProductInfoObj = new DataTable(TABLE_PRODUCT_INFO);
				$Specification  = $BTC_FABRIC_WEIGHT != ""?"<p>Weight: ".$BTC_FABRIC_WEIGHT."</p>":"";
				$Specification  .= $BTC_FABRIC_DESCRIPTION != ""?"<p>Fabric: ".$BTC_FABRIC_DESCRIPTION."</p>":"";
				if($Specification  != ""){
					$DBObj2 = new DataTable(TABLE_PRODUCT_INFO);
					$where = new Where();
					$where->equalTo('ProductID',$Obj->ProductID);
					$where->equalTo('TabTitle',"Specification ");
					$DBObj2->where = $where;
					$Obj2  = (object)$DBObj2->tableSelectOne(array("ProductID","InfoID"));
					if(isset($Obj2->InfoID)){
						
						$DataArray = array();
						$DataArray['Description'] = $Specification ;
						$ProductInfoObj->where[] = array('=',array('InfoID' => $Obj2->InfoID));
						$ProductInfoObj->tableUpdate($DataArray);
					}
					else{
						$DataArray = array();
						$DataArray['ProductID'] = $ProductID;
						$DataArray['Active'] = "1";
						$DataArray['Position'] = "1";
						$DataArray['TabTitle'] = "Specification ";
						$DataArray['InfoType'] = "HTML";
						$DataArray['Description'] = $Specification ;
						$ProductInfoObj->tableInsert($DataArray);
					}
					
				}
				/* Specification  tab end */
				
				return $ProductID;
				
			}
			
		}
	return 0;	
}

public function ImportBTCProductSizeGuideAction($ScriptTimeLimit,$Obj)
{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_sizeguide".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
			fputs($fp2,"======================================================".chr(13));	
			fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	

			
			$sk_timestart = explode(' ', microtime() );
			$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
			
			/* script start here*/	
			if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
				$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				if(count($Params)==0)
				{
					$Params['Section']="BTCSizeGuideFile";
					$Params['Action']="DownloadSizeGuide";
					$Params['StartPoint']="0";				
				}
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				/* Download BTCSizeGuideFile file start*/
				$BTCSizeGuideFile=$btcdir."size_info.xlsx";
				if($Params['Section']=="BTCSizeGuideFile" && $Params['Action']=="DownloadSizeGuide"){
					if(file_exists($BTCSizeGuideFile)==false)
					{
						fputs($fp2,"BTCSizeGuideFile ".$UniqueID."= START Download size_info file ".chr(13));	
						$this->ProductImport->downloadFTPFile("webdata/size_info.xlsx",$BTCSizeGuideFile);
						if(isset($d_return['error'])){
							fputs($fp2,"Download Fail BTCSizeGuideFile ".$UniqueID."=".print_r($d_return,true).chr(13));
							if(file_exists($BTCSizeGuideFile))
								unlink($BTCSizeGuideFile);
							
						}
						fputs($fp2,"BTCSizeGuideFile ".$UniqueID."= END Download size_info file ".chr(13));
					}
					else
					{
						fputs($fp2,"Ready for ImportSizeGuide ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCSizeGuideFile";
						$Params['Action']="ImportSizeGuide";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
					}
				}
				/* Download BTCSizeGuideFile file end*/
				
				
				/* ImportFull BTCSizeGuideFile file start*/
				if($Params['Section']=="BTCSizeGuideFile" && $Params['Action']=="ImportSizeGuide"){
					$BTCSizeGuideFile=$btcdir."size_info.xlsx";
					if(file_exists($BTCSizeGuideFile))
					{
						if(filesize($BTCSizeGuideFile) > 0){
							$StartPoint = $Params['StartPoint'];
							$reader = $this->ProductImport->ReadFileXLS($BTCSizeGuideFile);
							$ProductSizeArr = array();
							foreach ($reader->getSheetIterator() as $sheet) {
								$RowSNo =0;
								foreach ($sheet->getRowIterator() as $row) {
									$RowSNo++;
									if($RowSNo==1){
										$HeaderArray = array();
										foreach ($row->getCells() as $k=>$cell) {
											$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($cell->getValue())));
											//echo $index;
											if(!defined($index))	
												define($index,$k);
										
											$HeaderArray[constant($index)] = $cell->getValue();
											
										}
										
									}
									else{
										$ExcelData = Array();
										foreach ($row->getCells() as $k=>$cell) {
											$ExcelData[$k] = $cell->getValue();
										}
										$Arr = $this->BTCReadySizeGuide($HeaderArray,$ExcelData);
										$ProductSizeArr[$ExcelData[0]][] = $Arr;
									}
									
								}
								
							}
							$this->BTCImportSizeGuide($ProductSizeArr);
							
							fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
							$BTCSizeGuideFile=$btcdir."size_info.xlsx";
							if(file_exists($BTCSizeGuideFile))
								rename($BTCSizeGuideFile,$btcdir."size_info_".date('Y-m-d-His').".xlsx");
							
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d',strtotime("+7 day"));
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);
							
						}
						else{
							unlink($BTCSizeGuideFile);
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="BTCSizeGuideFile";
							$Params['Action']="ImportSizeGuide";
							$Params['StartPoint']="0";	
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);

						}
						
						
					}
					else
					{
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d');
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$DataArray['CronMessage'] = "";
						$CronObj->tableUpdate($DataArray);
					
						
					}
				}
				/* ImportSizeGuide BTCSizeGuideFile file end*/
				

				
				
			}
			/* script end here*/	
			
			if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
			
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d');
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$DataArray['CronMessage'] = "";
				$CronObj->tableUpdate($DataArray);
				
				$BTCSizeGuideFile=$btcdir."size_info.xlsx";
				if(file_exists($BTCSizeGuideFile))
					@unlink($BTCSizeGuideFile);	
				
			}

			fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
			fputs($fp2,"======================================================".chr(13));	
		}
		finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
		
		
	}
	public function BTCImportSizeGuide($FullArr)
	{
		if(count($FullArr) > 0){
			foreach($FullArr as $ModelNo=>$SizeArr){
					if(count($SizeArr) > 0){
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$ProductObj->where[] = array('=',array('ModelNo' => (string)$ModelNo));
						$ProductObj->where[] = array('=',array('FeedID' => (string)$ModelNo));
						$ProductObj->where[] = array('=',array('UploadType' => 'FeedBTC'));
						$DataArray = array();
						$DataArray['SizeGuide'] = base64_encode(serialize($SizeArr));
						$ProductObj->tableUpdate($DataArray);
					}
			}
		}
	}
	public function BTCReadySizeGuide($HeaderArray,$ExcelData)
	{
		foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)));
			//echo $index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		if($BTC_SPC__PRODUCT_CODE != ""){
			
			$SizeArray = array();
			$DefaultSize = isset($BTC_SIZE)?$BTC_SIZE:"";
			if($DefaultSize != ""){
				$SizeGuide['Size'][] = $DefaultSize;	
			}
			for($i=1;$i<=5;$i++){
				$HEADING = ${"BTC_EXTRA_SIZE_HEADING_".$i};
				$SIZE = ${"BTC_EXTRA_SIZE_".$i};
				if($HEADING != "" && $SIZE != ""){
					$SizeGuide[$HEADING][] = $SIZE;	
				}
			}
			/* $Size tab end */
			return $SizeGuide;
			
		}
	return array();	
}

public function ImportBTCProductFilterAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_filter".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	

		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Section']="BTCFilterFile";
				$Params['Action']="DownloadFilter";
				$Params['StartPoint']="0";				
			}
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download BTCFilterFile file start*/
			$BTCFilterFile=$btcdir."BTC_Filter_Data_monthly.xlsx";
			if($Params['Section']=="BTCFilterFile" && $Params['Action']=="DownloadFilter"){
				if(file_exists($BTCFilterFile)==false)
				{
					fputs($fp2,"BTCFilterFile ".$UniqueID."= START Download Filter file ".chr(13));	
					$this->ProductImport->downloadFTPFile("BTC_Filter_Data_monthly.xlsx",$BTCFilterFile);
					if(isset($d_return['error'])){
						fputs($fp2,"Download Fail BTCFilterFile ".$UniqueID."=".print_r($d_return,true).chr(13));
						if(file_exists($BTCFilterFile))
							unlink($BTCFilterFile);
						
					}
					fputs($fp2,"BTCFilterFile ".$UniqueID."= END Download Filter file ".chr(13));
				}
				else
				{
					fputs($fp2,"Ready for ImportFilter ".$UniqueID."=".print_r($Params,true).chr(13));		
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Section']="BTCFilterFile";
					$Params['Action']="ImportFilter";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download BTCFilterFile file end*/
			
			
			/* ImportFull BTCFilterFile file start*/
			if($Params['Section']=="BTCFilterFile" && $Params['Action']=="ImportFilter"){
				$BTCFilterFile=$btcdir."BTC_Filter_Data_monthly.xlsx";
				if(file_exists($BTCFilterFile))
				{
					if(filesize($BTCFilterFile) > 0){
						$StartPoint = $Params['StartPoint'];
						$reader = $this->ProductImport->ReadFileXLS($BTCFilterFile);
						$ProductSizeArr = array();
						foreach ($reader->getSheetIterator() as $sheet) {
							$RowSNo =0;
							foreach ($sheet->getRowIterator() as $row) {
								$RowSNo++;
								if($RowSNo==1){
									$HeaderArray = array();
									foreach ($row->getCells() as $k=>$cell) {
										$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($cell->getValue())));
										//echo $index;
										if(!defined($index))	
											define($index,$k);
									
										$HeaderArray[constant($index)] = $cell->getValue();
										
									}
									$FilterArr = $this->BTCFilterHeaderCheck($HeaderArray);
									
								}
								else{
									$ExcelData = Array();
									foreach ($row->getCells() as $k=>$cell) {
										$ExcelData[$k] = $cell->getValue();
									}
									$ProductID = $this->BTCReadyFilter($FilterArr,$HeaderArray,$ExcelData);
									echo $ProductID." product - RowSNo: ".$RowSNo." processed".chr(13);
								}
								
							}
							
						}
						
						fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
						$BTCFilterFile=$btcdir."BTC_Filter_Data_monthly.xlsx";
						if(file_exists($BTCFilterFile))
							rename($BTCFilterFile,$btcdir."Filter_".date('Y-m-d-His').".xlsx");
						
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d',strtotime("+7 day"));
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$CronObj->tableUpdate($DataArray);
						
					}
					else{
						unlink($BTCFilterFile);
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCFilterFile";
						$Params['Action']="ImportFilter";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);

					}
					
					
				}
				else
				{
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$DataArray = array();
					$DataArray['CronDate'] = date('Y-m-d');
					$DataArray['CronStatus'] = "Pending";
					$DataArray['Params'] = "";
					$DataArray['CronMessage'] = "";
					$CronObj->tableUpdate($DataArray);
				
					
				}
			}
			/* ImportFilter BTCFilterFile file end*/
			

			
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$BTCFilterFile=$btcdir."BTC_Filter_Data_monthly.xlsx";
			if(file_exists($BTCFilterFile))
				@unlink($BTCFilterFile);	
			
		}

		fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
		
		
	}
	public function BTCFilterHeaderCheck($HeaderArray)
	{
		$ReturnArray = array();
		foreach($HeaderArray as $k=>$FilterName){
			if($k > 0){
				$FilterObj = new DataTable(TABLE_FILTER);
				$where = new Where();
				$where->equalTo('FilterType','FeedBTC');
				$where->equalTo('FilterName',$FilterName);
				//$FilterObj->displayQuery = true;
				$FilterObj->where = $where;
				$TmpObj = (object)$FilterObj->tableSelectOne(array("FilterID","FilterName"));
				if(isset($TmpObj->FilterID)){
					$FilterID = $TmpObj->FilterID;
				}
				else{
					
					$DataArray = array();
					$DataArray['Active'] = "1";
					$DataArray['FilterName'] = $FilterName;
					$DataArray['FilterType'] = 'FeedBTC';
					$DataArray['CreatedDate'] = date('Y-n-d H:i:s');
					$FilterID = $FilterObj->tableInsert($DataArray);
					
				}
				$ReturnArray[$k] = array($FilterID,$FilterName);
			}
			
		}
		return $ReturnArray;
	}
	public function BTCReadyFilter($FilterArr,$HeaderArray,$ExcelData)
	{
		/*foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)));
			//echo $index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-","/"),array("_","_",""), trim($val)))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		*/
		$BTC_SPC = isset($ExcelData[0])?$ExcelData[0]:"";
		$ProductID = 0;
		if($BTC_SPC != ""){
			$checkProduct = $this->checkProductbySKU($BTC_SPC);
			$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
			if($ProductID > 0){
				
				$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION_FILTER);
				$ProductRelationObj->where = "ProductID='".(int)$ProductID."'";
				$ProductRelationObj->tableDelete();	
			
				foreach($FilterArr as $k=>$arr){
					$FilterID = isset($FilterArr[$k][0])?$FilterArr[$k][0]:"";
					$FValArr = explode(",",$ExcelData[$k]);
					if(count($FValArr) > 0){
						foreach($FValArr as $ff=>$FilterValue){
							if($FilterID > 0 && $FilterValue != ""){
								$FilterValueID = $this->getClass('Catalog\Filter\Common')->addEditFilterValue($FilterID,$FilterValue);
								
								$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION_FILTER);
								$AttDataArray = array();
								$AttDataArray['ProductID'] = $ProductID;
								$AttDataArray['FilterValueID'] = $FilterValueID;
								$AttDataArray['FilterID'] = $FilterID;
								$ProductRelationObj->tableInsert($AttDataArray);
							}
						}
					}
				}
			}
		}
		
	return $ProductID;	
}

	
	public function ImportBTCBrandAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_brand".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
			fputs($fp2,"======================================================".chr(13));	
			fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		
			
			$sk_timestart = explode(' ', microtime() );
			$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
			
			/* script start here*/	
			if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
				$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				if(count($Params)==0)
				{
					$Params['Section']="BTCBrandFile";
					$Params['Action']="DownloadBrand";
					$Params['StartPoint']="0";				
				}
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				/* Download BTCBrandFile file start*/
				$BTCBrandFile=$btcdir."brands.xlsx";
				if($Params['Section']=="BTCBrandFile" && $Params['Action']=="DownloadBrand"){
					if(file_exists($BTCBrandFile)==false)
					{
						fputs($fp2,"BTCBrandFile ".$UniqueID."= START Download brands.xlsx ".chr(13));	
						$d_return = $this->ProductImport->downloadFTPFile("webdata/brands.xlsx",$BTCBrandFile);
						if(isset($d_return['error'])){
							fputs($fp2,"Download Fail BTCBrandFile ".$UniqueID."=".print_r($d_return,true).chr(13));
							if(file_exists($BTCBrandFile))
								unlink($BTCBrandFile);
							
						}
						fputs($fp2,"BTCBrandFile ".$UniqueID."= END Download brands.xlsx ".chr(13));
					}
					else
					{
						fputs($fp2,"Ready for ImportBrand ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCBrandFile";
						$Params['Action']="ImportBrand";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
					}
				}
				/* Download BTCBrandFile file end*/
				
				
				/* ImportFull BTCBrandFile file start*/
				if($Params['Section']=="BTCBrandFile" && $Params['Action']=="ImportBrand"){
					$BTCBrandFile=$btcdir."brands.xlsx";
					if(file_exists($BTCBrandFile))
					{
						if(filesize($BTCBrandFile) > 0){
							$StartPoint = $Params['StartPoint'];
							$reader = $this->ProductImport->ReadFileXLS($BTCBrandFile);
							foreach ($reader->getSheetIterator() as $sheet) {
								$RowSNo =0;
								foreach ($sheet->getRowIterator() as $row) {
									$RowSNo++;
									if($RowSNo==1){
										$HeaderArray = array();
										foreach ($row->getCells() as $k=>$cell) {
											$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($cell->getValue())));
											if(!defined($index))	
												define($index,$k);
										
											$HeaderArray[constant($index)] = $cell->getValue();
										}
										
									}
									else{
										$ExcelData = Array();
										if($RowSNo >= $StartPoint){
											foreach ($row->getCells() as $k=>$cell) {
												$ExcelData[$k] = $cell->getValue();
											}
											$BrandID = $this->BTCImportBrand($HeaderArray,$ExcelData);
											fputs($fp2,"Brand Update ".$UniqueID."=".print_r($BrandID,true).chr(13));	
											echo "<hr>--".$BrandID;
											
											$CronObj = new DataTable(TABLE_MODULE_CRONS);
											$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
											$Params['StartPoint']=$RowSNo;		
											$DataArray = array();
											$DataArray['CronStatus'] = "Processing";
											$DataArray['Params'] = base64_encode(serialize($Params));
											$CronObj->tableUpdate($DataArray);										
										}
									}
									
								}
								
							}
							
							
							fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
							$BTCBrandFile=$btcdir."brands.xlsx";
							if(file_exists($BTCBrandFile))
								rename($BTCBrandFile,$btcdir."brands_".date('Y-m-d-His').".xlsx");
							
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d',strtotime("+4 day"));
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);
							
						}
						else{
							unlink($BTCBrandFile);
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="BTCBrandFile";
							$Params['Action']="ImportBrand";
							$Params['StartPoint']="0";	
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);

						}
						
						
					}
					else
					{
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$DataArray = array();
						$DataArray['CronDate'] = date('Y-m-d');
						$DataArray['CronStatus'] = "Pending";
						$DataArray['Params'] = "";
						$DataArray['CronMessage'] = "";
						$CronObj->tableUpdate($DataArray);
					
						
					}
				}
				/* ImportBrand BTCBrandFile file end*/
				

				
				
			}
			/* script end here*/	
			
			if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
			
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$DataArray = array();
				$DataArray['CronDate'] = date('Y-m-d');
				$DataArray['CronStatus'] = "Pending";
				$DataArray['Params'] = "";
				$DataArray['CronMessage'] = "";
				$CronObj->tableUpdate($DataArray);
				
				$BTCFile=$btcdir."ProductExport_gec0006.zip";
				if(file_exists($BTCFile))
					@unlink($BTCFile);	
				
			}

			fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
			fputs($fp2,"======================================================".chr(13));	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
		
			
		
		
	}
	public function ImportBTCProductAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$btcdir = FileHandle::CheckPrivateLogDirectory("cron/btc");
		$filename=$btcdir."btc_".date('Y-m-d').".txt";
		$UniqueID = uniqid("BTC_");
		
		$fp2 = fopen($filename, "a+");
		try{
			fputs($fp2,"======================================================".chr(13));	
			fputs($fp2,"BTC Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		
			
			$sk_timestart = explode(' ', microtime() );
			$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
			
			/* script start here*/	
			if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
				$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				if(count($Params)==0)
				{
					$Params['Section']="BTCFile";
					$Params['Action']="DownloadFull";
					$Params['StartPoint']="0";				
				}
				$CurrencyValue = $this->getClass('Base\Currency\CurrencyHandler')->GetCurrencyRateFromDB("USD","GBP","1");
				fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
				/* Download BTCFile file start*/
				$BTCFile=$btcdir."ProductExport_gec0006.zip";
				if($Params['Section']=="BTCFile" && $Params['Action']=="DownloadFull"){
					if(file_exists($BTCFile)==false)
					{
						fputs($fp2,"BTCFile ".$UniqueID."= START Download ProductExport_gec0006.zip ".chr(13));	
						$d_return = $this->ProductImport->downloadFTPFile("ProductExport_gec0006.zip",$BTCFile);
						if(isset($d_return['error'])){
							fputs($fp2,"Download Fail BTCFile ".$UniqueID."=".print_r($d_return,true).chr(13));
							if(file_exists($BTCFile))
								unlink($BTCFile);
							
						}
						fputs($fp2,"BTCFile ".$UniqueID."= END Download ProductExport_gec0006.zip ".chr(13));
					}
					else
					{
						fputs($fp2,"Ready for UnzipFileFull ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCFile";
						$Params['Action']="UnzipFileFull";
						$Params['StartPoint']="0";	
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
					}
				}
				/* Download BTCFile file end*/
				
				/* Unzip BTCFile file start*/
				$BTCFile=$btcdir."ProductExport_gec0006.zip";
				if($Params['Section']=="BTCFile" && $Params['Action']=="UnzipFileFull"){
					if(file_exists($BTCFile))
					{
						if(filesize($BTCFile) > 0){
							fputs($fp2,"BTCFile ".$UniqueID."= START Unzip File ProductExport_gec0006.zip ".chr(13));	
							$BTCXLSFile=$btcdir."ProductExport_gec0006.xlsx";
							if(file_exists($BTCXLSFile))
								unlink($BTCXLSFile);	
							
							$this->ProductImport->unZip($btcdir,$BTCFile);
							fputs($fp2,"BTCFile ".$UniqueID."= END Unzip File ProductExport_gec0006.zip ".chr(13));
							
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="BTCFile";
							$Params['Action']="XLSAnalysis";
							$Params['StartPoint']="0";	
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
						}
						else{
							unlink($BTCFile);
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d');
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);

						}
					}
					else{
						
					}
					
				}
				/* Unzip BTCFile file end*/
				
				/* XLSAnalysis BTCFile file start*/
				if($Params['Section']=="BTCFile" && $Params['Action']=="XLSAnalysis"){
					$BTCFile=$btcdir."ProductExport_gec0006.zip";
					$BTCXLSFile=$btcdir."ProductExport_gec0006.xlsx";
					fputs($fp2,"BTCFile ".$UniqueID."= START XLSAnalysis File ProductExport_gec0006.xlsx ".chr(13));	
					if(file_exists($BTCXLSFile))
					{
						if(file_exists($BTCFile))
							unlink($BTCFile);	
						
						$reader = $this->ProductImport->ReadFileXLS($BTCXLSFile);
						$RowCount =0;
						foreach ($reader->getSheetIterator() as $sheet) {
							foreach ($sheet->getRowIterator() as $row) {
								$RowCount++;
							}
						}
						fputs($fp2,"RowCount XLSAnalysis Params ".$UniqueID."=".print_r($Params,true).chr(13));		
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['Section']="BTCFile";
						$Params['Action']="ImportFull";
						$Params['StartPoint']="0";		
						$Params['TotalRow']=$RowCount;		
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
						
					}
					else
					{
						
					}
				}
				/* XLSAnalysis BTCFile file end*/
				
				/* ImportFull BTCFile file start*/
				if($Params['Section']=="BTCFile" && $Params['Action']=="ImportFull"){
					$BTCXLSFile=$btcdir."ProductExport_gec0006.xlsx";
					if(file_exists($BTCXLSFile))
					{
						fputs($fp2," ReadFileXLS Params ".$UniqueID."=".print_r($Params,true).chr(13));		
						
						$TotalRow = $Params['TotalRow'];
						$StartPoint = $Params['StartPoint'];
						$reader = $this->ProductImport->ReadFileXLS($BTCXLSFile);
						foreach ($reader->getSheetIterator() as $sheet) {
							$RowSNo =0;
							foreach ($sheet->getRowIterator() as $row) {
								$RowSNo++;
								if($RowSNo==1){
									$HeaderArray = array();
									foreach ($row->getCells() as $k=>$cell) {
										$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($cell->getValue())));
										if(!defined($index)){	
											define($index,$k);
										}
										$HeaderArray[constant($index)] = $cell->getValue();
									}
									
									
								}
								else{
									$ExcelData = Array();
									if($RowSNo >= $StartPoint){
										foreach ($row->getCells() as $k=>$cell) {
											$ExcelData[$k] = $cell->getValue();
										}
										$checkChild = $this->BTCImportProduct($HeaderArray,$ExcelData);
										//fputs($fp2,"BTC ".$UniqueID."Child Product  =".print_r($checkChild,true).chr(13));	
										echo (isset($checkChild->ProductID)?$checkChild->ProductID:0)." child - RowSNo: ".$RowSNo." processed".chr(13);
										$CronObj = new DataTable(TABLE_MODULE_CRONS);
										$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
										$Params['StartPoint']=$RowSNo;		
										$DataArray = array();
										$DataArray['CronStatus'] = "Processing";
										$DataArray['Params'] = base64_encode(serialize($Params));
										$CronObj->tableUpdate($DataArray);
									}
								}
								
								//if($RowSNo > 1000)
								//	break;
							}
							
						}
						/*
						$CronObj = new DataTable(TABLE_MODULE_CRONS);
						$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
						$Params['StartPoint']=0;		
						$DataArray = array();
						$DataArray['CronStatus'] = "Processing";
						$DataArray['Params'] = base64_encode(serialize($Params));
						$CronObj->tableUpdate($DataArray);
						*/
						
						if($RowSNo==$TotalRow){
							
							fputs($fp2,"Reset Cron Params ".$UniqueID."=".print_r($Params,true).chr(13));		
							$BTCXLSFile=$btcdir."ProductExport_gec0006.xlsx";
							rename($BTCXLSFile,$btcdir."ProductExport_gec0006_".date('Y-m-d-His').".xlsx");
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$DataArray = array();
							$DataArray['CronDate'] = date('Y-m-d',strtotime("+7 day"));
							$DataArray['CronStatus'] = "Pending";
							$DataArray['Params'] = "";
							$CronObj->tableUpdate($DataArray);
						}
						
						
					}
					else
					{
						
					}
				}
				/* ImportFull BTCFile file end*/
				

				
				
			}
			/* script end here*/	
			
			if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
			
				if($Obj->CronStatus=="Processing"){
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$DataArray = array();
					$DataArray['CronDate'] = date('Y-m-d');
					$CronObj->tableUpdate($DataArray);
				}
				else{
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$DataArray = array();
					$DataArray['CronDate'] = date('Y-m-d');
					$DataArray['CronStatus'] = "Pending";
					$DataArray['Params'] = "";
					$DataArray['CronMessage'] = "";
					$CronObj->tableUpdate($DataArray);
					
					$BTCFile=$btcdir."ProductExport_gec0006.zip";
					if(file_exists($BTCFile))
						@unlink($BTCFile);	
				}
				
				
			}

			fputs($fp2,"BTC End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
			fputs($fp2,"======================================================".chr(13));	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
		
			
			
		
	}
	
	
	public function BTCImportBrand($HeaderArray,$ExcelData)
	{
		foreach($HeaderArray as $key=>$val):
			$index = "  ".strtoupper(str_replace(array(" ",array("-")),array("_",""), trim($val)));
			//echo "<hr>".$index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ",array("-")),array("_",""),$val))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		if($BTC_BRAND_NAME != ""){
			
			$DBObj = new DataTable(TABLE_BRANDS);
			$where = new Where();
			$where->equalTo('UploadType','FeedBTC');
			$where->equalTo('FeedID',$BTC_BRAND_NAME);
			$DBObj->where = $where;
			$CurrentBrand  = (object)$DBObj->tableSelectOne(array("BrandID","BrandName","Image"));
			if(isset($CurrentBrand->BrandID)){
				$BrandID = $CurrentBrand->BrandID;
				//$DataArray = array();
				//$DataArray['Description'] = isset($BTC_BRAND_DESCRIPTION)?$BTC_BRAND_DESCRIPTION:"";
				//$DBObj->tableUpdate($DataArray);
			}
			else{
				
				$DBObj2 = new DataTable(TABLE_BRANDS);
				$DataArray = array();
				$DataArray['BrandName'] = isset($BTC_BRAND_NAME)?$BTC_BRAND_NAME:"";
				$Image = (isset($BTC_BRAND_IMAGE_FILENAME) && $BTC_BRAND_IMAGE_FILENAME != "")?"btc_".$BTC_BRAND_IMAGE_FILENAME:"";
				if($Image != ""){
					$branddir = FileHandle::CheckUploadLogDirectory("brand");
					$ImagePath=$branddir.$Image;
					if(!file_exists($ImagePath)){
						$this->ProductImport->downloadFTPFile("webdata/brands/".$BTC_BRAND_IMAGE_FILENAME,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							$ImageAltText = $BTC_BRAND_NAME;
							$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_brand",'brand',$ImageAltText);
						}
						else{
							unlink($ImagePath);
						}
					}
				}
				$DataArray['Description'] = isset($BTC_BRAND_DESCRIPTION)?$BTC_BRAND_DESCRIPTION:"";
				$DataArray['Active'] = "1";
				$DataArray['Position'] =  $DBObj2->getMax("Position") + 1;
				$DataArray['UploadType'] = "FeedBTC";
				$DataArray['FeedID'] = $BTC_BRAND_NAME;
				$DataArray['CreatedDate'] = date('Y-m-d-H:i:s');
				$BrandID = $DBObj->tableInsert($DataArray);
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$BrandID." AND MCode ='catalog_brand' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				$DataArray = array();
				$DataArray['MetaTitle'] =$BTC_BRAND_NAME." - Collections";
				$DataArray['MetaKeyword'] =$BTC_BRAND_NAME;
				$DataArray['MetaDescription'] =isset($BTC_BRAND_DESCRIPTION)?strip_tags($BTC_BRAND_DESCRIPTION):"";
			
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($BTC_BRAND_NAME,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;
					$SeoObj->tableUpdate($DataArray);
				}
				else{
					
					$URL = 	SkURLCreate($BTC_BRAND_NAME);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;			
					$DataArray['MCode'] = "catalog_brand";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $BrandID;
					$SeoObj->tableInsert($DataArray);
				}			
				
			}
			return $BrandID;
			
		}
		
	}
	
	public function BTCImportProduct($HeaderArray,$ExcelData)
	{
		foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($val)));
			//echo "<hr>".$index."--".constant($index);
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-"),array("_","_"),$val))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		if($BTC_UID != "" && $BTC_UID != "[stock_id]"){
			
			$ModifiedDate = date('Y-m-d H:i:s',strtotime(str_replace("/","-",$BTC_LAST_CHANGED_DATE)));
			$checkMaster = $this->BTCMasterProductbySKU($BTC_SPC,$ModifiedDate,$HeaderArray,$ExcelData);
			$MasterID = isset($checkMaster->ProductID)?$checkMaster->ProductID:"";
			if($MasterID > 0){
				$checkChild = $this->BTCAddEditChildProduct($MasterID,$ModifiedDate,$HeaderArray,$ExcelData);
				return $checkChild;
			}			
		}
		
	}
	public function BTCAddEditChildProduct($MasterID,$ModifiedDate,$HeaderArray=array(),$ExcelData=array())
	{
		$ImageArray = array();
		foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($val)));
			if(defined($index)){
			${"BTC_".strtoupper(str_replace(array(" ","-"),array("_","_"),$val))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
			}
		endforeach;
		if($BTC_UID != ""){
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$where = new Where();
			$where->equalTo('ProductType','Child');
			$where->equalTo('UploadType','FeedBTC');
			$where->equalTo('MasterID',$MasterID);
			$where->equalTo('FeedID',$BTC_UID);
			//$ProductObj->displayQuery = true;
			$ProductObj->where = $where;
			$checkProduct  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
			$ChildProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
			if($ChildProductID==0){
										
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
				$Position = $ProductObj->getMax("Position") + 1;
				$BlankData = array();
				$BlankData['StockStatus'] = "1";
				$BlankData['EndStock'] = "1";
				$BlankData['StockTotal'] = "0";
				$BlankData['Stock'] = "0";
				$BlankData['Clearance'] = "0";
				$BlankData['ProductType'] = 'Child';
				$BlankData['UploadType'] = 'FeedBTC';
				$BlankData['MasterID'] = $MasterID;
				$BlankData['FeedID'] = $BTC_UID;
				$BlankData['Position'] = $Position;
				$BlankData['ModelNo'] = $BTC_UID;
				$BlankData['ModifiedDate'] =$ModifiedDate;
				$BlankData['CreatedDate'] =date('Y-m-d H:i:s');
				$ChildProductID = $ProductObj->tableInsert($BlankData);		
				
			}
			if($ChildProductID > 0){
				$AttributeArr = $this->BTCAttributes($BTC_COLOUR_CODE,$BTC_COLOUR_NAME,$BTC_SIZE,$BTC_COLOUR_CODE_URL);
				$SubDataArray = array();
										
				$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
				$ProductRelationObj->where = "RelationType='attribute_child' and ProductID='".(int)$ChildProductID."'";
				$ProductRelationObj->tableDelete();	
				
				$ProductAttribute = "";
				$ProductAttributeString = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"")." - Colour: ".$BTC_COLOUR_NAME." - Size: ".$BTC_SIZE;
				$ModelNoString = $BTC_SPC;
				foreach($AttributeArr as $AttributeID=>$AttributeValueID){
					$ProductAttribute .= $AttributeID."=".$AttributeValueID.", ";
					$ModelNoString .= "___".$AttributeValueID;

					$AttDataArray = array();
					$AttDataArray['ProductID'] = $ChildProductID;
					$AttDataArray['RelationID'] = $AttributeValueID;
					$AttDataArray['RelationType'] = "attribute_child";
					$AttDataArray['Custom'] = $AttributeID;
					$ProductRelationObj->tableInsert($AttDataArray);
					
				}
				
				$SubDataArray['ProductAttribute'] = substr($ProductAttribute,0,-2); 
				$SubDataArray['ProductName'] = $ProductAttributeString;
				$SubDataArray['SmallDescription'] = $ProductAttributeString;
				$SubDataArray['ProductLine'] = $ModelNoString;
				//$SubDataArray['Active'] = ($BTC_STOCK_STATUS=="C")?"1":"0";
				$SubDataArray['Active'] = "1";
				$SubDataArray['Clearance'] = ($BTC_STOCK_STATUS=="D")?"1":"0";
				$SubDataArray['FeedBarcode'] = ($BTC_BARCODE !="")?$BTC_BARCODE:"";
				$SubDataArray['FeedGtin'] = ($BTC_GTIN !="")?$BTC_GTIN:"";
				$SubDataArray['DumpData'] = serialize($ExcelData);
				$SubDataArray['TaxClass'] = "1";
				if(isset($BTC_VAT_CODE) && $BTC_VAT_CODE==2)
					$SubDataArray['TaxClass'] = "2";
			
				
				if(isset($BTC_IMAGE_URL_HIGH_RES) && $BTC_IMAGE_URL_HIGH_RES != ""){
					$ImageArray[md5($BTC_IMAGE_URL_HIGH_RES)] =$BTC_IMAGE_URL_HIGH_RES;
					
				}
			
				if(isset($BTC_COLOUR_IMAGE_01) && $BTC_COLOUR_IMAGE_01 != ""){
					$ImageArray[md5($BTC_COLOUR_IMAGE_01)] =$BTC_COLOUR_IMAGE_01;
					$SubDataArray['Image'] = basename($BTC_IMAGE_URL_HIGH_RES);
				}
				if(isset($BTC_COLOUR_IMAGE_02) && $BTC_COLOUR_IMAGE_02 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_02)] =$BTC_COLOUR_IMAGE_02;
				if(isset($BTC_COLOUR_IMAGE_03) && $BTC_COLOUR_IMAGE_03 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_03)] =$BTC_COLOUR_IMAGE_03;
				if(isset($BTC_COLOUR_IMAGE_04) && $BTC_COLOUR_IMAGE_04 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_04)] =$BTC_COLOUR_IMAGE_04;
				if(isset($BTC_COLOUR_IMAGE_05) && $BTC_COLOUR_IMAGE_05 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_05)] =$BTC_COLOUR_IMAGE_05;
				if(isset($BTC_COLOUR_IMAGE_06) && $BTC_COLOUR_IMAGE_06 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_06)] =$BTC_COLOUR_IMAGE_06;
				if(isset($BTC_COLOUR_IMAGE_07) && $BTC_COLOUR_IMAGE_07 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_07)] =$BTC_COLOUR_IMAGE_07;
				if(isset($BTC_COLOUR_IMAGE_08) && $BTC_COLOUR_IMAGE_08 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_08)] =$BTC_COLOUR_IMAGE_08;
				if(isset($BTC_COLOUR_IMAGE_09) && $BTC_COLOUR_IMAGE_09 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_09)] =$BTC_COLOUR_IMAGE_09;
				if(isset($BTC_COLOUR_IMAGE_10) && $BTC_COLOUR_IMAGE_10 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_10)] =$BTC_COLOUR_IMAGE_10;
				
				
				
				if(isset($BTC_IMAGE_URL_HIGH_RES) && $BTC_IMAGE_URL_HIGH_RES != ""){
					$ImageArray[md5($BTC_IMAGE_URL_HIGH_RES)] =array("image"=>$BTC_IMAGE_URL_HIGH_RES,"alt"=>(isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:""));
					
				}
				
				if(isset($BTC_COLOUR_IMAGE_01) && $BTC_COLOUR_IMAGE_01 != ""){
					$ImageArray[md5($BTC_COLOUR_IMAGE_01)] =array("image"=>$BTC_COLOUR_IMAGE_01,"alt"=>$BTC_SPC."-01");
					$SubDataArray['Image'] = basename($BTC_COLOUR_IMAGE_01);
				}
				if(isset($BTC_COLOUR_IMAGE_02) && $BTC_COLOUR_IMAGE_02 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_02)] =array("image"=>$BTC_COLOUR_IMAGE_02,"alt"=>$BTC_SPC."-02");
				if(isset($BTC_COLOUR_IMAGE_03) && $BTC_COLOUR_IMAGE_03 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_03)] =array("image"=>$BTC_COLOUR_IMAGE_03,"alt"=>$BTC_SPC."-03");
				if(isset($BTC_COLOUR_IMAGE_04) && $BTC_COLOUR_IMAGE_04 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_04)] =array("image"=>$BTC_COLOUR_IMAGE_04,"alt"=>$BTC_SPC."-04");
				if(isset($BTC_COLOUR_IMAGE_05) && $BTC_COLOUR_IMAGE_05 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_05)] =array("image"=>$BTC_COLOUR_IMAGE_05,"alt"=>$BTC_SPC."-05");
				if(isset($BTC_COLOUR_IMAGE_06) && $BTC_COLOUR_IMAGE_06 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_06)] =array("image"=>$BTC_COLOUR_IMAGE_06,"alt"=>$BTC_SPC."-06");
				if(isset($BTC_COLOUR_IMAGE_07) && $BTC_COLOUR_IMAGE_07 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_07)] =array("image"=>$BTC_COLOUR_IMAGE_07,"alt"=>$BTC_SPC."-07");
				if(isset($BTC_COLOUR_IMAGE_08) && $BTC_COLOUR_IMAGE_08 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_08)] =array("image"=>$BTC_COLOUR_IMAGE_08,"alt"=>$BTC_SPC."-08");
				if(isset($BTC_COLOUR_IMAGE_09) && $BTC_COLOUR_IMAGE_09 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_09)] =array("image"=>$BTC_COLOUR_IMAGE_09,"alt"=>$BTC_SPC."-09");
				if(isset($BTC_COLOUR_IMAGE_10) && $BTC_COLOUR_IMAGE_10 != "")
					$ImageArray[md5($BTC_COLOUR_IMAGE_10)] =array("image"=>$BTC_COLOUR_IMAGE_10,"alt"=>$BTC_SPC."-10");
				
			
				$this->AddAddditionalImages($MasterID,$ImageArray,$BTC_IMAGE_URL_HIGH_RES,$BTC_DESCRIPTION);
				
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				 $ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
				$ProductObj->tableUpdate($SubDataArray);
				/* ProductPrice entry start*/
				$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
				$UserTypeID ='1';
				$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".$UserTypeID."' AND 
										   (QtyMin='0' OR QtyMin='1')";
				$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
				$DataArray = array();
				$DataArray['Price'] = (isset($BTC_BTC_PRICE) && $BTC_BTC_PRICE !="")?$this->ProductImport->PriceIncrease($BTC_BTC_PRICE):"0";
				if(isset($BTC_CUSTOMER_DISCOUNTED_PRICE) && $BTC_CUSTOMER_DISCOUNTED_PRICE > 0)
					$DataArray['Price'] = $this->ProductImport->PriceIncrease($BTC_CUSTOMER_DISCOUNTED_PRICE);
					
				$DataArray['SalePrice'] = "0";
				$DataArray['SaleActive'] = "0";
				
				if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
				{
					$ProductPriceObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['QtyMin'] = "0";
					$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$DataArray['PriceType'] = 'Unit';
					$DataArray['UserTypeID'] = $UserTypeID;
					$DataArray['ProductID'] = $ChildProductID;
					$ProductPriceObj->tableInsert($DataArray);
				}
				
				/* ProductPriceObj entry end*/
				
			$ProductObj = new DataTable(TABLE_PRODUCT);
			$where = new Where();
			$where->equalTo('ProductType','Child');
			$where->equalTo('UploadType','FeedBTC');
			$where->equalTo('MasterID',$MasterID);
			$where->equalTo('FeedID',$BTC_UID);
			//$ProductObj->displayQuery = true;
			$ProductObj->where = $where;
			$checkProduct  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
			return $checkProduct;				
									
				
			}
			
		}
		
	}
	public function BTCMasterProductbySKU($ModelNo,$ModifiedDate,$HeaderArray=array(),$ExcelData=array())
	{
		if(trim($ModelNo)=="")
			return 0;
		
		$ImageArray = array();
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$where = new Where();
		$where->equalTo('UploadType','FeedBTC');
		$where->equalTo('FeedID',$ModelNo);
		//$ProductObj->displayQuery = true;
		$ProductObj->where = $where;
		$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
		$UpdateRecord = $NewRecord = false;
		if(isset($Obj->ProductID)){
			$ProductID = $Obj->ProductID;
			if($Obj->ModifiedDate == $ModifiedDate){
				return $Obj;
			}
			else{
				$UpdateRecord = true;
			}
		}
		else{
			$NewRecord = true;
		}
		
		if($NewRecord===true || $UpdateRecord==true){
			
			foreach($HeaderArray as $key=>$val):
			$index = "DATA_EXCEL_".strtoupper(str_replace(array(" ","-"),array("_","_"), trim($val)));
				if(defined($index)){
				${"BTC_".strtoupper(str_replace(array(" ","-"),array("_","_"),$val))} = isset($ExcelData[constant($index)])?trim($ExcelData[constant($index)]):"";
				}
			endforeach;
			$BrandID = $this->BTCGetBrandID($BTC_BRAND_CODE,$BTC_BRAND,$BTC_BRAND_IMAGE);
			$CategoriesIDs = $this->BTCGetCategoryIDs($BTC_DEPARTMENT_CODE,$BTC_DEPARTMENT,$BTC_SUB_DEPARTMENT_CODE,$BTC_SUB_DEPARTMENT);
			
			
			
			
			$DataArray = array();
			$DataArray['ModelNo'] = $ModelNo;
			$DataArray['ProductName'] = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"");
			$DataArray['BrandID'] = ($BrandID > 0)?$BrandID:"0";
			$DataArray['LargeDescription'] = isset($BTC_BULLET_POINTS)?$BTC_BULLET_POINTS:"";
			//$DataArray['Active'] = ($BTC_STOCK_STATUS=="C")?"1":"0";
			$DataArray['Active'] = "1";
			$DataArray['SizeScale'] = isset($BTC_SIZE_SCALE)?$BTC_SIZE_SCALE:"";
			$DataArray['StyleCode'] = isset($BTC_STYLE_CODE)?$BTC_STYLE_CODE:"";
			$DataArray['TaxClass'] = "1";
			if(isset($BTC_VAT_CODE) && $BTC_VAT_CODE==2)
			  $DataArray['TaxClass'] = "2";
				
			$DataArray['ModifiedDate'] = $ModifiedDate;
			$DataArray['DumpData'] = serialize($ExcelData);
			if(isset($BTC_IMAGE_URL_HIGH_RES) && $BTC_IMAGE_URL_HIGH_RES != ""){
					$ImageArray[md5($BTC_IMAGE_URL_HIGH_RES)] =array("image"=>$BTC_IMAGE_URL_HIGH_RES,"alt"=>(isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:""));
					$DataArray['Image'] = basename($BTC_IMAGE_URL_HIGH_RES);
			}
			
			if(isset($BTC_COLOUR_IMAGE_01) && $BTC_COLOUR_IMAGE_01 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_01)] =array("image"=>$BTC_COLOUR_IMAGE_01,"alt"=>$BTC_SPC."-01");
			if(isset($BTC_COLOUR_IMAGE_02) && $BTC_COLOUR_IMAGE_02 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_02)] =array("image"=>$BTC_COLOUR_IMAGE_02,"alt"=>$BTC_SPC."-02");
			if(isset($BTC_COLOUR_IMAGE_03) && $BTC_COLOUR_IMAGE_03 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_03)] =array("image"=>$BTC_COLOUR_IMAGE_03,"alt"=>$BTC_SPC."-03");
			if(isset($BTC_COLOUR_IMAGE_04) && $BTC_COLOUR_IMAGE_04 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_04)] =array("image"=>$BTC_COLOUR_IMAGE_04,"alt"=>$BTC_SPC."-04");
			if(isset($BTC_COLOUR_IMAGE_05) && $BTC_COLOUR_IMAGE_05 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_05)] =array("image"=>$BTC_COLOUR_IMAGE_05,"alt"=>$BTC_SPC."-05");
			if(isset($BTC_COLOUR_IMAGE_06) && $BTC_COLOUR_IMAGE_06 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_06)] =array("image"=>$BTC_COLOUR_IMAGE_06,"alt"=>$BTC_SPC."-06");
			if(isset($BTC_COLOUR_IMAGE_07) && $BTC_COLOUR_IMAGE_07 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_07)] =array("image"=>$BTC_COLOUR_IMAGE_07,"alt"=>$BTC_SPC."-07");
			if(isset($BTC_COLOUR_IMAGE_08) && $BTC_COLOUR_IMAGE_08 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_08)] =array("image"=>$BTC_COLOUR_IMAGE_08,"alt"=>$BTC_SPC."-08");
			if(isset($BTC_COLOUR_IMAGE_09) && $BTC_COLOUR_IMAGE_09 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_09)] =array("image"=>$BTC_COLOUR_IMAGE_09,"alt"=>$BTC_SPC."-09");
			if(isset($BTC_COLOUR_IMAGE_10) && $BTC_COLOUR_IMAGE_10 != "")
				$ImageArray[md5($BTC_COLOUR_IMAGE_10)] =array("image"=>$BTC_COLOUR_IMAGE_10,"alt"=>$BTC_SPC."-10");
			
			if($UpdateRecord==true){
				$ProductObj->tableUpdate($DataArray);
			}
			else{
				
				$DataArray['StockStatus'] = "1";
				$DataArray['EndStock'] = "0";
				$DataArray['StockTotal'] = "0";
				$DataArray['Stock'] = "0";
				
				$DataArray['UploadType'] = "FeedBTC";
				$DataArray['FeedID'] = $ModelNo;
				$DataArray['ProductType'] = "Attribute";
				$DataArray['ProductAttribute'] = "101,102";
				$DataArray['MasterID'] = "0";
				$DataArray['SupplierID'] = "1";
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$ProductID = $ProductObj->tableInsert($DataArray);
				
				/* SEO START*/
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$ProductID." AND MCode ='catalog_product' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$DataArray = array();
				$URL = 	SkURLCreate((isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"")." ".$ModelNo);
				$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_product','Detail',$ProductID);
				$DataArray['URLName'] = $URL;
				
				if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
				{
					$DataArray['MetaTitle'] = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"");
					$DataArray['MetaKeyword'] = $BTC_BRAND." ".$BTC_SPC." "." ".$BTC_DEPARTMENT." "." ".$BTC_SUB_DEPARTMENT." "." ".$BTC_DESCRIPTION;
					$DataArray['MetaDescription'] = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"")." ".strip_tags($BTC_BULLET_POINTS);
				}
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['MCode'] = "catalog_product";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $ProductID;
					$SeoObj->tableInsert($DataArray);
				}
				/* SEO END*/
				
				
				
			}
			if($ProductID > 0){
				
				
				/* SEO START /
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$ProductID." AND MCode ='catalog_product' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$DataArray = array();
				$URL = 	SkURLCreate((isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"")." ".$ModelNo);
				$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_product','Detail',$ProductID);
				$DataArray['URLName'] = $URL;
				
				if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
				{
					$DataArray['MetaTitle'] = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"");
					$DataArray['MetaKeyword'] = $BTC_BRAND." ".$BTC_SPC." "." ".$BTC_DEPARTMENT." "." ".$BTC_SUB_DEPARTMENT." "." ".$BTC_DESCRIPTION;
					$DataArray['MetaDescription'] = (isset($BTC_BRAND)?$BTC_BRAND:"")." ".(isset($BTC_DESCRIPTION)?$BTC_DESCRIPTION:"")." ".strip_tags($BTC_BULLET_POINTS);
				}
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['MCode'] = "catalog_product";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $ProductID;
					$SeoObj->tableInsert($DataArray);
				}
				/* SEO END*/
				
				/* ProductPrice entry start*/
				$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
				$UserTypeID ='1';
				$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
										   (QtyMin='0' OR QtyMin='1')";
				$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
				$DataArray = array();
				$DataArray['Price'] = (isset($BTC_BTC_PRICE) && $BTC_BTC_PRICE !="")?$this->ProductImport->PriceIncrease($BTC_BTC_PRICE):"0";
				if(isset($BTC_CUSTOMER_DISCOUNTED_PRICE) && $BTC_CUSTOMER_DISCOUNTED_PRICE > 0)
					$DataArray['Price'] = $this->ProductImport->PriceIncrease($BTC_CUSTOMER_DISCOUNTED_PRICE);
				
				$DataArray['SalePrice'] = "0";
				$DataArray['SaleActive'] = "0";
				
				if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
				{
					$ProductPriceObj->tableUpdate($DataArray);
				}
				else 
				{
					$DataArray['QtyMin'] = "0";
					$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$DataArray['PriceType'] = 'Unit';
					$DataArray['UserTypeID'] = $UserTypeID;
					$DataArray['ProductID'] = $ProductID;
					$ProductPriceObj->tableInsert($DataArray);
				}
				
				/* ProductPriceObj entry end*/
				$this->AddAddditionalImages($ProductID,$ImageArray,$BTC_IMAGE_URL_HIGH_RES,$BTC_DESCRIPTION);
				$this->getClass('Catalog\Product\Common')->AssignCategories($ProductID,$CategoriesIDs);
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$where = new Where();
				$where->equalTo('UploadType','FeedBTC');
				$where->equalTo('FeedID',$ModelNo);
				//$ProductObj->displayQuery = true;
				$ProductObj->where = $where;
				$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName","ModifiedDate"));
				return $Obj;
				
			}
			
		}
	}
	
	
	public function AddAddditionalImages($ProductID,$ImageArray,$BTC_IMAGE_URL_HIGH_RES,$BTC_DESCRIPTION)
	{
		if(count($ImageArray) > 0){
			foreach($ImageArray as $imgk=>$img_arr){
				$img_url =$img_arr['image'];
				$Image = basename($img_url);
				if($Image != ""){
					$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
					$ImagePath=$productdir.$Image;
					if(!file_exists($ImagePath)){
						$this->ProductImport->uploadImage($img_url,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							
							$ProductImageObj = new DataTable(TABLE_PRODUCT_IMAGES);
							$DataArray = array();
							$DataArray['ProductID'] = $ProductID;
							$DataArray['Active'] = "1";
							$DataArray['Position'] = "0";
							
							/* product image added*/
							$ImageAltText = isset($img_arr['alt'])?$img_arr['alt']:$BTC_DESCRIPTION;
							$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$ProductID);
							$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_product",'product/p-'.$ProductID,$ImageAltText);
					
							/* product image end*/
							
							
							$where = new Where();
							$where->equalTo('Image',$Image);
							$where->equalTo('ProductID',$ProductID);
							$ProductImageObj->where = $where;
							$Obj  = (object)$ProductImageObj->tableSelectOne(array("ImageID"));
							if(!isset($Obj->ImageID) && $BTC_IMAGE_URL_HIGH_RES != "" && $imgk != md5($BTC_IMAGE_URL_HIGH_RES)){
								$ProductImageObj->tableInsert($DataArray);
							}
						}
						else{
							
						}
					}
				}
			}
		}
	}
	
	public function BTCAttributes($BTC_COLOUR_CODE,$BTC_COLOUR_NAME,$BTC_SIZE,$BTC_COLOUR_CODE_URL)
	{
		$AttributeArray = array();
		$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
		if($BTC_COLOUR_NAME != ""){
			
			$DBObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
			$where = new Where();
			$where->equalTo('AttributeID',"101");
			$where->equalTo('AttributeValue',trim($BTC_COLOUR_NAME));
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("AttributeValueID"),"AttributeValueID ASC");
			if(isset($Singleobj->AttributeValueID)){
				$AttributeArray[101] = $Singleobj->AttributeValueID;
			}
			else{
				
				
				$SubDataArray = array();
				
				$Image = basename($BTC_COLOUR_CODE_URL);
				if($Image != ""){
					$imgdir = FileHandle::CheckUploadLogDirectory("attribute");
					$ImagePath=$imgdir.$Image;
					if(!file_exists($ImagePath)){
						$this->ProductImport->uploadImage($BTC_COLOUR_CODE_URL,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							$ImageAltText = $BTC_COLOUR_NAME;
							$SubDataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_attribute","attribute",$ImageAltText);
						}
						else{
							unlink($ImagePath);
						}
					}
				}
				$SubDataArray['AttributeValue'] =trim($BTC_COLOUR_NAME);
				$SubDataArray['AttributeLine'] =trim($BTC_COLOUR_CODE);
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['AttributeID'] ="101";
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedType'] ="FeedBTC";
				$AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
				$AttributeArray[101] = $AttributeValueID;
				
			}
		}
		if($BTC_SIZE != ""){
			
			$DBObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
			$where = new Where();
			$where->equalTo('AttributeID',"102");
			$where->equalTo('AttributeValue',trim($BTC_SIZE));
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("AttributeValueID"),"AttributeValueID ASC");
			if(isset($Singleobj->AttributeValueID)){
				$AttributeArray[102] = $Singleobj->AttributeValueID;
			}
			else{
				
				
				$SubDataArray = array();
				
				$SubDataArray['AttributeValue'] =trim($BTC_SIZE);
				$SubDataArray['AttributeLine'] =trim($BTC_SIZE);
				$SubDataArray['Active'] = "1"; 
				$SubDataArray['Position'] = "0";  
				$SubDataArray['AttributeID'] ="102";
				$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubDataArray['FeedType'] ="FeedBTC";
				$AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
				$AttributeArray[102] = $AttributeValueID;
				
			}
		}
		
		return $AttributeArray;
	}
	public function BTCGetBrandID($BTC_BRAND_CODE,$BTC_BRAND,$BTC_BRAND_IMAGE)
	{
		$BrandID =0;
		if($BTC_BRAND != ""){
			$DBObj = new DataTable(array('c'=>TABLE_BRANDS));
			$where = new Where();
			$where->equalTo('BrandCode',trim($BTC_BRAND_CODE));
			$where->equalTo('UploadType','FeedBTC');
			$DBObj->where = $where;
			$Singleobj = (object)$DBObj->tableSelectOne(array("BrandID"),"BrandID ASC");
			if(isset($Singleobj->BrandID) && $Singleobj->BrandID != ""){
				$BrandID = $Singleobj->BrandID; 	
			}
			else{
				
				$BrandObj = new DataTable(array('c'=>TABLE_BRANDS));
				$DataArray = array();
				$DataArray['Active'] = "0";
				$DataArray['BrandName'] = trim($BTC_BRAND);
				$DataArray['BrandCode'] = trim($BTC_BRAND_CODE);
				$DataArray['UploadType'] = "FeedBTC";
				$DataArray['FeedID'] = $BTC_BRAND;
				
				$Image = "btc_".basename($BTC_BRAND_IMAGE);
				if($Image != ""){
					$branddir = FileHandle::CheckUploadLogDirectory("brand");
					$ImagePath=$branddir.$Image;
					if(!file_exists($ImagePath)){
						$this->ProductImport->uploadImage($BTC_BRAND_IMAGE,$ImagePath);
						if(file_exists($ImagePath) && filesize($ImagePath) > 0){
							$ImageAltText = $BTC_BRAND;
							$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_brand",'brand',$ImageAltText);
						}
						else{
							unlink($ImagePath);
						}
					}
				}
				
				$BrandObj->where ="1";
				$DataArray['Position'] = $BrandObj->getMax("Position") + 1;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$BrandID = $DBObj->tableInsert($DataArray);
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$BrandID." AND MCode ='catalog_brand' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				$DataArray = array();
				$DataArray['MetaTitle'] =$BTC_BRAND." - Collections";
				$DataArray['MetaKeyword'] =$BTC_BRAND;
				$DataArray['MetaDescription'] =isset($BTC_BRAND_DESCRIPTION)?strip_tags($BTC_BRAND_DESCRIPTION):"";
			
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
					$URL = 	SkURLCreate($BTC_BRAND);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;
					//$SeoObj->tableUpdate($DataArray);
				}
				else{
					
					$URL = 	SkURLCreate($BTC_BRAND);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
					$DataArray['URLName'] = $URL;			
					$DataArray['MCode'] = "catalog_brand";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $BrandID;
					$SeoObj->tableInsert($DataArray);
				}
				
				
				
			}
			
		}
		return $BrandID;
		
	}
	public function BTCGetCategoryIDs($BTC_DEPARTMENT_CODE,$BTC_DEPARTMENT,$BTC_SUB_DEPARTMENT_CODE,$BTC_SUB_DEPARTMENT)
	{
		$ReturnArray = array();
		if($BTC_DEPARTMENT != ""){
				$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
				$where = new Where();
				$where->equalTo('ParentID',"1");
				$where->equalTo('CategoryName',trim($BTC_DEPARTMENT));
				$Obj->where = $where;
				$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
				if(isset($Cobj->CategoryID) && $Cobj->CategoryID != ""){
					$CategoryID = $Cobj->CategoryID; 	
				}
				else{
					$CategoryObj = new DataTable(array('c'=>TABLE_CATEGORY));
					$DataArray = array();
					$DataArray['ParentID'] = "1";
					$DataArray['Active'] = "1";
					$DataArray['TopMenu'] = "1";
					$DataArray['CategoryName'] = trim($BTC_DEPARTMENT);
					$DataArray['CategoryTitle'] = trim($BTC_DEPARTMENT);
					$DataArray['CategoryCode'] = trim($BTC_DEPARTMENT_CODE);
					$CategoryObj->where ="ParentID='1'";
					$DataArray['Position'] = $CategoryObj->getMax("Position") + 1;
					$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
					$CategoryID = $Obj->tableInsert($DataArray);
					
					$SeoObj = new DataTable(TABLE_SEO);
					$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
					$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
					$DataArray = array();
					$DataArray['MetaTitle'] =$BTC_DEPARTMENT." - Collections";
					$DataArray['MetaKeyword'] =$BTC_DEPARTMENT;
					$DataArray['MetaDescription'] ="";
				
					if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
						$URL = 	SkURLCreate($BTC_DEPARTMENT);
						$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
						$DataArray['URLName'] = $URL;
						//$SeoObj->tableUpdate($DataArray);
					}
					else{
						
						$URL = 	SkURLCreate($BTC_DEPARTMENT);
						$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$CategoryID);
						$DataArray['URLName'] = $URL;			
						$DataArray['MCode'] = "catalog_category";
						$DataArray['MView'] = "Detail";
						$DataArray['ReferenceID'] = $CategoryID;
						$SeoObj->tableInsert($DataArray);
					}
					
					
					
				}
				$ReturnArray[] = $CategoryID; 	
		}
		
		if($CategoryID > 0 && $BTC_SUB_DEPARTMENT != ""){
			$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
			$where = new Where();
			$where->equalTo('ParentID',$CategoryID);
			$where->equalTo('CategoryName',trim($BTC_SUB_DEPARTMENT));
			$Obj->where = $where;
			$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
			if(isset($Cobj->CategoryID) && $Cobj->CategoryID != ""){
				$SubCategoryID = $Cobj->CategoryID; 	
			}
			else{
				$CategoryObj = new DataTable(array('c'=>TABLE_CATEGORY));
				$DataArray = array();
				$DataArray['ParentID'] = $CategoryID;
				$DataArray['Active'] = "1";
				$DataArray['TopMenu'] = "1";
				$DataArray['CategoryName'] = trim($BTC_SUB_DEPARTMENT);
				$DataArray['CategoryCode'] = trim($BTC_SUB_DEPARTMENT_CODE);
				$CategoryObj->where ="ParentID='".$CategoryID."'";
				$DataArray['Position'] = $CategoryObj->getMax("Position") + 1;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				$SubCategoryID = $Obj->tableInsert($DataArray);
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$SubCategoryID." AND MCode ='catalog_category' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				$DataArray = array();
				$DataArray['MetaTitle'] =$BTC_SUB_DEPARTMENT." - Collections";
				$DataArray['MetaKeyword'] =$BTC_SUB_DEPARTMENT;
				$DataArray['MetaDescription'] ="";
			
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
					$URL = 	SkURLCreate($BTC_SUB_DEPARTMENT);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$SubCategoryID);
					$DataArray['URLName'] = $URL;
					//$SeoObj->tableUpdate($DataArray);
				}
				else{
					
					$URL = 	SkURLCreate($BTC_SUB_DEPARTMENT);
					$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_category','Detail',$SubCategoryID);
					$DataArray['URLName'] = $URL;			
					$DataArray['MCode'] = "catalog_category";
					$DataArray['MView'] = "Detail";
					$DataArray['ReferenceID'] = $SubCategoryID;
					$SeoObj->tableInsert($DataArray);
				}
				
				
				
			}
			$ReturnArray[] = $SubCategoryID; 	
		}
		return $ReturnArray;
	}
	
	function checkProductbySKU($ModelNo)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$where = new Where();
		$where->equalTo('UploadType','FeedBTC');
		$where->equalTo('FeedID',$ModelNo);
		//$ProductObj->displayQuery = true;
		$ProductObj->where = $where;
		return (object)$ProductObj->tableSelectOne(array("ProductID","MasterID","ModelNo","ProductName"));
	}
	
	
}	