<?php 
namespace PaymentModule\Worldpay;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	  var $installationID;
	  var $md5Password;
	  var $callPassword;
	  var $multipleCurrency;
	  var $mode;
	  var $form;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		  $this->installationID = DEFINE_SK_PAYMENT_WORLDPAY_JUNIOR_INSTALLATION_ID;
		  $this->md5Password = DEFINE_SK_PAYMENT_WORLDPAY_JUNIOR_MD5_PASSWORD;
		  $this->callPassword = DEFINE_SK_PAYMENT_WORLDPAY_JUNIOR_CALLBACKPW;
		  $this->multipleCurrency = DEFINE_SK_PAYMENT_WORLDPAY_MULTIPLE_CURRENCY;
		  $this->mode = DEFINE_SK_PAYMENT_WORLDPAY_JUNIOR_MODE;
		  $this->form = DEFINE_SK_PAYMENT_WORLDPAY_FORM;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."WorldpayIPN-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
		
		fputs($fp2,"----------------PostArray Variable start---------\r\n");	
		fputs($fp2,"PaymentMethod POSTRETURN=".print_r($PostArray,true)."\r\n");	
		fputs($fp2,"----------------PostArray Variable end---------\r\n");
		fclose($fp2);
		
		fputs($fp2,"----------------GetArray Variable start---------\r\n");	
		fputs($fp2,"PaymentMethod GETRETURN=".print_r($GetArray,true)."\r\n");	
		fputs($fp2,"----------------GetArray Variable end---------\r\n");
		fclose($fp2);
		
		if(!isset($PostArray['MC_custom'])){
			$PostArray = $GetArray;
		}
		
		
		$PaymentStatus ="";
		$OrderID = "";
		$Return = array();
		if(isset($PostArray['MC_custom']))
		{
			if(isset($PostArray['transStatus']) && $PostArray['transStatus'] =='Y')	
			{
				$custom_array = explode("@@@",base64_decode($PostArray['MC_custom']));
				
				if($this->SKCheckWorldpayAuthenticate($PostArray)==true){
					$Return['OrderID'] = $custom_array[0];
					$Return['PaymentStatus'] = "Paid";
					$Return['Process'] = "1";
					$Return['Invoice'] = "1";
					$Return['ClearCart'] = "1";
					/* Process order Start*/
					$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
				
					/* Invoice sent Start*/
					$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
				
					/* Invoice sent Start*/
					$this->getClass("Sale\Checkout\Common")->clearCart();
					$ReturnURL = SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']);
					
					?>
					<html>
					<head>
					<META HTTP-EQUIV="refresh" content="0; url=<?php echo $ReturnURL;?>">
					</head>
					<body onload="document.location.href='<?php echo $ReturnURL;?>'">
						You will be redirect to thank you page with in 5 seconds.
						<a href="<?php echo $ReturnURL;?>">Click here</a>
					</body>
					</html>
					<?php 
					exit;					
			  }
			}
			else{
				fputs($fp2,"----------------PAYPAL ERROR START---------\r\n");	
				fputs($fp2,$req);	
				fputs($fp2,"----------------PAYPAL ERROR END---------\r\n");	
				?>
				<html>
				<head></head>
				<body>
					<?php echo d("ERROR_MSG_IN_PAYMENT_COMPLETED")?>
					<a href="<?php echo SKSEOURL('checkout','Confirm');?>">Click here</a>
				</body>
				</html>
				<?php 
				exit;
			}
			
		}
		
		return $Return;
	}
	
	function SKCheckWorldpayAuthenticate($Arr= array())
	{
		if(isset($Arr['callbackPW']) && $Arr['callbackPW'] !="" && $Arr['callbackPW']==$this->callPassword)
			return true;
		else 
			return false;
		
	}

	function getPaymentPreProcess($Obj){
		/* nothing to do*/
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
			$ItemName = "Products Name:";
			$rows = $this->getClass("Sale\Cart\Common")->getOrderCart($Obj->OrderID);
			foreach($rows as $CurrentCartItem){
				$ItemName .= $CurrentCartItem->ItemName.", "; 
			}
			$ItemName = substr($ItemName, 0, -2); 
		
			$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
			$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
			$Currency = "GBP";
			
			/*Currency Array start */
		if($this->multipleCurrency===true)
		{
			$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
			$OrderCurrencyObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$CurrentObj=(object)$OrderCurrencyObj->tableSelectOne();
			
			if(isset($CurrentObj->Value) && $CurrentObj->Value !="")
			{
				$GrandTotal = $CurrentObj->Value * $Obj->GrandTotal;
				$Amount = str_replace(",","",number_format($GrandTotal,2));
				$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
				$Currency = isset($CurrentObj->Code)?$CurrentObj->Code:"GBP";
			}
		}
		/*Currency Array end*/
		
			$WorldpayFields  = array('instId'=>$this->installationID,
		 						'amount'=>$Amount,
		 						'currency'=>$Currency,
		 						'hideCurrency'=>"true",
		 						'cartId'=>$Obj->OrderNo,
		 						'desc'=>$ItemName,
		 						'name'=>$Obj->BillingFirstName." ".$Obj->BillingLastName,
		 						'address'=>$Obj->BillingAddress1." ".$Obj->BillingAddress2." ".$Obj->BillingCity." ".$Obj->BillingState,
		 						'postcode'=>$Obj->BillingZipCode,
		 						'country'=>(isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB"),
		 						'tel'=>$Obj->BillingPhone,
		 						'email'=>$Obj->Email,
		 						'fixContact'=>'Y',
		 						'signatureFields'=>'amount:currency:cartId',
		 						'signature'=>md5($this->md5Password . ':' . $Amount . ':' . $Currency . ':' . $Obj->OrderNo),
		 						'MC_callback'=>SKSEOURL('checkout','Payment','','method='.$Obj->PaymentMethod),
		 						'MC_custom'=>$Custom,
		 						//'testMode'=>'100',
		 						);
								
						if($this->mode=="TEST")		
							$WorldpayFields["testMode"] = "100"; 
     
				     	 $QueryString = "";
							foreach($WorldpayFields as $Columns=>$Value){
							   $QueryString .= $Columns."=".$Value."&";
						      }
						      $QueryString = substr($QueryString, 0, -1); 
		
		$PaymentString = '<html>
							<head>
							<title></title>
							<script type="text/javascript">
							function FormSubmission()
							{
								FormObj = document.getElementById(\'FormRt\');
								FormObj.submit();
								return true;
							}
							</script>
							</head>
							<body onload="return FormSubmission();">
							<form name="FormRt" target="_top"  id="FormRt" action="'. $this->form .'" method="POST">';
							foreach ($WorldpayFields as $k=>$v)
								$PaymentString .= '<input type="hidden" name="'. $k .'" value="'. $v .'" />';
								
				
		$PaymentString .= '<br>If this page appears for more than five seconds <button type="submit" onclick="return FormSubmission();">click here to reload.</button>
						  </form>
							</body>
						</html>';
		
			echo $PaymentString;exit;
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		$Return = '<form role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '<p class="text-center"><input type="image" src="'.DIR_WS_SITE.'/templates/tools/worldpay/worldpay.png" alt="Credit Cards" /></p>';
		$Return .= '</form>';
		return $Return;
	}
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Credit/Debit Card (Worldpay)",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );

		return $ResponseArray; 
  
    }		
	
	
}	