<?php 
namespace PaymentModule\Stripe;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	  var $mode;
	  var $form;
	  var $publicKey;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		  $this->mode = DEFINE_SK_PAYMENT_STRIPE_MODE;
		  $this->form = "";
		  $this->publicKey = DEFINE_SK_PAYMENT_STRIPE_PUBLIC_KEY;
		  $this->secretKey = DEFINE_SK_PAYMENT_STRIPE_SECRET_KEY;
		  $this->multipleCurrency = true;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."Stripe-webhook-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
	
		$rawData = file_get_contents("php://input");
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"rawData=".print_r($rawData,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"POST=".print_r($_POST,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		
		//$rawData = '{ "id": "evt_3RB8MZK8tvvPwPC71N06hpUv", "object": "event", "api_version": "2022-11-15", "created": 1744004225, "data": { "object": { "id": "pi_3RB8MZK8tvvPwPC71Xw85Ldk", "object": "payment_intent", "amount": 1329, "amount_capturable": 0, "amount_details": { "tip": { } }, "amount_received": 1329, "application": null, "application_fee_amount": null, "automatic_payment_methods": { "allow_redirects": "always", "enabled": true }, "canceled_at": null, "cancellation_reason": null, "capture_method": "automatic", "client_secret": "pi_3RB8MZK8tvvPwPC71Xw85Ldk_secret_N2uQuwLiche6iDLu45b053v8I", "confirmation_method": "automatic", "created": 1744004211, "currency": "gbp", "customer": null, "description": null, "invoice": null, "last_payment_error": null, "latest_charge": "ch_3RB8MZK8tvvPwPC71T1qVsBS", "livemode": false, "metadata": { "OrderID": "5", "OrderNo": "A255", "Custom": "NUBAQDEzLjI5" }, "next_action": null, "on_behalf_of": null, "payment_method": "pm_1RB8MmK8tvvPwPC7MTCAfOwO", "payment_method_configuration_details": { "id": "pmc_1Qs1FUK8tvvPwPC7ixO19Et5", "parent": null }, "payment_method_options": { "card": { "installments": null, "mandate_options": null, "network": null, "request_three_d_secure": "automatic" }, "link": { "persistent_token": null } }, "payment_method_types": [ "card", "link" ], "processing": null, "receipt_email": "maxn1981@yahoo.com", "review": null, "setup_future_usage": null, "shipping": null, "source": null, "statement_descriptor": "Payment - A255", "statement_descriptor_suffix": "T-ShirtsDirect", "status": "succeeded", "transfer_data": null, "transfer_group": null } }, "livemode": false, "pending_webhooks": 2, "request": { "id": "req_m1hpSOykDOw4jv", "idempotency_key": "59dc89cc-ee01-4c51-bfc4-97ef874f51af" }, "type": "payment_intent.succeeded" }';

		
		if(isset($rawData) && $rawData != ""){
			
			$TmpData = json_decode($rawData);
			$pay_obj = isset($TmpData->data->object)?$TmpData->data->object:"";
			
			if( isset($TmpData->type) && in_array(strtoupper($TmpData->type),array("PAYMENT_INTENT.SUCCEEDED")) ){
				if(isset($pay_obj->object) && strtoupper($pay_obj->object) == "PAYMENT_INTENT" &&
					isset($pay_obj->metadata->Custom) && $pay_obj->metadata->Custom != ""){
					$custom_array = explode("@@@",base64_decode($pay_obj->metadata->Custom));
					fputs($fp2,"META Custom=".print_r($pay_obj->metadata->Custom,true)."\r\n");	
					if(isset($custom_array[0]) && $custom_array[0] != ""){
						$OrderID = $custom_array[0];
						
						$Obj =  $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);	
						$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
						$stripe_amount = (int)$pay_obj->amount;
						$order_amount = (int)($Amount*100);
						
						if(isset($pay_obj->status) && $pay_obj->status=="succeeded" && $stripe_amount > 0 && $stripe_amount==$order_amount && $Obj->PaymentStatus != "Paid"){
							$return = array();
							$Return['OrderID'] = $Obj->OrderID;
							$Return['TransactionID'] = $pay_obj->s_payment_id;
							$Return['PaymentStatus'] = "Paid";
							$Return['Process'] = "1";
							$Return['Invoice'] = "1";
							$Return['ClearCart'] = "1";
							$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
							//MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']));
							//exit;
							
						}
						
					}
				}
			}
		}
		fclose($fp2);
		echo "1";exit;
		
	}
	
	function getPaymentPreProcess($Obj){
		/* nothing to do*/
		//var_dump($_POST);exit;
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			$s_client_secret = isset($_POST['s_client_secret'])?$_POST['s_client_secret']:"";
			$s_payment_id = isset($_POST['s_payment_id'])?$_POST['s_payment_id']:"";
			
			$stripe = new \Stripe\StripeClient($this->secretKey);
			$pay_obj = $stripe->paymentIntents->retrieve($s_payment_id);
			$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
			$stripe_amount = (int)$pay_obj->amount;
			$order_amount = (int)($Amount*100);
			if(isset($pay_obj->status) && $pay_obj->status=="succeeded" && $stripe_amount > 0 && $stripe_amount==$order_amount && $Obj->PaymentStatus != "Paid"){
				$return = array();
				$Return['OrderID'] = $Obj->OrderID;
				$Return['TransactionID'] = $pay_obj->s_payment_id;
				$Return['PaymentStatus'] = "Paid";
				$Return['Process'] = "1";
				$Return['Invoice'] = "1";
				$Return['ClearCart'] = "1";
				$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
				MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']));
				exit;
				
			}

			
			var_dump($_POST,$PostArray,$Obj,"<hr>",$pay_obj,"<hr>",$pay_obj->status);exit;
			
		
		
			
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
		$Currency = "GBP";
			
			/*Currency Array start */
		if($this->multipleCurrency===true)
		{
			$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
			$OrderCurrencyObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$CurrentObj=(object)$OrderCurrencyObj->tableSelectOne();
			
			if(isset($CurrentObj->Value) && $CurrentObj->Value !="")
			{
				$GrandTotal = $CurrentObj->Value * $Obj->GrandTotal;
				$Amount = str_replace(",","",number_format($GrandTotal,2));
				$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
				$Currency = isset($CurrentObj->Code)?$CurrentObj->Code:"GBP";
			}
		}
		/*Currency Array end*/
		
		$statement_descriptor =  "Payment - ".$Obj->OrderNo;
		$stripe_array = array(
				'amount' => (int)($Amount*100),
				'currency' => $Currency,
				'payment_method_configuration' => d("DEFINE_SK_PAYMENT_STRIPE_PAYMENT_METHOD_CONFIGURATION"),
				'automatic_payment_methods' => array('enabled' => true),
				'statement_descriptor' => substr($statement_descriptor,0,21),
				'statement_descriptor_suffix' => d("SITE_NAME"),
				//'capture_method' => 'automatic', //automatic,manual
				//'confirm' => true,
				//'payment_method_types' => array('card'),
				//'return_url' => SKSEOURL('checkout','Payment','','method='.$Obj->PaymentMethod),
				'receipt_email' => $Obj->Email,
				'metadata' => array("Custom" => $Custom,
							        "OrderID"=>$Obj->OrderID,
							        "OrderNo"=>$Obj->OrderNo,
							  ),
							  
				
				
			  );
		
		$stripe = new \Stripe\StripeClient($this->secretKey);
		$payment_intent = $stripe->paymentIntents->create($stripe_array);
		$stripe_client_secret = $payment_intent->client_secret;
		$stripe_payment_id = $payment_intent->id;
		/*
		$payment_intent = $stripe->paymentIntents->create([
					  'amount' => 2000,
					  'currency' => 'usd',
					  'payment_method_types' => ['card'],
					]);
		*/			
		if($stripe_payment_id != "" && $stripe_client_secret != ""){
			$GLOBALS['InnerJsFile'][] = array('https://js.stripe.com/v3/',true);
			$GLOBALS['InnerJsScript'][] = '<script type="text/javascript">
			jQuery(document).ready(function($){
				const stripe = Stripe("'.$this->publicKey.'");
				var appearance = { theme: "stripe", rules: { ".Label": { marginTop: "15px", textColor: "#000000" } }, variables: { fontFamily: "Lato, system-ui, sans-serif" } };
				var clientSecret = "'.$stripe_client_secret.'";
				var elements = stripe.elements({ appearance, clientSecret });
				elements.create("payment", { fields: { billingDetails: "never" } }).mount("#stripe-payment-element");
				// button submit start
				$("#FinalPaymentButton").on("click", function (e) {
					e.preventDefault();
                    var paymentForm = $(this).closest("form");
                    if (!paymentForm || !paymentForm.valid()) return false;
					//showLoader();
					$("#stripe-error-message").html("processing... please wait");
					try{
						 stripe.confirmPayment({
                                    elements,
                                    redirect: "if_required",
                                    confirmParams: {
                                        return_url: "'.SKSEOURL('checkout','Payment','','method='.$Obj->PaymentMethod).'&payment_id='.$stripe_payment_id.'",
                                        payment_method_data: {
                                            billing_details: {
                                                name: "'.$Obj->BillingFirstName." ".$Obj->BillingLastName.'",
                                                email: "'.$Obj->Email.'",
                                                phone: "'.$Obj->BillingPhone.'",
                                                address: {
                                                    "line1": "'.$Obj->BillingAddress1.'",
                                                    "line2": "'.$Obj->BillingAddress2.'",
                                                    "city": "'.$Obj->BillingCity.'",
                                                    "state": "'.$Obj->BillingState.'",
                                                    "country": "'.SKGetCountryCodeByCountry($Obj->BillingCountry).'",
                                                    "postal_code": "'.$Obj->BillingZipCode.'"
                                                }
                                            }
                                        }
                                    },
                                }).then(function (result) {
                                    //hideLoader();
                                    if (result.error)
                                        $("#stripe-error-message").html(result.error.message || "An unexpected error occured.");
                                    else
                                        paymentForm.submit();
                                });
						
					} catch (e) {
                            //hideLoader();
                            console.log(e);
                        }
                   return false;
					
				});
				// button submit end
				
				
		   
			});	
			</script>';


			$Return = '';
			//$Return .= '<form role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
			//$Return .= '<input type="hidden" name="Process" value="1" />';
			$Return .= '<div class="mx-4"><form role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">
							<div id="stripe-payment-element" class="my-3"></div>
							<div id="stripe-error-message" style="color:#880000;line-height: 35px;"></div>';
			$Return .= '<input type="hidden" name="Process" value="1" />
						<input type="hidden" name="s_payment_id" value="'.$stripe_payment_id.'" />
						<input type="hidden" name="s_client_secret" value="'.$stripe_client_secret.'" />
						';				
			
		}
		
		
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '<p class="text-center"><input type="image" src="'.DIR_WS_SITE.'/templates/tools/stripe/stripe-logo.png" /></p>';
		$Return .= '';
		$Return .= '</form></div>';
		return $Return;
	}
	
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Debit/Credit Card",
								"note"=>'
								<div class="col-sm-3 text-start mb-3 clearfix"><div class="d-block"><img src="'.DIR_WS_SITE.'/templates/tools/stripe/stripe-logo.png" border="0" alt="stripe-logo" class="img-fluid"></div></div>
								',
								"hidenote"=>"fdsfs",
							  );

		return $ResponseArray; 
  
    }		
	
	
}	