<?php 
namespace PaymentModule\Payment;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	function getAllPayment($PostArray="")
	{
		$ModuleObj = new DataTable(TABLE_MODULES);
		$ModuleObj->where[] = array('=',array('ModuleType' => 'Payment'));
		$ModuleObj->where[] = array('=',array('Active' => '1'));
		$rows = $ModuleObj->tableSelectAll("",array("ModuleID ASC"));
		$PaymentArray = array();
		if(count($rows) > 0){
			foreach($rows as $CurrentRecord){
				
				if(class_exists("PaymentModule\\".$CurrentRecord->ModuleCode."\Common")){
					$arr = $this->getClass("PaymentModule\\".$CurrentRecord->ModuleCode."\Common")->getMethod($PostArray);
					if(isset($arr) && is_array($arr) && count($arr) > 0){
						$PaymentArray[$CurrentRecord->ModuleCode] = $arr;	
					}
				}
			}
			
		}
		return $PaymentArray;
	}	

    function getPaymentPreForm($PaymentMethod,$Obj,$PostArray="")
	{
		if(class_exists("PaymentModule\\".$PaymentMethod."\Common")){
			return  $this->getClass("PaymentModule\\".$PaymentMethod."\Common")->getPaymentPreForm($Obj,$PostArray);
		}
	}
	
	function getPaymentPostForm($PaymentMethod)
	{
		if(class_exists("PaymentModule\\".$PaymentMethod."\Common")){
			return $this->getClass("PaymentModule\\".$PaymentMethod."\Common")->getPaymentPostForm();
		}
	}
	
	function getPaymentPreProcess($PaymentMethod,$Obj,$PostArray="")
	{
		if(class_exists("PaymentModule\\".$PaymentMethod."\Common")){
			return  $this->getClass("PaymentModule\\".$PaymentMethod."\Common")->getPaymentPreProcess($Obj,$PostArray);
		}
	}
	
	function getPaymentPostProcess($PaymentMethod,$Obj,$PostArray="")
	{
		if(class_exists("PaymentModule\\".$PaymentMethod."\Common")){
			return $this->getClass("PaymentModule\\".$PaymentMethod."\Common")->getPaymentPostProcess($Obj,$PostArray);
		}
	}
	
	function paymentIPN($PaymentMethod,$GetArray = "",$PostArray="")
	{
		if(class_exists("PaymentModule\\".$PaymentMethod."\Common")){
			return $this->getClass("PaymentModule\\".$PaymentMethod."\Common")->paymentIPN($GetArray,$PostArray);
		}
	}
	
	
}	