<?php 
namespace PaymentModule\PayPalStandard;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	 var $paypalAccount;
	  var $mode;
	  var $form;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		  $this->paypalAccount = DEFINE_SK_PAYMENT_PAYPAL_STANDARD_ACCOUNT;
		  $this->mode = DEFINE_SK_PAYMENT_PAYPAL_STANDARD_MODE;
		  $this->form = DEFINE_SK_PAYMENT_PAYPAL_STANDARD_FORM;
		  $this->multipleCurrency = true;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		$PaymentStatus ="";
		$OrderID = "";
		$Return = array();
		$Return = $this->SKCheckPayPalAuthenticate($PostArray);
		if(isset($Return['PaymentStatus']) && $Return['PaymentStatus']=="Completed"){
			$Return['OrderID'] = $Return['OrderID'];
			$Return['PaymentStatus'] = "Paid";
			$Return['Process'] = "1";
			$Return['Invoice'] = "1";
			$Return['ClearCart'] = "1";
		}		
		return $Return;
	}
	
	function SKCheckPayPalAuthenticate($PostArray)
	{
		/*
		$TESTDATA ='mc_gross=0.01&protection_eligibility=Eligible&address_status=confirmed&payer_id=ZH2Y58TVU6BCN&tax=0.00&address_street=address 1
address 2&payment_date=00:18:08 Jul 15, 2021 PDT&payment_status=Completed&charset=UTF-8&address_zip=212212&first_name=Vaneet&mc_fee=0.01&address_country_code=GB&address_name=John Max&notify_version=3.9&custom=MTAwMTJAQEAwLjAx&payer_status=verified&business=vaneet_business@webcreationuk.com&address_country=United Kingdom&address_city=city&quantity=1&verify_sign=A0pmJdhz68X7AQ76ELLOPGURD4FQADH8zKCSz-mqb1VBELoP9xtKlpgH&payer_email=vaneetbuyer@webcreationuk.com&txn_id=0EA961188N486604K&payment_type=instant&last_name=Kaura&address_state=state&receiver_email=vaneet_business@webcreationuk.com&payment_fee=&shipping_discount=0.00&insurance_amount=0.00&receiver_id=4EGZ2UEC7NJV4&txn_type=web_accept&item_name=Products Name:TEST Product 1 DO NOT SHIP&discount=0.00&mc_currency=GBP&item_number=&residence_country=GB&test_ipn=1&shipping_method=Default&transaction_subject=&payment_gross=&ipn_track_id=44dc188fa578e';
parse_str($TESTDATA, $PostArray);
var_dump($PostArray);
		//https://github.com/paypal/ipn-code-samples/blob/master/paypal_ipn.php
		
		*/
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."PaymentPaypalStandardIPN-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
		
		fputs($fp2,"----------------PostArray Variable start---------\r\n");	
		fputs($fp2,"PaymentMethod RETURN=".print_r($PostArray,true)."\r\n");	
		fputs($fp2,"----------------PostArray Variable end---------\r\n");
			
		$Return = array();
		if(isset($PostArray['custom']))
		{
			if(function_exists('get_magic_quotes_gpc'))
				$get_magic_quotes_exists = true;
			
			$req = 'cmd=_notify-validate';
			foreach ($PostArray as $key => $value) {
				if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1)
					$value = urlencode(stripslashes($value));
				 else 
					$value = urlencode($value);
				
				$req .= "&$key=$value";
			}
			/* New code start*/
			$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
			if(constant("DEFINE_SK_PAYMENT_PAYPAL_STANDARD_MODE")=="TEST")
				$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
			
			$ch = curl_init($paypal_url);
			if ($ch == FALSE) {
				fputs($fp2,"----------------CURL not working--------\r\n");	
			}

			curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);

			
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
			
			$res = curl_exec($ch);
			
			//var_dump("<hr>",$res,$paypal_url);exit;
			
			curl_close($ch);
			if (strcmp ($res, "VERIFIED") == 0){
				if(strtolower($PostArray['business']) ==strtolower($this->paypalAccount)){
					/* custom fetch with amount*/
					$custom_array = explode("@@@",base64_decode($PostArray['custom']));
					fputs($fp2,"mc_gross= ".$PostArray['mc_gross']."---Custom Amount= ".$custom_array[1]."\r\n");	
					/* custom fetch with amount end*/
					if($PostArray['mc_gross'] == $custom_array[1]){
						fputs($fp2,"Custom orderid= ".$custom_array[0]."\r\n");	
						$Return['OrderID']= $custom_array[0];
						$Return['PaymentStatus'] = $PostArray['payment_status'];
					}
				}
				
			}
			else if (strcmp ($res, "INVALID") == 0) {
				fputs($fp2,"----------------PAYPAL ERROR START---------\r\n");	
				fputs($fp2,$req);	
				fputs($fp2,"----------------PAYPAL ERROR END---------\r\n");	
				
				$INVALIDfilename=$dir."PaymentPaypalStandardINVALID-".date("Y-m-d_h-i-s").".txt";
				$fpINVALID = fopen($INVALIDfilename, "w");
				fputs($fpINVALID,"----------------PAYPAL INVALID Variable---------\r\n");	
				fclose($fpINVALID);
		
			}
			elseif (strcmp ($res, "Failure") == 0){
				fputs($fp2,"----------------PAYPAL ERROR (Failure)---------\r\n");
				fclose($fp2);
				
				$Failurefilename=$dir."PaymentPaypalStandardFailure-".date("Y-m-d_h-i-s").".txt";
				$fpFailure = fopen($Failurefilename, "w");
				fputs($fpFailure,"----------------PAYPAL Failure ---------\r\n");	
				fclose($fpFailure);
				
				header('HTTP/1.1 500 Internal Server Error');
				exit;
			}	
			
		}
		fclose($fp2);
		return $Return;
	
	}
	
	function getPaymentPreProcess($Obj){
		/* nothing to do*/
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
			$ItemName = "Products Name:";
			$rows = $this->getClass("Sale\Cart\Common")->getOrderCart($Obj->OrderID);
			foreach($rows as $CurrentCartItem){
				$ItemName .= preg_replace('/[^a-zA-Z0-9- _\.]/','', $CurrentCartItem->ItemName).", "; 
			}
			$ItemName = substr($ItemName, 0, -2); 
			$ItemName = substr($ItemName, 0, 120); 
			
			$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
			$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
			$Currency = "GBP";
			
			/*Currency Array start */
		if($this->multipleCurrency===true)
		{
			$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
			$OrderCurrencyObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$CurrentObj=(object)$OrderCurrencyObj->tableSelectOne();
			
			if(isset($CurrentObj->Value) && $CurrentObj->Value !="")
			{
				$GrandTotal = $CurrentObj->Value * $Obj->GrandTotal;
				$Amount = str_replace(",","",number_format($GrandTotal,2));
				$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
				$Currency = isset($CurrentObj->Code)?$CurrentObj->Code:"GBP";
			}
		}
		/*Currency Array end*/
		
			$PaypalFields  = array('currency_code'=>$Currency,
		 						'cmd'=>'_xclick',
		 						//'redirect_cmd'=>'_cart', 
		 						'business'=>$this->paypalAccount,
		 						'rm'=>'2',
		 						'return'=>SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Obj->OrderID),
		 						'cancel_return'=>SKSEOURL('checkout','Confirm'),
		 						'notify_url'=>SKSEOURL('checkout','Payment','','method='.$Obj->PaymentMethod),
		 						'no_notes'=>'1',
		 						'custom'=>$Custom,
		 						'email'=>$Obj->Email,              ///billing info
		 						'first_name'=>$Obj->BillingFirstName, 
		 						'last_name'=>$Obj->BillingLastName, 
		 						'address1'=>$Obj->BillingAddress1, 
		 						'address2'=>$Obj->BillingAddress2, 
		 						'city'=>$Obj->BillingCity, 
		 						'state'=>$Obj->BillingState, 
		 						'country'=>$Obj->BillingCountry, 
		 						'zip'=>$Obj->BillingZipCode, 
		 						'sh_first_name'=>$Obj->ShippingFirstName,     ///shipping info
		 						'sh_last_name'=>$Obj->ShippingLastName, 
		 						'sh_address1'=>$Obj->ShippingAddress1, 
		 						'sh_address2'=>$Obj->ShippingAddress2, 
		 						'sh_city'=>$Obj->ShippingCity, 
		 						'sh_state'=>$Obj->ShippingState, 
		 						'sh_country'=>$Obj->ShippingCountry, 
		 						'sh_zip'=>$Obj->ShippingZipCode, 
		 						'no_shipping'=>'0',
		 						'item_name'=>$ItemName,
		 						//'shipping'=>number_format($ShippingAmount,2),
		 						'tax'=>number_format(0,2),
		 						'amount'=>$Amount,
		 					  );					
							
							$QueryString = "";
							foreach ($PaypalFields as $Columns=>$Value){
						        $QueryString .= $Columns."=".$Value."&";
						      }
						      $QueryString = substr($QueryString, 0, -1); 
		
		$PaymentString = '<html>
							<head>
							<title></title>
							<script type="text/javascript">
							function FormSubmission()
							{
								FormObj = document.getElementById(\'FormRt\');
								FormObj.submit();
								return true;
							}
							</script>
							</head>
							<body onload="return FormSubmission();">
							<form name="FormRt" target="_top"  id="FormRt" action="'. $this->form .'" method="POST">';
							foreach ($PaypalFields as $k=>$v)
								$PaymentString .= '<input type="hidden" name="'. $k .'" value="'. $v .'" />';
								
				
		$PaymentString .= '<br>If this page appears for more than five seconds <button type="submit" onclick="return FormSubmission();">click here to reload.</button>
						  </form>
							</body>
						</html>';
		
			echo $PaymentString;exit;
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		$Return = '<form role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '<p class="text-center"><input type="image" src="'.DIR_WS_SITE.'/templates/tools/paypal/paypal.png" /></p>';
		//$Return .= '<table border="0" cellpadding="10" cellspacing="0" align="center"><tr><td align="center"></td></tr><tr><td align="center"><a href="#" onclick="javascript:window.open(\'https://www.paypal.com/cgi-bin/webscr?cmd=xpt/Marketing/popup/OLCWhatIsPayPal-outside\',\'olcwhatispaypal\',\'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=400, height=350\');"><img  src="https://www.paypal.com/en_US/i/bnr/bnr_paymentsBy_150x40.gif" border="0" alt="PayPal Logo"></a></td></tr></table>';
		$Return .= '</form>';
		return $Return;
	}
	
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Paypal Secure",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );

		return $ResponseArray; 
  
    }		
	
	
}	