<div id="paypal-button-container"></div>
<p id="result-message"></p>
<script>
const paypalButtons = window.paypal.Buttons({
   style: {
        shape: "rect",
        layout: "vertical",
        color: "gold",
        label: "checkout",
    },
   message: {
        //amount: 99999,
    },
   async createOrder() {
        try {
            const response = await fetch(sk_pay.url_order_create, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                },
                // use the "body" param to optionally pass additional order information
                // like product ids and quantities
                body: JSON.stringify({
                    cart: [
                        {
                            id: "YOUR_PRODUCT_ID",
                            quantity: "YOUR_PRODUCT_QUANTITY",
                        },
                    ],
                }),
            });

            const orderData = await response.json();

            if (orderData.id) {
                return orderData.id;
            }
            const errorDetail = orderData?.details?.[0];
            const errorMessage = errorDetail
                ? `${errorDetail.issue} ${errorDetail.description} (${orderData.debug_id})`
                : JSON.stringify(orderData);

            throw new Error(errorMessage);
        } catch (error) {
            console.error(error);
            // resultMessage(`Could not initiate PayPal Checkout...<br><br>${error}`);
        }
    },
   async onApprove(data, actions) {
	   
		try {
            const response = await fetch(sk_pay.url_order_capture,{
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                    },
					body: JSON.stringify({
						post_data: data,
						method: "paypal_order_capture"
					}),
                }
            );

            const orderData = await response.json();
			if (orderData.Redirect) {
               if (typeof showLoader === "function"){ 
					showLoader();
			   }
			   
			   document.location.href=orderData.Redirect;
		    }
			
            console.log(
                    "Capture result",
                    orderData,
                    JSON.stringify(orderData, null, 2)
                );
        } catch (error) {
            console.error(error);
            resultMessage(
                `Sorry, your transaction could not be processed...<br><br>${error}`
            );
        }
    },
   onShippingOptionsChange: async(data, actions) => {
        // data will return:
        // OrderID, selectedShippingOption, and errors
        // actions will return:
        // `reject` function for you to display an error in the popup
        // Use case:
        // If you want to offer different sipping options
        // like express shipping or pick up in store,
        // this is where we return data to you for you
        // to be able to update an order
		try {
            const response = await fetch(sk_pay.url_shipping_update, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                },
                // use the "body" param to optionally pass additional order information
                // like product ids and quantities
                body: JSON.stringify({
                    post_data: data,
                    method: "paypal_address_update"
                }),
            });

            const ship_data = await response.json();
			if(ship_data.ack==true && ship_data.data == null){
				return true;
			}
			return actions.reject();
			//return actions.order.patch([ship_data]);
           
        } catch (error) {
            console.error(error);
			return actions.reject();
            // resultMessage(`Could not initiate Shipping Methods...<br><br>${error}`);
        }
		
    },
    onShippingAddressChange: async (data, actions) => {
        // data will return:
        // OrderID, shippingAddress, and errors
        // actions will return:
        // `reject` function for you to display an error in the popup
        // Use case:
        // As the customer changes their address in the popup,
        // the information will be sent back here so you can
        // update any order pricing or send an error that you
        // dont ship to a specific location
		try {
            const response = await fetch(sk_pay.url_shipping_method, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                },
                // use the "body" param to optionally pass additional order information
                // like product ids and quantities
                body: JSON.stringify({
                    post_data: data,
                    method: "paypal_address_change"
                }),
            });

            const ship_data = await response.json();
			if(ship_data.ack==true && ship_data.data == null){
				return true;
			}
			return actions.reject();
			//return actions.order.patch([ship_data]);
           
        } catch (error) {
            console.error(error);
			return actions.reject();
            // resultMessage(`Could not initiate Shipping Methods...<br><br>${error}`);
        }	
		
		//console.log("-onShippingAddressChange-");
		//console.log(data);
		//console.log(actions);
    },

   
});
paypalButtons.render("#paypal-button-container");


// Example function to show a result to the user. Your site's UI library can be used instead.
function resultMessage(message) {
    const container = document.querySelector("#result-message");
    container.innerHTML = message;
}

</script>