<?php 
namespace PaymentModule\PayPalApiV2;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	 var $paypalAccount;
	 var $mode;
	 var $form;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		 require_once (dirname(__FILE__)."/lib/Helpers/PayPalHelper.php");
		  $this->multipleCurrency = true;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."PaymentPaypalAPIV2-webhook-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
	
		$rawData = file_get_contents("php://input");
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"rawData=".print_r($rawData,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"POST=".print_r($_POST,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		fclose($fp2);
		
		//$rawData_TEST = '{"id":"WH-0W241635U33613342-9GR2936822414121F","event_version":"1.0","create_time":"2023-11-24T06:21:52.946Z","resource_type":"capture","resource_version":"2.0","event_type":"PAYMENT.CAPTURE.COMPLETED","summary":"Payment completed for GBP 20.28 GBP","resource":{"amount":{"value":"20.28","currency_code":"GBP"},"seller_protection":{"dispute_categories":["ITEM_NOT_RECEIVED","UNAUTHORIZED_TRANSACTION"],"status":"ELIGIBLE"},"create_time":"2023-11-24T06:21:48Z","custom_id":"MTA3MTZAQEAyMC4yOA==","payee":{"email_address":"vaneet_business@webcreationuk.com","merchant_id":"4EGZ2UEC7NJV4"},"supplementary_data":{"related_ids":{"order_id":"3SJ179423Y323014H"}},"update_time":"2023-11-24T06:21:48Z","final_capture":true,"seller_receivable_breakdown":{"paypal_fee":{"value":"0.54","currency_code":"GBP"},"gross_amount":{"value":"20.28","currency_code":"GBP"},"net_amount":{"value":"19.74","currency_code":"GBP"}},"invoice_id":"INV-10716-16460","links":[{"method":"GET","rel":"self","href":"https://api.sandbox.paypal.com/v2/payments/captures/55K02150UR342004G"},{"method":"POST","rel":"refund","href":"https://api.sandbox.paypal.com/v2/payments/captures/55K02150UR342004G/refund"},{"method":"GET","rel":"up","href":"https://api.sandbox.paypal.com/v2/checkout/orders/3SJ179423Y323014H"}],"id":"55K02150UR342004G","status":"COMPLETED"},"links":[{"href":"https://api.sandbox.paypal.com/v1/notifications/webhooks-events/WH-0W241635U33613342-9GR2936822414121F","rel":"self","method":"GET"},{"href":"https://api.sandbox.paypal.com/v1/notifications/webhooks-events/WH-0W241635U33613342-9GR2936822414121F/resend","rel":"resend","method":"POST"}]}';
		
		if(isset($rawData) && $rawData != ""){
			
			$TmpData = json_decode($rawData);
			if( isset($TmpData->resource_type) && in_array(strtoupper($TmpData->resource_type),array("CAPTURE")) &&
				isset($TmpData->event_type) && in_array(strtoupper($TmpData->event_type),array("PAYMENT.CAPTURE.COMPLETED")) ){
				if(isset($TmpData->resource->status) && strtoupper($TmpData->resource->status) == "COMPLETED" &&
					isset($TmpData->resource->custom_id) && $TmpData->resource->custom_id != ""){
					$custom_array = explode("@@@",base64_decode($TmpData->resource->custom_id));
					if(isset($custom_array[0]) && $custom_array[0] != ""){
						$OrderID = $custom_array[0];
						$Obj =  $this->getClass('Sale\Cart\ShoppingCalculation')->getOrder($OrderID);		
						if(isset($Obj->PaymentStatus) && $Obj->PaymentStatus != "Paid"){
							
							$Return['OrderID'] = $Obj->OrderID;
							$Return['PaymentStatus'] = "Paid";
							$Return['Process'] = "1";
							$Return['Invoice'] = "1";
							$Return['ClearCart'] = "1";
							$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
							$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
							
						}
					}
				}
			}
		}
		header("Content-Type: text/plain");
		echo "OK";exit;
		//https://sun82.elevateomdev.com/newsite/index.php?m=checkout&v=Payment&method=PayPalApiV2
		
		
	}
	
	function getPaymentPreProcess($Obj){
		/* nothing to do*/
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CreateOrder")
		{
			header('Content-Type: application/json');
			echo json_encode($this->CreatePayPalOrder($Obj));
			exit;
		}
		
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CaptureOrder")
		{
			header('Content-Type: application/json');
			echo json_encode($this->CapturePayPalOrder($Obj));
			exit;
		}
		
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="AfterCapture")
		{
			$PayPalOrder = $this->GetPayPalOrder($Obj);
			if(isset($PayPalOrder['data']['purchase_units'][0]['payments']['captures'][0]['status']) && strtoupper($PayPalOrder['data']['purchase_units'][0]['payments']['captures'][0]['status']) == "COMPLETED"){
				
				$Return['OrderID'] = $Obj->OrderID;
				$Return['PaymentStatus'] = "Paid";
				$Return['Process'] = "1";
				$Return['Invoice'] = "1";
				$Return['ClearCart'] = "1";
				$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
				$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
				MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']));
				exit;
				
			}
			else{
			
				$this->getSession()->setArrVar("alert",array("danger","Something went wrong please try again."));
				MyRedirect(SKSEOURL('checkout','Confirm'));
				exit;
			}
			
		}
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		
		$Currency = "GBP";
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
		
		$CurrencyObj = $this->getClass("Frontend\Common\Common")->getDefaultCurrency();
		if(isset($CurrencyObj->Code) && strlen($CurrencyObj->Code)==3)
			$Currency = $CurrencyObj->Code;
		
		
		$GLOBALS['InnerJsFile'][] = array('https://www.paypal.com/sdk/js?components=applepay,buttons,marks&client-id='.PAYPAL_CREDENTIALS[PAYPAL_ENVIRONMENT]['client_id'].'&currency='.$Currency.'&intent=capture&enable-funding=venmo,paylater,card&debug=false',true);
		$GLOBALS['InnerJsFile'][] = array('https://applepay.cdn-apple.com/jsapi/v1/apple-pay-sdk.js',true);
			$GLOBALS['InnerJsScript'][] = "
				<script type='text/javascript'>
				function SKCreateOrder()
				{
					return fetch('".SKSEOURL('checkout','Confirm','','APIAction=CreateOrder')."')
						.then(function(response) {
							return response.json();
						}).then(function(resJson) {
							console.log(resJson)
							console.log(resJson.data.id)
							return resJson.data.id;
						});
				}
				function SKCaptureOrder(token)
				{
					// Capture Order
					let postData = new FormData();
					return fetch(
						'".SKSEOURL('checkout','Confirm','','APIAction=CaptureOrder')."',
						{
							method: 'POST',
							body: postData
						}
					).then(function(res) {
						return res.json();
					}).then(function() {
						window.location.href = '".SKSEOURL('checkout','Confirm','','APIAction=AfterCapture')."';
					});
				}
						paypal.Buttons({

							// Set your environment
							env: '".d("DEFINE_SK_PAYMENT_PAYPAL_APIV2_MODE")."',

							// Set style of button
							style: {
								layout: 'vertical',   // horizontal | vertical
								size:   'responsive',    // medium | large | responsive
								shape:  'pill',      // pill | rect
								color:  'gold'       // gold | blue | silver | black
							},

							// Execute payment on authorize
							commit: true,

							// Wait for the PayPal button to be clicked
							createOrder: function() {
								return SKCreateOrder();
								
							},

							// Wait for the payment to be authorized by the customer
							onApprove: function(data, actions) {
								return SKCaptureOrder(data);					
								
							}

						}).render('#paypalCheckoutContainer');

					</script>
					<script>		
		async function setupApplepay() {
			const applepay = paypal.Applepay();
			const { isEligible, countryCode, currencyCode, merchantCapabilities, supportedNetworks } = await  applepay.config();
			if (!isEligible) {
				throw new Error('applepay is not eligible');
			}

			document.getElementById('applepay-container').classList.remove('d-none');
			document.getElementById('applepay-container').innerHTML = '<div style=\"background:#000; border-radius: 50px; overflow:hidden; padding: 7px 0px;\"><apple-pay-button id=\"btn-applepay\" style=\"display: block;\" buttonstyle=\"black\" type=\"pay\" locale=\"en\"></div>';
			document.getElementById('btn-applepay').addEventListener('click', onClick);
			async function onClick() {
				const paymentRequest = {
					countryCode: 'GB',
					currencyCode: 'GBP',
					merchantCapabilities: ['supports3DS'],
					supportedNetworks: ['amex', 'discover', 'masterCard', 'visa'],
					requiredBillingContactFields: ['name', 'phone', 'email'],
					requiredShippingContactFields: [],
					total: {
						label: '".d("SITE_NAME")."',
						amount: '".$Amount."',
						type: 'final',
					}
				};
				let session = new window.ApplePaySession(4, paymentRequest);
				session.onvalidatemerchant = (event) => {
					applepay.validateMerchant({
						validationUrl: event.validationURL,
						displayName: '".d("SITE_NAME")."'
					}).then((payload) => {
						session.completeMerchantValidation(payload.merchantSession);
					}).catch((err) => {
						alert(err);
						console.error(err);
						session.abort();
					});
				};
				session.onpaymentmethodselected = () => {
					session.completePaymentMethodSelection({
						newTotal: paymentRequest.total,
					});
				};
				session.onpaymentauthorized = async (event) => {
					const id = await SKCreateOrder();
					if(id != null){
						await applepay.confirmOrder({ orderId: id, token: event.payment.token, billingContact: event.payment.billingContact , shippingContact: event.payment.shippingContact });
						if(await SKCaptureOrder(event.payment.token))
							session.completePayment({  status: window.ApplePaySession.STATUS_SUCCESS });
						else
							session.completePayment({ status: window.ApplePaySession.STATUS_FAILURE });
					}
					else
						session.completePayment({ status: window.ApplePaySession.STATUS_FAILURE });
				};
				session.oncancel  = () => {
					alert('Apple Pay Cancelled !!')
				}
				session.begin();
			}
		}
		document.addEventListener('DOMContentLoaded', () => {

			//console.log(ApplePaySession);
		  // eslint-disable-next-line no-undef
		  if(ApplePaySession?.supportsVersion(4) && ApplePaySession?.canMakePayments()) {
			setupApplepay().catch(console.error);
		  }
		});
		
	</script>
					
					";

		
		$Return = '<div class="text-center m-auto w-50">
					<div id="applepay-container" class="mb-3"></div>
					<div id="paypalCheckoutContainer"></div>
		</div>
		<form class="d-none" role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		
		
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '
		
		';
		//$Return .= '<table border="0" cellpadding="10" cellspacing="0" align="center"><tr><td align="center"></td></tr><tr><td align="center"><a href="#" onclick="javascript:window.open(\'https://www.paypal.com/cgi-bin/webscr?cmd=xpt/Marketing/popup/OLCWhatIsPayPal-outside\',\'olcwhatispaypal\',\'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=400, height=350\');"><img  src="https://www.paypal.com/en_US/i/bnr/bnr_paymentsBy_150x40.gif" border="0" alt="PayPal Logo"></a></td></tr></table>';
		$Return .= '</form>';
		return $Return;
	}
	
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"PayPal",
								"note"=>'
								<div class="col-sm-3 text-start mb-3 clearfix"><div class="d-block"><a href="https://www.paypal.com/uk/webapps/mpp/paypal-popup" title="How PayPal Works" onclick="javascript:window.open(\'https://www.paypal.com/uk/webapps/mpp/paypal-popup\',\'WIPaypal\',\'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=1060, height=700\'); return false;"><img src="https://www.paypalobjects.com/webstatic/mktg/Logo/AM_mc_vs_ms_ae_UK.png" border="0" alt="PayPal Acceptance Mark"></a></div></div>
								',
								"hidenote"=>"fdsfs",
								"object"=>$this,
							  );

		return $ResponseArray; 
  
    }
	
	function getCardPaymentInit($PostArray="")
	{
		$Currency = "GBP";
		
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$SessionID = $this->getSession()->getCurrentSID();
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->equalTo('ItemStatus','Normal');
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('Weight'=>'SUM(Weight*Qty)','Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
		$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
		$CartWeight = $Obj->Weight;
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CartOrder")
		{
			header('Content-Type: application/json');
			echo json_encode($this->CreatePayPalCartOrder($CartTotal));
			exit;
		}
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="GetShipMethod")
		{
			$rawData = file_get_contents("php://input");
			//$rawData  = '{"post_data":{"errors":{"ADDRESS_ERROR":"Your order cant be shipped to this address.","COUNTRY_ERROR":"Your order cant be shipped to this country.","STATE_ERROR":"Your order cant be shipped to this state.","ZIP_ERROR":"Your order cant be shipped to this zip."},"shippingAddress":{"city":"Wiltshire","countryCode":"GB","postalCode":"BA14 8AR","state":""},"orderID":"7FB41923RM316342H"},"method":"paypal_address_change"}';
			if(isset($rawData) && $rawData != ""){
				$TmpData = json_decode($rawData);
			}
			$orderID = isset($TmpData->post_data->orderID)?$TmpData->post_data->orderID:"";
			$this->AddOrderIDinCart($orderID);
			
			$PostArray = array();
			$PostArray['ShippingCity'] = isset($TmpData->post_data->shippingAddress->city)?$TmpData->post_data->shippingAddress->city:"";
			$PostArray['ShippingState'] = isset($TmpData->post_data->shippingAddress->state)?$TmpData->post_data->shippingAddress->state:"";
			$PostArray['ShippingCountry'] = isset($TmpData->post_data->shippingAddress->countryCode)?$TmpData->post_data->shippingAddress->countryCode:"";
			$PostArray['ShippingZipCode'] = isset($TmpData->post_data->shippingAddress->postalCode)?$TmpData->post_data->shippingAddress->postalCode:"";
			$ShippingArray  = $this->getClass("ShippingModule\Shipping\Common")->getAllShipping($PostArray);
			
			$ShipData = [];
			
			$patch = [];
			$patch['op']   = "add";
			$patch['path'] = "/purchase_units/@reference_id=='default'/shipping/options";

			$values = [];
			$i = 0;

			if (isset($ShippingArray['count']) && $ShippingArray['count'] > 0 &&
				isset($ShippingArray['method']) && is_array($ShippingArray['method'])) {

				foreach ($ShippingArray['method'] as $m => $arr) {
					foreach ($arr['rates'] as $rateArr) {
						
						if($i==0)
							$PostArray['ship_method'] = $m.'__'.$rateArr['code'];
						
						$values[$i] = [
							"id"       => $m.'__'.$rateArr['code'],
							"label"    => $arr['title'] . "-" . $rateArr['title'],
							"type"     => "SHIPPING",
							"selected" => $i==0?true:false,
							"amount"   => [
								"currency_code" => $Currency,
								"value"         => number_format((float)$rateArr['price'], 2, '.', '')
							]
						];

						$i++;
					}
				}
			}

			$patch['value'] = $values;
			
			
			$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart",$PostArray);		
			$order_patch = [];
			$order_patch['op']   = "replace";
			$order_patch['path'] = "/purchase_units/@reference_id=='default'/amount";
			
			$order_patch['value']['currency_code'] = $Currency;
			$order_patch['value']['value'] = str_replace(",","",number_format($CalArray['grandtotal']['price'],2));
			
			$order_patch['value']['breakdown']['item_total']['currency_code'] = $Currency;
			$order_patch['value']['breakdown']['item_total']['value'] = str_replace(",","",number_format($CalArray['subtotal']['price'],2));
			$order_patch['value']['breakdown']['shipping']['currency_code'] = $Currency;
			$order_patch['value']['breakdown']['shipping']['value'] = str_replace(",","",number_format($CalArray['shipping']['price'],2));
			
			if(isset($CalArray['tax']['price'])){
				$order_patch['value']['breakdown']['tax_total']['currency_code'] = $Currency;
				$order_patch['value']['breakdown']['tax_total']['value'] = str_replace(",","",number_format($CalArray['tax']['price'],2));
			}
			if(isset($CalArray['subtotal']['price']) && $CalArray['subtotal']['price'] > 0){
				$order_patch['value']['breakdown']['discount']['currency_code'] = $Currency;
				$order_patch['value']['breakdown']['discount']['value'] = str_replace(",","",number_format($CalArray['discount']['price'],2));
			}
		
			// PayPal requires an ARRAY of patches
			$ShipData = [ $patch,$order_patch ];
			$ShipDataJson = json_encode($ShipData);
			//echo $ShipDataJson;exit;
			$paypalHelper = new \PayPalHelper();
			$ReturnJson = $paypalHelper->orderPatch($ShipDataJson, $orderID);
			header('Content-Type: application/json');
			echo json_encode($ReturnJson);
			exit;
		}

		if(isset($_GET['APIAction']) && $_GET['APIAction']=="GetShipUpdate")
		{
			$rawData = file_get_contents("php://input");
			//$rawData = '{"post_data":{"errors":{"METHOD_UNAVAILABLE":"The shipping method you chose is unavailable. To continue, choose another way to get your order.","STORE_UNAVAILABLE":"Part of your order isnt available at this store."},"selectedShippingOption":{"id":"code_2_2_2","type":"SHIPPING","label":"-Next Business day (United Kingdom)","selected":true,"amount":{"currencyCode":"GBP","value":"8.95"}},"orderID":"25J46511H8381215F"},"method":"paypal_address_update"}';
			
			if(isset($rawData) && $rawData != ""){
				$TmpData = json_decode($rawData);
			}
			
			$orderID = isset($TmpData->post_data->orderID)?$TmpData->post_data->orderID:"";
			$this->AddOrderIDinCart($orderID);
			
			$PostArray = array();
			$PostArray['ship_method'] = isset($TmpData->post_data->selectedShippingOption->id)?$TmpData->post_data->selectedShippingOption->id:"";
			$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart",$PostArray);
			
			
			$patch = [];
			$patch['op']   = "replace";
			$patch['path'] = "/purchase_units/@reference_id=='default'/shipping/options";		
			$values[0] = [
							"id"       => $PostArray['ship_method'],
							"label"    => isset($TmpData->post_data->selectedShippingOption->label)?$TmpData->post_data->selectedShippingOption->label:"",
							"type"     => "SHIPPING",
							"selected" => true,
							"amount"   => [
								"currency_code" => $Currency,
								"value"         => str_replace(",","",number_format($CalArray['shipping']['price'],2))
							]
						];
			
			$patch['value'] = $values;
			
			$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart",$PostArray);		
			$order_patch = [];
			$order_patch['op']   = "replace";
			$order_patch['path'] = "/purchase_units/@reference_id=='default'/amount";
			
			$order_patch['value']['currency_code'] = $Currency;
			$order_patch['value']['value'] = str_replace(",","",number_format($CalArray['grandtotal']['price'],2));
			
			$order_patch['value']['breakdown']['item_total']['currency_code'] = $Currency;
			$order_patch['value']['breakdown']['item_total']['value'] = str_replace(",","",number_format($CalArray['subtotal']['price'],2));
			$order_patch['value']['breakdown']['shipping']['currency_code'] = $Currency;
			$order_patch['value']['breakdown']['shipping']['value'] = str_replace(",","",number_format($CalArray['shipping']['price'],2));
			if(isset($CalArray['tax']['price'])){
				$order_patch['value']['breakdown']['tax_total']['currency_code'] = $Currency;
				$order_patch['value']['breakdown']['tax_total']['value'] = str_replace(",","",number_format($CalArray['tax']['price'],2));
			}
			if(isset($CalArray['subtotal']['price']) && $CalArray['subtotal']['price'] > 0){
				$order_patch['value']['breakdown']['discount']['currency_code'] = $Currency;
				$order_patch['value']['breakdown']['discount']['value'] = str_replace(",","",number_format($CalArray['discount']['price'],2));
			}
		
			// PayPal requires an ARRAY of patches
			$ShipData = [ $patch, $order_patch ];
			$ShipDataJson = json_encode($ShipData);
			//echo $ShipDataJson;exit;
			$paypalHelper = new \PayPalHelper();
			$ReturnJson = $paypalHelper->orderPatch($ShipDataJson, $orderID);
			header('Content-Type: application/json');
			echo json_encode($ReturnJson);
			exit;
			
		}
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="CartOrderCapture")
		{
			$rawData = file_get_contents("php://input");
			//$rawData = '{"post_data":{"orderID":"2EM32746W4561983A","payerID":"Z2858D6K7N7TU","paymentID":"2EM32746W4561983A","billingToken":null,"facilitatorAccessToken":"A21AAL9e1Y-hqaGZpGbb_StqreZHshnW84VHxS8Ip5tzIVWsX5CEtD3Ym7Bsc9r37YpuAKVzb_wJ20SmAbQrKKHET-2yhCGkw","paymentSource":"paypal"},"method":"paypal_order_capture"}';
			if(isset($rawData) && $rawData != ""){
				$TmpData = json_decode($rawData);
			}
			$orderID = isset($TmpData->post_data->orderID)?$TmpData->post_data->orderID:"";
			
			$payerID = isset($TmpData->post_data->payerID)?$TmpData->post_data->payerID:"";
			$paymentID = isset($TmpData->post_data->paymentID)?$TmpData->post_data->paymentID:"";
			
			$paypalHelper = new \PayPalHelper();
			$ReturnJson = $paypalHelper->orderCapture($orderID);
			
			$ReturnArray = array();
			if(isset($ReturnJson['data']['status']) && strtoupper($ReturnJson['data']['status'])=="COMPLETED"){
				$PaidOrderID = $this->OrderGenerateByPayPalOrderID($ReturnJson['data']['id']);
				$ReturnArray['status'] = "success";
				$ReturnArray['Redirect'] = SKSEOURL('checkout','Cart','','action=PaymentInit&APIAction=SendInvoice&Status=Completed&OrderID='.$PaidOrderID);
				//$ReturnArray['Redirect'] = SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$PaidOrderID);
			}
			else{
				$ReturnArray['status'] = "failure";
				$ReturnArray['Redirect'] = SKSEOURL('checkout','Cart','','error=Payment Fail');
				
			}
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
			$filename=$dir."PaymentPaypalAPIV2-CART-".date("Y-m-d_h-i-s").".txt";
			$fp2 = fopen($filename, "w");
		
			fputs($fp2,"----------------rawData start---------\r\n");	
			fputs($fp2,"rawData=".print_r($rawData,true)."\r\n");	
			fputs($fp2,"----------------rawData end---------\r\n");
			
			fputs($fp2,"----------------ReturnJson start---------\r\n");	
			fputs($fp2,"POST=".print_r($ReturnJson,true)."\r\n");	
			fputs($fp2,"----------------ReturnJson end---------\r\n");
			fclose($fp2);
				
			header('Content-Type: application/json');
			echo json_encode($ReturnArray);
			exit;
			
		}
		if(isset($_GET['APIAction']) && $_GET['APIAction']=="SendInvoice")
		{
			$OrderID = isset($_GET['OrderID'])?$_GET['OrderID']:"";
			$Status = isset($_GET['Status'])?$_GET['Status']:"";
			if($OrderID != "" && strtoupper($Status)=="COMPLETED"){
				
				$this->getClass("Sale\Checkout\Common")->clearCart($OrderID);
				$this->getClass("Sale\Checkout\Common")->processInvoice($OrderID,$Return,$_GET,$_POST);
				MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$OrderID));
				exit;
			}
			else{
				die("Invalid request");
				exit;
			}
			
		}
	}
	function getCardMethod($PostArray="")
	{
		
		
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$SessionID = $this->getSession()->getCurrentSID();
		$where = new Where();
		$where->equalTo('SessionID',$SessionID);
		$where->equalTo('ItemStatus','Normal');
		$TmpCartObj->where = $where;
		$TmpCartObj->columnExpression=true;
		$Obj = (object)$TmpCartObj->tableSelectOne(array('Weight'=>'SUM(Weight*Qty)','Price'=>'SUM(Price*Qty)','UnitPrice'=>'SUM(UnitPrice*Qty)','Total'=>'SUM(Total)','TaxPrice'=>'SUM(TaxPrice*Qty)'));
		//$CartTotal = $Obj->UnitPrice + $Obj->TaxPrice;
		$CartTotal = $Obj->UnitPrice;
		$CartWeight = $Obj->Weight;
			
		
		$Return = '<script
            src="https://www.paypal.com/sdk/js?client-id='.PAYPAL_CREDENTIALS[PAYPAL_ENVIRONMENT]['client_id'].'&buyer-country='.PAYPAL_DEFAULT_COUNTRY.'&currency='.PAYPAL_DEFAULT_CURRENCY.'&components=buttons&enable-funding=venmo,paylater,card"
            data-sdk-integration-source="developer-studio"
        ></script>
		<script>
		var sk_pay = {
				url_order_create: "'.SKSEOURL('checkout','Cart','','action=PaymentInit&APIAction=CartOrder').'",
				url_shipping_method: "'.SKSEOURL('checkout','Cart','','action=PaymentInit&APIAction=GetShipMethod').'",
				url_shipping_update: "'.SKSEOURL('checkout','Cart','','action=PaymentInit&APIAction=GetShipUpdate').'",
				url_order_capture: "'.SKSEOURL('checkout','Cart','','action=PaymentInit&APIAction=CartOrderCapture').'",
				total: "'.$CartTotal.'",
				label: "checkout"
			}
		</script>
		';
        $Return .= file_get_contents(dirname(__FILE__)."/cart.js.php");
		return $Return;
	}

	function CreatePayPalCartOrder($Amount)
	{
		$paypalHelper = new \PayPalHelper;
		$Amount = str_replace(",","",number_format($Amount,2));
		$Currency = "GBP";
		$OrderData = array();
		$Custom = base64_encode((int)$Amount.'@@@'.$Amount);
		$OrderData['intent'] = 'CAPTURE'; //CAPTURE,AUTHORIZE
		$OrderData['purchase_units'][0]['custom_id'] = $Custom;
		$cartRows = $this->getClass("Sale\Cart\Common")->getShoppingCart();
		$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart");
		$i =0;
		foreach($cartRows as $CurrentCartItem){
			$OrderData['purchase_units'][0]['custom_id'] = base64_encode($CurrentCartItem->SessionID);
			
			$ItemName = preg_replace('/[^a-zA-Z0-9- _\.]/','', $CurrentCartItem->ItemName); 
			$OrderData['purchase_units'][0]['items'][$i]['name'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['description'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['sku'] = $CurrentCartItem->ItemNo;
			$OrderData['purchase_units'][0]['items'][$i]['quantity'] = $CurrentCartItem->Qty;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['value'] = str_replace(",","",number_format($CurrentCartItem->Price,2));
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['currency_code'] = $Currency;
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['value'] = str_replace(",","",number_format($CurrentCartItem->TaxPrice,2));
			$i++;
		}
		
		$OrderData['purchase_units'][0]['amount']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['value'] = str_replace(",","",number_format($CalArray['grandtotal']['price'],2));
		
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['value'] = str_replace(",","",number_format($CalArray['subtotal']['price'],2));
		//$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['currency_code'] = $Currency;
		//$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['value'] = str_replace(",","",number_format($CalArray['shipping']['price'],2));
		if(isset($CalArray['tax']['price'])){
			$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['value'] = str_replace(",","",number_format($CalArray['tax']['price'],2));
		}
		if(isset($CalArray['subtotal']['price']) && $CalArray['subtotal']['price'] > 0){
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['value'] = str_replace(",","",number_format($CalArray['discount']['price'],2));
		}
		
		$OrderDataJson = json_encode($OrderData);
		$ReturnJson = $paypalHelper->orderCreate($OrderDataJson);
		
		if(isset($ReturnJson['data']['id']) && $ReturnJson['data']['id'] != ""){
			$this->AddOrderIDinCart($ReturnJson['data']['id']);
			return $ReturnJson['data'];
			exit;
		}
		//$ReturnJson = $OrderDataJson;
		return $ReturnJson;
		
	}
	function CreatePayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
		$Currency = "GBP";
		$CurrencyObj = $this->getClass("Frontend\Common\Common")->getDefaultCurrency();
		if(isset($CurrencyObj->Code) && strlen($CurrencyObj->Code)==3)
			$Currency = $CurrencyObj->Code;
			
		$randNo= (string)rand(10000,20000);
		
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
			
			
		$OrderData = array();
		$OrderData['intent'] = 'CAPTURE'; //CAPTURE,AUTHORIZE
		$OrderData['application_context']['return_url'] = ""; //SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Obj->OrderID);
		$OrderData['application_context']['cancel_url'] = ""; //SKSEOURL('checkout','Confirm');
		$OrderData['purchase_units'][0]['reference_id'] = isset($Obj->OrderNo)?$Obj->OrderNo:"";
		$OrderData['purchase_units'][0]['description'] = "Shop";//d("SITE_NAME").' Shop';
		$OrderData['purchase_units'][0]['custom_id'] = $Custom;
		$OrderData['purchase_units'][0]['invoice_id'] = 'INV-'.$Obj->OrderID.'-'.$randNo;
		//$OrderData['purchase_units'][0]['soft_descriptor'] = substr(d("SITE_NAME"),0,21);
		$OrderData['purchase_units'][0]['soft_descriptor'] = "PayPal Payment";
		
		$cartRows = $this->getClass("Sale\Cart\Common")->getOrderCart($Obj->OrderID);
		
		$i =0;
		foreach($cartRows as $CurrentCartItem){
			$ItemName = preg_replace('/[^a-zA-Z0-9- _\.]/','', $CurrentCartItem->ItemName); 
			$OrderData['purchase_units'][0]['items'][$i]['name'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['description'] = substr($ItemName,0,125);
			$OrderData['purchase_units'][0]['items'][$i]['sku'] = $CurrentCartItem->ItemNo;
			$OrderData['purchase_units'][0]['items'][$i]['quantity'] = $CurrentCartItem->Qty;
			//$OrderData['purchase_units'][0]['items'][$i]['category'] = $category;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['items'][$i]['unit_amount']['value'] = str_replace(",","",number_format($CurrentCartItem->Price,2));
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['currency_code'] = $Currency;
			//$OrderData['purchase_units'][0]['items'][$i]['tax']['value'] = str_replace(",","",number_format($CurrentCartItem->TaxPrice,2));
			$i++;
	}
		
		
		$OrderData['purchase_units'][0]['amount']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['value'] = $Amount;
		
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['item_total']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['shipping']['value'] = str_replace(",","",number_format($Obj->ShippingAmount,2));
		$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['currency_code'] = $Currency;
		$OrderData['purchase_units'][0]['amount']['breakdown']['tax_total']['value'] = str_replace(",","",number_format($Obj->TaxAmount,2));
		if($Obj->ProductDiscount > 0){
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['currency_code'] = $Currency;
			$OrderData['purchase_units'][0]['amount']['breakdown']['discount']['value'] = str_replace(",","",number_format($Obj->ProductDiscount,2));
		}
		
		//$OrderData['purchase_units'][0]['amount']['breakdown']['handling']['currency_code'] = $Currency;
		//$OrderData['purchase_units'][0]['amount']['breakdown']['handling']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		//$OrderData['purchase_units'][0]['amount']['breakdown']['insurance']['currency_code'] = $Currency;
		//$OrderData['purchase_units'][0]['amount']['breakdown']['insurance']['value'] = str_replace(",","",number_format($Obj->SubTotal,2));
		
		
		
		
		$OrderData['application_context']['shipping_preference'] = "SET_PROVIDED_ADDRESS";
		$OrderData['application_context']['user_action'] = "PAY_NOW";
		
		$OrderData['purchase_units'][0]['shipping']['type']= "SHIPPING";
		//$OrderData['purchase_units'][0]['shipping']['name']['given_name']= isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"";
		//$OrderData['purchase_units'][0]['shipping']['name']['surname']= isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"";
		$OrderData['purchase_units'][0]['shipping']['name']['full_name']= (isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"")." ".(isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"");
		$OrderData['purchase_units'][0]['shipping']['address']['address_line_1']= isset($Obj->ShippingAddress1)?$Obj->ShippingAddress1:"";
		$OrderData['purchase_units'][0]['shipping']['address']['address_line_2']= isset($Obj->ShippingAddress2)?$Obj->ShippingAddress2:"";
		$OrderData['purchase_units'][0]['shipping']['address']['admin_area_2']= isset($Obj->ShippingCity)?$Obj->ShippingCity:"";
		$OrderData['purchase_units'][0]['shipping']['address']['admin_area_1']= isset($Obj->ShippingState)?$Obj->ShippingState:"";
		$OrderData['purchase_units'][0]['shipping']['address']['postal_code']= isset($Obj->ShippingZipCode)?$Obj->ShippingZipCode:"";
		$OrderData['purchase_units'][0]['shipping']['address']['country_code']= isset($Obj->ShippingCountry)?$Obj->ShippingCountry:"GB";

		$OrderData['payer']['email_address']= (isset($Obj->Email)?$Obj->Email:"");
		$OrderData['payer']['full_name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		$OrderData['payer']['name']['given_name']= isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"";
		$OrderData['payer']['name']['surname']= isset($Obj->BillingLastName)?$Obj->BillingLastName:"";
		$OrderData['payer']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payer']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payer']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payer']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payer']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payer']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";
		
		//$OrderData['payer']['phone']['phone_type']= "MOBILE";
		//$OrderData['payer']['phone']['phone_number']['national_number']= isset($Obj->BillingPhone)?$Obj->BillingPhone:"";
		

		/*
		$OrderData['payment_source']['paypal']['email_address']= (isset($Obj->Email)?$Obj->Email:"");
		$OrderData['payment_source']['paypal']['name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		//$OrderData['payment_source']['paypal']['name']['given_name']= isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"";
		//$OrderData['payment_source']['paypal']['name']['surname']= isset($Obj->BillingLastName)?$Obj->BillingLastName:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payment_source']['paypal']['billing_address']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";

		$OrderData['payment_source']['card']['name']= (isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"")." ".(isset($Obj->BillingLastName)?$Obj->BillingLastName:"");
		$OrderData['payment_source']['card']['billing_address']['address']['address_line_1']= isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"";
		$OrderData['payment_source']['card']['billing_address']['address']['address_line_2']= isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"";
		$OrderData['payment_source']['card']['billing_address']['address']['admin_area_2']= isset($Obj->BillingCity)?$Obj->BillingCity:"";
		$OrderData['payment_source']['card']['billing_address']['address']['admin_area_1']= isset($Obj->BillingState)?$Obj->BillingState:"";
		$OrderData['payment_source']['card']['billing_address']['address']['postal_code']= isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"";
		$OrderData['payment_source']['card']['billing_address']['address']['country_code']= isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB";
		*/

		$OrderDataJson = json_encode($OrderData);
		$ReturnJson = $paypalHelper->orderCreate($OrderDataJson);
		
		if(isset($ReturnJson['data']['id']) && $ReturnJson['data']['id'] != ""){
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$DataArray = array();
			$DataArray['TransactionID'] = isset($ReturnJson['data']['id'])?$ReturnJson['data']['id']:"";;
			$OrderObj->tableUpdate($DataArray);
		}
		//$ReturnJson = $OrderDataJson;
		return $ReturnJson;
	
	}
	
	function CapturePayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$ReturnJson = $paypalHelper->orderCapture($Obj->TransactionID);
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."PaymentPaypalAPIV2-".$Obj->OrderID."-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
		
		fputs($fp2,"----------------TransactionID Variable start---------\r\n");	
		fputs($fp2,"TransactionID=".$Obj->TransactionID."\r\n");	
		fputs($fp2,"----------------TransactionID Variable end---------\r\n");
		
		fputs($fp2,"----------------ReturnJson Variable start---------\r\n");	
		fputs($fp2,"ReturnJson=".print_r($ReturnJson,true)."\r\n");	
		fputs($fp2,"----------------ReturnJson Variable end---------\r\n");
		
		fputs($fp2,"----------------POST Variable start---------\r\n");	
		fputs($fp2,"POST=".print_r($_POST,true)."\r\n");	
		fputs($fp2,"----------------POST Variable end---------\r\n");
		fclose($fp2);
		
		/* ORDER change status insert start*/
			$OrderLogObj = new DataTable(TABLE_ORDER_LOG);
			$DataArray = array();
			$DataArray['OrderID'] = $Obj->OrderID;
			$DataArray['MSG'] = "PayPalApiV2Capture";
			$DataArray['MSGOBJ'] = print_r($ReturnJson,true);
			$DataArray['LogInfo'] = base64_encode(serialize($ReturnJson));
			$DataArray['CreatedDate'] = date("Y-m-d H:i:s");
			$OrderLogObj->tableInsert($DataArray);
			/* ORDER change status insert end*/	
		
		return $ReturnJson;
	}
	function GetPayPalOrder($Obj,$PostArray="")
	{
		$paypalHelper = new \PayPalHelper;
		$ReturnJson = $paypalHelper->orderGet($Obj->TransactionID);
		return $ReturnJson;
	}
	
	function PatchPayPalOrder($Obj,$PostArray="")
	{
		
		
	}
	
	function AddOrderIDinCart($orderID)
	{
		$SessionID = $this->getSession()->getCurrentSID();
		$TmpCartObj = new DataTable(TABLE_TMPCART);
		$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
		$DataArray = array();
		$DataArray['ExtraField1'] = $orderID;
		$TmpCartObj->tableUpdate($DataArray);
		
	}

	function OrderGenerateByPayPalOrderID($PayPalOrderID)
	{
		
		if($PayPalOrderID != ""){
			
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('TransactionID' => $PayPalOrderID));
			$CurrentOrder = (object)$OrderObj->tableSelectOne(array("OrderID","PaymentStatus"));
			
			if(isset($CurrentOrder->PaymentStatus) && $CurrentOrder->PaymentStatus=="Paid")
				return $CurrentOrder->OrderID;
			
			
			$paypalHelper = new \PayPalHelper;
			$OrderJson = $paypalHelper->orderGet($PayPalOrderID);
		
			$SessionID = $this->getSession()->getCurrentSID();
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
			$UserID = isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
			$DownloadID ="";
		
			$OrderDataArray = array();
			$OrderDataArray['UserID'] = $UserID;
			$OrderDataArray['SessionID'] =$SessionID;
			$OrderDataArray['CreatedBy'] = isset($PostArray['CreatedBy'])?$PostArray['CreatedBy']:"";
			$OrderDataArray['PurchaseNo'] = isset($PostArray['PurchaseNo'])?$PostArray['PurchaseNo']:"";
			$OrderDataArray['IPAddress'] 	= isset($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:"";
		
			$OrderDataArray['Email'] = isset($OrderJson['data']['payer']['email_address'])?$OrderJson['data']['payer']['email_address']:"";
			
			$OrderDataArray['ShippingFirstName'] = isset($OrderJson['data']['payer']['name']['given_name'])?$OrderJson['data']['payer']['name']['given_name']:"";
			$OrderDataArray['ShippingLastName'] = isset($OrderJson['data']['payer']['name']['surname'])?$OrderJson['data']['payer']['name']['surname']:"";
			
			
			$OrderDataArray['ShippingAddress1'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['address_line_1'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['address_line_1']:"";
			$OrderDataArray['ShippingAddress2'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['address_line_2'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['address_line_2']:"";
			$OrderDataArray['ShippingCity'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['admin_area_2'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['admin_area_2']:"";
			$OrderDataArray['ShippingState'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['admin_area_1'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['admin_area_1']:"";
			$OrderDataArray['ShippingArea'] = "";
			$OrderDataArray['ShippingCountry'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['country_code'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['country_code']:"";
			$OrderDataArray['ShippingZipCode'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['address']['postal_code'])?$OrderJson['data']['purchase_units'][0]['shipping']['address']['postal_code']:"";
			$OrderDataArray['ShippingPhone'] = "";
			$OrderDataArray['ShippingFax'] = "";
			
			$OrderDataArray['BillingAddress1'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['address_line_1'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['address_line_1']:$OrderDataArray['ShippingAddress1'];
			$OrderDataArray['BillingAddress2'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['address_line_2'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['address_line_2']:$OrderDataArray['ShippingAddress2'];
			$OrderDataArray['BillingCity'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['admin_area_2'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['admin_area_2']:$OrderDataArray['ShippingCity'];
			$OrderDataArray['BillingState'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['admin_area_1'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['admin_area_1']:$OrderDataArray['ShippingState'];
			$OrderDataArray['BillingArea'] = "";
			$OrderDataArray['BillingCountry'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['country_code'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['country_code']:$OrderDataArray['ShippingCountry'];
			$OrderDataArray['BillingZipCode'] = isset($OrderJson['data']['purchase_units'][0]['billing']['address']['postal_code'])?$OrderJson['data']['purchase_units'][0]['billing']['address']['postal_code']:$OrderDataArray['ShippingZipCode'];
			$OrderDataArray['BillingPhone'] = "";
			$OrderDataArray['BillingFax'] = "";
			
			$OrderDataArray['BillingFirstName'] = isset($OrderJson['data']['payer']['name']['given_name'])?$OrderJson['data']['payer']['name']['given_name']:"";
			$OrderDataArray['BillingLastName'] = isset($OrderJson['data']['payer']['name']['surname'])?$OrderJson['data']['payer']['name']['surname']:"";
			
			
			$OrderDataArray['Comments'] = "";
			
			
			$OrderDataArray['OrderStatus'] = 'Pending';
			$OrderDataArray['ShippingStatus'] = 'Pending';
			$OrderDataArray['PaymentStatus'] = 'Pending';
			
			$OrderDataArray['PaymentMethod'] = "PayPalApiV2";
			$OrderDataArray['Attempted'] = "0";
			
			
			$CalArray = $this->getClass('Sale\Cart\ShoppingCalculation')->Calculate("cart");
			
			$OrderDataArray['PointText'] = "";
			$OrderDataArray['PointAmount'] = "0";
			
			$OrderDataArray['VoucherText'] = "";
			$OrderDataArray['VoucherCode'] = "";
			$OrderDataArray['VoucherAmount'] = "0";
			
			
			$OrderDataArray['ShippingText'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['label'])?$OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['label']:"";
			$OrderDataArray['ShippingCode'] = isset($OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['id'])?$OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['id']:"";
			$OrderDataArray['ShippingAmount'] = (isset($OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['amount']['value']) && $OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['amount']['value'] > 0)?$OrderJson['data']['purchase_units'][0]['shipping']['options'][0]['amount']['value']:"0";
			
			$OrderDataArray['SubTotal'] = (isset($OrderJson['data']['purchase_units'][0]['amount']['breakdown']['item_total']['value']) && $OrderJson['data']['purchase_units'][0]['amount']['breakdown']['item_total']['value'] > 0)?$OrderJson['data']['purchase_units'][0]['amount']['breakdown']['item_total']['value']:"0";
			$OrderDataArray['TaxText'] = isset($CalArray['tax']['title'])?$CalArray['tax']['title']:"VAT";
			$OrderDataArray['TaxAmount'] = (isset($OrderJson['data']['purchase_units'][0]['amount']['breakdown']['tax_total']['value']) && $OrderJson['data']['purchase_units'][0]['amount']['breakdown']['tax_total']['value'] > 0)?$OrderJson['data']['purchase_units'][0]['amount']['breakdown']['tax_total']['value']:"0";
			
			$OrderDataArray['Total'] = (isset($OrderJson['data']['purchase_units'][0]['amount']['value']) && $OrderJson['data']['purchase_units'][0]['amount']['value'] > 0)?$OrderJson['data']['purchase_units'][0]['amount']['value']:"0";
			$OrderDataArray['ProductDiscount'] = "0";
			
			$OrderDataArray['GrandTotal'] = (isset($OrderJson['data']['purchase_units'][0]['amount']['value']) && $OrderJson['data']['purchase_units'][0]['amount']['value'] > 0)?$OrderJson['data']['purchase_units'][0]['amount']['value']:"0";
			
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('TransactionID' => $PayPalOrderID));
			$CurrentOrder = (object)$OrderObj->tableSelectOne(array("OrderID"));
			
			if(isset($CurrentOrder->OrderID) && $CurrentOrder->OrderID !=""){
				$OrderID = $OrderObj->tableUpdate($OrderDataArray);
			}
			else{
				$OrderObj->tableUpdate($OrderDataArray);
				$OrderDataArray['TransactionID'] =$PayPalOrderID;
				$OrderDataArray['CreatedDate']	=date("Y-m-d H:i:s");
				$OrderID = $OrderObj->tableInsert($OrderDataArray);
			}
			
			/* Order Currencies start*/
			$CurrentCurrency = $this->getClass('Frontend\Common\Common')->getFrontCurrency();
			$DefaultCurrentCurrency = $this->getClass('Frontend\Common\Common')->getDefaultCurrency();
			if(isset($CurrentCurrency->CurrencyID) && $CurrentCurrency->CurrencyID !="")
			{
				$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
				$OrderCurrencyObj->where[] = array('=',array('OrderID' => $OrderID));
				$OrderCurrencyObj->tableDelete();
		
				$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
				$OrderCurrencyArray = array();
				$OrderCurrencyArray['OrderID'] = $OrderID;
				$OrderCurrencyArray['CurrencyName'] = $CurrentCurrency->CurrencyName;
				$OrderCurrencyArray['Code'] = $CurrentCurrency->Code;
				$OrderCurrencyArray['Symbol'] = $CurrentCurrency->Symbol;
				$OrderCurrencyArray['Value'] = $CurrentCurrency->Value;
				$OrderCurrencyArray['ExchangeRate'] = $CurrentCurrency->Value;
				$OrderCurrencyArray['DefaultCode'] = $DefaultCurrentCurrency->Code;
				$OrderCurrencyArray['Prefix'] = $CurrentCurrency->Prefix;
				$OrderCurrencyObj->tableInsert($OrderCurrencyArray);
				
			}
			/* Order Currencies end*/
			
			
			$TmpCartObj = new DataTable(TABLE_TMPCART);
			$TmpCartObj->where[] = array('=',array('ExtraField1' => $PayPalOrderID));
			$cartRows = $TmpCartObj->tableSelectAll("","TmpCartID ASC");
			
			$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
			$OrderDetailObj->where[] = array('=',array('OrderID' => $OrderID));
			$OrderDetailObj->tableDelete();
			foreach($cartRows as $CurrentCartItem){
				
				$OrderDetailObj = new DataTable(TABLE_ORDER_DETAILS);
				$DataArray = array();
				$DataArray['OrderID'] = $OrderID;
				$DataArray['ItemID'] = "OD_".$CurrentCartItem->ItemID;
				//$DataArray['WishListID'] = $CurrentCartItem->WishListID;
				if($CurrentCartItem->ParentItemID != "")
					$DataArray['ParentItemID'] = "OD_".$CurrentCartItem->ParentItemID;
				else
					$DataArray['ParentItemID'] = $CurrentCartItem->ParentItemID;
				
				$DataArray['ItemType'] = $CurrentCartItem->ItemType;
				$DataArray['ItemStatus'] = $CurrentCartItem->ItemStatus;
				$DataArray['ReferenceID'] = $CurrentCartItem->ReferenceID;
				$DataArray['ItemName'] = $CurrentCartItem->ItemName;
				$DataArray['ItemNo'] = $CurrentCartItem->ItemNo;
				$DataArray['Attribute1'] = $CurrentCartItem->Attribute1;
				$DataArray['Attribute2'] = $CurrentCartItem->Attribute2;
				$DataArray['Width'] = $CurrentCartItem->Width > 0?$CurrentCartItem->Width:"0";
				$DataArray['Height'] = $CurrentCartItem->Height > 0?$CurrentCartItem->Height:"0";
				$DataArray['Length'] = $CurrentCartItem->Length > 0?$CurrentCartItem->Length:"0";
				$DataArray['Weight'] = $CurrentCartItem->Weight > 0?$CurrentCartItem->Weight:"0";
				$DataArray['ModifyPrice'] = $CurrentCartItem->ModifyPrice > 0?$CurrentCartItem->ModifyPrice:"0";
				$DataArray['UnitPrice'] = $CurrentCartItem->UnitPrice;
				$DataArray['TaxPrice'] = $CurrentCartItem->TaxPrice;
				$DataArray['TaxPercent'] = $CurrentCartItem->TaxPercent;
				$DataArray['VoucherAmount'] = $CurrentCartItem->VoucherAmount > 0?$CurrentCartItem->VoucherAmount:"0";
				$DataArray['VoucherText'] = $CurrentCartItem->VoucherText;
				$DataArray['VoucherCode'] = $CurrentCartItem->VoucherCode;
				$DataArray['Price'] = $CurrentCartItem->Price;
				$DataArray['PriceWithTax'] = $CurrentCartItem->PriceWithTax;
				$DataArray['ActualPrice'] = $CurrentCartItem->ActualPrice;
				$DataArray['ActualPriceWithTax'] = $CurrentCartItem->ActualPriceWithTax;
				$DataArray['Qty'] = $CurrentCartItem->Qty;
				$DataArray['Total'] = $CurrentCartItem->Total;
				$DataArray['TotalWithTax'] = $CurrentCartItem->TotalWithTax;
				$DataArray['Comments'] = $CurrentCartItem->Comments;
				$DataArray['SessionID'] = $CurrentCartItem->SessionID;
				$DataArray['SessionInfo'] = $CurrentCartItem->SessionInfo;
				$DataArray['ExtraField1'] = $CurrentCartItem->ExtraField1;
				$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
				
				$OrderDetailObj->tableInsert($DataArray);
				
				/*check download files start*/
				if($DownloadID =="" && $CurrentCartItem->ItemType=="Product"){
					$ProductDownloadObj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
					$ProductDownloadObj->where[] = array('=',array('ProductID' => (int)$CurrentCartItem->ReferenceID));
					$CurrentDownload = (object)$ProductDownloadObj->tableSelectOne(array("ProductID"));
					if(isset($CurrentDownload->ProductID) && $CurrentDownload->ProductID !="" && $DownloadID =="")
						$DownloadID = uniqid("DW_");
					
				}
				/*check download files start*/
			
				if($DownloadID =="" && $CurrentCartItem->ItemStatus=="Download")
					$DownloadID = uniqid("DW_");
				
			}
			
			$OrderDataArray = array();
			$OrderDataArray['OrderNo'] ="A".date('y').($OrderID);
			$OrderDataArray['DownloadID'] =$DownloadID;
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
			$OrderObj->tableUpdate($OrderDataArray);
			
			
			$OrderObj = new DataTable(TABLE_ORDERS);
			$OrderObj->where[] = array('=',array('OrderID' => $OrderID));
			$CurrentOrder = (object)$OrderObj->tableSelectOne(array("OrderID","PaymentStatus"));
			
			if(isset($CurrentOrder->PaymentStatus) && $CurrentOrder->PaymentStatus != "Paid" && isset($OrderJson['data']['status']) && strtoupper($OrderJson['data']['status'])=="COMPLETED"){
				$Return['OrderID'] = $OrderID;
				$Return['PaymentStatus'] = "Paid";
				$Return['Process'] = "1";
				$Return['Invoice'] = "1";
				$Return['ClearCart'] = "1";
				$this->getClass("Sale\Checkout\Common")->processPayment($OrderID,$Return,$_GET,$_POST);				
			}
							
			return $OrderID;	
		}	
		
	}
	
}	