<?php 
namespace PaymentModule\Braintree;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	 var $environment;
	  var $merchantid;
	  var $publickey;
	  var $privatekey;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		  $this->environment = DEFINE_SK_PAYMENT_BRAINTREE_ENVIRONMENT;
		  $this->merchantid = DEFINE_SK_PAYMENT_BRAINTREE_MERCHANTID;
		  $this->publickey = DEFINE_SK_PAYMENT_BRAINTREE_PUBLICKEY;
		  $this->privatekey = DEFINE_SK_PAYMENT_BRAINTREE_PRIVATEKEY;
		  
		  $this->multipleCurrency = true;
	
	}
	
	function BraintreeGateway(){
		$gateway = new \Braintree\Gateway([
				'environment' => $this->environment,
				'merchantId' => $this->merchantid,
				'publicKey' => $this->publickey,
				'privateKey' => $this->privatekey,
		]);
		
		return $gateway;
	}
	
	function SKCheckPayPalAuthenticate($PostArray)
	{
		
	
	}
	
	function getPaymentPreProcess($Obj){
		/* nothing to do*/
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/braintree");
			$filename=$dir."Braintree-".date("Y-m-d_h-i-s")."-".$Obj->OrderID."-".$Obj->OrderNo.".txt";
			$fp2 = fopen($filename, "w");
			
			
			$OrderAmount = str_replace(",","",number_format($Obj->GrandTotal,2));
			$amount = isset($PostArray["amount"])?$PostArray["amount"]:"";
			$nonce = isset($PostArray["payment_method_nonce"])?$PostArray["payment_method_nonce"]:"";
			 if($OrderAmount != $amount){
				$this->getSession()->setArrVar("alert",array("danger","Something went wrong. please try again."));
				MyRedirect(SKSEOURL('checkout','Confirm'));
				exit; 
			 }	
			
			$gateway = $this->BraintreeGateway();
			$result = $gateway->transaction()->sale([
				'amount' => $amount,
				'orderId' => $Obj->OrderNo,
				'paymentMethodNonce' => $nonce,
				'options' => [
					'submitForSettlement' => true
				],
				'customer' => array(
					'firstName' => isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"",
					'lastName' => isset($Obj->BillingLastName)?$Obj->BillingLastName:"",
					'email' => isset($Obj->Email)?$Obj->Email:"",
				),
				'billing' => array(
					'firstName' => isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"",
					'lastName' => isset($Obj->BillingLastName)?$Obj->BillingLastName:"",
					'streetAddress' => isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"",
					'extendedAddress' => isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"",
					'locality' => isset($Obj->BillingCity)?$Obj->BillingCity:"",
					'region' => isset($Obj->BillingState)?$Obj->BillingState:"",
					'postalCode' => isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"",
					'countryCodeAlpha2' => isset($Obj->BillingCountry)?$Obj->BillingCountry:"GB",
				),
				'shipping' => array(
					'firstName' => isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"",
					'lastName' => isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"",
					'streetAddress' => isset($Obj->ShippingAddress1)?$Obj->ShippingAddress1:"",
					'extendedAddress' => isset($Obj->ShippingAddress2)?$Obj->ShippingAddress2:"",
					'locality' => isset($Obj->ShippingCity)?$Obj->ShippingCity:"",
					'region' => isset($Obj->ShippingState)?$Obj->ShippingState:"",
					'postalCode' => isset($Obj->ShippingZipCode)?$Obj->ShippingZipCode:"",
					'countryCodeAlpha2' => isset($Obj->ShippingCountry)?$Obj->ShippingCountry:"GB",
				)
			]);

			fputs($fp2,"----------------BraintreeGateway transaction start---------\r\n");	
			fputs($fp2,"RESULT --------- ".print_r($result,true)."\r\n");	
			fputs($fp2,"----------------BraintreeGateway transaction end---------\r\n");
			fclose($fp2);
			if ($result->success || !is_null($result->transaction)) {
				$transaction = $result->transaction;
			
				$transactionSuccessStatuses = [
												\Braintree\Transaction::AUTHORIZED,
												\Braintree\Transaction::AUTHORIZING,
												\Braintree\Transaction::SETTLED,
												\Braintree\Transaction::SETTLING,
												\Braintree\Transaction::SETTLEMENT_CONFIRMED,
												\Braintree\Transaction::SETTLEMENT_PENDING,
												\Braintree\Transaction::SUBMITTED_FOR_SETTLEMENT
											];
											
				 if (in_array($transaction->status, $transactionSuccessStatuses)) {
						$Return['OrderID'] = $Obj->OrderID;
						$Return['TransactionID'] = $transaction->id;
						$Return['PaymentStatus'] = "Paid";
						$Return['Process'] = "1";
						$Return['Invoice'] = "1";
						$Return['ClearCart'] = "1";
						$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
						$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
						$this->getClass("Sale\Checkout\Common")->clearCart($Return['OrderID']);
						MyRedirect(SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']));
						exit;
				 }
				 else{
					 
					 $errorString = "Sorry your order is not completed due to some error. (Status: " . $transaction->status . ").";
					 $this->getSession()->setArrVar("alert",array("danger",$errorString));
					 MyRedirect(SKSEOURL('checkout','Confirm'));
					 exit;
				 }
				 
				
			} else {
				$errorString = "";
				foreach($result->errors->deepAll() as $error) {
					$errorString .= 'Error: ' . $error->code . ": " . $error->message . "\n";
				}
				$this->getSession()->setArrVar("alert",array("danger",$errorString));
				MyRedirect(SKSEOURL('checkout','Confirm'));
				exit;
			}
		
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		$gateway = $this->BraintreeGateway();
		
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Return = '<form role="form" id="braintree-payment-form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		$Return .= '<input type="hidden" name="amount" value="'.$Amount.'" />';
		$Return .= '<input id="nonce" name="payment_method_nonce" type="hidden" />';
		$Return .= '<div class="bt-drop-in-wrapper">
                        <div id="dropin-container"></div>
                    </div>';
					
		
		$Return .= ' <script src="https://js.braintreegateway.com/web/dropin/1.20.2/js/dropin.min.js"></script>
						<script>
							var form = document.querySelector("#braintree-payment-form");
							var client_token = "'.($gateway->ClientToken()->generate()).'";
								
							var threeDSecureParameters = {
							  amount: "'.($Amount).'",
							  email: "'.(isset($Obj->Email)?$Obj->Email:"").'",
							  billingAddress: {
								givenName: "'.(isset($Obj->BillingFirstName)?$Obj->BillingFirstName:"").'", // ASCII-printable characters required, else will throw a validation error
								surname: "'.(isset($Obj->BillingLastName)?$Obj->BillingLastName:"").'", // ASCII-printable characters required, else will throw a validation error
								phoneNumber: "'.(isset($Obj->BillingPhone)?preg_replace('/[^0-9]/s', '', $Obj->BillingPhone):"").'",
								streetAddress: "'.(isset($Obj->BillingAddress1)?$Obj->BillingAddress1:"").'",
								extendedAddress: "'.(isset($Obj->BillingAddress2)?$Obj->BillingAddress2:"").'",
								locality: "'.(isset($Obj->BillingCity)?$Obj->BillingCity:"").'",
								region: "'.(isset($Obj->BillingState)?$Obj->BillingState:"").'",
								postalCode: "'.(isset($Obj->BillingZipCode)?$Obj->BillingZipCode:"").'",
								countryCodeAlpha2: "'.(isset($Obj->BillingCountry)?$Obj->BillingCountry:"").'"
							  },
							  additionalInformation: {
								workPhoneNumber: "'.(isset($Obj->BillingPhone)?preg_replace('/[^0-9]/s', '', $Obj->BillingPhone):"").'",
								shippingGivenName: "'.(isset($Obj->ShippingFirstName)?$Obj->ShippingFirstName:"").'",
								shippingSurname: "'.(isset($Obj->ShippingLastName)?$Obj->ShippingLastName:"").'",
								shippingPhone: "'.(isset($Obj->ShippingPhone)?preg_replace('/[^0-9]/s', '', $Obj->ShippingPhone):"").'",
								shippingAddress: {
								  streetAddress: "'.(isset($Obj->ShippingAddress1)?$Obj->ShippingAddress1:"").'",
									extendedAddress: "'.(isset($Obj->ShippingAddress2)?$Obj->ShippingAddress2:"").'",
									locality: "'.(isset($Obj->ShippingCity)?$Obj->ShippingCity:"").'",
									region: "'.(isset($Obj->BillingState)?$Obj->ShippingState:"").'",
									postalCode: "'.(isset($Obj->ShippingZipCode)?$Obj->ShippingZipCode:"").'",
									countryCodeAlpha2: "'.(isset($Obj->ShippingCountry)?$Obj->ShippingCountry:"").'"
								}
							  },
							};	

							braintree.dropin.create({
								authorization: client_token,
								container: "#dropin-container",
								 paypal: {
									flow: "checkout",
									amount: "'.($Amount).'",
									currency: "GBP"
								  },
								threeDSecure: true
							}).then(function (dropinInstance) {
								form.addEventListener("submit", function (event) {
									event.preventDefault();
									dropinInstance.requestPaymentMethod({
									  threeDSecure: threeDSecureParameters
									}).then(function (payload) {
										// Send payload.nonce to your server
										document.querySelector("#nonce").value = payload.nonce;
										form.submit();
									}).catch(function (error) {
										// Handle error
									});
								});
							}).catch(function (error) {
								// Handle error
							});
						</script>';
						
			$Return .= '<style type="text/css">
						.braintree-large-button.braintree-toggle{
							border-color: #a42a2a;
							border: 1px solid #a42a2a;
							background-color: transparent;
							border-radius: 0px;
							color: #fff;
							font-size: 12px;
							padding: 0 4rem;
							line-height: 42px;
						}
						.braintree-option{
							background: #a42a2a;
							color: #fff;
							font-weight: 400;
							line-height: 2;
							border-color: #fff;
							border-style: solid;
							border-width: 0 1px 1px 1px;
						}
						.braintree-option:hover .braintree-option__label{
							color:#000;
						}
						.braintree-option .braintree-option__label,.braintree-sheet__header .braintree-sheet__text {
							color: #fff;
						}
						
						.braintree-sheet__header {
							background-color: #a42a2a;
							color: #fff;
						
						}
						.braintree-sheet__content{
								background-color: #fff;
								color: #000;
							}
						</style>';			
				
					
		return $Return;
	}
	
	function getPaymentPreForm_wihout3d($Obj,$PostArray=""){
		
		$gateway = $this->BraintreeGateway();
		
		$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
		$Return = '<form role="form" id="braintree-payment-form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		$Return .= '<input type="hidden" name="amount" value="'.$Amount.'" />';
		$Return .= '<input id="nonce" name="payment_method_nonce" type="hidden" />';
		$Return .= '<div class="bt-drop-in-wrapper">
                        <div id="bt-dropin"></div>
                    </div>';
					
		
		$Return .= ' <script src="https://js.braintreegateway.com/web/dropin/1.20.0/js/dropin.min.js"></script>
						<script>
							var form = document.querySelector("#braintree-payment-form");
							var client_token = "'.($gateway->ClientToken()->generate()).'";

							braintree.dropin.create({
							  authorization: client_token,
							  selector: "#bt-dropin",
							  paypal: {
								flow: "vault"
							  }
							}, function (createErr, instance) {
							  if (createErr) {
								console.log("Create Error", createErr);
								return;
							  }
							  form.addEventListener("submit", function (event) {
								event.preventDefault();

								instance.requestPaymentMethod(function (err, payload) {
								  if (err) {
									console.log("Request Payment Method Error", err);
									return;
								  }

								  // Add the nonce to the form and submit
								  document.querySelector("#nonce").value = payload.nonce;
								  form.submit();
								});
							  });
							});
						</script>';
						
			$Return .= '<style type="text/css">
						.braintree-large-button.braintree-toggle{
							border-color: #a42a2a;
							border: 1px solid #a42a2a;
							background-color: transparent;
							border-radius: 0px;
							color: #fff;
							font-size: 12px;
							padding: 0 4rem;
							line-height: 42px;
						}
						.braintree-option{
							background: #a42a2a;
							color: #fff;
							font-weight: 400;
							line-height: 2;
							border-color: #fff;
							border-style: solid;
							border-width: 0 1px 1px 1px;
						}
						.braintree-option:hover .braintree-option__label{
							color:#000;
						}
						.braintree-option .braintree-option__label,.braintree-sheet__header .braintree-sheet__text {
							color: #fff;
						}
						
						.braintree-sheet__header {
							background-color: #a42a2a;
							color: #fff;
						
						}
						.braintree-sheet__content{
								background-color: #fff;
								color: #000;
							}
						</style>';			
				
					
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '<p class="text-center"><input type="image" src="'.DIR_WS_SITE.'/templates/tools/braintree/all-cc-logos.png" /></p>';
		$Return .= '</form>';
		return $Return;
	}
	
	function getMethod_TESTONLY($PostArray="")
	{
		$ResponseArray = array();
		
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		if(isset($IsCurrentUser->Email) && in_array(strtolower($IsCurrentUser->Email),array("maxn1981@yahoo.com"))){
		$ResponseArray = array("title"=>"Pay securely with credit and debit cards (Braintree)",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );
		}
		
		return $ResponseArray; 
  
    }		
	
	function getMethod($PostArray="")
	{
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Pay securely with credit and debit cards",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );
		return $ResponseArray; 
  
    }		
	
	
}	