<?php 
namespace PaymentModule\BARCLAY;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	  var $pspID;
	  var $passPhase;
	  var $multipleCurrency;
	  var $currency;
	  var $language;
	  var $mode;
	  var $form;
		  
	function __construct()
	{
		 require_once (dirname(__FILE__)."/config.php");
		  $this->pspID = DEFINE_SK_PAYMENT_BARCLAY_EPDQ_PSPID;
		  $this->passPhase = DEFINE_SK_PAYMENT_BARCLAY_EPDQ_PASS_IN_PHRASE;
		  $this->multipleCurrency = DEFINE_SK_PAYMENT_BARCLAY_MULTIPLE_CURRENCY;
		  $this->currency = DEFINE_SK_PAYMENT_BARCLAY_CURRENCY;
		  $this->language = DEFINE_SK_PAYMENT_BARCLAY_LANGUAGE;
		  $this->mode = DEFINE_SK_PAYMENT_BARCLAY_EPDQ_MODE;
		  $this->form = DEFINE_SK_PAYMENT_BARCLAY_FORM;
	}
	
	function paymentIPN($GetArray,$PostArray=""){
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/payment");
		$filename=$dir."BARCLAYIPN-".date("Y-m-d_h-i-s").".txt";
		$fp2 = fopen($filename, "w");
		
		fputs($fp2,"----------------PostArray Variable start---------\r\n");	
		fputs($fp2,"PaymentMethod POSTRETURN=".print_r($PostArray,true)."\r\n");	
		fputs($fp2,"----------------PostArray Variable end---------\r\n");
		fclose($fp2);
		
		fputs($fp2,"----------------GetArray Variable start---------\r\n");	
		fputs($fp2,"PaymentMethod GETRETURN=".print_r($GetArray,true)."\r\n");	
		fputs($fp2,"----------------GetArray Variable end---------\r\n");
		
		$PaymentStatus ="";
		$OrderID = "";
		$Return = array();
		if(count($PostArray) > 0)
		{
				if($this->SKCheckBARCLAYAuthenticate($PostArray,$fp2)==true){
					$Return['OrderID'] = $PostArray['orderID'];
					$Return['PaymentStatus'] = "Paid";
					$Return['Process'] = "1";
					$Return['Invoice'] = "1";
					$Return['ClearCart'] = "1";
					/* Process order Start*/
					$this->getClass("Sale\Checkout\Common")->processPayment($Return['OrderID'],$Return,$_GET,$_POST);
				
					/* Invoice sent Start*/
					$this->getClass("Sale\Checkout\Common")->processInvoice($Return['OrderID'],$Return,$_GET,$_POST);
				
					/* Invoice sent Start*/
					$this->getClass("Sale\Checkout\Common")->clearCart();
					$ReturnURL = SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Return['OrderID']);
					?>
					<html>
					<head>
					<META HTTP-EQUIV="refresh" content="0; url=<?php echo $ReturnURL;?>">
					</head>
					<body onload="document.location.href='<?php echo $ReturnURL;?>'">
						You will be redirect to thank you page with in 5 seconds.
						<a href="<?php echo $ReturnURL;?>">Click here</a>
					</body>
					</html>
					<?php 
					exit;					
			  }
			else{
				?>
				<html>
				<head></head>
				<body>
					<?php echo d("ERROR_MSG_IN_PAYMENT_COMPLETED")?>
					<a href="<?php echo SKSEOURL('checkout','Confirm');?>">Click here</a>
				</body>
				</html>
				<?php 
				exit;
			}
			
		}
		
		fclose($fp2);
		return $Return;
	}
	
	function SKCheckBARCLAYAuthenticate($BarclayArr,$fp2)
	{
		$SHASIGNPost = isset($BarclayArr['SHASIGN'])?$BarclayArr['SHASIGN']:"";
		unset($BarclayArr['SHASIGN']);
		ksort($BarclayArr);
		
		 $DigestivePlain = "";
		 foreach($BarclayArr as $Columns=>$Value){
		   $DigestivePlain .= $Columns."=".$Value.$this->passPhase;
		  }
		  $SHASIGNGenerate =  strtoupper(sha1($DigestivePlain));
		  fputs($fp2,"----------------SHASIGNGenerate=".$SHASIGNGenerate."---------\r\n");	
		  fputs($fp2,"----------------STATUS=".$BarclayArr["STATUS"]."---------\r\n");	
		  if($SHASIGNGenerate == $SHASIGNPost){
			  if (isset($BarclayArr["STATUS"]) && in_array($BarclayArr["STATUS"],array('5','9','51','91'))){
				  return true;
			  }
          }
		return false;
		
	}

	function getPaymentPreProcess($Obj){
		/* nothing to do*/
		if(isset($Obj->PaymentMethod) && $Obj->PaymentMethod=="Barclay"){
			if(isset($_GET['error']) && $_GET['error']=="exception"){
				$this->getSession()->setArrVar("alert",array("danger","Error Occurred: Exception"));	
			}
			if(isset($_GET['error']) && $_GET['error']=="decline"){
				$this->getSession()->setArrVar("alert",array("danger","Error Occurred: Your payment has been declined. Please try again."));	
			}
			if(isset($_GET['error']) && $_GET['error']=="cancel"){
				$this->getSession()->setArrVar("alert",array("danger","Error Occurred: You have cancelled the payment. Please try again."));	
			}
		}
	}
	
	function getPaymentPostProcess($Obj,$PostArray=""){
		if(isset($PostArray['Process']) && $PostArray['Process']=="1"){
			
			$OrderRawData = "Order Number: ".$Obj->OrderNo;
			$ItemName = "Products Name:";
			$rows = $this->getClass("Sale\Cart\Common")->getOrderCart($Obj->OrderID);
			foreach($rows as $CurrentCartItem){
				$ItemName .= $CurrentCartItem->ItemName.", "; 
			}
			$ItemName = substr($ItemName, 0, -2); 
		
			$Amount = str_replace(",","",number_format($Obj->GrandTotal,2));
			$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
			$Currency = "GBP";
			
			/*Currency Array start */
		if($this->multipleCurrency===true)
		{
			$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
			$OrderCurrencyObj->where[] = array('=',array('OrderID' => $Obj->OrderID));
			$CurrentObj=(object)$OrderCurrencyObj->tableSelectOne();
			
			if(isset($CurrentObj->Value) && $CurrentObj->Value !="")
			{
				$GrandTotal = $CurrentObj->Value * $Obj->GrandTotal;
				$Amount = str_replace(",","",number_format($GrandTotal,2));
				$Custom = base64_encode((int)$Obj->OrderID.'@@@'.$Amount);
				$Currency = isset($CurrentObj->Code)?$CurrentObj->Code:"GBP";
			}
		}
		/*Currency Array end*/
		
			$BARCLAYFields  = array(
							   'PSPID' => $this->pspID,
							   'CURRENCY'=> $Currency,
							   'LANGUAGE'=> $this->language,
							   'PMLISTTYPE'=> "1",
							   'LOGO'=> d("DIR_WS_SITE")."templates/front/logo.jpg",
							   'COM'=> $OrderRawData,
							   'ORDERID'=> $Obj->OrderID,
							   'AMOUNT'=> round($Amount * 100),
							   
							   	'CN'=>$Obj->BillingFirstName." ".$Obj->BillingLastName, 
		 						'OWNERADDRESS'=>$Obj->BillingAddress1." ".$Obj->BillingAddress2,
		 						'OWNERCTY'=>$Obj->BillingCountry, 
		 						'OWNERTOWN'=>$Obj->BillingState,
								'EMAIL'=>$Obj->Email,  
								'OWNERTELNO'=>$Obj->BillingPhone,
								'OWNERZIP'=>$Obj->BillingZipCode,
								
								///shipping info
								'ECOM_SHIPTO_POSTAL_NAME_FIRST'=>$Obj->ShippingFirstName,
								'ECOM_SHIPTO_POSTAL_NAME_LAST'=>$Obj->ShippingLastName,
								'ECOM_SHIPTO_ONLINE_EMAIL'=>$Obj->Email,
								'ECOM_SHIPTO_POSTAL_STREET_LINE1'=>$Obj->ShippingAddress1,
								'ECOM_SHIPTO_POSTAL_STREET_LINE2'=>$Obj->ShippingAddress2,
								'ECOM_SHIPTO_POSTAL_CITY'=>$Obj->ShippingCity,
								'ECOM_SHIPTO_POSTAL_POSTALCODE'=>$Obj->ShippingZip,
								'ECOM_SHIPTO_TELECOM_PHONE_NUMBER'=>$Obj->ShippingPhone,								
								
								'TITLE'=> d("SITE_NAME")." - Secure Payment",
               					'BGCOLOR'=> "#FFFFFF",
               					'TXTCOLOR'=> "#C41B1E",
              					'TBLBGCOLOR'=> "#DEDEDE",
             					'TBLTXTCOLOR'=>"#000000",
              					'BUTTONBGCOLOR'=> "#000000",
               					'BUTTONTXTCOLOR'=> "#FFFFFF",
               					'FONTTYPE'=> "Helvetica, Arial",								
								
								'HOMEURL'=>SKSEOURL('cms_pages','Detail',d('DEFAULT_PAGEID')),                				
                				'ACCEPTURL'=>SKSEOURL('customer','Thankyou','','Status=Completed&PaymentEnd=1&OrderID='.$Obj->OrderID),
                				'DECLINEURL'=>SKSEOURL('checkout','Confirm','','error=decline'),
                				'EXCEPTIONURL'=>SKSEOURL('checkout','Confirm','','error=exception'),
               					'CANCELURL'=>SKSEOURL('checkout','Confirm','',"error=cancel")
		 						);
		 ksort($BARCLAYFields);
		 $DigestivePlain = "";
		 foreach($BARCLAYFields as $Columns=>$Value){
		   $DigestivePlain .= $Columns."=".$Value.$this->passPhase;
		  }
		  $BARCLAYFields['SHASign'] =  strtoupper(sha1($DigestivePlain));
				     	 
		
		$PaymentString = '<html>
							<head>
							<title></title>
							<script type="text/javascript">
							function FormSubmission()
							{
								FormObj = document.getElementById(\'FormRt\');
								FormObj.submit();
								return true;
							}
							</script>
							</head>
							<body onload="return FormSubmission();">
							<form name="FormRt" target="_top"  id="FormRt" action="'. $this->form .'" method="POST">';
							foreach ($BARCLAYFields as $k=>$v)
								$PaymentString .= '<input type="hidden" name="'. $k .'" value="'. $v .'" />';
								
				
		$PaymentString .= '<br>If this page appears for more than five seconds <button type="submit" onclick="return FormSubmission();">click here to reload.</button>
						  </form>
							</body>
						</html>';
		
			echo $PaymentString;exit;
			
		}
	}
	function getPaymentPreForm($Obj,$PostArray=""){
		
		$Return = '<form role="form" method="POST" class="my-3" action="'.SKSEOURL('checkout','Confirm').'">';
		$Return .= '<input type="hidden" name="Process" value="1" />';
		return $Return;
	}
	
	function getPaymentPostForm($PostArray=""){
		
		$Return = '<p class="text-center"><input type="image" src="'.DIR_WS_SITE.'/templates/tools/barclay/barclay.png" alt="Credit Cards" /></p>';
		$Return .= '</form>';
		return $Return;
	}
	function getMethod($PostArray="")
	{
			
		$ResponseArray = array();
		$ResponseArray = array("title"=>"Credit/Debit Card (Barclay)",
								"note"=>"fdsfdsf",
								"hidenote"=>"fdsfs",
							  );

		return $ResponseArray; 
  
    }		
	
	
}	