<?php
namespace Google\Recaptcha;
class Recaptcha 
{
	var $version = "v3";
	function __construct()
	{
		
	}
	
	function GoogleCaptchaVerificationCheck($secret,$grecaptcharesponse,$parms=array())
	{
		if($this->version=="v2"){
			return $this->serverV2($secret,$grecaptcharesponse,$parms);
		}
		if($this->version=="v3"){
			return $this->serverV3($secret,$grecaptcharesponse,$parms);
		}
		
	} 
	function GoogleCaptchaVerificationDisplay($key,$parms=array())
	{
		if($this->version=="v2"){
			return $this->clientV2($key,$parms);
		}
		if($this->version=="v3"){
			return $this->clientV3($key,$parms);
		}
		
	}
	
	function clientV3($key,$parms=array())
	{
		$field_id= uniqid("captcha");
		if((isset($parms['button']) && $parms['button'] != "")){
			$GLOBALS['InnerJsScript'][] = '
			<script>
			jQuery(document).ready(function($){
			  jQuery("#'.$parms['button'].'").bind("click",function(e){
				 var validator = jQuery("#'.$parms['button'].'").closest("form").validate();
				 if(validator.checkForm()==true){
				   e.preventDefault();
					grecaptcha.ready(function() {
					  grecaptcha.execute("'.$key.'", {action: "submit"}).then(function(token) {
						  document.getElementById("'.$field_id.'").value=token; 
						  jQuery("#'.$parms['button'].'").closest("form").submit();
					  });
					});
				 }
			  })	
				
			});	
			</script>
			';
		}

		return '<input type="hidden" id="'.$field_id.'" name="'.((isset($parms['field']) && $parms['field'] != "")?$parms['field']:"").'" value="" />';
	}
	
	function serverV3($secret,$grecaptcharesponse,$parms=array())
	{
		//var_dump($grecaptcharesponse,"<hr>");
		if($secret != ""){	
			$responseData = false;
			$url = 'https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$grecaptcharesponse;
			//$url = 'https://www.google.com/recaptcha/api/siteverify';
			 $data = array(
				'secret' => $secret,
				'response' => $grecaptcharesponse,
				'remoteip' => $_SERVER['REMOTE_ADDR'],
			);
			
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			//curl_setopt($verify, CURLOPT_POST, true);
			//curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($curl, CURLOPT_TIMEOUT, 15);
			$verifyResponse = curl_exec($curl);
			curl_close($curl);
			$responseData = json_decode($verifyResponse);
			//var_dump($responseData);exit;
			$ReturnObject = new \stdClass;
			$ReturnObject->success = false;
			$ReturnObject->gObj = $responseData;
			if(isset($responseData->success) && $responseData->success===true && $responseData->score >= 0.3){
				$ReturnObject->success = true;
			}
			return $ReturnObject;
		}
		
	}
	
	function clientV2($key,$parms=array())
	{
		return '<div class="g-recaptcha" data-sitekey="'.$key.'"></div>';
	}
	
	function serverV2($secret,$grecaptcharesponse,$parms=array())
	{
		$responseData = false;
		$url = 'https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$grecaptcharesponse;
		//$url = 'https://www.google.com/recaptcha/api/siteverify';
		 $data = array(
			'secret' => $secret,
			'response' => $grecaptcharesponse,
			'remoteip' => $_SERVER['REMOTE_ADDR'],
		);
		
		
			$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		//curl_setopt($verify, CURLOPT_POST, true);
		//curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($curl, CURLOPT_TIMEOUT, 15);
		$verifyResponse = curl_exec($curl);
		
		if(curl_errno($curl) != false){
			 $verifyResponse = file_get_contents($url);
		}
		else{
			
		}
		curl_close($curl);
		$responseData = json_decode($verifyResponse);
		return $responseData;
		
		
	} 
	
};
