<?php 
namespace Frontend\Common;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Cron extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function ExecuteCron($time)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$filename=$dir."cron.txt";
		$UniqueID = uniqid("Cron_");
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Cron Executed Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		fputs($fp2,"Cron Time ".$UniqueID."=".print_r($time,true).chr(13));		
						
		$Obj = new DataTable(TABLE_MODULE_CRONS);
		$where = new Where();
		$where->NEST//start braket
				->equalTo('CronStatus','Pending')
				->OR
				->equalTo('CronStatus','Processing')
				->UNNEST;
		$where->equalTo('Active','1');
		
		$Obj->where = $where;
		//$Obj->displayQuery = true;
		$rows = $Obj->tableSelectAll(array("*"),array("CronStatus ASC","Position ASC"));
		
		if(count($rows) > 0){
			$total = $time/count($rows);
			$SNo = 1;
			foreach($rows as $CurrentRecord){
				try {
					$sk_timestart = explode(' ', microtime() );
					$sk_timestart = $sk_timestart[1] + $sk_timestart[0];

					//echo "<hr>".date('Y-m-d H:i:s')."<br>";
					var_dump($CurrentRecord->MCode,$CurrentRecord->MFuncs);
					fputs($fp2,"Script Time ".$UniqueID."=".print_r($total,true).chr(13));		
					fputs($fp2,"CurrentRecord ".$UniqueID."=".print_r($CurrentRecord,true).chr(13));		
					set_time_limit(floor($total)+4);
					$this->getClass($CurrentRecord->MCode)->{$CurrentRecord->MFuncs}(floor($total),$CurrentRecord);
					//echo "<br>".date('Y-m-d H:i:s')."<br>";
					sleep(1);
					
					$sk_timeend = explode(' ', microtime() );
					$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
					$script_time = number_format($sk_timeend-$sk_timestart);
					if($total > $script_time && (count($rows)-$SNo) > 0)
						$total = $total + (($total-$script_time)/(count($rows)-$SNo)); 
					
					fputs($fp2,"Script Completed on  ".$UniqueID."=".print_r($script_time,true).chr(13));	
					$SNo++;
				}
				catch(Exception $e) {
				  /* catch */
				  fputs($fp2,"ErrorMessage ".$UniqueID."=".$e->getMessage().chr(13));	
				  echo 'Message: ' .$e->getMessage();
				}
				
			}
			set_time_limit($time);
		}
		
		fputs($fp2,"Cron Executed End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);
	}
	
	
}	